/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.dynmap.Log;

public class TileFlags {
    private HashMap<Long, long[]> chunkmap = new HashMap();
    private long last_key = Long.MAX_VALUE;
    private long[] last_row;
    private int count;

    public List<String> save() {
        ArrayList<String> v = new ArrayList<String>();
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<Long, long[]> ent : this.chunkmap.entrySet()) {
            long[] val;
            long v1 = ent.getKey();
            sb.append(String.format("%x/%x", v1 >> 32 & 0xFFFFFFFFL, v1 & 0xFFFFFFFFL));
            for (long vv : val = ent.getValue()) {
                sb.append(String.format(":%x/%x", vv >> 32 & 0xFFFFFFFFL, vv & 0xFFFFFFFFL));
            }
            v.add(sb.toString());
            sb.setLength(0);
        }
        return v;
    }

    public void load(List<String> vals) {
        this.clear();
        for (String v : vals) {
            String[] tok = v.split(":");
            long[] row = new long[64];
            try {
                String[] ss = tok[0].split("/");
                long rowaddr = Long.parseLong(ss[0], 16) << 32 | Long.parseLong(ss[1], 16);
                for (int i = 0; i < 64 && i < tok.length - 1; ++i) {
                    ss = tok[i + 1].split("/");
                    row[i] = Long.parseLong(ss[0], 16) << 32 | Long.parseLong(ss[1], 16);
                    this.count += Long.bitCount(row[i]);
                }
                this.chunkmap.put(rowaddr, row);
            }
            catch (NumberFormatException nfx) {
                Log.info("parse error - " + nfx);
            }
        }
    }

    public boolean getFlag(int x, int y) {
        long[] row;
        long k = (long)(x >> 6) << 32 | 0xFFFFFFFFL & (long)(y >> 6);
        if (k == this.last_key) {
            row = this.last_row;
        } else {
            row = this.chunkmap.get(k);
            this.last_key = k;
            this.last_row = row;
        }
        if (row == null) {
            return false;
        }
        return (row[y & 0x3F] & 1L << (x & 0x3F)) != 0L;
    }

    public boolean setFlag(int x, int y, boolean f) {
        long[] row;
        long k = (long)(x >> 6) << 32 | 0xFFFFFFFFL & (long)(y >> 6);
        if (k == this.last_key) {
            row = this.last_row;
        } else {
            row = this.chunkmap.get(k);
            this.last_key = k;
            this.last_row = row;
        }
        boolean prev = false;
        long mask = 1L << (x & 0x3F);
        int idx = y & 0x3F;
        if (f) {
            if (row == null) {
                row = new long[64];
                this.chunkmap.put(k, row);
                this.last_row = row;
            } else {
                boolean bl = prev = (row[idx] & mask) != 0L;
            }
            if (!prev) {
                int n = idx;
                row[n] = row[n] | mask;
                ++this.count;
            }
        } else if (row != null) {
            boolean bl = prev = (row[idx] & mask) != 0L;
            if (prev) {
                int n = idx;
                row[n] = row[n] & (mask ^ 0xFFFFFFFFFFFFFFFFL);
                --this.count;
                if (row[idx] == 0L) {
                    boolean nonzero = false;
                    for (int i = 0; i < row.length; ++i) {
                        if (row[i] == 0L) continue;
                        nonzero = true;
                        break;
                    }
                    if (!nonzero) {
                        this.chunkmap.remove(k);
                        this.last_row = null;
                        this.last_key = Long.MAX_VALUE;
                    }
                }
            }
        }
        return prev;
    }

    public void union(TileFlags flags) {
        for (Map.Entry<Long, long[]> es : flags.chunkmap.entrySet()) {
            Long k = es.getKey();
            long[] f = this.chunkmap.get(k);
            long[] nf = es.getValue();
            if (f == null) {
                f = new long[64];
                this.chunkmap.put(k, f);
            }
            for (int i = 0; i < f.length; ++i) {
                this.count -= Long.bitCount(f[i]);
                f[i] = f[i] | nf[i];
                this.count += Long.bitCount(f[i]);
            }
        }
    }

    public void clear() {
        this.chunkmap.clear();
        this.last_row = null;
        this.last_key = Long.MAX_VALUE;
        this.count = 0;
    }

    public int countFlags() {
        return this.count;
    }

    public Iterator getIterator() {
        return new Iterator();
    }

    public class Iterator {
        private Long[] keySet = new Long[1];
        private int nextIndex = 0;
        private int lastKeyIndex = -1;

        Iterator() {
        }

        public TileFlags iterSource() {
            return TileFlags.this;
        }

        public boolean hasNext() {
            return !TileFlags.this.chunkmap.isEmpty();
        }

        public boolean next(TileCoord coord) {
            if (TileFlags.this.count == 0) {
                return false;
            }
            while (true) {
                if (this.lastKeyIndex < 0) {
                    Set ks = TileFlags.this.chunkmap.keySet();
                    this.nextIndex = 0;
                    int kscnt = ks.size();
                    if (kscnt == 0) {
                        return false;
                    }
                    this.keySet = ks.toArray(new Long[kscnt]);
                    this.lastKeyIndex = 0;
                }
                while (this.lastKeyIndex < this.keySet.length) {
                    Long k = this.keySet[this.lastKeyIndex];
                    if (k != null) {
                        long[] flgs = (long[])TileFlags.this.chunkmap.get(k);
                        if (flgs != null) {
                            while (this.nextIndex < 4096) {
                                int vidx = this.nextIndex & 0x3F;
                                int hidx = this.nextIndex >> 6 & 0x3F;
                                if ((flgs[vidx] >> hidx & 1L) != 0L) {
                                    coord.x = (int)((k >> 32 & 0xFFFFFFFFL) << 6) | hidx;
                                    coord.y = (int)((k & 0xFFFFFFFFL) << 6) | vidx;
                                    ++this.nextIndex;
                                    return true;
                                }
                                ++this.nextIndex;
                            }
                        }
                        this.nextIndex = 0;
                    }
                    ++this.lastKeyIndex;
                }
                this.lastKeyIndex = -1;
            }
        }
    }

    public static class TileCoord {
        public int x;
        public int y;

        public TileCoord() {
            this.x = 0;
            this.y = 0;
        }

        public TileCoord(int x, int y) {
            this.x = x;
            this.y = y;
        }

        public boolean equals(Object o) {
            if (o instanceof TileCoord) {
                TileCoord tc = (TileCoord)o;
                return tc.x == this.x && tc.y == this.y;
            }
            return false;
        }

        public int hashCode() {
            return this.x ^ this.y << 8;
        }
    }
}

