/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.servlet;

import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Date;
import java.util.ListIterator;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.InternalClientUpdateComponent;
import org.dynmap.JSONUtils;
import org.dynmap.json.simple.JSONArray;
import org.dynmap.json.simple.JSONObject;

public class ClientConfigurationServlet
extends HttpServlet {
    private static final long serialVersionUID = 9106801553080522469L;
    private DynmapCore core;
    private Charset cs_utf8 = Charset.forName("UTF-8");

    public ClientConfigurationServlet(DynmapCore plugin) {
        this.core = plugin;
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        JSONObject obj;
        HttpSession sess = req.getSession(true);
        String user = (String)sess.getAttribute("userid");
        if (user == null) {
            user = "_guest_";
        }
        boolean guest = user.equals("_guest_");
        JSONObject json = new JSONObject();
        if (this.core.getLoginRequired() && guest) {
            JSONUtils.s(json, "error", "login-required");
        } else if (this.core.isLoginSupportEnabled()) {
            if (guest) {
                JSONUtils.s(json, "loggedin", false);
            } else {
                JSONUtils.s(json, "loggedin", true);
                JSONUtils.s(json, "player", user);
            }
            obj = InternalClientUpdateComponent.getClientConfig();
            if (obj != null) {
                json.putAll(obj);
            }
            JSONArray wlist = (JSONArray)JSONUtils.g(json, "worlds");
            JSONArray newwlist = new JSONArray();
            json.put("worlds", newwlist);
            ListIterator iter = wlist.listIterator();
            while (iter.hasNext()) {
                JSONObject w = (JSONObject)iter.next();
                String n = (String)JSONUtils.g(w, "name");
                DynmapWorld dw = this.core.getWorld(n);
                if (dw.isProtected() && (guest || !this.core.getServer().checkPlayerPermission(user, "world." + n))) continue;
                JSONObject neww = new JSONObject();
                neww.putAll(w);
                newwlist.add(neww);
                JSONArray mlist = (JSONArray)JSONUtils.g(w, "maps");
                JSONArray newmlist = new JSONArray();
                neww.put("maps", newmlist);
                ListIterator iter2 = mlist.listIterator();
                while (iter2.hasNext()) {
                    JSONObject m = (JSONObject)iter2.next();
                    Boolean prot = (Boolean)JSONUtils.g(m, "protected");
                    if (prot == null || !prot.booleanValue()) {
                        newmlist.add(m);
                        continue;
                    }
                    String mn = (String)JSONUtils.g(m, "name");
                    if (guest || !this.core.getServer().checkPlayerPermission(user, "map." + n + "." + mn)) continue;
                    newmlist.add(m);
                }
            }
        } else {
            JSONUtils.s(json, "loggedin", !guest);
            obj = InternalClientUpdateComponent.getClientConfig();
            if (obj != null) {
                json.putAll(obj);
            }
        }
        byte[] outputBytes = json.toJSONString().getBytes(this.cs_utf8);
        String dateStr = new Date().toString();
        res.addHeader("Date", dateStr);
        res.setContentType("text/plain; charset=utf-8");
        res.addHeader("Expires", "Thu, 01 Dec 1994 16:00:00 GMT");
        res.addHeader("Last-modified", dateStr);
        res.setContentLength(outputBytes.length);
        res.getOutputStream().write(outputBytes);
    }
}

