/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport.impl;

import org.dynmap.modsupport.VolumetricBlockModel;
import org.dynmap.modsupport.impl.BlockModelImpl;
import org.dynmap.modsupport.impl.ModModelDefinitionImpl;

public class VolumetricBlockModelImpl
extends BlockModelImpl
implements VolumetricBlockModel {
    private boolean[][][] grid;

    public VolumetricBlockModelImpl(int blkid, ModModelDefinitionImpl mdf, int scale) {
        super(blkid, mdf);
        this.grid = new boolean[scale][][];
        for (int i = 0; i < scale; ++i) {
            this.grid[i] = new boolean[scale][];
            for (int j = 0; j < scale; ++j) {
                this.grid[i][j] = new boolean[scale];
            }
        }
    }

    @Override
    public void setSubBlockToFilled(int x, int y, int z) {
        if (x >= 0 && x < this.grid.length && y >= 0 && y < this.grid.length && z >= 0 && z < this.grid.length) {
            this.grid[x][y][z] = true;
        }
    }

    @Override
    public void setSubBlockToEmpty(int x, int y, int z) {
        if (x >= 0 && x < this.grid.length && y >= 0 && y < this.grid.length && z >= 0 && z < this.grid.length) {
            this.grid[x][y][z] = false;
        }
    }

    @Override
    public String getLine() {
        String ids = this.getIDsAndMeta();
        if (ids == null) {
            return null;
        }
        String line = String.format("block:%s,scale=%d\n", ids, this.grid.length);
        for (int y = 0; y < this.grid.length; ++y) {
            String l = "layer: " + y + "\n";
            boolean empty = true;
            for (int z = 0; z < this.grid.length; ++z) {
                for (int x = 0; x < this.grid.length; ++x) {
                    if (this.grid[x][y][z]) {
                        empty = false;
                        l = l + '*';
                        continue;
                    }
                    l = l + '-';
                }
                l = l + "\n";
            }
            if (empty) continue;
            line = line + l;
        }
        return line;
    }
}

