/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport.impl;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import org.dynmap.modsupport.BigChestTextureFile;
import org.dynmap.modsupport.BiomeTextureFile;
import org.dynmap.modsupport.BlockTextureRecord;
import org.dynmap.modsupport.ChestTextureFile;
import org.dynmap.modsupport.CopyBlockTextureRecord;
import org.dynmap.modsupport.CustomTextureFile;
import org.dynmap.modsupport.GridTextureFile;
import org.dynmap.modsupport.ModModelDefinition;
import org.dynmap.modsupport.ModTextureDefinition;
import org.dynmap.modsupport.SignTextureFile;
import org.dynmap.modsupport.SkinTextureFile;
import org.dynmap.modsupport.impl.BigChestTextureFileImpl;
import org.dynmap.modsupport.impl.BiomeTextureFileImpl;
import org.dynmap.modsupport.impl.BlockTextureRecordImpl;
import org.dynmap.modsupport.impl.ChestTextureFileImpl;
import org.dynmap.modsupport.impl.CopyBlockTextureRecordImpl;
import org.dynmap.modsupport.impl.CustomTextureFileImpl;
import org.dynmap.modsupport.impl.GridTextureFileImpl;
import org.dynmap.modsupport.impl.ModModelDefinitionImpl;
import org.dynmap.modsupport.impl.SignTextureFileImpl;
import org.dynmap.modsupport.impl.SkinTextureFileImpl;
import org.dynmap.modsupport.impl.TextureFileImpl;

public class ModTextureDefinitionImpl
implements ModTextureDefinition {
    private final String modid;
    private final String modver;
    private ModModelDefinitionImpl modDef = null;
    private String texturePath;
    private HashMap<String, TextureFileImpl> txtFileByID = new HashMap();
    private ArrayList<BlockTextureRecordImpl> blkTextureRec = new ArrayList();
    private ArrayList<CopyBlockTextureRecordImpl> blkCopyTextureRec = new ArrayList();
    private boolean published = false;

    public ModTextureDefinitionImpl(String modid, String modver) {
        this.modid = modid;
        this.modver = modver;
        this.texturePath = "assets/" + modid.toLowerCase() + "/textures/blocks/";
    }

    @Override
    public String getModID() {
        return this.modid;
    }

    @Override
    public String getModVersion() {
        return this.modver;
    }

    @Override
    public ModModelDefinition getModelDefinition() {
        if (this.modDef == null) {
            this.modDef = new ModModelDefinitionImpl(this);
        }
        return this.modDef;
    }

    @Override
    public boolean publishDefinition() {
        this.published = true;
        return true;
    }

    @Override
    public void setTexturePath(String txtpath) {
        this.texturePath = txtpath;
        if (!this.texturePath.endsWith("/")) {
            this.texturePath = this.texturePath + "/";
        }
        if (this.texturePath.startsWith("/")) {
            this.texturePath = this.texturePath.substring(1);
        }
    }

    @Override
    public String getTexturePath() {
        return this.texturePath;
    }

    private TextureFileImpl registerTextureFile(TextureFileImpl tfi) {
        TextureFileImpl orig_tfi = this.txtFileByID.get(tfi.getTextureID());
        if (orig_tfi == null) {
            this.txtFileByID.put(tfi.getTextureID(), tfi);
        } else {
            tfi = orig_tfi.equals(tfi) ? orig_tfi : null;
        }
        return tfi;
    }

    private String getDefFilename(String id) {
        return this.texturePath + id + ".png";
    }

    @Override
    public GridTextureFile registerTextureFile(String id) {
        return (GridTextureFile)((Object)this.registerTextureFile(new GridTextureFileImpl(id, this.getDefFilename(id), 1, 1)));
    }

    @Override
    public GridTextureFile registerTextureFile(String id, String filename) {
        return (GridTextureFile)((Object)this.registerTextureFile(new GridTextureFileImpl(id, filename, 1, 1)));
    }

    @Override
    public ChestTextureFile registerChestTextureFile(String id, String filename) {
        return (ChestTextureFile)((Object)this.registerTextureFile(new ChestTextureFileImpl(id, filename)));
    }

    @Override
    public BigChestTextureFile registerBigChestTextureFile(String id, String filename) {
        return (BigChestTextureFile)((Object)this.registerTextureFile(new BigChestTextureFileImpl(id, filename)));
    }

    @Override
    public SignTextureFile registerSignTextureFile(String id, String filename) {
        return (SignTextureFile)((Object)this.registerTextureFile(new SignTextureFileImpl(id, filename)));
    }

    @Override
    public SkinTextureFile registerSkinTextureFile(String id, String filename) {
        return (SkinTextureFile)((Object)this.registerTextureFile(new SkinTextureFileImpl(id, filename)));
    }

    @Override
    public GridTextureFile registerGridTextureFile(String id, String filename, int xcount, int ycount) {
        return (GridTextureFile)((Object)this.registerTextureFile(new GridTextureFileImpl(id, filename, xcount, ycount)));
    }

    @Override
    public CustomTextureFile registerCustomTextureFile(String id, String filename, int xcount, int ycount) {
        return (CustomTextureFile)((Object)this.registerTextureFile(new CustomTextureFileImpl(id, filename, xcount, ycount)));
    }

    @Override
    public BiomeTextureFile registerBiomeTextureFile(String id, String filename) {
        return (BiomeTextureFile)((Object)this.registerTextureFile(new BiomeTextureFileImpl(id, filename)));
    }

    @Override
    public BlockTextureRecord addBlockTextureRecord(int blockID) {
        BlockTextureRecordImpl btr = new BlockTextureRecordImpl(blockID);
        this.blkTextureRec.add(btr);
        return btr;
    }

    @Override
    public CopyBlockTextureRecord addCopyBlockTextureRecord(int blockID, int srcBlockID, int srcMeta) {
        CopyBlockTextureRecordImpl btr = new CopyBlockTextureRecordImpl(blockID, srcBlockID, srcMeta);
        this.blkCopyTextureRec.add(btr);
        return btr;
    }

    public boolean isPublished() {
        return this.published;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void writeToFile(File destdir) throws IOException {
        File f = new File(destdir, this.modid + "-texture.txt");
        FileWriter fw = null;
        try {
            String line;
            fw = new FileWriter(f);
            String s = "modname:" + this.modid;
            fw.write(s + "\n\n");
            for (TextureFileImpl textureFileImpl : this.txtFileByID.values()) {
                line = textureFileImpl.getLine();
                if (line == null) continue;
                fw.write(line + "\n");
            }
            for (BlockTextureRecordImpl blockTextureRecordImpl : this.blkTextureRec) {
                line = blockTextureRecordImpl.getLine();
                if (line == null) continue;
                fw.write(line + "\n");
            }
            for (CopyBlockTextureRecordImpl copyBlockTextureRecordImpl : this.blkCopyTextureRec) {
                line = copyBlockTextureRecordImpl.getLine();
                if (line == null) continue;
                fw.write(line + "\n");
            }
        }
        finally {
            if (fw != null) {
                fw.close();
            }
        }
    }
}

