/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.modsupport.impl;

import java.util.Arrays;
import org.dynmap.modsupport.CopyBlockTextureRecord;
import org.dynmap.modsupport.TransparencyMode;

public class CopyBlockTextureRecordImpl
implements CopyBlockTextureRecord {
    private int[] ids = new int[0];
    private int metaMask = -1;
    private final int srcid;
    private final int srcmeta;
    private TransparencyMode mode = null;

    public CopyBlockTextureRecordImpl(int blkid, int srcid, int srcmeta) {
        this.addBlockID(blkid);
        this.srcid = srcid;
        this.srcmeta = srcmeta;
    }

    @Override
    public void addBlockID(int blockID) {
        if (blockID > 0 && blockID < 4096) {
            for (int i = 0; i < this.ids.length; ++i) {
                if (this.ids[i] != blockID) continue;
                return;
            }
            this.ids = Arrays.copyOf(this.ids, this.ids.length + 1);
            this.ids[this.ids.length - 1] = blockID;
        }
    }

    @Override
    public int[] getBlockIDs() {
        return this.ids;
    }

    @Override
    public void setMetaValue(int data) {
        if (data < 0) {
            this.metaMask = -1;
        } else if (data < 16) {
            if (this.metaMask == -1) {
                this.metaMask = 0;
            }
            this.metaMask |= 1 << data;
        }
    }

    @Override
    public int getMetaValueMask() {
        return this.metaMask;
    }

    public String getLine() {
        int i;
        if (this.ids.length == 0) {
            return null;
        }
        String s = "copyblock:";
        for (i = 0; i < this.ids.length; ++i) {
            s = i == 0 ? s + "id=" + this.ids[i] : s + ",id=" + this.ids[i];
        }
        if (this.metaMask == -1) {
            s = s + ",data=*";
        } else {
            for (i = 0; i < 16; ++i) {
                if ((this.metaMask & 1 << i) == 0) continue;
                s = s + ",data=" + i;
            }
        }
        s = s + ",srcid=" + this.srcid + ",srcmeta=" + this.srcmeta;
        switch (this.mode) {
            case TRANSPARENT: {
                s = s + ",transparency=TRANSPARENT";
                break;
            }
            case SEMITRANSPARENT: {
                s = s + ",transparency=SEMITRANSPARENT";
                break;
            }
        }
        return s;
    }

    @Override
    public int getSourceBlockID() {
        return this.srcid;
    }

    @Override
    public int getSourceMeta() {
        return this.srcmeta;
    }

    @Override
    public void setTransparencyMode(TransparencyMode mode) {
        this.mode = mode;
    }

    @Override
    public TransparencyMode getTransparencyMode() {
        return this.mode;
    }
}

