/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.markers.impl;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapWorld;
import org.dynmap.hdmap.HDPerspective;
import org.dynmap.markers.CircleMarker;
import org.dynmap.markers.MarkerSet;
import org.dynmap.markers.impl.MarkerAPIImpl;
import org.dynmap.markers.impl.MarkerImpl;
import org.dynmap.markers.impl.MarkerSetImpl;
import org.dynmap.utils.Vector3D;

class CircleMarkerImpl
implements CircleMarker {
    private String markerid;
    private String label;
    private boolean markup;
    private String desc;
    private MarkerSetImpl markerset;
    private String world;
    private String normalized_world;
    private boolean ispersistent;
    private double x;
    private double y;
    private double z;
    private double xr;
    private double zr;
    private int lineweight = 3;
    private double lineopacity = 0.8;
    private int linecolor = 0xFF0000;
    private double fillopacity = 0.35;
    private int fillcolor = 0xFF0000;
    private boolean boostflag = false;
    private int minzoom = -1;
    private int maxzoom = -1;
    private Map<String, BoundingBox> bb_cache = null;

    CircleMarkerImpl(String id, String lbl, boolean markup, String world, double x, double y, double z, double xr, double zr, boolean persistent, MarkerSetImpl set) {
        this.markerid = id;
        this.label = lbl != null ? lbl : id;
        this.markup = markup;
        this.x = x;
        this.y = y;
        this.z = z;
        this.xr = xr;
        this.zr = zr;
        this.world = world;
        this.normalized_world = DynmapWorld.normalizeWorldName(world);
        this.desc = null;
        this.minzoom = -1;
        this.maxzoom = -1;
        this.ispersistent = persistent;
        this.markerset = set;
    }

    CircleMarkerImpl(String id, MarkerSetImpl set) {
        this.markerid = id;
        this.markerset = set;
        this.label = id;
        this.markup = false;
        this.desc = null;
        this.normalized_world = "world";
        this.world = "world";
        this.minzoom = -1;
        this.maxzoom = -1;
        this.z = 0.0;
        this.x = 0.0;
        this.y = 64.0;
        this.zr = 0.0;
        this.xr = 0.0;
    }

    boolean loadPersistentData(ConfigurationNode node) {
        this.label = node.getString("label", this.markerid);
        this.markup = node.getBoolean("markup", false);
        this.world = node.getString("world", "world");
        this.normalized_world = DynmapWorld.normalizeWorldName(this.world);
        this.x = node.getDouble("x", 0.0);
        this.y = node.getDouble("y", 64.0);
        this.z = node.getDouble("z", 0.0);
        this.xr = node.getDouble("xr", 0.0);
        this.zr = node.getDouble("zr", 0.0);
        this.desc = node.getString("desc", null);
        this.lineweight = node.getInteger("strokeWeight", -1);
        if (this.lineweight == -1) {
            this.lineweight = node.getInteger("stokeWeight", 3);
        }
        this.lineopacity = node.getDouble("strokeOpacity", 0.8);
        this.linecolor = node.getInteger("strokeColor", 0xFF0000);
        this.fillopacity = node.getDouble("fillOpacity", 0.35);
        this.fillcolor = node.getInteger("fillColor", 0xFF0000);
        this.boostflag = node.getBoolean("boostFlag", false);
        this.minzoom = node.getInteger("minzoom", -1);
        this.maxzoom = node.getInteger("maxzoom", -1);
        this.ispersistent = true;
        return true;
    }

    void cleanup() {
        this.markerset = null;
        this.bb_cache = null;
    }

    @Override
    public String getMarkerID() {
        return this.markerid;
    }

    @Override
    public MarkerSet getMarkerSet() {
        return this.markerset;
    }

    @Override
    public void deleteMarker() {
        if (this.markerset == null) {
            return;
        }
        this.markerset.removeCircleMarker(this);
        this.cleanup();
    }

    @Override
    public boolean isPersistentMarker() {
        return this.ispersistent;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public void setLabel(String lbl) {
        this.setLabel(lbl, false);
    }

    @Override
    public void setLabel(String lbl, boolean markup) {
        this.label = lbl;
        this.markup = markup;
        MarkerAPIImpl.circleMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    Map<String, Object> getPersistentData() {
        if (!this.ispersistent) {
            return null;
        }
        HashMap<String, Object> node = new HashMap<String, Object>();
        node.put("label", this.label);
        node.put("markup", this.markup);
        node.put("x", this.x);
        node.put("y", this.y);
        node.put("z", this.z);
        node.put("xr", this.xr);
        node.put("zr", this.zr);
        node.put("world", this.world);
        if (this.desc != null) {
            node.put("desc", this.desc);
        }
        node.put("strokeWeight", this.lineweight);
        node.put("strokeOpacity", this.lineopacity);
        node.put("strokeColor", this.linecolor);
        node.put("fillOpacity", this.fillopacity);
        node.put("fillColor", this.fillcolor);
        if (this.boostflag) {
            node.put("boostFlag", true);
        }
        if (this.minzoom >= 0) {
            node.put("minzoom", this.minzoom);
        }
        if (this.maxzoom >= 0) {
            node.put("maxzoom", this.maxzoom);
        }
        return node;
    }

    @Override
    public String getWorld() {
        return this.world;
    }

    @Override
    public String getNormalizedWorld() {
        return this.normalized_world;
    }

    @Override
    public boolean isLabelMarkup() {
        return this.markup;
    }

    @Override
    public void setDescription(String desc) {
        if (this.desc == null || !this.desc.equals(desc)) {
            this.desc = desc;
            MarkerAPIImpl.circleMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    @Override
    public String getDescription() {
        return this.desc;
    }

    @Override
    public void setLineStyle(int weight, double opacity, int color) {
        if (weight != this.lineweight || opacity != this.lineopacity || color != this.linecolor) {
            this.lineweight = weight;
            this.lineopacity = opacity;
            this.linecolor = color;
            MarkerAPIImpl.circleMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    @Override
    public int getLineWeight() {
        return this.lineweight;
    }

    @Override
    public double getLineOpacity() {
        return this.lineopacity;
    }

    @Override
    public int getLineColor() {
        return this.linecolor;
    }

    @Override
    public void setFillStyle(double opacity, int color) {
        if (opacity != this.fillopacity || color != this.fillcolor) {
            this.fillopacity = opacity;
            this.fillcolor = color;
            MarkerAPIImpl.circleMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    @Override
    public double getFillOpacity() {
        return this.fillopacity;
    }

    @Override
    public int getFillColor() {
        return this.fillcolor;
    }

    @Override
    public double getCenterX() {
        return this.x;
    }

    @Override
    public double getCenterY() {
        return this.y;
    }

    @Override
    public double getCenterZ() {
        return this.z;
    }

    @Override
    public void setCenter(String worldid, double x, double y, double z) {
        boolean updated = false;
        if (!worldid.equals(this.world)) {
            this.world = worldid;
            this.normalized_world = DynmapWorld.normalizeWorldName(this.world);
            updated = true;
        }
        if (this.x != x) {
            this.x = x;
            updated = true;
        }
        if (this.y != y) {
            this.y = y;
            updated = true;
        }
        if (this.z != z) {
            this.z = z;
            updated = true;
        }
        if (updated) {
            MarkerAPIImpl.circleMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
            this.bb_cache = null;
        }
    }

    @Override
    public double getRadiusX() {
        return this.xr;
    }

    @Override
    public double getRadiusZ() {
        return this.zr;
    }

    @Override
    public void setRadius(double xr, double zr) {
        if (this.xr != xr || this.zr != zr) {
            this.xr = xr;
            this.zr = zr;
            MarkerAPIImpl.circleMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
            this.bb_cache = null;
        }
    }

    @Override
    public void setMarkerSet(MarkerSet newset) {
        if (this.markerset != null) {
            this.markerset.removeCircleMarker(this);
        }
        this.markerset = (MarkerSetImpl)newset;
        this.markerset.insertCircleMarker(this);
    }

    @Override
    public void setBoostFlag(boolean bflag) {
        if (this.boostflag != bflag) {
            this.boostflag = bflag;
            if (this.markerset != null) {
                this.setMarkerSet(this.markerset);
            }
            if (this.ispersistent) {
                MarkerAPIImpl.saveMarkers();
            }
        }
    }

    @Override
    public boolean getBoostFlag() {
        return this.boostflag;
    }

    final boolean testTileForBoostMarkers(DynmapWorld w, HDPerspective perspective, double tile_x, double tile_y, double tile_dim) {
        BoundingBox bb;
        Map<String, BoundingBox> bbc = this.bb_cache;
        if (bbc == null) {
            bbc = new ConcurrentHashMap<String, BoundingBox>();
        }
        if ((bb = bbc.get(perspective.getName())) == null) {
            bb = new BoundingBox();
            Vector3D v = new Vector3D();
            Vector3D v2 = new Vector3D();
            bb.xmin = Double.MAX_VALUE;
            bb.xmax = -1.7976931348623157E308;
            bb.ymin = Double.MAX_VALUE;
            bb.ymax = -1.7976931348623157E308;
            int cnt = 16;
            bb.xp = new double[cnt];
            bb.yp = new double[cnt];
            for (int i = 0; i < cnt; ++i) {
                v.x = this.x + this.xr * Math.cos(Math.PI * 2 * (double)i / (double)cnt);
                v.y = this.y;
                v.z = this.z + this.zr * Math.sin(Math.PI * 2 * (double)i / (double)cnt);
                perspective.transformWorldToMapCoord(v, v2);
                if (v2.x < bb.xmin) {
                    bb.xmin = v2.x;
                }
                if (v2.y < bb.ymin) {
                    bb.ymin = v2.y;
                }
                if (v2.x > bb.xmax) {
                    bb.xmax = v2.x;
                }
                if (v2.y > bb.ymax) {
                    bb.ymax = v2.y;
                }
                bb.xp[i] = v2.x;
                bb.yp[i] = v2.y;
            }
            bbc.put(perspective.getName(), bb);
            this.bb_cache = bbc;
        }
        double tile_x2 = tile_x + tile_dim;
        double tile_y2 = tile_y + tile_dim;
        if (bb.xmin > tile_x2 || bb.xmax < tile_x || bb.ymin > tile_y2 || bb.ymax < tile_y) {
            return false;
        }
        int cnt = bb.xp.length;
        double[] px = bb.xp;
        double[] py = bb.yp;
        if (MarkerImpl.testPointInPolygon(tile_x, tile_y, px, py)) {
            return true;
        }
        if (MarkerImpl.testPointInPolygon(tile_x2, tile_y, px, py)) {
            return true;
        }
        if (MarkerImpl.testPointInPolygon(tile_x, tile_y2, px, py)) {
            return true;
        }
        if (MarkerImpl.testPointInPolygon(tile_x2, tile_y2, px, py)) {
            return true;
        }
        for (int i = 0; i < cnt; ++i) {
            if (!(px[i] >= tile_x) || !(px[i] <= tile_x2) || !(py[i] >= tile_y) || !(py[i] <= tile_y2)) continue;
            return true;
        }
        return false;
    }

    @Override
    public int getMinZoom() {
        return this.minzoom;
    }

    @Override
    public void setMinZoom(int zoom) {
        if (zoom < 0) {
            zoom = -1;
        }
        if (this.minzoom == zoom) {
            return;
        }
        this.minzoom = zoom;
        MarkerAPIImpl.circleMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    @Override
    public int getMaxZoom() {
        return this.maxzoom;
    }

    @Override
    public void setMaxZoom(int zoom) {
        if (zoom < 0) {
            zoom = -1;
        }
        if (this.maxzoom == zoom) {
            return;
        }
        this.maxzoom = zoom;
        MarkerAPIImpl.circleMarkerUpdated(this, MarkerAPIImpl.MarkerUpdate.UPDATED);
        if (this.ispersistent) {
            MarkerAPIImpl.saveMarkers();
        }
    }

    private static class BoundingBox {
        double xmin;
        double xmax;
        double ymin;
        double ymax;
        double[] xp;
        double[] yp;

        private BoundingBox() {
        }
    }
}

