/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.jetty.util;

import java.io.File;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.dynmap.jetty.util.resource.Resource;

public class Loader {
    public static URL getResource(Class<?> loadClass, String name, boolean checkParents) {
        URL url = null;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        while (url == null && loader != null) {
            url = loader.getResource(name);
            loader = url == null && checkParents ? loader.getParent() : null;
        }
        ClassLoader classLoader = loader = loadClass == null ? null : loadClass.getClassLoader();
        while (url == null && loader != null) {
            url = loader.getResource(name);
            loader = url == null && checkParents ? loader.getParent() : null;
        }
        if (url == null) {
            url = ClassLoader.getSystemResource(name);
        }
        return url;
    }

    public static Class loadClass(Class loadClass, String name) throws ClassNotFoundException {
        return Loader.loadClass(loadClass, name, false);
    }

    public static Class loadClass(Class loadClass, String name, boolean checkParents) throws ClassNotFoundException {
        Class<?> c;
        ClassNotFoundException ex;
        block12: {
            ex = null;
            c = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            while (c == null && loader != null) {
                block10: {
                    try {
                        c = loader.loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        if (ex != null) break block10;
                        ex = e;
                    }
                }
                loader = c == null && checkParents ? loader.getParent() : null;
            }
            ClassLoader classLoader = loader = loadClass == null ? null : loadClass.getClassLoader();
            while (c == null && loader != null) {
                block11: {
                    try {
                        c = loader.loadClass(name);
                    }
                    catch (ClassNotFoundException e) {
                        if (ex != null) break block11;
                        ex = e;
                    }
                }
                loader = c == null && checkParents ? loader.getParent() : null;
            }
            if (c == null) {
                try {
                    c = Class.forName(name);
                }
                catch (ClassNotFoundException e) {
                    if (ex != null) break block12;
                    ex = e;
                }
            }
        }
        if (c != null) {
            return c;
        }
        throw ex;
    }

    public static ResourceBundle getResourceBundle(Class<?> loadClass, String name, boolean checkParents, Locale locale) throws MissingResourceException {
        ResourceBundle bundle;
        MissingResourceException ex;
        block12: {
            ex = null;
            bundle = null;
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            while (bundle == null && loader != null) {
                block10: {
                    try {
                        bundle = ResourceBundle.getBundle(name, locale, loader);
                    }
                    catch (MissingResourceException e) {
                        if (ex != null) break block10;
                        ex = e;
                    }
                }
                loader = bundle == null && checkParents ? loader.getParent() : null;
            }
            ClassLoader classLoader = loader = loadClass == null ? null : loadClass.getClassLoader();
            while (bundle == null && loader != null) {
                block11: {
                    try {
                        bundle = ResourceBundle.getBundle(name, locale, loader);
                    }
                    catch (MissingResourceException e) {
                        if (ex != null) break block11;
                        ex = e;
                    }
                }
                loader = bundle == null && checkParents ? loader.getParent() : null;
            }
            if (bundle == null) {
                try {
                    bundle = ResourceBundle.getBundle(name, locale);
                }
                catch (MissingResourceException e) {
                    if (ex != null) break block12;
                    ex = e;
                }
            }
        }
        if (bundle != null) {
            return bundle;
        }
        throw ex;
    }

    public static String getClassPath(ClassLoader loader) throws Exception {
        StringBuilder classpath = new StringBuilder();
        while (loader != null && loader instanceof URLClassLoader) {
            URL[] urls = ((URLClassLoader)loader).getURLs();
            if (urls != null) {
                for (int i = 0; i < urls.length; ++i) {
                    Resource resource = Resource.newResource(urls[i]);
                    File file = resource.getFile();
                    if (file == null || !file.exists()) continue;
                    if (classpath.length() > 0) {
                        classpath.append(File.pathSeparatorChar);
                    }
                    classpath.append(file.getAbsolutePath());
                }
            }
            loader = loader.getParent();
        }
        return classpath.toString();
    }
}

