/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.hdmap.renderer;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.BitSet;
import java.util.HashMap;
import java.util.Map;
import org.dynmap.Log;
import org.dynmap.renderer.CustomRenderer;
import org.dynmap.renderer.MapDataContext;
import org.dynmap.renderer.RenderPatch;
import org.dynmap.renderer.RenderPatchFactory;

public class FrameRenderer
extends CustomRenderer {
    private static Map<String, BitSet> linked_ids_by_set = new HashMap<String, BitSet>();
    private BitSet linked_ids;
    private double diameter;
    private RenderPatch[][][] models = new RenderPatch[64][][];
    private int base_index = 0;
    private int[] txtIndex;
    private int txtOffset = 0;
    private String idx_attrib = null;
    private String map_id = null;
    private int txtCount = 0;
    private int txtDefIndex = -1;
    private String[] tileEntityAttribs = null;
    private static final int[] x_off = new int[]{-1, 1, 0, 0, 0, 0};
    private static final int[] y_off = new int[]{0, 0, -1, 1, 0, 0};
    private static final int[] z_off = new int[]{0, 0, 0, 0, -1, 1};

    @Override
    public boolean initializeRenderer(RenderPatchFactory rpf, int blkid, int blockdatamask, Map<String, String> custparm) {
        String idx;
        if (!super.initializeRenderer(rpf, blkid, blockdatamask, custparm)) {
            return false;
        }
        String linkset = custparm.get("linkset");
        if (linkset == null) {
            linkset = "default";
        }
        this.linked_ids = linked_ids_by_set.get(linkset);
        if (this.linked_ids == null) {
            this.linked_ids = new BitSet();
            linked_ids_by_set.put(linkset, this.linked_ids);
        }
        this.linked_ids.set(blkid);
        String dia = custparm.get("diameter");
        if (dia == null) {
            dia = "0.5";
        }
        try {
            this.diameter = Double.parseDouble(dia);
        }
        catch (NumberFormatException nfx) {
            this.diameter = 0.5;
            Log.severe("Error: diameter must be number between 0.0 and 1.0");
        }
        if (this.diameter <= 0.0 || this.diameter >= 1.0) {
            Log.severe("Error: diameter must be number between 0.0 and 1.0");
            this.diameter = 0.5;
        }
        for (String k : custparm.keySet()) {
            if (!k.startsWith("linkid")) continue;
            int linkblkid = 0;
            try {
                linkblkid = Integer.parseInt(custparm.get(k));
            }
            catch (NumberFormatException nfx) {
                // empty catch block
            }
            if (linkblkid <= 0) continue;
            this.linked_ids.set(linkblkid);
        }
        String force = custparm.get("force");
        if (force != null) {
            String v = "xXyYzZ";
            for (int i = 0; i < v.length(); ++i) {
                if (force.indexOf(v.charAt(i)) < 0) continue;
                this.base_index |= 1 << i;
            }
        }
        if ((idx = custparm.get("textureIndex")) != null) {
            this.txtOffset = 0;
            String txt_off = custparm.get("textureOffset");
            if (txt_off != null) {
                this.txtOffset = Integer.valueOf(txt_off);
            }
            this.idx_attrib = idx;
            String txt_def = custparm.get("textureDefault");
            if (txt_def != null) {
                this.txtDefIndex = Integer.valueOf(txt_def);
            }
            this.map_id = custparm.get("textureMap");
            if (this.map_id == null) {
                String v;
                ArrayList<Integer> map = new ArrayList<Integer>();
                int id = 0;
                while ((v = custparm.get("index" + id)) != null) {
                    map.add(Integer.valueOf(v));
                    ++id;
                }
                this.txtIndex = new int[map.size()];
                for (id = 0; id < this.txtIndex.length; ++id) {
                    this.txtIndex[id] = (Integer)map.get(id) + this.txtOffset;
                }
                this.txtCount = this.txtIndex.length;
            }
            this.tileEntityAttribs = new String[1];
            this.tileEntityAttribs[0] = this.idx_attrib;
        } else {
            this.txtIndex = new int[1];
            this.txtCount = 1;
        }
        return true;
    }

    @Override
    public int getMaximumTextureCount(RenderPatchFactory rpf) {
        if (this.map_id != null && this.txtCount == 0) {
            this.txtCount = rpf.getTextureCountFromMap(this.map_id);
            if (this.txtCount < 0) {
                this.txtCount = 0;
            }
        }
        return this.txtCount;
    }

    @Override
    public String[] getTileEntityFieldsNeeded() {
        return this.tileEntityAttribs;
    }

    private RenderPatch[] buildModel(RenderPatchFactory rpf, int idx, int txt_idx) {
        ArrayList<RenderPatch> list = new ArrayList<RenderPatch>();
        int[] sides = new int[]{txt_idx, txt_idx, txt_idx, txt_idx, txt_idx, txt_idx};
        if ((idx & 3) != 0) {
            FrameRenderer.addBox(rpf, list, (idx & 1) != 0 ? 0.0 : 0.5 - this.diameter / 2.0, (idx & 2) != 0 ? 1.0 : 0.5 + this.diameter / 2.0, 0.5 - this.diameter / 2.0, 0.5 + this.diameter / 2.0, 0.5 - this.diameter / 2.0, 0.5 + this.diameter / 2.0, sides);
        }
        if ((idx & 0xC) != 0) {
            FrameRenderer.addBox(rpf, list, 0.5 - this.diameter / 2.0, 0.5 + this.diameter / 2.0, (idx & 4) != 0 ? 0.0 : 0.5 - this.diameter / 2.0, (idx & 8) != 0 ? 1.0 : 0.5 + this.diameter / 2.0, 0.5 - this.diameter / 2.0, 0.5 + this.diameter / 2.0, sides);
        }
        if ((idx & 0x30) != 0 || idx == 0) {
            FrameRenderer.addBox(rpf, list, 0.5 - this.diameter / 2.0, 0.5 + this.diameter / 2.0, 0.5 - this.diameter / 2.0, 0.5 + this.diameter / 2.0, (idx & 0x10) != 0 ? 0.0 : 0.5 - this.diameter / 2.0, (idx & 0x20) != 0 ? 1.0 : 0.5 + this.diameter / 2.0, sides);
        }
        return list.toArray(new RenderPatch[list.size()]);
    }

    @Override
    public RenderPatch[] getRenderPatchList(MapDataContext ctx) {
        int textureIdx;
        block8: {
            int val;
            block9: {
                Object idxv;
                textureIdx = 0;
                if (this.map_id != null && this.txtCount == 0) {
                    this.txtCount = ctx.getPatchFactory().getTextureCountFromMap(this.map_id);
                }
                if (this.idx_attrib == null || !((idxv = ctx.getBlockTileEntityField(this.idx_attrib)) instanceof Number)) break block8;
                val = ((Number)idxv).intValue();
                if (this.map_id == null) break block9;
                textureIdx = ctx.getPatchFactory().getTextureIndexFromMap(this.map_id, val - this.txtOffset);
                if (textureIdx < 0 && this.txtDefIndex >= 0) {
                    textureIdx = ctx.getPatchFactory().getTextureIndexFromMap(this.map_id, this.txtDefIndex);
                }
                if (textureIdx >= 0) break block8;
                textureIdx = 0;
                break block8;
            }
            for (int i = 0; i < this.txtIndex.length; ++i) {
                if (val != this.txtIndex[i]) continue;
                textureIdx = i;
                break;
            }
        }
        int idx = this.base_index;
        for (int i = 0; i < x_off.length; ++i) {
            int blkid;
            if ((idx & 1 << i) != 0 || !this.linked_ids.get(blkid = ctx.getBlockTypeIDAt(x_off[i], y_off[i], z_off[i]))) continue;
            idx |= 1 << i;
        }
        RenderPatch[][] row = this.models[idx];
        if (row == null) {
            row = new RenderPatch[this.txtCount][];
            this.models[idx] = row;
        }
        RenderPatch[] model = null;
        if (textureIdx < row.length) {
            model = row[textureIdx];
        }
        if (model == null) {
            model = this.buildModel(ctx.getPatchFactory(), idx, textureIdx);
            if (textureIdx >= row.length) {
                row = (RenderPatch[][])Arrays.copyOf(row, textureIdx + 1);
                this.models[idx] = row;
            }
            row[textureIdx] = model;
        }
        return model;
    }
}

