/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit;

import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Field;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import javax.imageio.ImageIO;
import org.bukkit.Material;
import org.bukkit.plugin.Plugin;
import org.dynmap.DynmapCore;
import org.dynmap.Log;
import org.dynmap.bukkit.DynmapPlugin;
import org.getspout.spoutapi.block.design.BlockDesign;
import org.getspout.spoutapi.block.design.GenericBlockDesign;
import org.getspout.spoutapi.block.design.GenericCuboidBlockDesign;
import org.getspout.spoutapi.block.design.Texture;
import org.getspout.spoutapi.material.CustomBlock;
import org.getspout.spoutapi.material.MaterialData;

public class SpoutPluginBlocks {
    private Field textXPosField;
    private Field textYPosField;
    private HashSet<String> plugins_pending = new HashSet();

    public SpoutPluginBlocks(Plugin plugin) {
        for (Plugin p : plugin.getServer().getPluginManager().getPlugins()) {
            List dep = p.getDescription().getDepend();
            if (dep == null || !dep.contains("Spout")) continue;
            Log.info("Found Spout plugin: " + p.getName());
            if (p.isEnabled()) continue;
            this.plugins_pending.add(p.getName());
        }
    }

    public boolean isReady() {
        return this.plugins_pending.isEmpty();
    }

    public void markPluginEnabled(Plugin p) {
        this.plugins_pending.remove(p.getName());
    }

    private boolean initSpoutAccess() {
        boolean success = false;
        try {
            this.textXPosField = GenericBlockDesign.class.getDeclaredField("textXPos");
            this.textXPosField.setAccessible(true);
            this.textYPosField = GenericBlockDesign.class.getDeclaredField("textYPos");
            this.textYPosField.setAccessible(true);
            success = true;
        }
        catch (NoSuchFieldException nsfx) {
            Log.severe("Cannot access needed Spout custom block fields!");
            Log.severe(nsfx);
        }
        return success;
    }

    private void addDefaultBlock(StringBuilder sb, CustomBlock blk) {
        if (blk.isOpaque()) {
            sb.append("block:id=" + blk.getCustomId() + ",data=*,allfaces=1\n");
        } else {
            sb.append("block:id=" + blk.getCustomId() + ",allfaces=12049,transparency=TRANSPARENT\n");
        }
    }

    private static String fixIDString(String id) {
        StringBuilder sb = new StringBuilder();
        int len = id.length();
        sb.setLength(len);
        for (int i = 0; i < len; ++i) {
            char c = id.charAt(i);
            if (Character.isJavaIdentifierStart(c)) {
                sb.setCharAt(i, c);
                continue;
            }
            sb.setCharAt(i, '_');
        }
        return sb.toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean processSpoutBlocks(DynmapPlugin plugin, DynmapCore core) {
        File st;
        File datadir = core.getDataFolder();
        if (this.textYPosField == null && !this.initSpoutAccess()) {
            return false;
        }
        HashMap<String, String> texturelist = new HashMap<String, String>();
        boolean use_existing_texture = core.configuration.getBoolean("spout/use-existing-textures", true);
        int cnt = 0;
        File f = new File(datadir, "texturepacks/standard/spout");
        if (!f.exists()) {
            f.mkdirs();
        }
        ArrayList<CustomBlock> blks = new ArrayList<CustomBlock>();
        CustomBlock[] cb = MaterialData.getCustomBlocks();
        StringBuilder sb = new StringBuilder();
        for (CustomBlock b : cb) {
            String txfileid;
            String blkname;
            String txtplug;
            BlockDesign bd = b.getBlockDesign();
            if (bd == null || (txtplug = bd.getTexturePlugin()) == null || (blkname = b.getName()) == null) continue;
            String blkid = txtplug + "." + SpoutPluginBlocks.fixIDString(blkname);
            if (!(bd instanceof GenericCuboidBlockDesign)) {
                Log.info("Block " + blkid + " not suppored - only cubiod blocks");
                this.addDefaultBlock(sb, b);
                continue;
            }
            Texture txt = bd.getTexture();
            int w = txt.getWidth();
            int h = txt.getHeight();
            int sz = txt.getSpriteSize();
            GenericCuboidBlockDesign gbd = (GenericCuboidBlockDesign)bd;
            int[] txtidx = new int[6];
            try {
                float[][] textXPos = (float[][])this.textXPosField.get(gbd);
                float[][] textYPos = (float[][])this.textYPosField.get(gbd);
                for (int i = 0; i < 6; ++i) {
                    float minx = 1.0f;
                    float miny = 1.0f;
                    for (int j = 0; j < 4; ++j) {
                        minx = Math.min(minx, textXPos[i][j]);
                        miny = Math.min(miny, textYPos[i][j]);
                    }
                    txtidx[i] = (int)(minx * (float)w / (float)sz) + w / sz * (int)(miny * (float)h / (float)sz);
                }
            }
            catch (Exception iax) {
                this.addDefaultBlock(sb, b);
                continue;
            }
            String txname = bd.getTexureURL();
            String txtid = (String)texturelist.get(txname);
            if (txtid == null) {
                File imgfile = new File(f, blkid + ".png");
                if (!use_existing_texture || !imgfile.exists()) {
                    boolean urlloaded;
                    BufferedImage img;
                    block58: {
                        img = null;
                        urlloaded = false;
                        try {
                            URL url = new URL(txname);
                            img = ImageIO.read(url);
                            urlloaded = true;
                        }
                        catch (IOException iox) {
                            if (!txname.startsWith("http")) {
                                File tf = new File(txname);
                                if (!tf.exists()) {
                                    try {
                                        File tmpf = File.createTempFile("dynmap", "test");
                                        tf = new File(tmpf.getParent(), txname);
                                        tmpf.delete();
                                    }
                                    catch (IOException iox2) {
                                        // empty catch block
                                    }
                                }
                                if (tf.exists()) {
                                    try {
                                        img = ImageIO.read(tf);
                                        urlloaded = true;
                                    }
                                    catch (IOException iox3) {
                                        // empty catch block
                                    }
                                }
                            }
                            if (img != null) break block58;
                            Log.severe("Error loading texture for custom block '" + blkid + "' (" + b.getCustomId() + ") from " + txname + "(" + iox.getMessage() + ")");
                            if (!imgfile.exists()) break block58;
                            try {
                                img = ImageIO.read(imgfile);
                                Log.info("Loaded cached texture file for " + blkid);
                            }
                            catch (IOException iox2) {
                                Log.severe("Error loading cached texture file for " + blkid + " - " + iox2.getMessage());
                            }
                        }
                    }
                    if (img != null) {
                        try {
                            if (urlloaded) {
                                ImageIO.write((RenderedImage)img, "png", imgfile);
                            }
                        }
                        catch (IOException iox) {
                            Log.severe("Error writing " + blkid + ".png");
                        }
                        finally {
                            img.flush();
                        }
                    }
                }
                if (imgfile.exists()) {
                    String tfid = "txtid" + texturelist.size();
                    sb.append("texturefile:id=" + tfid + ",filename=spout/" + blkid + ".png,xcount=" + w / sz + ",ycount=" + h / sz + "\n");
                    texturelist.put(txname, tfid);
                }
            }
            if ((txfileid = (String)texturelist.get(txname)) == null) continue;
            blks.add(b);
            sb.append("block:id=" + b.getCustomId() + ",data=*,bottom=" + txtidx[0] + ",west=" + txtidx[1] + ",south=" + txtidx[2] + ",east=" + txtidx[3] + ",north=" + txtidx[4] + ",top=" + txtidx[5]);
            if (b.getBlockId() == Material.GLASS.getId()) {
                sb.append(",transparency=TRANSPARENT");
            }
            sb.append(",txtid=" + txfileid + "\n");
            ++cnt;
        }
        String rslt = sb.toString();
        File renderdata = new File(datadir, "renderdata");
        if (!renderdata.exists()) {
            renderdata.mkdirs();
        }
        if ((st = new File(renderdata, "spout-texture.txt")).exists()) {
            FileReader fr = null;
            StringBuilder sbold = new StringBuilder();
            try {
                int len;
                fr = new FileReader(st);
                char[] buf = new char[512];
                while ((len = fr.read(buf)) > 0) {
                    sbold.append(buf, 0, len);
                }
            }
            catch (IOException iox) {
            }
            finally {
                if (fr != null) {
                    try {
                        fr.close();
                    }
                    catch (IOException iox) {}
                }
            }
            if (sbold.equals(rslt)) {
                Log.info("Loaded " + cnt + " Spout custom blocks");
                return false;
            }
        }
        FileWriter fw = null;
        try {
            fw = new FileWriter(st);
            fw.write(rslt);
        }
        catch (IOException iox) {
            Log.severe("Error opening spout texture file - " + st.getPath());
            boolean bl = false;
            return bl;
        }
        finally {
            if (fw != null) {
                try {
                    fw.close();
                }
                catch (IOException iox) {}
            }
        }
        Log.info("Loaded " + cnt + " Spout custom blocks");
        return false;
    }
}

