/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit;

import java.util.ArrayList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.block.Biome;
import org.dynmap.DynmapChunk;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapWorld;
import org.dynmap.Log;
import org.dynmap.bukkit.BukkitVersionHelper;
import org.dynmap.bukkit.BukkitWorld;
import org.dynmap.bukkit.DynmapPlugin;
import org.dynmap.bukkit.SnapshotCache;
import org.dynmap.common.BiomeMap;
import org.dynmap.hdmap.HDBlockModels;
import org.dynmap.renderer.RenderPatchFactory;
import org.dynmap.utils.BlockStep;
import org.dynmap.utils.DynIntHashMap;
import org.dynmap.utils.MapChunkCache;
import org.dynmap.utils.MapIterator;
import org.dynmap.utils.VisibilityLimit;
import org.getspout.spoutapi.block.SpoutChunk;

public class NewMapChunkCache
extends MapChunkCache {
    private static boolean init;
    private static boolean use_spout;
    private World w;
    private DynmapWorld dw;
    private int nsect;
    private List<DynmapChunk> chunks;
    private ListIterator<DynmapChunk> iterator;
    private int x_min;
    private int x_max;
    private int z_min;
    private int z_max;
    private int x_dim;
    private boolean biome;
    private boolean biomeraw;
    private boolean highesty;
    private boolean blockdata;
    private MapChunkCache.HiddenChunkStyle hidestyle = MapChunkCache.HiddenChunkStyle.FILL_AIR;
    private List<VisibilityLimit> visible_limits = null;
    private List<VisibilityLimit> hidden_limits = null;
    private boolean isempty = true;
    private int snapcnt;
    private ChunkSnapshot[] snaparray;
    private DynIntHashMap[] snaptile;
    private byte[][] sameneighborbiomecnt;
    private BiomeMap[][] biomemap;
    private boolean[][] isSectionNotEmpty;
    private long[] inhabitedTicks;
    private static BukkitVersionHelper helper;
    private static final BlockStep[] unstep;
    private static BiomeMap[] biome_to_bmap;
    private static final EmptyChunk EMPTY;
    private static final PlainChunk STONE;
    private static final PlainChunk OCEAN;

    private static final int getIndexInChunk(int cx, int cy, int cz) {
        return cy << 8 | cz << 4 | cx;
    }

    public NewMapChunkCache() {
        if (!init) {
            use_spout = DynmapPlugin.plugin.hasSpout();
            init = true;
        }
    }

    public void setChunks(BukkitWorld dw, List<DynmapChunk> chunks) {
        this.dw = dw;
        this.w = dw.getWorld();
        if (this.w == null) {
            this.chunks = new ArrayList<DynmapChunk>();
        }
        this.nsect = dw.worldheight >> 4;
        this.chunks = chunks;
        if (chunks.size() == 0) {
            this.x_min = 0;
            this.x_max = 0;
            this.z_min = 0;
            this.z_max = 0;
            this.x_dim = 1;
        } else {
            this.x_min = this.x_max = chunks.get((int)0).x;
            this.z_min = this.z_max = chunks.get((int)0).z;
            for (DynmapChunk c : chunks) {
                if (c.x > this.x_max) {
                    this.x_max = c.x;
                }
                if (c.x < this.x_min) {
                    this.x_min = c.x;
                }
                if (c.z > this.z_max) {
                    this.z_max = c.z;
                }
                if (c.z >= this.z_min) continue;
                this.z_min = c.z;
            }
            this.x_dim = this.x_max - this.x_min + 1;
        }
        this.snapcnt = this.x_dim * (this.z_max - this.z_min + 1);
        this.snaparray = new ChunkSnapshot[this.snapcnt];
        this.inhabitedTicks = new long[this.snapcnt];
        this.snaptile = new DynIntHashMap[this.snapcnt];
        this.isSectionNotEmpty = new boolean[this.snapcnt][];
    }

    private ChunkSnapshot checkSpoutData(Chunk c, ChunkSnapshot ss) {
        SpoutChunk sc;
        short[] custids;
        if (c instanceof SpoutChunk && (custids = (sc = (SpoutChunk)c).getCustomBlockIds()) != null) {
            return new SpoutChunkSnapshot(ss, custids, c.getWorld().getMaxHeight());
        }
        return ss;
    }

    @Override
    public int loadChunks(int max_to_load) {
        if (!this.dw.isLoaded()) {
            return 0;
        }
        Object queue = helper.getUnloadQueue(this.w);
        int cnt = 0;
        if (this.iterator == null) {
            this.iterator = this.chunks.listIterator();
        }
        DynmapCore.setIgnoreChunkLoads(true);
        while (cnt < max_to_load && this.iterator.hasNext()) {
            boolean isunloadpending;
            boolean didload;
            boolean wasLoaded;
            SnapshotCache.SnapshotRec ssr;
            DynIntHashMap tileData;
            long inhabited_ticks;
            Object ss;
            boolean vis;
            DynmapChunk chunk;
            long startTime;
            block30: {
                startTime = System.nanoTime();
                chunk = this.iterator.next();
                vis = true;
                if (this.visible_limits != null) {
                    vis = false;
                    for (VisibilityLimit limit : this.visible_limits) {
                        if (!limit.doIntersectChunk(chunk.x, chunk.z)) continue;
                        vis = true;
                        break;
                    }
                }
                if (vis && this.hidden_limits != null) {
                    for (VisibilityLimit limit : this.hidden_limits) {
                        if (!limit.doIntersectChunk(chunk.x, chunk.z)) continue;
                        vis = false;
                        break;
                    }
                }
                ss = null;
                inhabited_ticks = 0L;
                tileData = null;
                ssr = DynmapPlugin.plugin.sscache.getSnapshot(this.dw.getName(), chunk.x, chunk.z, this.blockdata, this.biome, this.biomeraw, this.highesty);
                if (ssr != null) {
                    ss = ssr.ss;
                    inhabited_ticks = ssr.inhabitedTicks;
                    if (!vis) {
                        ss = this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? STONE : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? OCEAN : EMPTY);
                    }
                    int idx = chunk.x - this.x_min + (chunk.z - this.z_min) * this.x_dim;
                    this.snaparray[idx] = ss;
                    this.snaptile[idx] = ssr.tileData;
                    this.inhabitedTicks[idx] = inhabited_ticks;
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.CACHED_SNAPSHOT_HIT);
                    continue;
                }
                wasLoaded = this.w.isChunkLoaded(chunk.x, chunk.z);
                didload = false;
                isunloadpending = false;
                if (queue != null) {
                    isunloadpending = helper.isInUnloadQueue(queue, chunk.x, chunk.z);
                }
                if (isunloadpending) {
                    wasLoaded = true;
                }
                try {
                    didload = this.w.loadChunk(chunk.x, chunk.z, false);
                }
                catch (Throwable t) {
                    Log.warning("Bukkit error loading chunk " + chunk.x + "," + chunk.z + " on " + this.w.getName());
                    if (wasLoaded) break block30;
                    didload = this.w.isChunkLoaded(chunk.x, chunk.z);
                }
            }
            if (didload) {
                tileData = new DynIntHashMap();
                Chunk c = this.w.getChunkAt(chunk.x, chunk.z);
                inhabited_ticks = helper.getInhabitedTicks(c);
                if (!vis) {
                    ss = this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_STONE_PLAIN ? STONE : (this.hidestyle == MapChunkCache.HiddenChunkStyle.FILL_OCEAN ? OCEAN : EMPTY);
                } else {
                    if (this.blockdata || this.highesty) {
                        ss = c.getChunkSnapshot(this.highesty, this.biome, this.biomeraw);
                        if (use_spout) {
                            ss = this.checkSpoutData(c, (ChunkSnapshot)ss);
                        }
                        ArrayList<Object> vals = new ArrayList<Object>();
                        Map tileents = helper.getTileEntitiesForChunk(c);
                        for (Object t : tileents.values()) {
                            int blkdat;
                            int te_z;
                            int cz;
                            int te_y;
                            int te_x = helper.getTileEntityX(t);
                            int cx = te_x & 0xF;
                            int blkid = ss.getBlockTypeId(cx, te_y = helper.getTileEntityY(t), cz = (te_z = helper.getTileEntityZ(t)) & 0xF);
                            String[] te_fields = HDBlockModels.getTileEntityFieldsNeeded(blkid, blkdat = ss.getBlockData(cx, te_y, cz));
                            if (te_fields == null) continue;
                            Object nbtcompound = helper.readTileEntityNBT(t);
                            vals.clear();
                            for (String id : te_fields) {
                                Object val = helper.getFieldValue(nbtcompound, id);
                                if (val == null) continue;
                                vals.add(id);
                                vals.add(val);
                            }
                            if (vals.size() <= 0) continue;
                            Object[] vlist = vals.toArray(new Object[vals.size()]);
                            tileData.put(NewMapChunkCache.getIndexInChunk(cx, te_y, cz), vlist);
                        }
                    } else {
                        ss = this.w.getEmptyChunkSnapshot(chunk.x, chunk.z, this.biome, this.biomeraw);
                    }
                    if (ss != null) {
                        ssr = new SnapshotCache.SnapshotRec();
                        ssr.ss = ss;
                        ssr.inhabitedTicks = inhabited_ticks;
                        ssr.tileData = tileData;
                        DynmapPlugin.plugin.sscache.putSnapshot(this.dw.getName(), chunk.x, chunk.z, ssr, this.blockdata, this.biome, this.biomeraw, this.highesty);
                    }
                }
                int chunkIndex = chunk.x - this.x_min + (chunk.z - this.z_min) * this.x_dim;
                this.snaparray[chunkIndex] = ss;
                this.snaptile[chunkIndex] = tileData;
                this.inhabitedTicks[chunkIndex] = inhabited_ticks;
                if (!wasLoaded) {
                    helper.unloadChunkNoSave(this.w, c, chunk.x, chunk.z);
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.UNLOADED_CHUNKS);
                } else if (isunloadpending) {
                    this.w.unloadChunkRequest(chunk.x, chunk.z);
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.LOADED_CHUNKS);
                } else {
                    this.endChunkLoad(startTime, MapChunkCache.ChunkStats.LOADED_CHUNKS);
                }
            } else {
                this.endChunkLoad(startTime, MapChunkCache.ChunkStats.UNGENERATED_CHUNKS);
            }
            ++cnt;
        }
        DynmapCore.setIgnoreChunkLoads(false);
        if (!this.iterator.hasNext()) {
            this.isempty = true;
            for (int i = 0; i < this.snaparray.length; ++i) {
                if (this.snaparray[i] == null) {
                    this.snaparray[i] = EMPTY;
                    continue;
                }
                if (this.snaparray[i] == EMPTY) continue;
                this.isempty = false;
            }
        }
        return cnt;
    }

    @Override
    public boolean isDoneLoading() {
        if (!this.dw.isLoaded()) {
            this.isempty = true;
            this.unloadChunks();
            return true;
        }
        if (this.iterator != null) {
            return !this.iterator.hasNext();
        }
        return false;
    }

    @Override
    public boolean isEmpty() {
        return this.isempty;
    }

    @Override
    public void unloadChunks() {
        if (this.snaparray != null) {
            for (int i = 0; i < this.snaparray.length; ++i) {
                this.snaparray[i] = null;
            }
            this.snaparray = null;
            this.inhabitedTicks = null;
        }
    }

    private void initSectionData(int idx) {
        this.isSectionNotEmpty[idx] = new boolean[this.nsect + 1];
        if (this.snaparray[idx] != EMPTY) {
            for (int i = 0; i < this.nsect; ++i) {
                if (this.snaparray[idx].isSectionEmpty(i)) continue;
                this.isSectionNotEmpty[idx][i] = true;
            }
        }
    }

    @Override
    public boolean isEmptySection(int sx, int sy, int sz) {
        int idx = sx - this.x_min + (sz - this.z_min) * this.x_dim;
        if (this.isSectionNotEmpty[idx] == null) {
            this.initSectionData(idx);
        }
        return !this.isSectionNotEmpty[idx][sy];
    }

    @Override
    public MapIterator getIterator(int x, int y, int z) {
        if (this.w.getEnvironment().toString().equals("THE_END")) {
            return new OurEndMapIterator(x, y, z);
        }
        return new OurMapIterator(x, y, z);
    }

    @Override
    public void setHiddenFillStyle(MapChunkCache.HiddenChunkStyle style) {
        this.hidestyle = style;
    }

    @Override
    public void setVisibleRange(VisibilityLimit lim) {
        if (this.visible_limits == null) {
            this.visible_limits = new ArrayList<VisibilityLimit>();
        }
        this.visible_limits.add(lim);
    }

    @Override
    public void setHiddenRange(VisibilityLimit lim) {
        if (this.hidden_limits == null) {
            this.hidden_limits = new ArrayList<VisibilityLimit>();
        }
        this.hidden_limits.add(lim);
    }

    @Override
    public boolean setChunkDataTypes(boolean blockdata, boolean biome, boolean highestblocky, boolean rawbiome) {
        this.biome = biome;
        this.biomeraw = rawbiome;
        this.highesty = highestblocky;
        this.blockdata = blockdata;
        return true;
    }

    @Override
    public DynmapWorld getWorld() {
        return this.dw;
    }

    static /* synthetic */ byte[][] access$802(NewMapChunkCache x0, byte[][] x1) {
        x0.sameneighborbiomecnt = x1;
        return x1;
    }

    static /* synthetic */ BiomeMap[][] access$1002(NewMapChunkCache x0, BiomeMap[][] x1) {
        x0.biomemap = x1;
        return x1;
    }

    static {
        int i;
        init = false;
        use_spout = false;
        helper = BukkitVersionHelper.getHelper();
        unstep = new BlockStep[]{BlockStep.X_MINUS, BlockStep.Y_MINUS, BlockStep.Z_MINUS, BlockStep.X_PLUS, BlockStep.Y_PLUS, BlockStep.Z_PLUS};
        EMPTY = new EmptyChunk();
        STONE = new PlainChunk(1);
        OCEAN = new PlainChunk(9);
        Biome[] b = Biome.values();
        BiomeMap[] bm = BiomeMap.values();
        biome_to_bmap = new BiomeMap[256];
        for (i = 0; i < biome_to_bmap.length; ++i) {
            NewMapChunkCache.biome_to_bmap[i] = BiomeMap.NULL;
        }
        block1: for (i = 0; i < b.length; ++i) {
            String bs = b[i].toString();
            for (int j = 0; j < bm.length; ++j) {
                if (!bm[j].toString().equals(bs)) continue;
                NewMapChunkCache.biome_to_bmap[b[i].ordinal()] = bm[j];
                continue block1;
            }
        }
    }

    private static class SpoutChunkSnapshot
    implements ChunkSnapshot {
        private ChunkSnapshot chunk;
        private short[] customids;
        private final int shiftx;
        private final int shiftz;

        SpoutChunkSnapshot(ChunkSnapshot chunk, short[] customids, int height) {
            this.chunk = chunk;
            this.customids = (short[])customids.clone();
            int sx = 11;
            int sz = 7;
            while (height > 128) {
                ++sx;
                ++sz;
                height >>= 1;
            }
            this.shiftx = sx;
            this.shiftz = sz;
        }

        public final int getX() {
            return this.chunk.getX();
        }

        public final int getZ() {
            return this.chunk.getZ();
        }

        public final String getWorldName() {
            return this.chunk.getWorldName();
        }

        public final Biome getBiome(int x, int z) {
            return this.chunk.getBiome(x, z);
        }

        public final double getRawBiomeTemperature(int x, int z) {
            return this.chunk.getRawBiomeTemperature(x, z);
        }

        public final double getRawBiomeRainfall(int x, int z) {
            return this.chunk.getRawBiomeRainfall(x, z);
        }

        public final long getCaptureFullTime() {
            return this.chunk.getCaptureFullTime();
        }

        public final int getBlockTypeId(int x, int y, int z) {
            short id = this.customids[x << this.shiftx | z << this.shiftz | y];
            if (id != 0) {
                return id;
            }
            return this.chunk.getBlockTypeId(x, y, z);
        }

        public final int getBlockData(int x, int y, int z) {
            return this.chunk.getBlockData(x, y, z);
        }

        public final int getBlockSkyLight(int x, int y, int z) {
            return this.chunk.getBlockSkyLight(x, y, z);
        }

        public final int getBlockEmittedLight(int x, int y, int z) {
            return this.chunk.getBlockEmittedLight(x, y, z);
        }

        public final int getHighestBlockYAt(int x, int z) {
            return this.chunk.getHighestBlockYAt(x, z);
        }

        public boolean isSectionEmpty(int sy) {
            return this.chunk.isSectionEmpty(sy);
        }
    }

    private static class PlainChunk
    implements ChunkSnapshot {
        private int fillid;

        PlainChunk(int fillid) {
            this.fillid = fillid;
        }

        public int getX() {
            return 0;
        }

        public int getZ() {
            return 0;
        }

        public String getWorldName() {
            return "";
        }

        public Biome getBiome(int x, int z) {
            return null;
        }

        public double getRawBiomeTemperature(int x, int z) {
            return 0.0;
        }

        public double getRawBiomeRainfall(int x, int z) {
            return 0.0;
        }

        public long getCaptureFullTime() {
            return 0L;
        }

        public final int getBlockTypeId(int x, int y, int z) {
            if (y < 64) {
                return this.fillid;
            }
            return 0;
        }

        public final int getBlockData(int x, int y, int z) {
            return 0;
        }

        public final int getBlockSkyLight(int x, int y, int z) {
            if (y < 64) {
                return 0;
            }
            return 15;
        }

        public final int getBlockEmittedLight(int x, int y, int z) {
            return 0;
        }

        public final int getHighestBlockYAt(int x, int z) {
            return 64;
        }

        public boolean isSectionEmpty(int sy) {
            return sy < 4;
        }
    }

    private static class EmptyChunk
    implements ChunkSnapshot {
        private EmptyChunk() {
        }

        public int getX() {
            return 0;
        }

        public int getZ() {
            return 0;
        }

        public String getWorldName() {
            return "";
        }

        public long getCaptureFullTime() {
            return 0L;
        }

        public final int getBlockTypeId(int x, int y, int z) {
            return 0;
        }

        public final int getBlockData(int x, int y, int z) {
            return 0;
        }

        public final int getBlockSkyLight(int x, int y, int z) {
            return 15;
        }

        public final int getBlockEmittedLight(int x, int y, int z) {
            return 0;
        }

        public final int getHighestBlockYAt(int x, int z) {
            return 0;
        }

        public Biome getBiome(int x, int z) {
            return null;
        }

        public double getRawBiomeTemperature(int x, int z) {
            return 0.0;
        }

        public double getRawBiomeRainfall(int x, int z) {
            return 0.0;
        }

        public boolean isSectionEmpty(int sy) {
            return true;
        }
    }

    private class OurEndMapIterator
    extends OurMapIterator {
        OurEndMapIterator(int x0, int y0, int z0) {
            super(x0, y0, z0);
        }

        @Override
        public final int getBlockSkyLight() {
            return 15;
        }
    }

    public class OurMapIterator
    implements MapIterator {
        private int x;
        private int y;
        private int z;
        private int chunkindex;
        private int bx;
        private int bz;
        private int off;
        private ChunkSnapshot snap;
        private BlockStep laststep;
        private int typeid = -1;
        private int blkdata = -1;
        private final int worldheight;
        private final int x_base;
        private final int z_base;

        OurMapIterator(int x0, int y0, int z0) {
            this.x_base = NewMapChunkCache.this.x_min << 4;
            this.z_base = NewMapChunkCache.this.z_min << 4;
            if (NewMapChunkCache.this.biome) {
                this.biomePrep();
            }
            this.initialize(x0, y0, z0);
            this.worldheight = NewMapChunkCache.this.w.getMaxHeight();
        }

        @Override
        public final void initialize(int x0, int y0, int z0) {
            this.x = x0;
            this.y = y0;
            this.z = z0;
            this.chunkindex = (this.x >> 4) - NewMapChunkCache.this.x_min + ((this.z >> 4) - NewMapChunkCache.this.z_min) * NewMapChunkCache.this.x_dim;
            this.bx = this.x & 0xF;
            this.bz = this.z & 0xF;
            this.off = this.bx + (this.bz << 4);
            this.snap = this.chunkindex >= NewMapChunkCache.this.snapcnt || this.chunkindex < 0 ? EMPTY : NewMapChunkCache.this.snaparray[this.chunkindex];
            this.laststep = BlockStep.Y_MINUS;
            if (this.y >= 0 && this.y < this.worldheight) {
                this.blkdata = -1;
                this.typeid = -1;
            } else {
                this.blkdata = 0;
                this.typeid = 0;
            }
        }

        @Override
        public final int getBlockTypeID() {
            if (this.typeid < 0) {
                this.typeid = this.snap.getBlockTypeId(this.bx, this.y, this.bz);
            }
            return this.typeid;
        }

        @Override
        public final int getBlockData() {
            if (this.blkdata < 0) {
                this.blkdata = this.snap.getBlockData(this.bx, this.y, this.bz);
            }
            return this.blkdata;
        }

        @Override
        public int getBlockSkyLight() {
            try {
                return this.snap.getBlockSkyLight(this.bx, this.y, this.bz);
            }
            catch (ArrayIndexOutOfBoundsException aioobx) {
                return 15;
            }
        }

        @Override
        public final int getBlockEmittedLight() {
            try {
                return this.snap.getBlockEmittedLight(this.bx, this.y, this.bz);
            }
            catch (ArrayIndexOutOfBoundsException aioobx) {
                return 0;
            }
        }

        private void biomePrep() {
            if (NewMapChunkCache.this.sameneighborbiomecnt != null) {
                return;
            }
            int x_size = NewMapChunkCache.this.x_dim << 4;
            int z_size = NewMapChunkCache.this.z_max - NewMapChunkCache.this.z_min + 1 << 4;
            NewMapChunkCache.access$802(NewMapChunkCache.this, new byte[x_size][]);
            NewMapChunkCache.access$1002(NewMapChunkCache.this, new BiomeMap[x_size][]);
            for (int i = 0; i < x_size; ++i) {
                ((NewMapChunkCache)NewMapChunkCache.this).sameneighborbiomecnt[i] = new byte[z_size];
                ((NewMapChunkCache)NewMapChunkCache.this).biomemap[i] = new BiomeMap[z_size];
            }
            Object[] biomebase = null;
            ChunkSnapshot biome_css = null;
            for (int i = 0; i < x_size; ++i) {
                for (int j = 0; j < z_size; ++j) {
                    Biome bb;
                    if (j == 0) {
                        this.initialize(i + this.x_base, 64, this.z_base);
                    } else {
                        this.stepPosition(BlockStep.Z_PLUS);
                    }
                    if (this.snap != biome_css) {
                        biomebase = null;
                        biome_css = this.snap;
                        if (biome_css instanceof SpoutChunkSnapshot) {
                            biome_css = ((SpoutChunkSnapshot)biome_css).chunk;
                        }
                        biomebase = helper.getBiomeBaseFromSnapshot(biome_css);
                    }
                    BiomeMap bm = biomebase != null ? BiomeMap.byBiomeID(helper.getBiomeBaseID(biomebase[this.bz << 4 | this.bx])) : ((bb = this.snap.getBiome(this.bx, this.bz)) == null ? BiomeMap.NULL : biome_to_bmap[bb.ordinal()]);
                    ((NewMapChunkCache)NewMapChunkCache.this).biomemap[i][j] = bm;
                    int cnt = 0;
                    if (i > 0) {
                        if (bm == NewMapChunkCache.this.biomemap[i - 1][j]) {
                            ++cnt;
                            byte[] byArray = NewMapChunkCache.this.sameneighborbiomecnt[i - 1];
                            int n = j;
                            byArray[n] = (byte)(byArray[n] + 1);
                        }
                        if (j > 0 && bm == NewMapChunkCache.this.biomemap[i - 1][j - 1]) {
                            ++cnt;
                            byte[] byArray = NewMapChunkCache.this.sameneighborbiomecnt[i - 1];
                            int n = j - 1;
                            byArray[n] = (byte)(byArray[n] + 1);
                        }
                        if (j < z_size - 1 && bm == NewMapChunkCache.this.biomemap[i - 1][j + 1]) {
                            ++cnt;
                            byte[] byArray = NewMapChunkCache.this.sameneighborbiomecnt[i - 1];
                            int n = j + 1;
                            byArray[n] = (byte)(byArray[n] + 1);
                        }
                    }
                    if (j > 0 && NewMapChunkCache.this.biomemap[i][j] == NewMapChunkCache.this.biomemap[i][j - 1]) {
                        ++cnt;
                        byte[] byArray = NewMapChunkCache.this.sameneighborbiomecnt[i];
                        int n = j - 1;
                        byArray[n] = (byte)(byArray[n] + 1);
                    }
                    ((NewMapChunkCache)NewMapChunkCache.this).sameneighborbiomecnt[i][j] = (byte)cnt;
                }
            }
        }

        @Override
        public final BiomeMap getBiome() {
            try {
                return NewMapChunkCache.this.biomemap[this.x - this.x_base][this.z - this.z_base];
            }
            catch (Exception ex) {
                return BiomeMap.NULL;
            }
        }

        @Override
        public final int getSmoothGrassColorMultiplier(int[] colormap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = NewMapChunkCache.this.biomemap[rx][rz];
                if (NewMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = bm.getModifiedGrassMultiplier(colormap[bm.biomeLookup()]);
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = NewMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = bm.getModifiedGrassMultiplier(colormap[bm.biomeLookup()]);
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final int getSmoothFoliageColorMultiplier(int[] colormap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = NewMapChunkCache.this.biomemap[rx][rz];
                if (NewMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = bm.getModifiedFoliageMultiplier(colormap[bm.biomeLookup()]);
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = NewMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = bm.getModifiedFoliageMultiplier(colormap[bm.biomeLookup()]);
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final int getSmoothColorMultiplier(int[] colormap, int[] swampmap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = NewMapChunkCache.this.biomemap[rx][rz];
                if (NewMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = bm == BiomeMap.SWAMPLAND ? swampmap[bm.biomeLookup()] : colormap[bm.biomeLookup()];
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = NewMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = bm == BiomeMap.SWAMPLAND ? swampmap[bm.biomeLookup()] : colormap[bm.biomeLookup()];
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final int getSmoothWaterColorMultiplier() {
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = NewMapChunkCache.this.biomemap[rx][rz];
                if (NewMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    return bm.getWaterColorMult();
                }
                int raccum = 0;
                int gaccum = 0;
                int baccum = 0;
                for (int xoff = -1; xoff < 2; ++xoff) {
                    for (int zoff = -1; zoff < 2; ++zoff) {
                        bm = NewMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                        int mult = bm.getWaterColorMult();
                        raccum += mult >> 16 & 0xFF;
                        gaccum += mult >> 8 & 0xFF;
                        baccum += mult & 0xFF;
                    }
                }
                return raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
            }
            catch (Exception x) {
                return 0xFFFFFF;
            }
        }

        @Override
        public final int getSmoothWaterColorMultiplier(int[] colormap) {
            int mult = 0xFFFFFF;
            try {
                int rx = this.x - this.x_base;
                int rz = this.z - this.z_base;
                BiomeMap bm = NewMapChunkCache.this.biomemap[rx][rz];
                if (NewMapChunkCache.this.sameneighborbiomecnt[rx][rz] >= 8) {
                    mult = colormap[bm.biomeLookup()];
                } else {
                    int raccum = 0;
                    int gaccum = 0;
                    int baccum = 0;
                    for (int xoff = -1; xoff < 2; ++xoff) {
                        for (int zoff = -1; zoff < 2; ++zoff) {
                            bm = NewMapChunkCache.this.biomemap[rx + xoff][rz + zoff];
                            int rmult = colormap[bm.biomeLookup()];
                            raccum += rmult >> 16 & 0xFF;
                            gaccum += rmult >> 8 & 0xFF;
                            baccum += rmult & 0xFF;
                        }
                    }
                    mult = raccum / 9 << 16 | gaccum / 9 << 8 | baccum / 9;
                }
            }
            catch (Exception x) {
                mult = 0xFFFFFF;
            }
            return mult;
        }

        @Override
        public final void stepPosition(BlockStep step) {
            this.typeid = -1;
            this.blkdata = -1;
            switch (step.ordinal()) {
                case 0: {
                    ++this.x;
                    ++this.bx;
                    ++this.off;
                    if (this.bx != 16) break;
                    this.bx = 0;
                    this.off -= 16;
                    ++this.chunkindex;
                    if (this.chunkindex >= NewMapChunkCache.this.snapcnt || this.chunkindex < 0) {
                        this.snap = EMPTY;
                        break;
                    }
                    this.snap = NewMapChunkCache.this.snaparray[this.chunkindex];
                    break;
                }
                case 1: {
                    ++this.y;
                    if (this.y < this.worldheight) break;
                    this.blkdata = 0;
                    this.typeid = 0;
                    break;
                }
                case 2: {
                    ++this.z;
                    ++this.bz;
                    this.off += 16;
                    if (this.bz != 16) break;
                    this.bz = 0;
                    this.off -= 256;
                    this.chunkindex += NewMapChunkCache.this.x_dim;
                    if (this.chunkindex >= NewMapChunkCache.this.snapcnt || this.chunkindex < 0) {
                        this.snap = EMPTY;
                        break;
                    }
                    this.snap = NewMapChunkCache.this.snaparray[this.chunkindex];
                    break;
                }
                case 3: {
                    --this.x;
                    --this.bx;
                    --this.off;
                    if (this.bx != -1) break;
                    this.bx = 15;
                    this.off += 16;
                    --this.chunkindex;
                    if (this.chunkindex >= NewMapChunkCache.this.snapcnt || this.chunkindex < 0) {
                        this.snap = EMPTY;
                        break;
                    }
                    this.snap = NewMapChunkCache.this.snaparray[this.chunkindex];
                    break;
                }
                case 4: {
                    --this.y;
                    if (this.y >= 0) break;
                    this.blkdata = 0;
                    this.typeid = 0;
                    break;
                }
                case 5: {
                    --this.z;
                    --this.bz;
                    this.off -= 16;
                    if (this.bz != -1) break;
                    this.bz = 15;
                    this.off += 256;
                    this.chunkindex -= NewMapChunkCache.this.x_dim;
                    this.snap = this.chunkindex >= NewMapChunkCache.this.snapcnt || this.chunkindex < 0 ? EMPTY : NewMapChunkCache.this.snaparray[this.chunkindex];
                }
            }
            this.laststep = step;
        }

        @Override
        public BlockStep unstepPosition() {
            BlockStep ls = this.laststep;
            this.stepPosition(unstep[ls.ordinal()]);
            return ls;
        }

        @Override
        public void unstepPosition(BlockStep s) {
            this.stepPosition(unstep[s.ordinal()]);
        }

        @Override
        public final void setY(int y) {
            this.laststep = y > this.y ? BlockStep.Y_PLUS : BlockStep.Y_MINUS;
            this.y = y;
            if (y < 0 || y >= this.worldheight) {
                this.blkdata = 0;
                this.typeid = 0;
            } else {
                this.blkdata = -1;
                this.typeid = -1;
            }
        }

        @Override
        public final int getX() {
            return this.x;
        }

        @Override
        public final int getY() {
            return this.y;
        }

        @Override
        public final int getZ() {
            return this.z;
        }

        @Override
        public final int getBlockTypeIDAt(BlockStep s) {
            if (s == BlockStep.Y_MINUS) {
                if (this.y > 0) {
                    return this.snap.getBlockTypeId(this.bx, this.y - 1, this.bz);
                }
            } else if (s == BlockStep.Y_PLUS) {
                if (this.y < this.worldheight - 1) {
                    return this.snap.getBlockTypeId(this.bx, this.y + 1, this.bz);
                }
            } else {
                BlockStep ls = this.laststep;
                this.stepPosition(s);
                int tid = this.snap.getBlockTypeId(this.bx, this.y, this.bz);
                this.unstepPosition();
                this.laststep = ls;
                return tid;
            }
            return 0;
        }

        @Override
        public BlockStep getLastStep() {
            return this.laststep;
        }

        @Override
        public int getWorldHeight() {
            return this.worldheight;
        }

        @Override
        public long getBlockKey() {
            return this.chunkindex * this.worldheight + this.y << 8 | this.bx << 4 | this.bz;
        }

        @Override
        public final boolean isEmptySection() {
            try {
                return !NewMapChunkCache.this.isSectionNotEmpty[this.chunkindex][this.y >> 4];
            }
            catch (Exception x) {
                NewMapChunkCache.this.initSectionData(this.chunkindex);
                return !NewMapChunkCache.this.isSectionNotEmpty[this.chunkindex][this.y >> 4];
            }
        }

        @Override
        public RenderPatchFactory getPatchFactory() {
            return HDBlockModels.getPatchDefinitionFactory();
        }

        @Override
        public Object getBlockTileEntityField(String fieldId) {
            try {
                int idx = NewMapChunkCache.getIndexInChunk(this.bx, this.y, this.bz);
                Object[] vals = (Object[])NewMapChunkCache.this.snaptile[this.chunkindex].get(idx);
                for (int i = 0; i < vals.length; i += 2) {
                    if (!vals[i].equals(fieldId)) continue;
                    return vals[i + 1];
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return null;
        }

        @Override
        public int getBlockTypeIDAt(int xoff, int yoff, int zoff) {
            int xx = this.x + xoff;
            int yy = this.y + yoff;
            int zz = this.z + zoff;
            int idx = (xx >> 4) - NewMapChunkCache.this.x_min + ((zz >> 4) - NewMapChunkCache.this.z_min) * NewMapChunkCache.this.x_dim;
            try {
                return NewMapChunkCache.this.snaparray[idx].getBlockTypeId(xx & 0xF, yy, zz & 0xF);
            }
            catch (Exception x) {
                return 0;
            }
        }

        @Override
        public int getBlockDataAt(int xoff, int yoff, int zoff) {
            int xx = this.x + xoff;
            int yy = this.y + yoff;
            int zz = this.z + zoff;
            int idx = (xx >> 4) - NewMapChunkCache.this.x_min + ((zz >> 4) - NewMapChunkCache.this.z_min) * NewMapChunkCache.this.x_dim;
            try {
                return NewMapChunkCache.this.snaparray[idx].getBlockData(xx & 0xF, yy, zz & 0xF);
            }
            catch (Exception x) {
                return 0;
            }
        }

        @Override
        public Object getBlockTileEntityFieldAt(String fieldId, int xoff, int yoff, int zoff) {
            return null;
        }

        @Override
        public long getInhabitedTicks() {
            try {
                return NewMapChunkCache.this.inhabitedTicks[this.chunkindex];
            }
            catch (Exception x) {
                return 0L;
            }
        }
    }
}

