/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.Server;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.dynmap.Log;
import org.dynmap.bukkit.BukkitVersionHelper;

public abstract class BukkitVersionHelperGeneric
extends BukkitVersionHelper {
    private String obc_package;
    protected String nms_package;
    private boolean failed = false;
    private static final Object[] nullargs = new Object[0];
    private static final Map nullmap = Collections.emptyMap();
    private Class<?> craftchunksnapshot;
    private Field ccss_biome;
    private Class<?> craftchunk;
    private Method cc_gethandle;
    private Class<?> craftworld;
    private Method cw_gethandle;
    protected Class<?> biomebase;
    protected Class<?> biomebasearray;
    protected Field biomebaselist;
    protected Field biomebasetemp;
    protected Field biomebasehumi;
    protected Field biomebaseidstring;
    protected Field biomebaseid;
    protected Class<?> nmsworld;
    protected Class<?> chunkprovserver;
    protected Class<?> longhashset;
    protected Field nmsw_chunkproviderserver;
    protected Field cps_unloadqueue;
    protected Method lhs_containskey;
    protected Class<?> nmschunk;
    protected Method nmsc_removeentities;
    protected Field nmsc_tileentities;
    protected Field nmsc_inhabitedticks;
    protected Class<?> nbttagcompound;
    protected Class<?> nbttagbyte;
    protected Class<?> nbttagshort;
    protected Class<?> nbttagint;
    protected Class<?> nbttaglong;
    protected Class<?> nbttagfloat;
    protected Class<?> nbttagdouble;
    protected Class<?> nbttagbytearray;
    protected Class<?> nbttagstring;
    protected Class<?> nbttagintarray;
    protected Method compound_get;
    protected Field nbttagbyte_val;
    protected Field nbttagshort_val;
    protected Field nbttagint_val;
    protected Field nbttaglong_val;
    protected Field nbttagfloat_val;
    protected Field nbttagdouble_val;
    protected Field nbttagbytearray_val;
    protected Field nbttagstring_val;
    protected Field nbttagintarray_val;
    protected Class<?> nms_tileentity;
    protected Method nmst_readnbt;
    protected Field nmst_x;
    protected Field nmst_y;
    protected Field nmst_z;
    protected Method server_getonlineplayers;
    protected Method player_gethealth;
    private static final Long zero = new Long(0L);

    BukkitVersionHelperGeneric() {
        Server srv = Bukkit.getServer();
        this.obc_package = Bukkit.getServer().getClass().getPackage().getName();
        this.nms_package = this.getNMSPackage();
        if (this.nms_package == null) {
            this.failed = true;
        }
        this.craftworld = this.getOBCClass("org.bukkit.craftbukkit.CraftWorld");
        this.cw_gethandle = this.getMethod(this.craftworld, new String[]{"getHandle"}, new Class[0]);
        this.craftchunksnapshot = this.getOBCClass("org.bukkit.craftbukkit.CraftChunkSnapshot");
        this.ccss_biome = this.getPrivateField(this.craftchunksnapshot, new String[]{"biome"}, this.biomebasearray);
        this.craftchunk = this.getOBCClass("org.bukkit.craftbukkit.CraftChunk");
        this.cc_gethandle = this.getMethod(this.craftchunk, new String[]{"getHandle"}, new Class[0]);
        this.server_getonlineplayers = this.getMethod(Server.class, new String[]{"getOnlinePlayers"}, new Class[0]);
        this.player_gethealth = this.getMethod(Player.class, new String[]{"getHealth"}, new Class[0]);
        if (!this.failed) {
            this.loadNMS();
        }
        if (this.failed) {
            throw new IllegalArgumentException("Error initializing dynmap - bukkit version incompatible!");
        }
    }

    protected abstract void loadNMS();

    protected abstract String getNMSPackage();

    protected Class<?> getOBCClass(String classname) {
        return this.getClassByName(classname, "org.bukkit.craftbukkit", this.obc_package, false);
    }

    protected Class<?> getOBCClassNoFail(String classname) {
        return this.getClassByName(classname, "org.bukkit.craftbukkit", this.obc_package, true);
    }

    protected Class<?> getNMSClass(String classname) {
        return this.getClassByName(classname, "net.minecraft.server", this.nms_package, false);
    }

    protected Class<?> getClassByName(String classname, String base, String mapping, boolean nofail) {
        String n = classname;
        int idx = classname.indexOf(base);
        if (idx >= 0) {
            n = classname.substring(0, idx) + mapping + classname.substring(idx + base.length());
        }
        try {
            return Class.forName(n);
        }
        catch (ClassNotFoundException cnfx) {
            try {
                return Class.forName(classname);
            }
            catch (ClassNotFoundException cnfx2) {
                if (!nofail) {
                    Log.severe("Cannot find " + classname);
                    this.failed = true;
                }
                return null;
            }
        }
    }

    protected Field getField(Class<?> cls, String[] ids, Class<?> type) {
        return this.getField(cls, ids, type, false);
    }

    protected Field getFieldNoFail(Class<?> cls, String[] ids, Class<?> type) {
        return this.getField(cls, ids, type, true);
    }

    private Field getField(Class<?> cls, String[] ids, Class<?> type, boolean nofail) {
        if (cls == null || type == null) {
            return null;
        }
        for (String id : ids) {
            try {
                Field f = cls.getField(id);
                if (!f.getType().isAssignableFrom(type)) continue;
                return f;
            }
            catch (NoSuchFieldException nsfx) {
                // empty catch block
            }
        }
        if (!nofail) {
            Log.severe("Unable to find field " + ids[0] + " for " + cls.getName());
            this.failed = true;
        }
        return null;
    }

    protected Field getPrivateField(Class<?> cls, String[] ids, Class<?> type) {
        if (cls == null || type == null) {
            return null;
        }
        for (String id : ids) {
            try {
                Field f = cls.getDeclaredField(id);
                if (!f.getType().isAssignableFrom(type)) continue;
                f.setAccessible(true);
                return f;
            }
            catch (NoSuchFieldException nsfx) {
                // empty catch block
            }
        }
        Log.severe("Unable to find field " + ids[0] + " for " + cls.getName());
        this.failed = true;
        return null;
    }

    protected Object getFieldValue(Object obj, Field field, Object def) {
        if (obj != null && field != null) {
            try {
                return field.get(obj);
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
        }
        return def;
    }

    protected Method getMethod(Class<?> cls, String[] ids, Class[] args) {
        if (cls == null) {
            return null;
        }
        for (String id : ids) {
            try {
                return cls.getMethod(id, args);
            }
            catch (SecurityException e) {
            }
            catch (NoSuchMethodException e) {
                // empty catch block
            }
        }
        Log.severe("Unable to find method " + ids[0] + " for " + cls.getName());
        this.failed = true;
        return null;
    }

    private Object callMethod(Object obj, Method meth, Object[] args, Object def) {
        if (obj == null || meth == null) {
            return def;
        }
        try {
            return meth.invoke(obj, args);
        }
        catch (IllegalArgumentException iax) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException e) {
            // empty catch block
        }
        return def;
    }

    @Override
    public Object[] getBiomeBaseList() {
        return (Object[])this.getFieldValue(this.biomebase, this.biomebaselist, new Object[0]);
    }

    @Override
    public float getBiomeBaseTemperature(Object bb) {
        return ((Float)this.getFieldValue(bb, this.biomebasetemp, Float.valueOf(0.5f))).floatValue();
    }

    @Override
    public float getBiomeBaseHumidity(Object bb) {
        return ((Float)this.getFieldValue(bb, this.biomebasehumi, Float.valueOf(0.5f))).floatValue();
    }

    @Override
    public String getBiomeBaseIDString(Object bb) {
        return (String)this.getFieldValue(bb, this.biomebaseidstring, null);
    }

    @Override
    public int getBiomeBaseID(Object bb) {
        return (Integer)this.getFieldValue(bb, this.biomebaseid, -1);
    }

    protected Object getNMSWorld(World w) {
        return this.callMethod(w, this.cw_gethandle, nullargs, null);
    }

    @Override
    public Object getUnloadQueue(World world) {
        Object cps = this.getFieldValue(this.getNMSWorld(world), this.nmsw_chunkproviderserver, null);
        if (cps != null) {
            return this.getFieldValue(cps, this.cps_unloadqueue, null);
        }
        return null;
    }

    @Override
    public boolean isInUnloadQueue(Object unloadqueue, int x, int z) {
        if (unloadqueue != null) {
            return (Boolean)this.callMethod(unloadqueue, this.lhs_containskey, new Object[]{x, z}, true);
        }
        return true;
    }

    @Override
    public Object[] getBiomeBaseFromSnapshot(ChunkSnapshot css) {
        return (Object[])this.getFieldValue(css, this.ccss_biome, null);
    }

    @Override
    public void removeEntitiesFromChunk(Chunk c) {
        Object omsc = this.callMethod(c, this.cc_gethandle, nullargs, null);
        if (omsc != null) {
            this.callMethod(omsc, this.nmsc_removeentities, nullargs, null);
        }
    }

    @Override
    public long getInhabitedTicks(Chunk c) {
        if (this.nmsc_inhabitedticks == null) {
            return 0L;
        }
        Object omsc = this.callMethod(c, this.cc_gethandle, nullargs, null);
        if (omsc != null) {
            return (Long)this.getFieldValue(omsc, this.nmsc_inhabitedticks, zero);
        }
        return 0L;
    }

    @Override
    public Map getTileEntitiesForChunk(Chunk c) {
        Object omsc = this.callMethod(c, this.cc_gethandle, nullargs, null);
        if (omsc != null) {
            return (Map)this.getFieldValue(omsc, this.nmsc_tileentities, nullmap);
        }
        return nullmap;
    }

    @Override
    public int getTileEntityX(Object te) {
        return (Integer)this.getFieldValue(te, this.nmst_x, 0);
    }

    @Override
    public int getTileEntityY(Object te) {
        return (Integer)this.getFieldValue(te, this.nmst_y, 0);
    }

    @Override
    public int getTileEntityZ(Object te) {
        return (Integer)this.getFieldValue(te, this.nmst_z, 0);
    }

    @Override
    public Object readTileEntityNBT(Object te) {
        if (this.nbttagcompound == null) {
            return null;
        }
        Object nbt = null;
        try {
            nbt = this.nbttagcompound.newInstance();
        }
        catch (InstantiationException e) {
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (nbt != null) {
            this.callMethod(te, this.nmst_readnbt, new Object[]{nbt}, null);
        }
        return nbt;
    }

    @Override
    public Object getFieldValue(Object nbt, String field) {
        Object val = this.callMethod(nbt, this.compound_get, new Object[]{field}, null);
        if (val == null) {
            return null;
        }
        Class<?> valcls = val.getClass();
        if (valcls.equals(this.nbttagbyte)) {
            return this.getFieldValue(val, this.nbttagbyte_val, null);
        }
        if (valcls.equals(this.nbttagshort)) {
            return this.getFieldValue(val, this.nbttagshort_val, null);
        }
        if (valcls.equals(this.nbttagint)) {
            return this.getFieldValue(val, this.nbttagint_val, null);
        }
        if (valcls.equals(this.nbttaglong)) {
            return this.getFieldValue(val, this.nbttaglong_val, null);
        }
        if (valcls.equals(this.nbttagfloat)) {
            return this.getFieldValue(val, this.nbttagfloat_val, null);
        }
        if (valcls.equals(this.nbttagdouble)) {
            return this.getFieldValue(val, this.nbttagdouble_val, null);
        }
        if (valcls.equals(this.nbttagbytearray)) {
            return this.getFieldValue(val, this.nbttagbytearray_val, null);
        }
        if (valcls.equals(this.nbttagstring)) {
            return this.getFieldValue(val, this.nbttagstring_val, null);
        }
        if (valcls.equals(this.nbttagintarray)) {
            return this.getFieldValue(val, this.nbttagintarray_val, null);
        }
        return null;
    }

    @Override
    public Player[] getOnlinePlayers() {
        Object players = this.callMethod(Bukkit.getServer(), this.server_getonlineplayers, nullargs, null);
        if (players instanceof Player[]) {
            return (Player[])players;
        }
        Collection p = (Collection)players;
        return p.toArray(new Player[0]);
    }

    @Override
    public int getHealth(Player p) {
        Object health = this.callMethod(p, this.player_gethealth, nullargs, null);
        if (health instanceof Integer) {
            return (Integer)health;
        }
        return ((Double)health).intValue();
    }
}

