/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit;

import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Server;
import org.bukkit.World;
import org.dynmap.Log;
import org.dynmap.bukkit.BukkitVersionHelperGeneric;

public class BukkitVersionHelperCB
extends BukkitVersionHelperGeneric {
    private Class<?> nmsblock;
    private Class<?> nmsblockarray;
    private Class<?> nmsmaterial;
    private Field blockbyid;
    private Field blockname;
    private Field material;
    private Method blockbyidfunc;

    BukkitVersionHelperCB() {
    }

    @Override
    protected String getNMSPackage() {
        Server srv = Bukkit.getServer();
        try {
            Method m = srv.getClass().getMethod("getHandle", new Class[0]);
            Object scm = m.invoke((Object)srv, new Object[0]);
            return scm.getClass().getPackage().getName();
        }
        catch (Exception x) {
            Log.severe("Error finding net.minecraft.server packages");
            return null;
        }
    }

    @Override
    protected void loadNMS() {
        this.nmsblock = this.getNMSClass("net.minecraft.server.Block");
        this.nmsblockarray = this.getNMSClass("[Lnet.minecraft.server.Block;");
        this.nmsmaterial = this.getNMSClass("net.minecraft.server.Material");
        this.blockbyid = this.getFieldNoFail(this.nmsblock, new String[]{"byId"}, this.nmsblockarray);
        if (this.blockbyid == null) {
            this.blockbyidfunc = this.getMethod(this.nmsblock, new String[]{"getById", "e"}, new Class[]{Integer.TYPE});
        }
        this.blockname = this.getPrivateField(this.nmsblock, new String[]{"name", "b"}, String.class);
        this.material = this.getPrivateField(this.nmsblock, new String[]{"material"}, this.nmsmaterial);
        this.biomebase = this.getNMSClass("net.minecraft.server.BiomeBase");
        this.biomebasearray = this.getNMSClass("[Lnet.minecraft.server.BiomeBase;");
        this.biomebaselist = this.getPrivateField(this.biomebase, new String[]{"biomes"}, this.biomebasearray);
        this.biomebasetemp = this.getField(this.biomebase, new String[]{"temperature", "F"}, Float.TYPE);
        this.biomebasehumi = this.getField(this.biomebase, new String[]{"humidity", "G"}, Float.TYPE);
        this.biomebaseidstring = this.getField(this.biomebase, new String[]{"y", "af"}, String.class);
        this.biomebaseid = this.getField(this.biomebase, new String[]{"id"}, Integer.TYPE);
        this.nmsworld = this.getNMSClass("net.minecraft.server.WorldServer");
        this.chunkprovserver = this.getNMSClass("net.minecraft.server.ChunkProviderServer");
        this.nmsw_chunkproviderserver = this.getField(this.nmsworld, new String[]{"chunkProviderServer"}, this.chunkprovserver);
        this.longhashset = this.getOBCClassNoFail("org.bukkit.craftbukkit.util.LongHashSet");
        if (this.longhashset != null) {
            this.lhs_containskey = this.getMethod(this.longhashset, new String[]{"contains"}, new Class[]{Integer.TYPE, Integer.TYPE});
        } else {
            this.longhashset = this.getOBCClass("org.bukkit.craftbukkit.util.LongHashset");
            this.lhs_containskey = this.getMethod(this.longhashset, new String[]{"containsKey"}, new Class[]{Integer.TYPE, Integer.TYPE});
        }
        this.cps_unloadqueue = this.getFieldNoFail(this.chunkprovserver, new String[]{"unloadQueue"}, this.longhashset);
        if (this.cps_unloadqueue == null) {
            Log.info("Unload queue not found - default to unload all chunks");
        }
        this.nmschunk = this.getNMSClass("net.minecraft.server.Chunk");
        this.nmsc_removeentities = this.getMethod(this.nmschunk, new String[]{"removeEntities"}, new Class[0]);
        this.nmsc_tileentities = this.getField(this.nmschunk, new String[]{"tileEntities"}, Map.class);
        this.nmsc_inhabitedticks = this.getFieldNoFail(this.nmschunk, new String[]{"s", "q"}, Long.TYPE);
        if (this.nmsc_inhabitedticks == null) {
            Log.info("inhabitedTicks field not found - inhabited shader not functional");
        }
        this.nbttagcompound = this.getNMSClass("net.minecraft.server.NBTTagCompound");
        this.nbttagbyte = this.getNMSClass("net.minecraft.server.NBTTagByte");
        this.nbttagshort = this.getNMSClass("net.minecraft.server.NBTTagShort");
        this.nbttagint = this.getNMSClass("net.minecraft.server.NBTTagInt");
        this.nbttaglong = this.getNMSClass("net.minecraft.server.NBTTagLong");
        this.nbttagfloat = this.getNMSClass("net.minecraft.server.NBTTagFloat");
        this.nbttagdouble = this.getNMSClass("net.minecraft.server.NBTTagDouble");
        this.nbttagbytearray = this.getNMSClass("net.minecraft.server.NBTTagByteArray");
        this.nbttagstring = this.getNMSClass("net.minecraft.server.NBTTagString");
        this.nbttagintarray = this.getNMSClass("net.minecraft.server.NBTTagIntArray");
        this.compound_get = this.getMethod(this.nbttagcompound, new String[]{"get"}, new Class[]{String.class});
        this.nbttagbyte_val = this.getPrivateField(this.nbttagbyte, new String[]{"data"}, Byte.TYPE);
        this.nbttagshort_val = this.getPrivateField(this.nbttagshort, new String[]{"data"}, Short.TYPE);
        this.nbttagint_val = this.getPrivateField(this.nbttagint, new String[]{"data"}, Integer.TYPE);
        this.nbttaglong_val = this.getPrivateField(this.nbttaglong, new String[]{"data"}, Long.TYPE);
        this.nbttagfloat_val = this.getPrivateField(this.nbttagfloat, new String[]{"data"}, Float.TYPE);
        this.nbttagdouble_val = this.getPrivateField(this.nbttagdouble, new String[]{"data"}, Double.TYPE);
        this.nbttagbytearray_val = this.getPrivateField(this.nbttagbytearray, new String[]{"data"}, byte[].class);
        this.nbttagstring_val = this.getPrivateField(this.nbttagstring, new String[]{"data"}, String.class);
        this.nbttagintarray_val = this.getPrivateField(this.nbttagintarray, new String[]{"data"}, int[].class);
        this.nms_tileentity = this.getNMSClass("net.minecraft.server.TileEntity");
        this.nmst_readnbt = this.getMethod(this.nms_tileentity, new String[]{"b"}, new Class[]{this.nbttagcompound});
        this.nmst_x = this.getField(this.nms_tileentity, new String[]{"x"}, Integer.TYPE);
        this.nmst_y = this.getField(this.nms_tileentity, new String[]{"y"}, Integer.TYPE);
        this.nmst_z = this.getField(this.nms_tileentity, new String[]{"z"}, Integer.TYPE);
    }

    @Override
    public void unloadChunkNoSave(World w, Chunk c, int cx, int cz) {
        this.removeEntitiesFromChunk(c);
        w.unloadChunk(cx, cz, false, false);
    }

    @Override
    public String[] getBlockShortNames() {
        try {
            String[] names = new String[4096];
            if (this.blockbyid != null) {
                Object[] byid = (Object[])this.blockbyid.get(this.nmsblock);
                for (int i = 0; i < names.length; ++i) {
                    if (byid[i] == null) continue;
                    names[i] = (String)this.blockname.get(byid[i]);
                }
            } else {
                for (int i = 0; i < names.length; ++i) {
                    Object blk = this.blockbyidfunc.invoke(this.nmsblock, i);
                    if (blk == null) continue;
                    names[i] = (String)this.blockname.get(blk);
                }
            }
            return names;
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return new String[0];
    }

    @Override
    public String[] getBiomeNames() {
        Object[] biomelist = this.getBiomeBaseList();
        String[] names = new String[biomelist.length];
        for (int i = 0; i < biomelist.length; ++i) {
            Object bb = biomelist[i];
            if (bb == null) continue;
            names[i] = this.getBiomeBaseIDString(bb);
        }
        return names;
    }

    @Override
    public int[] getBlockMaterialMap() {
        try {
            int[] map = new int[4096];
            if (this.blockbyid != null) {
                Object[] byid = (Object[])this.blockbyid.get(this.nmsblock);
                ArrayList<Object> mats = new ArrayList<Object>();
                for (int i = 0; i < map.length; ++i) {
                    if (byid[i] == null) continue;
                    Object mat = this.material.get(byid[i]);
                    if (mat != null) {
                        map[i] = mats.indexOf(mat);
                        if (map[i] >= 0) continue;
                        map[i] = mats.size();
                        mats.add(mat);
                        continue;
                    }
                    map[i] = -1;
                }
            } else {
                ArrayList<Object> mats = new ArrayList<Object>();
                for (int i = 0; i < map.length; ++i) {
                    Object blk = this.blockbyidfunc.invoke(this.nmsblock, i);
                    if (blk == null) continue;
                    Object mat = this.material.get(blk);
                    if (mat != null) {
                        map[i] = mats.indexOf(mat);
                        if (map[i] >= 0) continue;
                        map[i] = mats.size();
                        mats.add(mat);
                        continue;
                    }
                    map[i] = -1;
                }
            }
            return map;
        }
        catch (IllegalArgumentException e) {
        }
        catch (IllegalAccessException e) {
        }
        catch (InvocationTargetException invocationTargetException) {
            // empty catch block
        }
        return new int[0];
    }
}

