/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap.bukkit;

import java.util.Map;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.ChunkSnapshot;
import org.bukkit.World;
import org.bukkit.entity.Player;
import org.dynmap.Log;
import org.dynmap.bukkit.BukkitVersionHelperCB;
import org.dynmap.bukkit.BukkitVersionHelperGlowstone;

public abstract class BukkitVersionHelper {
    private static BukkitVersionHelper helper = null;

    public static final BukkitVersionHelper getHelper() {
        if (helper == null) {
            Log.info("version=" + Bukkit.getServer().getVersion());
            if (Bukkit.getServer().getVersion().contains("MCPC")) {
                Log.severe("*********************************************************************************");
                Log.severe("* MCPC-Plus is no longer supported via the Bukkit version of Dynmap.            *");
                Log.severe("* Install the appropriate Forge version of Dynmap.                              *");
                Log.severe("* Add the DynmapCBBridge plugin to enable support for Dynmap-compatible plugins *");
                Log.severe("*********************************************************************************");
            } else if (Bukkit.getServer().getVersion().contains("BukkitForge")) {
                Log.severe("*********************************************************************************");
                Log.severe("* BukkitForge is not supported via the Bukkit version of Dynmap.                *");
                Log.severe("* Install the appropriate Forge version of Dynmap.                              *");
                Log.severe("* Add the DynmapCBBridge plugin to enable support for Dynmap-compatible plugins *");
                Log.severe("*********************************************************************************");
            } else if (Bukkit.getServer().getClass().getName().contains("GlowServer")) {
                Log.info("Loading Glowstone support");
                helper = new BukkitVersionHelperGlowstone();
            } else {
                helper = new BukkitVersionHelperCB();
            }
        }
        return helper;
    }

    protected BukkitVersionHelper() {
    }

    public abstract Object[] getBiomeBaseList();

    public abstract float getBiomeBaseTemperature(Object var1);

    public abstract float getBiomeBaseHumidity(Object var1);

    public abstract String getBiomeBaseIDString(Object var1);

    public abstract int getBiomeBaseID(Object var1);

    public abstract Object getUnloadQueue(World var1);

    public abstract boolean isInUnloadQueue(Object var1, int var2, int var3);

    public abstract Object[] getBiomeBaseFromSnapshot(ChunkSnapshot var1);

    public abstract void removeEntitiesFromChunk(Chunk var1);

    public abstract long getInhabitedTicks(Chunk var1);

    public abstract Map getTileEntitiesForChunk(Chunk var1);

    public abstract int getTileEntityX(Object var1);

    public abstract int getTileEntityY(Object var1);

    public abstract int getTileEntityZ(Object var1);

    public abstract Object readTileEntityNBT(Object var1);

    public abstract Object getFieldValue(Object var1, String var2);

    public abstract void unloadChunkNoSave(World var1, Chunk var2, int var3, int var4);

    public abstract String[] getBlockShortNames();

    public abstract String[] getBiomeNames();

    public abstract int[] getBlockMaterialMap();

    public abstract Player[] getOnlinePlayers();

    public abstract int getHealth(Player var1);
}

