/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import org.dynmap.ChatEvent;
import org.dynmap.Client;
import org.dynmap.Component;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.Event;
import org.dynmap.JSONUtils;
import org.dynmap.common.DynmapListenerManager;
import org.dynmap.common.DynmapPlayer;
import org.dynmap.json.simple.JSONObject;

public class SimpleWebChatComponent
extends Component {
    public SimpleWebChatComponent(final DynmapCore plugin, final ConfigurationNode configuration) {
        super(plugin, configuration);
        plugin.events.addListener("webchat", new Event.Listener<ChatEvent>(){

            @Override
            public void triggered(ChatEvent t) {
                if (plugin.getServer().sendWebChatEvent(t.source, t.name, t.message)) {
                    String msg;
                    String msgfmt = plugin.configuration.getString("webmsgformat", null);
                    if (msgfmt != null) {
                        msgfmt = Component.unescapeString(msgfmt);
                        msg = msgfmt.replace("%playername%", t.name).replace("%message%", t.message);
                    } else {
                        msg = Component.unescapeString(plugin.configuration.getString("webprefix", "\u00a72[WEB] ")) + t.name + ": " + Component.unescapeString(plugin.configuration.getString("websuffix", "\u00a7f")) + t.message;
                    }
                    plugin.getServer().broadcastMessage(msg);
                    if (SimpleWebChatComponent.this.core.mapManager != null) {
                        SimpleWebChatComponent.this.core.mapManager.pushUpdate(new Client.ChatMessage("web", null, t.name, t.message, null));
                    }
                }
            }
        });
        plugin.events.addListener("buildclientconfiguration", new Event.Listener<JSONObject>(){

            @Override
            public void triggered(JSONObject t) {
                JSONUtils.s(t, "allowchat", configuration.getBoolean("allowchat", false));
            }
        });
        if (configuration.getBoolean("allowchat", false)) {
            plugin.listenerManager.addListener(DynmapListenerManager.EventType.PLAYER_CHAT, new DynmapListenerManager.ChatEventListener(){

                @Override
                public void chatEvent(DynmapPlayer p, String msg) {
                    if (SimpleWebChatComponent.this.core.disable_chat_to_web) {
                        return;
                    }
                    if (SimpleWebChatComponent.this.core.mapManager != null) {
                        SimpleWebChatComponent.this.core.mapManager.pushUpdate(new Client.ChatMessage("player", "", p.getDisplayName(), msg, p.getName()));
                    }
                }
            });
            plugin.listenerManager.addListener(DynmapListenerManager.EventType.PLAYER_JOIN, new DynmapListenerManager.PlayerEventListener(){

                @Override
                public void playerEvent(DynmapPlayer p) {
                    if (SimpleWebChatComponent.this.core.disable_chat_to_web) {
                        return;
                    }
                    if (SimpleWebChatComponent.this.core.mapManager != null && SimpleWebChatComponent.this.core.playerList != null && SimpleWebChatComponent.this.core.playerList.isVisiblePlayer(p.getName())) {
                        SimpleWebChatComponent.this.core.mapManager.pushUpdate(new Client.PlayerJoinMessage(p.getDisplayName(), p.getName()));
                    }
                }
            });
            plugin.listenerManager.addListener(DynmapListenerManager.EventType.PLAYER_QUIT, new DynmapListenerManager.PlayerEventListener(){

                @Override
                public void playerEvent(DynmapPlayer p) {
                    if (SimpleWebChatComponent.this.core.disable_chat_to_web) {
                        return;
                    }
                    if (SimpleWebChatComponent.this.core.mapManager != null && SimpleWebChatComponent.this.core.playerList != null && SimpleWebChatComponent.this.core.playerList.isVisiblePlayer(p.getName())) {
                        SimpleWebChatComponent.this.core.mapManager.pushUpdate(new Client.PlayerQuitMessage(p.getDisplayName(), p.getName()));
                    }
                }
            });
        }
    }
}

