/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import org.dynmap.DynmapCore;
import org.dynmap.MapManager;
import org.dynmap.MapType;
import org.dynmap.common.DynmapListenerManager;
import org.dynmap.common.DynmapPlayer;
import org.dynmap.debug.Debug;
import org.dynmap.storage.MapStorage;
import org.dynmap.utils.BufferOutputStream;
import org.dynmap.utils.DynmapBufferedImage;
import org.dynmap.utils.ImageIOManager;

public class PlayerFaces {
    private boolean fetchskins;
    private boolean refreshskins;
    private String skinurl;
    public MapStorage storage;

    public PlayerFaces(DynmapCore core) {
        this.fetchskins = core.configuration.getBoolean("fetchskins", true);
        this.refreshskins = core.configuration.getBoolean("refreshskins", true);
        this.skinurl = core.configuration.getString("skin-url", "http://s3.amazonaws.com/MinecraftSkins/%player%.png");
        core.listenerManager.addListener(DynmapListenerManager.EventType.PLAYER_JOIN, new DynmapListenerManager.PlayerEventListener(){

            @Override
            public void playerEvent(DynmapPlayer p) {
                LoadPlayerImages job = new LoadPlayerImages(p.getName());
                if (PlayerFaces.this.fetchskins) {
                    MapManager.scheduleDelayedJob(job, 0L);
                } else {
                    job.run();
                }
            }
        });
        this.storage = core.getDefaultMapStorage();
    }

    private class LoadPlayerImages
    implements Runnable {
        public String playername;

        public LoadPlayerImages(String playername) {
            this.playername = playername;
        }

        @Override
        public void run() {
            BufferOutputStream bos;
            int j;
            BufferOutputStream bos2;
            int i;
            boolean has_8x8 = PlayerFaces.this.storage.hasPlayerFaceImage(this.playername, FaceType.FACE_8X8);
            boolean has_16x16 = PlayerFaces.this.storage.hasPlayerFaceImage(this.playername, FaceType.FACE_16X16);
            boolean has_32x32 = PlayerFaces.this.storage.hasPlayerFaceImage(this.playername, FaceType.FACE_32X32);
            boolean has_body = PlayerFaces.this.storage.hasPlayerFaceImage(this.playername, FaceType.BODY_32X32);
            boolean missing_any = !has_8x8 || !has_16x16 || !has_32x32 || !has_body;
            BufferedImage img = null;
            try {
                if (PlayerFaces.this.fetchskins && (PlayerFaces.this.refreshskins || missing_any)) {
                    URL url = new URL(PlayerFaces.this.skinurl.replace("%player%", this.playername));
                    img = ImageIO.read(url);
                }
            }
            catch (IOException iox) {
                Debug.debug("Error loading skin for '" + this.playername + "' - " + iox);
            }
            if (img == null) {
                try {
                    InputStream in = this.getClass().getResourceAsStream("/char.png");
                    img = ImageIO.read(in);
                    in.close();
                }
                catch (IOException iox) {
                    Debug.debug("Error loading default skin for '" + this.playername + "' - " + iox);
                }
            }
            if (img == null) {
                return;
            }
            if (img.getWidth() < 64 || img.getHeight() < 32) {
                img.flush();
                return;
            }
            int[] faceaccessory = new int[64];
            DynmapBufferedImage face8x8 = DynmapBufferedImage.allocateBufferedImage(8, 8);
            img.getRGB(8, 8, 8, 8, face8x8.argb_buf, 0, 8);
            img.getRGB(40, 8, 8, 8, faceaccessory, 0, 8);
            boolean transp = false;
            int v = faceaccessory[0];
            for (i = 0; i < 64; ++i) {
                if ((faceaccessory[i] & 0xFF000000) == 0) {
                    transp = true;
                    break;
                }
                if (faceaccessory[i] == v) continue;
                transp = true;
                break;
            }
            if (transp) {
                for (i = 0; i < 64; ++i) {
                    if ((faceaccessory[i] & 0xFF000000) == 0) continue;
                    face8x8.argb_buf[i] = faceaccessory[i];
                }
            }
            if ((PlayerFaces.this.refreshskins || !has_8x8) && (bos2 = ImageIOManager.imageIOEncode(face8x8.buf_img, MapType.ImageFormat.FORMAT_PNG)) != null) {
                PlayerFaces.this.storage.setPlayerFaceImage(this.playername, FaceType.FACE_8X8, bos2);
            }
            if (PlayerFaces.this.refreshskins || !has_16x16) {
                DynmapBufferedImage face16x16 = DynmapBufferedImage.allocateBufferedImage(16, 16);
                for (int i2 = 0; i2 < 16; ++i2) {
                    for (j = 0; j < 16; ++j) {
                        face16x16.argb_buf[i2 * 16 + j] = face8x8.argb_buf[i2 / 2 * 8 + j / 2];
                    }
                }
                bos = ImageIOManager.imageIOEncode(face16x16.buf_img, MapType.ImageFormat.FORMAT_PNG);
                if (bos != null) {
                    PlayerFaces.this.storage.setPlayerFaceImage(this.playername, FaceType.FACE_16X16, bos);
                }
                DynmapBufferedImage.freeBufferedImage(face16x16);
            }
            if (PlayerFaces.this.refreshskins || !has_32x32) {
                DynmapBufferedImage face32x32 = DynmapBufferedImage.allocateBufferedImage(32, 32);
                for (int i3 = 0; i3 < 32; ++i3) {
                    for (j = 0; j < 32; ++j) {
                        face32x32.argb_buf[i3 * 32 + j] = face8x8.argb_buf[i3 / 4 * 8 + j / 4];
                    }
                }
                bos = ImageIOManager.imageIOEncode(face32x32.buf_img, MapType.ImageFormat.FORMAT_PNG);
                if (bos != null) {
                    PlayerFaces.this.storage.setPlayerFaceImage(this.playername, FaceType.FACE_32X32, bos);
                }
                DynmapBufferedImage.freeBufferedImage(face32x32);
            }
            if (PlayerFaces.this.refreshskins || !has_body) {
                DynmapBufferedImage body32x32 = DynmapBufferedImage.allocateBufferedImage(32, 32);
                for (int i4 = 0; i4 < 8; ++i4) {
                    for (j = 0; j < 8; ++j) {
                        body32x32.argb_buf[i4 * 32 + j + 12] = face8x8.argb_buf[i4 * 8 + j];
                    }
                }
                img.getRGB(20, 20, 8, 12, body32x32.argb_buf, 268, 32);
                img.getRGB(4, 20, 4, 12, body32x32.argb_buf, 652, 32);
                img.getRGB(4, 20, 4, 12, body32x32.argb_buf, 656, 32);
                img.getRGB(44, 20, 4, 12, body32x32.argb_buf, 264, 32);
                img.getRGB(44, 20, 4, 12, body32x32.argb_buf, 276, 32);
                BufferOutputStream bos3 = ImageIOManager.imageIOEncode(body32x32.buf_img, MapType.ImageFormat.FORMAT_PNG);
                if (bos3 != null) {
                    PlayerFaces.this.storage.setPlayerFaceImage(this.playername, FaceType.BODY_32X32, bos3);
                }
                DynmapBufferedImage.freeBufferedImage(body32x32);
            }
            DynmapBufferedImage.freeBufferedImage(face8x8);
            img.flush();
        }
    }

    public static enum FaceType {
        FACE_8X8("8x8", 0),
        FACE_16X16("16x16", 1),
        FACE_32X32("32x32", 2),
        BODY_32X32("body", 3);

        public final String id;
        public final int typeID;

        private FaceType(String id, int typeid) {
            this.id = id;
            this.typeID = typeid;
        }

        public static FaceType byID(String i_d) {
            for (FaceType ft : FaceType.values()) {
                if (!ft.id.equals(i_d)) continue;
                return ft;
            }
            return null;
        }

        public static FaceType byTypeID(int tid) {
            for (FaceType ft : FaceType.values()) {
                if (ft.typeID != tid) continue;
                return ft;
            }
            return null;
        }
    }
}

