/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import org.dynmap.ClientComponent;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapLocation;
import org.dynmap.DynmapWorld;
import org.dynmap.common.DynmapListenerManager;
import org.dynmap.common.DynmapPlayer;
import org.dynmap.markers.Marker;
import org.dynmap.markers.MarkerAPI;
import org.dynmap.markers.MarkerIcon;
import org.dynmap.markers.MarkerSet;
import org.dynmap.markers.impl.MarkerSignManager;

public class MarkersComponent
extends ClientComponent {
    private MarkerAPI api;
    private MarkerSignManager signmgr;
    private MarkerIcon spawnicon;
    private String spawnlbl;
    private MarkerSet offlineset;
    private MarkerIcon offlineicon;
    private MarkerSet spawnbedset;
    private MarkerIcon spawnbedicon;
    private String spawnbedformat;
    private long maxofflineage;
    private HashMap<String, Long> offline_times = new HashMap();
    private static final String OFFLINE_PLAYERS_SETID = "offline_players";
    private static final String PLAYER_SPAWN_BED_SETID = "spawn_beds";

    public MarkersComponent(final DynmapCore core, ConfigurationNode configuration) {
        super(core, configuration);
        this.api = core.getMarkerAPI();
        if (configuration.getBoolean("enablesigns", false)) {
            this.signmgr = MarkerSignManager.initializeSignManager(core, configuration.getString("default-sign-set", "markers"));
        }
        if (configuration.getBoolean("showspawn", false)) {
            String ico = configuration.getString("spawnicon", "world");
            this.spawnlbl = configuration.getString("spawnlabel", "Spawn");
            this.spawnicon = this.api.getMarkerIcon(ico);
            if (this.spawnicon == null) {
                this.spawnicon = this.api.getMarkerIcon("world");
            }
            DynmapListenerManager.WorldEventListener wel = new DynmapListenerManager.WorldEventListener(){

                @Override
                public void worldEvent(DynmapWorld w) {
                    DynmapLocation loc = w.getSpawnLocation();
                    if (loc != null) {
                        MarkersComponent.this.addUpdateWorld(w, loc);
                    }
                }
            };
            core.listenerManager.addListener(DynmapListenerManager.EventType.WORLD_LOAD, wel);
            core.listenerManager.addListener(DynmapListenerManager.EventType.WORLD_SPAWN_CHANGE, wel);
            for (DynmapWorld w : core.getMapManager().getWorlds()) {
                DynmapLocation loc = w.getSpawnLocation();
                if (loc == null) continue;
                this.addUpdateWorld(w, loc);
            }
        }
        if (configuration.getBoolean("showofflineplayers", false)) {
            this.offlineset = this.api.getMarkerSet(OFFLINE_PLAYERS_SETID);
            if (this.offlineset == null) {
                this.offlineset = this.api.createMarkerSet(OFFLINE_PLAYERS_SETID, configuration.getString("offlinelabel", "Offline"), null, true);
            }
            this.offlineset.setHideByDefault(configuration.getBoolean("offlinehidebydefault", true));
            this.offlineset.setMinZoom(configuration.getInteger("offlineminzoom", 0));
            this.maxofflineage = 60000L * (long)configuration.getInteger("maxofflinetime", 30);
            if (this.maxofflineage > 0L) {
                Set<Marker> prev_m = this.offlineset.getMarkers();
                for (Marker m : prev_m) {
                    DynmapPlayer p = core.getServer().getOfflinePlayer(m.getMarkerID());
                    if (p != null) {
                        long ageout = p.getLastLoginTime() + this.maxofflineage;
                        if (ageout < System.currentTimeMillis()) {
                            m.deleteMarker();
                            continue;
                        }
                        this.offline_times.put(p.getName(), ageout);
                        continue;
                    }
                    m.deleteMarker();
                }
            }
            this.offlineicon = this.api.getMarkerIcon(configuration.getString("offlineicon", "offlineuser"));
            if (this.maxofflineage > 0L) {
                core.getServer().scheduleServerTask(new Runnable(){

                    @Override
                    public void run() {
                        long ts = System.currentTimeMillis();
                        ArrayList deleted = new ArrayList();
                        for (Map.Entry me : MarkersComponent.this.offline_times.entrySet()) {
                            if (ts <= (Long)me.getValue()) continue;
                            deleted.add(me.getKey());
                        }
                        for (String id : deleted) {
                            Marker m = MarkersComponent.this.offlineset.findMarker(id);
                            if (m == null) continue;
                            m.deleteMarker();
                        }
                        core.getServer().scheduleServerTask(this, 600L);
                    }
                }, 600L);
            }
            core.listenerManager.addListener(DynmapListenerManager.EventType.PLAYER_JOIN, new DynmapListenerManager.PlayerEventListener(){

                @Override
                public void playerEvent(DynmapPlayer p) {
                    Marker m = MarkersComponent.this.offlineset.findMarker(p.getName());
                    if (m != null) {
                        m.deleteMarker();
                        MarkersComponent.this.offline_times.remove(p.getName());
                    }
                }
            });
            core.listenerManager.addListener(DynmapListenerManager.EventType.PLAYER_QUIT, new DynmapListenerManager.PlayerEventListener(){

                @Override
                public void playerEvent(DynmapPlayer p) {
                    String pname = p.getName();
                    Marker m = MarkersComponent.this.offlineset.findMarker(pname);
                    if (m != null) {
                        m.deleteMarker();
                        MarkersComponent.this.offline_times.remove(p.getName());
                    }
                    if (core.playerList.isVisiblePlayer(pname)) {
                        DynmapLocation loc = p.getLocation();
                        m = MarkersComponent.this.offlineset.createMarker(p.getName(), core.getServer().stripChatColor(p.getDisplayName()), false, loc.world, loc.x, loc.y, loc.z, MarkersComponent.this.offlineicon, true);
                        if (MarkersComponent.this.maxofflineage > 0L) {
                            MarkersComponent.this.offline_times.put(p.getName(), System.currentTimeMillis() + MarkersComponent.this.maxofflineage);
                        }
                    }
                }
            });
        } else {
            this.offlineset = this.api.getMarkerSet(OFFLINE_PLAYERS_SETID);
            if (this.offlineset != null) {
                this.offlineset.deleteMarkerSet();
            }
        }
        if (configuration.getBoolean("showspawnbeds", false)) {
            this.spawnbedset = this.api.getMarkerSet(PLAYER_SPAWN_BED_SETID);
            if (this.spawnbedset == null) {
                this.spawnbedset = this.api.createMarkerSet(PLAYER_SPAWN_BED_SETID, configuration.getString("spawnbedlabel", "Spawn Beds"), null, true);
            }
            this.spawnbedset.setHideByDefault(configuration.getBoolean("spawnbedhidebydefault", true));
            this.spawnbedset.setMinZoom(configuration.getInteger("spawnbedminzoom", 0));
            this.spawnbedicon = this.api.getMarkerIcon(configuration.getString("spawnbedicon", "bed"));
            this.spawnbedformat = configuration.getString("spawnbedformat", "%name%'s bed");
            core.listenerManager.addListener(DynmapListenerManager.EventType.PLAYER_JOIN, new DynmapListenerManager.PlayerEventListener(){

                @Override
                public void playerEvent(DynmapPlayer p) {
                    MarkersComponent.this.updatePlayer(p);
                }
            });
            core.listenerManager.addListener(DynmapListenerManager.EventType.PLAYER_QUIT, new DynmapListenerManager.PlayerEventListener(){

                @Override
                public void playerEvent(DynmapPlayer p) {
                    Marker m = MarkersComponent.this.spawnbedset.findMarker(p.getName() + "_bed");
                    if (m != null) {
                        m.deleteMarker();
                    }
                }
            });
            core.listenerManager.addListener(DynmapListenerManager.EventType.PLAYER_BED_LEAVE, new DynmapListenerManager.PlayerEventListener(){

                @Override
                public void playerEvent(final DynmapPlayer p) {
                    core.getServer().scheduleServerTask(new Runnable(){

                        @Override
                        public void run() {
                            MarkersComponent.this.updatePlayer(p);
                        }
                    }, 0L);
                }
            });
        } else {
            this.spawnbedset = this.api.getMarkerSet(PLAYER_SPAWN_BED_SETID);
            if (this.spawnbedset != null) {
                this.spawnbedset.deleteMarkerSet();
            }
        }
    }

    private void updatePlayer(DynmapPlayer p) {
        DynmapLocation bl = p.getBedSpawnLocation();
        Marker m = this.spawnbedset.findMarker(p.getName() + "_bed");
        if (bl == null) {
            if (m != null) {
                m.deleteMarker();
            }
        } else if (m != null) {
            m.setLocation(bl.world, bl.x, bl.y, bl.z);
        } else {
            m = this.spawnbedset.createMarker(p.getName() + "_bed", this.spawnbedformat.replace("%name%", this.core.getServer().stripChatColor(p.getDisplayName())), false, bl.world, bl.x, bl.y, bl.z, this.spawnbedicon, true);
        }
    }

    private void addUpdateWorld(DynmapWorld w, DynmapLocation loc) {
        MarkerSet ms = this.api.getMarkerSet("markers");
        if (ms != null) {
            String spawnid = "_spawn_" + w.getName();
            Marker m = ms.findMarker(spawnid);
            if (m == null) {
                ms.createMarker(spawnid, this.spawnlbl, w.getName(), loc.x, loc.y, loc.z, this.spawnicon, false);
            } else {
                m.setLocation(w.getName(), loc.x, loc.y, loc.z);
            }
        }
    }

    @Override
    public void dispose() {
        if (this.signmgr != null) {
            MarkerSignManager.terminateSignManager(this.core);
            this.signmgr = null;
        }
    }
}

