/*
 * Decompiled with CFR 0.152.
 */
package org.dynmap;

import org.dynmap.Component;
import org.dynmap.ConfigurationNode;
import org.dynmap.DynmapCore;
import org.dynmap.DynmapLocation;
import org.dynmap.DynmapWorld;
import org.dynmap.Event;
import org.dynmap.JSONUtils;
import org.dynmap.MapType;
import org.dynmap.json.simple.JSONObject;

public class ClientConfigurationComponent
extends Component {
    public ClientConfigurationComponent(final DynmapCore core, ConfigurationNode configuration) {
        super(core, configuration);
        core.events.addListener("buildclientconfiguration", new Event.Listener<JSONObject>(){

            @Override
            public void triggered(JSONObject t) {
                ConfigurationNode c = core.configuration;
                JSONUtils.s(t, "confighash", core.getConfigHashcode());
                JSONUtils.s(t, "updaterate", Float.valueOf(c.getFloat("updaterate", 1.0f)));
                JSONUtils.s(t, "showplayerfacesinmenu", c.getBoolean("showplayerfacesinmenu", true));
                JSONUtils.s(t, "joinmessage", c.getString("joinmessage", "%playername% joined"));
                JSONUtils.s(t, "quitmessage", c.getString("quitmessage", "%playername% quit"));
                JSONUtils.s(t, "spammessage", c.getString("spammessage", "You may only chat once every %interval% seconds."));
                JSONUtils.s(t, "webprefix", Component.unescapeString(c.getString("webprefix", "[WEB] ")));
                JSONUtils.s(t, "defaultzoom", c.getInteger("defaultzoom", 0));
                JSONUtils.s(t, "sidebaropened", c.getString("sidebaropened", "false"));
                JSONUtils.s(t, "dynmapversion", core.getDynmapPluginVersion());
                JSONUtils.s(t, "coreversion", core.getDynmapCoreVersion());
                JSONUtils.s(t, "cyrillic", c.getBoolean("cyrillic-support", false));
                JSONUtils.s(t, "showlayercontrol", c.getString("showlayercontrol", "true"));
                JSONUtils.s(t, "grayplayerswhenhidden", c.getBoolean("grayplayerswhenhidden", true));
                JSONUtils.s(t, "login-enabled", core.isLoginSupportEnabled());
                String sn = core.getServer().getServerName();
                if (sn.equals("Unknown Server")) {
                    sn = "Minecraft Dynamic Map";
                }
                JSONUtils.s(t, "title", c.getString("webpage-title", sn));
                JSONUtils.s(t, "msg-maptypes", c.getString("msg/maptypes", "Map Types"));
                JSONUtils.s(t, "msg-players", c.getString("msg/players", "Players"));
                JSONUtils.s(t, "msg-chatrequireslogin", c.getString("msg/chatrequireslogin", "Chat Requires Login"));
                JSONUtils.s(t, "msg-chatnotallowed", c.getString("msg/chatnotallowed", "You are not permitted to send chat messages"));
                JSONUtils.s(t, "msg-hiddennamejoin", c.getString("msg/hiddennamejoin", "Player joined"));
                JSONUtils.s(t, "msg-hiddennamequit", c.getString("msg/hiddennamequit", "Player quit"));
                JSONUtils.s(t, "maxcount", core.getMaxPlayers());
                DynmapWorld defaultWorld = null;
                String defmap = null;
                JSONUtils.a(t, "worlds", null);
                for (DynmapWorld world : core.mapManager.getWorlds()) {
                    if (world.maps.size() == 0) continue;
                    if (defaultWorld == null) {
                        defaultWorld = world;
                    }
                    JSONObject wo = new JSONObject();
                    JSONUtils.s(wo, "name", world.getName());
                    JSONUtils.s(wo, "title", world.getTitle());
                    JSONUtils.s(wo, "protected", world.isProtected());
                    DynmapLocation center = world.getCenterLocation();
                    JSONUtils.s(wo, "center/x", center.x);
                    JSONUtils.s(wo, "center/y", center.y);
                    JSONUtils.s(wo, "center/z", center.z);
                    JSONUtils.s(wo, "extrazoomout", world.getExtraZoomOutLevels());
                    JSONUtils.s(wo, "sealevel", world.sealevel);
                    JSONUtils.s(wo, "worldheight", world.worldheight);
                    JSONUtils.a(t, "worlds", wo);
                    for (MapType mt : world.maps) {
                        mt.buildClientConfiguration(wo, world);
                        if (defmap != null) continue;
                        defmap = mt.getName();
                    }
                }
                JSONUtils.s(t, "defaultworld", c.getString("defaultworld", defaultWorld == null ? "world" : defaultWorld.getName()));
                JSONUtils.s(t, "defaultmap", c.getString("defaultmap", defmap == null ? "surface" : defmap));
                if (c.getString("followmap", null) != null) {
                    JSONUtils.s(t, "followmap", c.getString("followmap"));
                }
                if (c.getInteger("followzoom", -1) >= 0) {
                    JSONUtils.s(t, "followzoom", c.getInteger("followzoom", 0));
                }
            }
        });
    }
}

