/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.world.generator;

import com.hbm.inventory.RecipesCommon;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.util.Vec3;
import net.minecraft.world.World;
import net.minecraft.world.gen.feature.WorldGenMinable;

public class DungeonToolbox {
    public static void generateBox(World world, int x, int y, int z, int sx, int sy, int sz, List<RecipesCommon.MetaBlock> blocks) {
        if (blocks.isEmpty()) {
            return;
        }
        for (int i = x; i < x + sx; ++i) {
            for (int j = y; j < y + sy; ++j) {
                for (int k = z; k < z + sz; ++k) {
                    RecipesCommon.MetaBlock b = DungeonToolbox.getRandom(blocks, world.field_73012_v);
                    world.func_147465_d(i, j, k, b.block, b.meta, 2);
                }
            }
        }
    }

    public static void generateBox(World world, int x, int y, int z, int sx, int sy, int sz, Block block) {
        DungeonToolbox.generateBox(world, x, y, z, sx, sy, sz, new RecipesCommon.MetaBlock(block));
    }

    public static void generateBox(World world, int x, int y, int z, int sx, int sy, int sz, RecipesCommon.MetaBlock block) {
        for (int i = x; i < x + sx; ++i) {
            for (int j = y; j < y + sy; ++j) {
                for (int k = z; k < z + sz; ++k) {
                    world.func_147465_d(i, j, k, block.block, block.meta, 2);
                }
            }
        }
    }

    public static void generateBox(World world, int x, int y, int z, Vec3 size, List<RecipesCommon.MetaBlock> blocks) {
        DungeonToolbox.generateBox(world, x, y, z, (int)size.field_72450_a, (int)size.field_72448_b, (int)size.field_72449_c, blocks);
    }

    public static <T> T getRandom(List<T> list, Random rand) {
        if (list.isEmpty()) {
            return null;
        }
        return list.get(rand.nextInt(list.size()));
    }

    public static void generateOre(World world, Random rand, int chunkX, int chunkZ, int veinCount, int amount, int minHeight, int variance, Block ore) {
        DungeonToolbox.generateOre(world, rand, chunkX, chunkZ, veinCount, amount, minHeight, variance, ore, 0, Blocks.field_150348_b);
    }

    public static void generateOre(World world, Random rand, int chunkX, int chunkZ, int veinCount, int amount, int minHeight, int variance, Block ore, int meta) {
        DungeonToolbox.generateOre(world, rand, chunkX, chunkZ, veinCount, amount, minHeight, variance, ore, meta, Blocks.field_150348_b);
    }

    public static void generateOre(World world, Random rand, int chunkX, int chunkZ, int veinCount, int amount, int minHeight, int variance, Block ore, Block target) {
        DungeonToolbox.generateOre(world, rand, chunkX, chunkZ, veinCount, amount, minHeight, variance, ore, 0, target);
    }

    public static void generateOre(World world, Random rand, int chunkX, int chunkZ, int veinCount, int amount, int minHeight, int variance, Block ore, int meta, Block target) {
        for (int i = 0; i < veinCount; ++i) {
            int x = chunkX + rand.nextInt(16);
            int y = minHeight + (variance > 0 ? rand.nextInt(variance) : 0);
            int z = chunkZ + rand.nextInt(16);
            new WorldGenMinable(ore, meta, amount, target).func_76484_a(world, rand, x, y, z);
        }
    }
}

