/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import api.hbm.entity.IRadiationImmune;
import com.hbm.config.GeneralConfig;
import com.hbm.entity.mob.EntityNuclearCreeper;
import com.hbm.entity.mob.EntityQuackos;
import com.hbm.extprop.HbmLivingProps;
import com.hbm.handler.HazmatRegistry;
import com.hbm.lib.ModDamageSource;
import com.hbm.potion.HbmPotion;
import com.hbm.saveddata.RadiationSavedData;
import com.hbm.util.ArmorUtil;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.passive.EntityMooshroom;
import net.minecraft.entity.passive.EntityOcelot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.potion.Potion;
import net.minecraft.util.ChatComponentText;
import net.minecraft.util.ChatComponentTranslation;
import net.minecraft.util.ChatStyle;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.IChatComponent;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;

public class ContaminationUtil {
    public static float calculateRadiationMod(EntityLivingBase entity) {
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            float koeff = 10.0f;
            return (float)Math.pow(koeff, -HazmatRegistry.getResistance(player));
        }
        return 1.0f;
    }

    private static void applyRadData(Entity e, float f) {
        if (!(e instanceof EntityLivingBase)) {
            return;
        }
        if (ContaminationUtil.isRadImmune(e)) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)e;
        if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d) {
            return;
        }
        if (e instanceof EntityPlayer && e.field_70173_aa < 200) {
            return;
        }
        HbmLivingProps.incrementRadiation(entity, f *= ContaminationUtil.calculateRadiationMod(entity));
    }

    private static void applyRadDirect(Entity e, float f) {
        if (!(e instanceof EntityLivingBase)) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)e;
        if (ContaminationUtil.isRadImmune(e)) {
            return;
        }
        if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d) {
            return;
        }
        HbmLivingProps.incrementRadiation(entity, f);
    }

    public static float getRads(Entity e) {
        if (!(e instanceof EntityLivingBase)) {
            return 0.0f;
        }
        if (ContaminationUtil.isRadImmune(e)) {
            return 0.0f;
        }
        EntityLivingBase entity = (EntityLivingBase)e;
        return HbmLivingProps.getRadiation(entity);
    }

    public static boolean isRadImmune(Entity e) {
        if (e instanceof EntityLivingBase && ((EntityLivingBase)e).func_70644_a((Potion)HbmPotion.mutation)) {
            return true;
        }
        return e instanceof EntityNuclearCreeper || e instanceof EntityMooshroom || e instanceof EntityZombie || e instanceof EntitySkeleton || e instanceof EntityQuackos || e instanceof EntityOcelot || e instanceof IRadiationImmune;
    }

    public static void applyAsbestos(Entity e, int i) {
        if (!(e instanceof EntityLivingBase)) {
            return;
        }
        if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d) {
            return;
        }
        if (e instanceof EntityPlayer && e.field_70173_aa < 200) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)e;
        if (!(entity instanceof EntityPlayer) || !ArmorUtil.checkForGasMask((EntityPlayer)entity)) {
            HbmLivingProps.incrementAsbestos(entity, i);
        }
    }

    public static void applyDigammaData(Entity e, float f) {
        if (!(e instanceof EntityLivingBase)) {
            return;
        }
        if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d) {
            return;
        }
        if (e instanceof EntityPlayer && e.field_70173_aa < 200) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)e;
        if (entity.func_82165_m(HbmPotion.stability.field_76415_H)) {
            return;
        }
        if (!(entity instanceof EntityPlayer) || !ArmorUtil.checkForDigamma((EntityPlayer)entity)) {
            HbmLivingProps.incrementDigamma(entity, f);
        }
    }

    public static void applyDigammaDirect(Entity e, float f) {
        if (!(e instanceof EntityLivingBase)) {
            return;
        }
        if (e instanceof IRadiationImmune) {
            return;
        }
        if (e instanceof EntityPlayer && ((EntityPlayer)e).field_71075_bZ.field_75098_d) {
            return;
        }
        EntityLivingBase entity = (EntityLivingBase)e;
        HbmLivingProps.incrementDigamma(entity, f);
    }

    public static float getDigamma(Entity e) {
        if (!(e instanceof EntityLivingBase)) {
            return 0.0f;
        }
        EntityLivingBase entity = (EntityLivingBase)e;
        return HbmLivingProps.getDigamma(entity);
    }

    public static void printGeigerData(EntityPlayer player) {
        World world = player.field_70170_p;
        double eRad = (double)((int)(HbmLivingProps.getRadiation((EntityLivingBase)player) * 10.0f)) / 10.0;
        RadiationSavedData data = RadiationSavedData.getData(player.field_70170_p);
        Chunk chunk = world.func_72938_d((int)player.field_70165_t, (int)player.field_70161_v);
        double rads = (double)((int)(data.getRadNumFromCoord(chunk.field_76635_g, chunk.field_76647_h) * 10.0f)) / 10.0;
        double env = (double)((int)((double)HbmLivingProps.getRadBuf((EntityLivingBase)player) * 10.0)) / 10.0;
        double res = (double)((int)(10000.0 - (double)ContaminationUtil.calculateRadiationMod((EntityLivingBase)player) * 10000.0)) / 100.0;
        double resKoeff = (double)((int)((double)HazmatRegistry.getResistance(player) * 100.0)) / 100.0;
        String chunkPrefix = ContaminationUtil.getPreffixFromRad(rads);
        String envPrefix = ContaminationUtil.getPreffixFromRad(env);
        String radPrefix = "";
        String resPrefix = "" + EnumChatFormatting.WHITE;
        radPrefix = eRad < 200.0 ? radPrefix + EnumChatFormatting.GREEN : (eRad < 400.0 ? radPrefix + EnumChatFormatting.YELLOW : (eRad < 600.0 ? radPrefix + EnumChatFormatting.GOLD : (eRad < 800.0 ? radPrefix + EnumChatFormatting.RED : (eRad < 1000.0 ? radPrefix + EnumChatFormatting.DARK_RED : radPrefix + EnumChatFormatting.DARK_GRAY))));
        if (resKoeff > 0.0) {
            resPrefix = resPrefix + EnumChatFormatting.GREEN;
        }
        player.func_145747_a(new ChatComponentText("===== \u2622 ").func_150257_a((IChatComponent)new ChatComponentTranslation("geiger.title", new Object[0])).func_150257_a((IChatComponent)new ChatComponentText(" \u2622 =====")).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.GOLD)));
        player.func_145747_a(new ChatComponentTranslation("geiger.chunkRad", new Object[0]).func_150257_a((IChatComponent)new ChatComponentText(" " + chunkPrefix + rads + " RAD/s")).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)));
        player.func_145747_a(new ChatComponentTranslation("geiger.envRad", new Object[0]).func_150257_a((IChatComponent)new ChatComponentText(" " + envPrefix + env + " RAD/s")).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)));
        player.func_145747_a(new ChatComponentTranslation("geiger.playerRad", new Object[0]).func_150257_a((IChatComponent)new ChatComponentText(" " + radPrefix + eRad + " RAD")).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)));
        player.func_145747_a(new ChatComponentTranslation("geiger.playerRes", new Object[0]).func_150257_a((IChatComponent)new ChatComponentText(" " + resPrefix + res + "% (" + resKoeff + ")")).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.YELLOW)));
    }

    public static String getPreffixFromRad(double rads) {
        String chunkPrefix = "";
        chunkPrefix = rads == 0.0 ? chunkPrefix + EnumChatFormatting.GREEN : (rads < 1.0 ? chunkPrefix + EnumChatFormatting.YELLOW : (rads < 10.0 ? chunkPrefix + EnumChatFormatting.GOLD : (rads < 100.0 ? chunkPrefix + EnumChatFormatting.RED : (rads < 1000.0 ? chunkPrefix + EnumChatFormatting.DARK_RED : chunkPrefix + EnumChatFormatting.DARK_GRAY))));
        return chunkPrefix;
    }

    public static void printDiagnosticData(EntityPlayer player) {
        double digamma = (double)((int)(HbmLivingProps.getDigamma((EntityLivingBase)player) * 100.0f)) / 100.0;
        double halflife = (double)((int)((1.0 - Math.pow(0.5, digamma)) * 100.0)) / 100.0;
        player.func_145747_a(new ChatComponentText("===== \u03dc ").func_150257_a((IChatComponent)new ChatComponentTranslation("digamma.title", new Object[0])).func_150257_a((IChatComponent)new ChatComponentText(" \u03dc =====")).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.DARK_PURPLE)));
        player.func_145747_a(new ChatComponentTranslation("digamma.playerDigamma", new Object[0]).func_150257_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + " " + digamma + " DRX")).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.LIGHT_PURPLE)));
        player.func_145747_a(new ChatComponentTranslation("digamma.playerHealth", new Object[0]).func_150257_a((IChatComponent)new ChatComponentText(EnumChatFormatting.RED + " " + halflife + "%")).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.LIGHT_PURPLE)));
        player.func_145747_a(new ChatComponentTranslation("digamma.playerRes", new Object[0]).func_150257_a((IChatComponent)new ChatComponentText(EnumChatFormatting.BLUE + " N/A")).func_150255_a(new ChatStyle().func_150238_a(EnumChatFormatting.LIGHT_PURPLE)));
    }

    public static boolean contaminate(EntityLivingBase entity, HazardType hazard, ContaminationType cont, float amount) {
        if (hazard == HazardType.RADIATION) {
            float radEnv = HbmLivingProps.getRadEnv(entity);
            HbmLivingProps.setRadEnv(entity, radEnv + amount);
        }
        if (entity instanceof EntityPlayer) {
            EntityPlayer player = (EntityPlayer)entity;
            switch (cont) {
                case GAS: {
                    if (!ArmorUtil.checkForGasMask(player)) break;
                    return false;
                }
                case GAS_NON_REACTIVE: {
                    if (!ArmorUtil.checkForMonoMask(player)) break;
                    return false;
                }
                case GOGGLES: {
                    if (!ArmorUtil.checkForGoggles(player)) break;
                    return false;
                }
                case FARADAY: {
                    if (!ArmorUtil.checkForFaraday(player)) break;
                    return false;
                }
                case HAZMAT: {
                    if (!ArmorUtil.checkForHazmat(player)) break;
                    return false;
                }
                case HAZMAT2: {
                    if (!ArmorUtil.checkForHaz2(player)) break;
                    return false;
                }
                case DIGAMMA: {
                    if (ArmorUtil.checkForDigamma(player)) {
                        return false;
                    }
                    if (!ArmorUtil.checkForDigamma2(player)) break;
                    return false;
                }
                case DIGAMMA2: {
                    if (!ArmorUtil.checkForDigamma2(player)) break;
                    return false;
                }
            }
            if (player.field_71075_bZ.field_75098_d && cont != ContaminationType.NONE && cont != ContaminationType.DIGAMMA2) {
                return false;
            }
            if (player.field_70173_aa < 200) {
                return false;
            }
        }
        if (hazard == HazardType.RADIATION && (ContaminationUtil.isRadImmune((Entity)entity) || !GeneralConfig.enableRads)) {
            return false;
        }
        switch (hazard) {
            case MONOXIDE: {
                entity.func_70097_a(ModDamageSource.monoxide, amount);
                break;
            }
            case RADIATION: {
                HbmLivingProps.incrementRadiation(entity, amount * (cont == ContaminationType.RAD_BYPASS ? 1.0f : ContaminationUtil.calculateRadiationMod(entity)));
                break;
            }
            case ASBESTOS: {
                HbmLivingProps.incrementAsbestos(entity, (int)amount);
                break;
            }
            case DIGAMMA: {
                HbmLivingProps.incrementDigamma(entity, amount);
            }
        }
        return true;
    }

    public static enum ContaminationType {
        GAS,
        GAS_NON_REACTIVE,
        GOGGLES,
        FARADAY,
        HAZMAT,
        HAZMAT2,
        DIGAMMA,
        DIGAMMA2,
        CREATIVE,
        RAD_BYPASS,
        NONE;

    }

    public static enum HazardType {
        MONOXIDE,
        RADIATION,
        ASBESTOS,
        DIGAMMA;

    }
}

