/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.util;

import com.hbm.handler.ArmorModHandler;
import com.hbm.handler.HazmatRegistry;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.potion.HbmPotion;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.Potion;

public class ArmorUtil {
    public static final String[] metals = new String[]{"chainmail", "iron", "silver", "gold", "platinum", "tin", "lead", "liquidator", "schrabidium", "euphemium", "steel", "cmb", "titanium", "alloy", "copper", "bronze", "electrum", "t45", "bj", "starmetal", "hazmat", "rubber", "hev", "ajr", "spacesuit"};

    public static boolean checkArmor(EntityPlayer player, Item helmet, Item plate, Item legs, Item boots) {
        return player.field_71071_by.field_70460_b[0] != null && player.field_71071_by.field_70460_b[0].func_77973_b() == boots && player.field_71071_by.field_70460_b[1] != null && player.field_71071_by.field_70460_b[1].func_77973_b() == legs && player.field_71071_by.field_70460_b[2] != null && player.field_71071_by.field_70460_b[2].func_77973_b() == plate && player.field_71071_by.field_70460_b[3] != null && player.field_71071_by.field_70460_b[3].func_77973_b() == helmet;
    }

    public static boolean checkArmorPiece(EntityPlayer player, Item armor, int slot) {
        return player.field_71071_by.field_70460_b[slot] != null && player.field_71071_by.field_70460_b[slot].func_77973_b() == armor;
    }

    public static boolean checkArmorNull(EntityPlayer player, int slot) {
        return player.field_71071_by.field_70460_b[slot] == null;
    }

    public static void damageSuit(EntityPlayer player, int slot, int amount) {
        if (player.field_71071_by.field_70460_b[slot] == null) {
            return;
        }
        int j = player.field_71071_by.field_70460_b[slot].func_77960_j();
        player.field_71071_by.field_70460_b[slot].func_77964_b(j += amount);
        if (player.field_71071_by.field_70460_b[slot].func_77960_j() >= player.field_71071_by.field_70460_b[slot].func_77958_k()) {
            player.field_71071_by.field_70460_b[slot] = null;
        }
    }

    public static boolean checkForHazmat(EntityPlayer player) {
        if (ArmorUtil.checkArmor(player, ModItems.hazmat_helmet, ModItems.hazmat_plate, ModItems.hazmat_legs, ModItems.hazmat_boots) || ArmorUtil.checkArmor(player, ModItems.hazmat_helmet_red, ModItems.hazmat_plate_red, ModItems.hazmat_legs_red, ModItems.hazmat_boots_red) || ArmorUtil.checkArmor(player, ModItems.hazmat_helmet_grey, ModItems.hazmat_plate_grey, ModItems.hazmat_legs_grey, ModItems.hazmat_boots_grey) || ArmorUtil.checkArmor(player, ModItems.t45_helmet, ModItems.t45_plate, ModItems.t45_legs, ModItems.t45_boots) || ArmorUtil.checkArmor(player, ModItems.schrabidium_helmet, ModItems.schrabidium_plate, ModItems.schrabidium_legs, ModItems.schrabidium_boots) || ArmorUtil.checkForHaz2(player)) {
            return true;
        }
        return player.func_70644_a((Potion)HbmPotion.mutation);
    }

    public static boolean checkForHaz2(EntityPlayer player) {
        return ArmorUtil.checkArmor(player, ModItems.hazmat_paa_helmet, ModItems.hazmat_paa_plate, ModItems.hazmat_paa_legs, ModItems.hazmat_paa_boots) || ArmorUtil.checkArmor(player, ModItems.liquidator_helmet, ModItems.liquidator_plate, ModItems.liquidator_legs, ModItems.liquidator_boots) || ArmorUtil.checkArmor(player, ModItems.euphemium_helmet, ModItems.euphemium_plate, ModItems.euphemium_legs, ModItems.euphemium_boots);
    }

    public static boolean checkForAsbestos(EntityPlayer player) {
        return ArmorUtil.checkArmor(player, ModItems.asbestos_helmet, ModItems.asbestos_plate, ModItems.asbestos_legs, ModItems.asbestos_boots);
    }

    public static boolean checkForDigamma(EntityPlayer player) {
        if (ArmorUtil.checkArmor(player, ModItems.fau_helmet, ModItems.fau_plate, ModItems.fau_legs, ModItems.fau_boots)) {
            return true;
        }
        return player.func_82165_m(HbmPotion.stability.field_76415_H);
    }

    public static boolean checkForDigamma2(EntityPlayer player) {
        if (!ArmorUtil.checkArmor(player, ModItems.robes_helmet, ModItems.robes_plate, ModItems.robes_legs, ModItems.robes_boots)) {
            return false;
        }
        if (player.func_82165_m(HbmPotion.stability.field_76415_H)) {
            return true;
        }
        for (int i = 0; i < 4; ++i) {
            ItemStack[] mods;
            ItemStack armor = player.func_82169_q(i);
            if (armor == null || !ArmorModHandler.hasMods(armor) || (mods = ArmorModHandler.pryMods(armor))[5] != null && mods[5].func_77973_b() == ModItems.cladding_iron) continue;
            return false;
        }
        return player.func_110138_aP() < 3.0f;
    }

    public static boolean checkForFaraday(EntityPlayer player) {
        ItemStack[] armor = player.field_71071_by.field_70460_b;
        if (armor[0] == null || armor[1] == null || armor[2] == null || armor[3] == null) {
            return false;
        }
        return ArmorUtil.isFaradayArmor(armor[0]) && ArmorUtil.isFaradayArmor(armor[1]) && ArmorUtil.isFaradayArmor(armor[2]) && ArmorUtil.isFaradayArmor(armor[3]);
    }

    public static boolean isFaradayArmor(ItemStack item) {
        String name = item.func_77977_a();
        for (String metal : metals) {
            if (!name.toLowerCase().contains(metal)) continue;
            return true;
        }
        return HazmatRegistry.getCladding(item) > 0.0;
    }

    public static boolean checkForGasMask(EntityPlayer player) {
        ItemStack[] mods;
        if (ArmorUtil.checkArmorPiece(player, ModItems.hazmat_helmet, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.hazmat_helmet_red, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.hazmat_helmet_grey, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.hazmat_paa_helmet, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.liquidator_helmet, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.gas_mask, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.gas_mask_m65, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.t45_helmet, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.ajr_helmet, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.ajro_helmet, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.hev_helmet, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.schrabidium_helmet, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.euphemium_helmet, 3)) {
            return true;
        }
        if (player.func_70644_a((Potion)HbmPotion.mutation)) {
            return true;
        }
        ItemStack helmet = player.func_82169_q(3);
        return helmet != null && ArmorModHandler.hasMods(helmet) && (mods = ArmorModHandler.pryMods(helmet))[0] != null && mods[0].func_77973_b() == ModItems.attachment_mask;
    }

    public static boolean checkForMonoMask(EntityPlayer player) {
        ItemStack[] mods;
        if (ArmorUtil.checkArmorPiece(player, ModItems.gas_mask_mono, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.liquidator_helmet, 3)) {
            return true;
        }
        if (player.func_70644_a((Potion)HbmPotion.mutation)) {
            return true;
        }
        ItemStack helmet = player.func_82169_q(3);
        return helmet != null && ArmorModHandler.hasMods(helmet) && (mods = ArmorModHandler.pryMods(helmet))[0] != null && mods[0].func_77973_b() == ModItems.attachment_mask_mono;
    }

    public static boolean checkForGoggles(EntityPlayer player) {
        if (ArmorUtil.checkArmorPiece(player, ModItems.goggles, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.ashglasses, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.hazmat_helmet_red, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.hazmat_helmet_grey, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.liquidator_helmet, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.gas_mask, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.t45_helmet, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.ajr_helmet, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.ajro_helmet, 3)) {
            return true;
        }
        if (ArmorUtil.checkArmorPiece(player, ModItems.bj_helmet, 3)) {
            return true;
        }
        return ArmorUtil.checkArmorPiece(player, ModItems.hev_helmet, 3);
    }

    public static boolean checkForFiend(EntityPlayer player) {
        return ArmorUtil.checkArmorPiece(player, ModItems.jackt, 2) && Library.checkForHeld(player, ModItems.shimmer_sledge);
    }

    public static boolean checkForFiend2(EntityPlayer player) {
        return ArmorUtil.checkArmorPiece(player, ModItems.jackt2, 2) && Library.checkForHeld(player, ModItems.shimmer_axe);
    }
}

