/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.turret;

import com.hbm.entity.logic.EntityBomber;
import com.hbm.entity.missile.EntityMissileBaseAdvanced;
import com.hbm.entity.missile.EntityMissileCustom;
import com.hbm.entity.projectile.EntityBulletBase;
import com.hbm.handler.BulletConfigSyncingUtil;
import com.hbm.handler.BulletConfiguration;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemTurretBiometry;
import com.hbm.lib.Library;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.INpc;
import net.minecraft.entity.item.EntityMinecart;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.passive.IAnimals;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;
import net.minecraftforge.common.util.FakePlayer;

public abstract class TileEntityTurretBaseNT
extends TileEntityMachineBase
implements IConsumer,
IControlReceiver {
    public double rotationYaw;
    public double rotationPitch;
    public double lastRotationYaw;
    public double lastRotationPitch;
    public boolean isOn = false;
    public boolean aligned = false;
    public int searchTimer;
    public long power;
    public boolean targetPlayers = false;
    public boolean targetAnimals = false;
    public boolean targetMobs = true;
    public boolean targetMachines = true;
    public Entity target;
    public Vec3 tPos;
    public int stattrak;

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return this.func_70300_a(player);
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("del")) {
            this.removeName(data.func_74762_e("del"));
        } else if (data.func_74764_b("name")) {
            this.addName(data.func_74779_i("name"));
        }
    }

    public TileEntityTurretBaseNT() {
        super(11);
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.isOn = nbt.func_74767_n("isOn");
        this.targetPlayers = nbt.func_74767_n("targetPlayers");
        this.targetAnimals = nbt.func_74767_n("targetAnimals");
        this.targetMobs = nbt.func_74767_n("targetMobs");
        this.targetMachines = nbt.func_74767_n("targetMachines");
        this.stattrak = nbt.func_74762_e("stattrak");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74757_a("targetPlayers", this.targetPlayers);
        nbt.func_74757_a("targetAnimals", this.targetAnimals);
        nbt.func_74757_a("targetMobs", this.targetMobs);
        nbt.func_74757_a("targetMachines", this.targetMachines);
        nbt.func_74768_a("stattrak", this.stattrak);
    }

    public void manualSetup() {
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.field_72995_K) {
            this.lastRotationPitch = this.rotationPitch;
            this.lastRotationYaw = this.rotationYaw;
        }
        this.aligned = false;
        if (!this.field_145850_b.field_72995_K && this.target != null && !this.target.func_70089_S()) {
            this.target = null;
            ++this.stattrak;
        }
        if (this.target != null && !this.entityInLOS(this.target)) {
            this.target = null;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.tPos = this.target != null ? this.getEntityPos(this.target) : null;
        }
        if (this.isOn && this.hasPower()) {
            if (this.tPos != null) {
                this.alignTurret();
            }
        } else {
            this.target = null;
            this.tPos = null;
        }
        if (!this.field_145850_b.field_72995_K) {
            if (this.target != null && !this.target.func_70089_S()) {
                this.target = null;
                this.tPos = null;
                ++this.stattrak;
            }
            if (this.isOn && this.hasPower()) {
                --this.searchTimer;
                this.setPower(this.getPower() - this.getConsumption());
                if (this.searchTimer <= 0) {
                    this.searchTimer = this.getDecetorInterval();
                    if (this.target == null) {
                        this.seekNewTarget();
                    }
                }
            } else {
                this.searchTimer = 0;
            }
            if (this.aligned) {
                this.updateFiringTick();
            }
            this.power = Library.chargeTEFromItems(this.slots, 10, this.power, this.getMaxPower());
            NBTTagCompound data = new NBTTagCompound();
            if (this.tPos != null) {
                data.func_74780_a("tX", this.tPos.field_72450_a);
                data.func_74780_a("tY", this.tPos.field_72448_b);
                data.func_74780_a("tZ", this.tPos.field_72449_c);
            }
            data.func_74772_a("power", this.power);
            data.func_74757_a("isOn", this.isOn);
            data.func_74757_a("targetPlayers", this.targetPlayers);
            data.func_74757_a("targetAnimals", this.targetAnimals);
            data.func_74757_a("targetMobs", this.targetMobs);
            data.func_74757_a("targetMachines", this.targetMachines);
            data.func_74768_a("stattrak", this.stattrak);
            this.networkPack(data, 250);
        } else {
            Vec3 vec = Vec3.func_72443_a((double)this.getBarrelLength(), (double)0.0, (double)0.0);
            vec.func_72446_c((float)(-this.rotationPitch));
            vec.func_72442_b((float)(-(this.rotationYaw + 1.5707963267948966)));
            if (Math.abs(this.lastRotationYaw - this.rotationYaw) > Math.PI) {
                this.lastRotationYaw = this.lastRotationYaw < this.rotationYaw ? (this.lastRotationYaw += Math.PI * 2) : (this.lastRotationYaw -= Math.PI * 2);
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.isOn = nbt.func_74767_n("isOn");
        this.targetPlayers = nbt.func_74767_n("targetPlayers");
        this.targetAnimals = nbt.func_74767_n("targetAnimals");
        this.targetMobs = nbt.func_74767_n("targetMobs");
        this.targetMachines = nbt.func_74767_n("targetMachines");
        this.stattrak = nbt.func_74762_e("stattrak");
        this.tPos = nbt.func_74764_b("tX") ? Vec3.func_72443_a((double)nbt.func_74769_h("tX"), (double)nbt.func_74769_h("tY"), (double)nbt.func_74769_h("tZ")) : null;
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        switch (meta) {
            case 0: {
                this.isOn = !this.isOn;
                break;
            }
            case 1: {
                this.targetPlayers = !this.targetPlayers;
                break;
            }
            case 2: {
                this.targetAnimals = !this.targetAnimals;
                break;
            }
            case 3: {
                this.targetMobs = !this.targetMobs;
                break;
            }
            case 4: {
                this.targetMachines = !this.targetMachines;
            }
        }
    }

    public abstract void updateFiringTick();

    public BulletConfiguration getFirstConfigLoaded() {
        List<Integer> list = this.getAmmoList();
        if (list == null || list.isEmpty()) {
            return null;
        }
        for (int i = 1; i < 10; ++i) {
            if (this.slots[i] == null) continue;
            for (Integer c : list) {
                BulletConfiguration conf = BulletConfigSyncingUtil.pullConfig(c);
                if (conf.ammo != this.slots[i].func_77973_b()) continue;
                return conf;
            }
        }
        return null;
    }

    public void spawnBullet(BulletConfiguration bullet) {
        Vec3 pos = this.getTurretPos();
        Vec3 vec = Vec3.func_72443_a((double)this.getBarrelLength(), (double)0.0, (double)0.0);
        vec.func_72446_c((float)(-this.rotationPitch));
        vec.func_72442_b((float)(-(this.rotationYaw + 1.5707963267948966)));
        EntityBulletBase proj = new EntityBulletBase(this.field_145850_b, BulletConfigSyncingUtil.getKey(bullet));
        proj.func_70080_a(pos.field_72450_a + vec.field_72450_a, pos.field_72448_b + vec.field_72448_b, pos.field_72449_c + vec.field_72449_c, 0.0f, 0.0f);
        proj.func_70186_c(vec.field_72450_a, vec.field_72448_b, vec.field_72449_c, bullet.velocity, bullet.spread);
        this.field_145850_b.func_72838_d((Entity)proj);
    }

    public void conusmeAmmo(Item ammo) {
        for (int i = 1; i < 10; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ammo) continue;
            this.func_70298_a(i, 1);
            return;
        }
        this.func_70296_d();
    }

    public List<String> getWhitelist() {
        if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.turret_chip) {
            String[] array = ItemTurretBiometry.getNames(this.slots[0]);
            if (array == null) {
                return null;
            }
            return Arrays.asList(ItemTurretBiometry.getNames(this.slots[0]));
        }
        return null;
    }

    public void addName(String name) {
        if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.turret_chip) {
            ItemTurretBiometry.addName(this.slots[0], name);
        }
    }

    public void removeName(int index) {
        if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.turret_chip) {
            String[] array = ItemTurretBiometry.getNames(this.slots[0]);
            if (array == null) {
                return;
            }
            ArrayList<String> names = new ArrayList<String>(Arrays.asList(array));
            ItemTurretBiometry.clearNames(this.slots[0]);
            names.remove(index);
            for (String name : names) {
                ItemTurretBiometry.addName(this.slots[0], name);
            }
        }
    }

    protected void seekNewTarget() {
        Vec3 pos = this.getTurretPos();
        double range = this.getDecetorRange();
        List entities = this.field_145850_b.func_72872_a(Entity.class, AxisAlignedBB.func_72330_a((double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c, (double)pos.field_72450_a, (double)pos.field_72448_b, (double)pos.field_72449_c).func_72314_b(range, range, range));
        Entity target = null;
        double closest = range;
        for (Entity entity : entities) {
            Vec3 ent = this.getEntityPos(entity);
            Vec3 delta = Vec3.func_72443_a((double)(ent.field_72450_a - pos.field_72450_a), (double)(ent.field_72448_b - pos.field_72448_b), (double)(ent.field_72449_c - pos.field_72449_c));
            double dist = delta.func_72433_c();
            if (dist > range || !this.entityAcceptableTarget(entity) || !this.entityInLOS(entity) || !(dist < closest)) continue;
            closest = dist;
            target = entity;
        }
        this.target = target;
        if (target != null) {
            this.tPos = this.getEntityPos(this.target);
        }
    }

    protected void alignTurret() {
        this.turnTowards(this.tPos);
    }

    public void turnTowards(Vec3 ent) {
        double turnYaw = Math.toRadians(this.getTurretYawSpeed());
        double turnPitch = Math.toRadians(this.getTurretPitchSpeed());
        double pi2 = Math.PI * 2;
        Vec3 pos = this.getTurretPos();
        Vec3 delta = Vec3.func_72443_a((double)(ent.field_72450_a - pos.field_72450_a), (double)(ent.field_72448_b - pos.field_72448_b), (double)(ent.field_72449_c - pos.field_72449_c));
        double targetPitch = Math.asin(delta.field_72448_b / delta.func_72433_c());
        double targetYaw = -Math.atan2(delta.field_72450_a, delta.field_72449_c);
        this.rotationPitch = Math.abs(this.rotationPitch - targetPitch) < turnPitch || Math.abs(this.rotationPitch - targetPitch) > pi2 - turnPitch ? targetPitch : (targetPitch > this.rotationPitch ? (this.rotationPitch += turnPitch) : (this.rotationPitch -= turnPitch));
        double deltaYaw = (targetYaw - this.rotationYaw) % pi2;
        int dir = 0;
        if (deltaYaw < -Math.PI) {
            dir = 1;
        } else if (deltaYaw < 0.0) {
            dir = -1;
        } else if (deltaYaw > Math.PI) {
            dir = -1;
        } else if (deltaYaw > 0.0) {
            dir = 1;
        }
        this.rotationYaw = Math.abs(this.rotationYaw - targetYaw) < turnYaw || Math.abs(this.rotationYaw - targetYaw) > pi2 - turnYaw ? targetYaw : (this.rotationYaw += turnYaw * (double)dir);
        double deltaPitch = targetPitch - this.rotationPitch;
        deltaYaw = targetYaw - this.rotationYaw;
        double deltaAngle = Math.sqrt(deltaYaw * deltaYaw + deltaPitch * deltaPitch);
        this.rotationYaw %= pi2;
        this.rotationPitch %= pi2;
        if (deltaAngle <= Math.toRadians(this.getAcceptableInaccuracy())) {
            this.aligned = true;
        }
    }

    public boolean entityInLOS(Entity e) {
        if (e.field_70128_L || !e.func_70089_S()) {
            return false;
        }
        Vec3 pos = this.getTurretPos();
        Vec3 ent = this.getEntityPos(e);
        Vec3 delta = Vec3.func_72443_a((double)(ent.field_72450_a - pos.field_72450_a), (double)(ent.field_72448_b - pos.field_72448_b), (double)(ent.field_72449_c - pos.field_72449_c));
        double length = delta.func_72433_c();
        if (length < this.getDecetorGrace()) {
            return false;
        }
        double pitch = Math.asin(delta.field_72448_b / (delta = delta.func_72432_b()).func_72433_c());
        double pitchDeg = Math.toDegrees(pitch);
        if (pitchDeg < -this.getTurretDepression() || pitchDeg > this.getTurretElevation()) {
            return false;
        }
        return !Library.isObstructed(this.field_145850_b, ent.field_72450_a, ent.field_72448_b, ent.field_72449_c, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
    }

    public boolean entityAcceptableTarget(Entity e) {
        if (e.field_70128_L || !e.func_70089_S()) {
            return false;
        }
        if (this.targetAnimals) {
            if (e instanceof IAnimals) {
                return true;
            }
            if (e instanceof INpc) {
                return true;
            }
        }
        if (this.targetMobs && e instanceof IMob) {
            return true;
        }
        if (this.targetMachines) {
            if (e instanceof EntityMissileBaseAdvanced) {
                return true;
            }
            if (e instanceof EntityMissileCustom) {
                return true;
            }
            if (e instanceof EntityMinecart) {
                return true;
            }
            if (e instanceof EntityBomber) {
                return true;
            }
        }
        if (this.targetPlayers && e instanceof EntityPlayer) {
            if (e instanceof FakePlayer) {
                return false;
            }
            List<String> wl = this.getWhitelist();
            if (wl == null || wl.isEmpty()) {
                return true;
            }
            return !wl.contains(((EntityPlayer)e).getDisplayName());
        }
        return false;
    }

    public double getAcceptableInaccuracy() {
        return 5.0;
    }

    public double getTurretYawSpeed() {
        return 4.5;
    }

    public double getTurretPitchSpeed() {
        return 3.0;
    }

    public double getTurretDepression() {
        return 30.0;
    }

    public double getTurretElevation() {
        return 30.0;
    }

    public int getDecetorInterval() {
        return 10;
    }

    public double getDecetorRange() {
        return 32.0;
    }

    public double getDecetorGrace() {
        return 3.0;
    }

    public double getHeightOffset() {
        return 1.5;
    }

    public double getBarrelLength() {
        return 1.0;
    }

    public Vec3 getTurretPos() {
        Vec3 offset = this.getHorizontalOffset();
        return Vec3.func_72443_a((double)((double)this.field_145851_c + offset.field_72450_a), (double)((double)this.field_145848_d + this.getHeightOffset()), (double)((double)this.field_145849_e + offset.field_72449_c));
    }

    public Vec3 getHorizontalOffset() {
        int meta = this.func_145832_p() - 10;
        if (meta == 2) {
            return Vec3.func_72443_a((double)1.0, (double)0.0, (double)1.0);
        }
        if (meta == 4) {
            return Vec3.func_72443_a((double)1.0, (double)0.0, (double)0.0);
        }
        if (meta == 5) {
            return Vec3.func_72443_a((double)0.0, (double)0.0, (double)1.0);
        }
        return Vec3.func_72443_a((double)0.0, (double)0.0, (double)0.0);
    }

    public Vec3 getEntityPos(Entity e) {
        return Vec3.func_72443_a((double)e.field_70165_t, (double)(e.field_70163_u + (double)e.field_70131_O * 0.5 - e.func_70033_W()), (double)e.field_70161_v);
    }

    protected abstract List<Integer> getAmmoList();

    @Override
    public int[] func_94128_d(int side) {
        return new int[]{1, 2, 3, 4, 5, 6, 7, 8, 9};
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    public boolean hasPower() {
        return this.getPower() >= this.getConsumption();
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    public int getPowerScaled(int scale) {
        return (int)(this.power * (long)scale / this.getMaxPower());
    }

    public long getConsumption() {
        return 100L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

