/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.turret;

import com.hbm.blocks.turret.TurretBase;
import com.hbm.entity.logic.EntityBomber;
import com.hbm.entity.missile.EntityMissileBaseAdvanced;
import com.hbm.entity.missile.EntityMissileCustom;
import com.hbm.lib.Library;
import com.hbm.packet.PacketDispatcher;
import com.hbm.packet.TETurretPacket;
import com.hbm.tileentity.turret.TileEntityTurretCIWS;
import com.hbm.tileentity.turret.TileEntityTurretCheapo;
import com.hbm.tileentity.turret.TileEntityTurretFlamer;
import com.hbm.tileentity.turret.TileEntityTurretSpitfire;
import com.hbm.tileentity.turret.TileEntityTurretTau;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;

public abstract class TileEntityTurretBase
extends TileEntity {
    public double rotationYaw;
    public double rotationPitch;
    public boolean isAI = false;
    public List<String> players = new ArrayList<String>();
    public int use;
    public int ammo = 0;

    public void func_145845_h() {
        if (this.isAI) {
            Object[] iter = this.field_145850_b.field_72996_f.toArray();
            double radius = 1000.0;
            if (this instanceof TileEntityTurretFlamer) {
                radius /= 2.0;
            }
            if (this instanceof TileEntityTurretSpitfire) {
                radius *= 3.0;
            }
            if (this instanceof TileEntityTurretCIWS) {
                radius *= 250.0;
            }
            Entity target = null;
            for (int i = 0; i < iter.length; ++i) {
                double distance;
                Entity e = (Entity)iter[i];
                if (!this.isInSight(e) || !((distance = e.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5)) < radius)) continue;
                radius = distance;
                target = e;
            }
            if (target != null) {
                Vec3 turret = Vec3.func_72443_a((double)(target.field_70165_t - ((double)this.field_145851_c + 0.5)), (double)(target.field_70163_u + (double)target.func_70047_e() - (double)(this.field_145848_d + 1)), (double)(target.field_70161_v - ((double)this.field_145849_e + 0.5)));
                if (this instanceof TileEntityTurretCIWS || this instanceof TileEntityTurretSpitfire || this instanceof TileEntityTurretCheapo) {
                    turret = Vec3.func_72443_a((double)(target.field_70165_t - ((double)this.field_145851_c + 0.5)), (double)(target.field_70163_u + (double)target.func_70047_e() - ((double)this.field_145848_d + 1.5)), (double)(target.field_70161_v - ((double)this.field_145849_e + 0.5)));
                }
                this.rotationPitch = -Math.asin(turret.field_72448_b / turret.func_72433_c()) * 180.0 / Math.PI;
                this.rotationYaw = -Math.atan2(turret.field_72450_a, turret.field_72449_c) * 180.0 / Math.PI;
                if (this.rotationPitch < -60.0) {
                    this.rotationPitch = -60.0;
                }
                if (this.rotationPitch > 30.0) {
                    this.rotationPitch = 30.0;
                }
                if (this instanceof TileEntityTurretCheapo) {
                    if (this.rotationPitch < -30.0) {
                        this.rotationPitch = -30.0;
                    }
                    if (this.rotationPitch > 15.0) {
                        this.rotationPitch = 15.0;
                    }
                }
                if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof TurretBase && this.ammo > 0 && ((TurretBase)this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e)).executeHoldAction(this.field_145850_b, this.use, this.rotationYaw, this.rotationPitch, this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
                    --this.ammo;
                }
                ++this.use;
            } else {
                this.use = 0;
            }
        }
        if (!this.field_145850_b.field_72995_K) {
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new TETurretPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.rotationYaw, this.rotationPitch), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 150.0));
        }
    }

    private boolean isInSight(Entity e) {
        if (!(e instanceof EntityLivingBase || e instanceof EntityMissileBaseAdvanced || e instanceof EntityBomber || e instanceof EntityMissileCustom)) {
            return false;
        }
        if (this instanceof TileEntityTurretCIWS && !(e instanceof EntityMissileBaseAdvanced) && !(e instanceof EntityBomber) && !(e instanceof EntityMissileCustom)) {
            return false;
        }
        if (e instanceof EntityPlayer && this.players.contains(((EntityPlayer)e).getDisplayName())) {
            return false;
        }
        Vec3 turret = this instanceof TileEntityTurretSpitfire || this instanceof TileEntityTurretCIWS || this instanceof TileEntityTurretCheapo ? Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 1.5), (double)((double)this.field_145849_e + 0.5)) : Vec3.func_72443_a((double)((double)this.field_145851_c + 0.5), (double)(this.field_145848_d + 1), (double)((double)this.field_145849_e + 0.5));
        Vec3 entity = Vec3.func_72443_a((double)e.field_70165_t, (double)(e.field_70163_u + (double)e.func_70047_e()), (double)e.field_70161_v);
        Vec3 side = Vec3.func_72443_a((double)(entity.field_72450_a - turret.field_72450_a), (double)(entity.field_72448_b - turret.field_72448_b), (double)(entity.field_72449_c - turret.field_72449_c));
        side = side.func_72432_b();
        turret.field_72450_a += side.field_72450_a;
        turret.field_72448_b += side.field_72448_b;
        turret.field_72449_c += side.field_72449_c;
        if (this instanceof TileEntityTurretTau) {
            return true;
        }
        return !Library.isObstructed(this.field_145850_b, turret.field_72450_a, turret.field_72448_b, turret.field_72449_c, entity.field_72450_a, entity.field_72448_b, entity.field_72449_c);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.rotationYaw = nbt.func_74769_h("yaw");
        this.rotationPitch = nbt.func_74769_h("pitch");
        this.isAI = nbt.func_74767_n("AI");
        this.ammo = nbt.func_74762_e("ammo");
        int playercount = nbt.func_74762_e("playercount");
        for (int i = 0; i < playercount; ++i) {
            this.players.add(nbt.func_74779_i("player_" + i));
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("yaw", this.rotationYaw);
        nbt.func_74780_a("pitch", this.rotationPitch);
        nbt.func_74757_a("AI", this.isAI);
        nbt.func_74768_a("ammo", this.ammo);
        nbt.func_74768_a("playercount", this.players.size());
        for (int i = 0; i < this.players.size(); ++i) {
            nbt.func_74778_a("player_" + i, this.players.get(i));
        }
    }
}

