/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.rbmk.RBMKBase;
import com.hbm.entity.projectile.EntityRBMKDebris;
import com.hbm.handler.radiation.ChunkRadiationManager;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemRBMKRod;
import com.hbm.tileentity.machine.rbmk.IRBMKFluxReceiver;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKAbsorber;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBase;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKControl;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKModerator;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKReflector;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKSlottedBase;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.MathHelper;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityRBMKRod
extends TileEntityRBMKSlottedBase
implements IRBMKFluxReceiver {
    public double fluxFast;
    public double fluxSlow;
    public boolean hasRod;
    public static final ForgeDirection[] fluxDirs = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};

    public TileEntityRBMKRod() {
        super(1);
    }

    @Override
    public String getName() {
        return "container.rbmkRod";
    }

    @Override
    public void receiveFlux(IRBMKFluxReceiver.NType type, double flux) {
        switch (type) {
            case FAST: {
                this.fluxFast += flux;
                break;
            }
            case SLOW: {
                this.fluxSlow += flux;
            }
        }
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
                ItemRBMKRod rod = (ItemRBMKRod)this.slots[0].func_77973_b();
                double fluxIn = this.fluxFromType(rod.nType);
                double fluxOut = rod.burn(this.field_145850_b, this.slots[0], fluxIn);
                IRBMKFluxReceiver.NType rType = rod.rType;
                rod.updateHeat(this.field_145850_b, this.slots[0], 1.0);
                this.heat += rod.provideHeat(this.field_145850_b, this.slots[0], this.heat, 1.0);
                if (this.heat > this.maxHeat()) {
                    this.meltdown();
                    return;
                }
                if (!this.hasLid()) {
                    ChunkRadiationManager.proxy.incrementRad(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (float)((this.fluxFast + this.fluxSlow) * (double)0.05f));
                }
                super.func_145845_h();
                this.fluxFast = 0.0;
                this.fluxSlow = 0.0;
                this.spreadFlux(rType, fluxOut);
                this.hasRod = true;
            } else {
                this.fluxFast = 0.0;
                this.fluxSlow = 0.0;
                this.hasRod = false;
            }
        }
    }

    private double fluxFromType(IRBMKFluxReceiver.NType type) {
        switch (type) {
            case SLOW: {
                return this.fluxFast * 0.5 + this.fluxSlow;
            }
            case FAST: {
                return this.fluxFast + this.fluxSlow * 0.3;
            }
            case ANY: {
                return this.fluxFast + this.fluxSlow;
            }
        }
        return 0.0;
    }

    private void spreadFlux(IRBMKFluxReceiver.NType type, double fluxOut) {
        int range = 5;
        block0: for (ForgeDirection dir : fluxDirs) {
            IRBMKFluxReceiver.NType stream = type;
            double flux = fluxOut;
            for (int i = 1; i <= range; ++i) {
                IRBMKFluxReceiver rod;
                TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX * i, this.field_145848_d, this.field_145849_e + dir.offsetZ * i);
                if (te instanceof TileEntityRBMKRod && ((TileEntityRBMKSlottedBase)((Object)(rod = (TileEntityRBMKRod)te))).func_70301_a(0) != null && ((TileEntityRBMKSlottedBase)((Object)rod)).func_70301_a(0).func_77973_b() instanceof ItemRBMKRod) {
                    ((TileEntityRBMKRod)rod).receiveFlux(stream, flux);
                    continue block0;
                }
                if (te instanceof IRBMKFluxReceiver) {
                    rod = (IRBMKFluxReceiver)te;
                    rod.receiveFlux(stream, flux);
                    continue block0;
                }
                if (te instanceof TileEntityRBMKControl) {
                    TileEntityRBMKControl control = (TileEntityRBMKControl)te;
                    if (control.getMult() == 0.0) continue block0;
                    flux *= control.getMult();
                    continue;
                }
                if (te instanceof TileEntityRBMKModerator) {
                    stream = IRBMKFluxReceiver.NType.SLOW;
                    continue;
                }
                if (te instanceof TileEntityRBMKReflector) {
                    this.receiveFlux(stream, flux);
                    continue block0;
                }
                if (te instanceof TileEntityRBMKAbsorber) continue block0;
                if (te instanceof TileEntityRBMKBase) continue;
                int limit = RBMKDials.getColumnHeight(this.field_145850_b);
                int hits = 0;
                for (int h = 0; h <= limit; ++h) {
                    if (this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX * i, this.field_145848_d + h, this.field_145849_e + dir.offsetZ * i).func_149662_c()) continue;
                    ++hits;
                }
                if (hits <= 0) continue;
                ChunkRadiationManager.proxy.incrementRad(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, (float)(flux * (double)0.05f * (double)hits / (double)limit));
            }
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.fluxFast = nbt.func_74769_h("fluxFast");
        this.fluxSlow = nbt.func_74769_h("fluxSlow");
        this.hasRod = nbt.func_74767_n("hasRod");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("fluxFast", this.fluxFast);
        nbt.func_74780_a("fluxSlow", this.fluxSlow);
        nbt.func_74757_a("hasRod", this.hasRod);
    }

    @Override
    public void getDiagData(NBTTagCompound nbt) {
        this.func_145841_b(nbt);
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
            ItemRBMKRod rod = (ItemRBMKRod)this.slots[0].func_77973_b();
            nbt.func_74778_a("f_yield", ItemRBMKRod.getYield(this.slots[0]) + " / " + rod.yield + " (" + ItemRBMKRod.getEnrichment(this.slots[0]) * 100.0 + "%)");
            nbt.func_74778_a("f_xenon", ItemRBMKRod.getPoison(this.slots[0]) + "%");
            nbt.func_74778_a("f_heat", ItemRBMKRod.getCoreHeat(this.slots[0]) + " / " + ItemRBMKRod.getHullHeat(this.slots[0]) + " / " + rod.meltingPoint);
        }
    }

    @Override
    public void onMelt(int reduce) {
        boolean corium;
        int h = RBMKDials.getColumnHeight(this.field_145850_b);
        reduce = MathHelper.func_76125_a((int)reduce, (int)1, (int)h);
        if (this.field_145850_b.field_73012_v.nextInt(3) == 0) {
            ++reduce;
        }
        boolean bl = corium = this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod;
        if (corium && this.slots[0].func_77973_b() == ModItems.rbmk_fuel_drx) {
            RBMKBase.digamma = true;
        }
        this.slots[0] = null;
        if (corium) {
            for (int i = h; i >= 0; --i) {
                if (i <= h + 1 - reduce) {
                    this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + i, this.field_145849_e, ModBlocks.corium_block);
                } else {
                    this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + i, this.field_145849_e, Blocks.field_150350_a);
                }
                this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d + i, this.field_145849_e);
            }
            int count = 1 + this.field_145850_b.field_73012_v.nextInt(RBMKDials.getColumnHeight(this.field_145850_b));
            for (int i = 0; i < count; ++i) {
                this.spawnDebris(EntityRBMKDebris.DebrisType.FUEL);
            }
        } else {
            this.standardMelt(reduce);
        }
        this.spawnDebris(EntityRBMKDebris.DebrisType.ELEMENT);
        if (this.func_145832_p() == RBMKBase.DIR_NORMAL_LID.ordinal() + 10) {
            this.spawnDebris(EntityRBMKDebris.DebrisType.LID);
        }
    }

    @Override
    public TileEntityRBMKConsole.ColumnType getConsoleType() {
        return TileEntityRBMKConsole.ColumnType.FUEL;
    }

    @Override
    public NBTTagCompound getNBTForConsole() {
        NBTTagCompound data = new NBTTagCompound();
        if (this.slots[0] != null && this.slots[0].func_77973_b() instanceof ItemRBMKRod) {
            ItemRBMKRod rod = (ItemRBMKRod)this.slots[0].func_77973_b();
            data.func_74780_a("enrichment", ItemRBMKRod.getEnrichment(this.slots[0]));
            data.func_74780_a("xenon", ItemRBMKRod.getPoison(this.slots[0]));
            data.func_74780_a("c_heat", ItemRBMKRod.getHullHeat(this.slots[0]));
            data.func_74780_a("c_coreHeat", ItemRBMKRod.getCoreHeat(this.slots[0]));
            data.func_74780_a("c_maxHeat", rod.meltingPoint);
        }
        return data;
    }
}

