/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.blocks.ModBlocks;
import com.hbm.entity.projectile.EntityRBMKDebris;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.FluidTank;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFluidIcon;
import com.hbm.lib.Library;
import com.hbm.tileentity.machine.rbmk.IRBMKFluxReceiver;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKSlottedBase;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityRBMKOutgasser
extends TileEntityRBMKSlottedBase
implements IRBMKFluxReceiver,
IFluidSource {
    public List<IFluidAcceptor> list = new ArrayList<IFluidAcceptor>();
    public FluidTank gas = new FluidTank(FluidTypeHandler.FluidType.TRITIUM, 64000, 0);
    public double progress;
    public static final int duration = 10000;
    private static HashMap<Object, ItemStack> recipes = new HashMap();

    public TileEntityRBMKOutgasser() {
        super(2);
    }

    @Override
    public String getName() {
        return "container.rbmkOutgasser";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.gas.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            if (this.field_145850_b.func_82737_E() % 10L == 0L) {
                this.fillFluidInit(this.gas.getTankType());
            }
            if (!this.canProcess()) {
                this.progress = 0.0;
            }
        }
        super.func_145845_h();
    }

    @Override
    public void receiveFlux(IRBMKFluxReceiver.NType type, double flux) {
        if (this.canProcess()) {
            if (type == IRBMKFluxReceiver.NType.FAST) {
                flux *= 0.2;
            }
            this.progress += flux * RBMKDials.getOutgasserMod(this.field_145850_b);
            if (this.progress > 10000.0) {
                this.process();
                this.func_70296_d();
            }
        }
    }

    private boolean canProcess() {
        if (this.slots[0] == null) {
            return false;
        }
        ItemStack output = TileEntityRBMKOutgasser.getOutput(this.slots[0]);
        if (output == null) {
            return false;
        }
        if (output.func_77973_b() == ModItems.fluid_icon) {
            return output.func_77960_j() == this.gas.getTankType().ordinal() && this.gas.getFill() + ItemFluidIcon.getQuantity(output) <= this.gas.getMaxFill();
        }
        if (this.slots[1] == null) {
            return true;
        }
        return this.slots[1].func_77973_b() == output.func_77973_b() && this.slots[1].func_77960_j() == output.func_77960_j() && this.slots[1].field_77994_a + output.field_77994_a <= this.slots[1].func_77976_d();
    }

    public static ItemStack getOutput(ItemStack stack) {
        String[] dictKeys;
        if (stack == null || stack.func_77973_b() == null) {
            return null;
        }
        RecipesCommon.ComparableStack comp = new RecipesCommon.ComparableStack(stack);
        if (recipes.containsKey(comp)) {
            return recipes.get(comp);
        }
        for (String key : dictKeys = comp.getDictKeys()) {
            if (!recipes.containsKey(key)) continue;
            return recipes.get(key);
        }
        return null;
    }

    private void process() {
        ItemStack output = TileEntityRBMKOutgasser.getOutput(this.slots[0]);
        this.func_70298_a(0, 1);
        this.progress = 0.0;
        if (output.func_77973_b() == ModItems.fluid_icon) {
            this.gas.setFill(this.gas.getFill() + ItemFluidIcon.getQuantity(output));
            return;
        }
        if (this.slots[1] == null) {
            this.slots[1] = output.func_77946_l();
        } else {
            this.slots[1].field_77994_a += output.field_77994_a;
        }
    }

    @Override
    public void fillFluidInit(FluidTypeHandler.FluidType type) {
        this.fillFluid(this.field_145851_c, this.field_145848_d + RBMKDials.getColumnHeight(this.field_145850_b) + 1, this.field_145849_e, this.getTact(), type);
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == ModBlocks.rbmk_loader) {
            this.fillFluid(this.field_145851_c + 1, this.field_145848_d - 1, this.field_145849_e, this.getTact(), type);
            this.fillFluid(this.field_145851_c - 1, this.field_145848_d - 1, this.field_145849_e, this.getTact(), type);
            this.fillFluid(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e + 1, this.getTact(), type);
            this.fillFluid(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e - 1, this.getTact(), type);
            this.fillFluid(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e, this.getTact(), type);
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e) == ModBlocks.rbmk_loader) {
            this.fillFluid(this.field_145851_c + 1, this.field_145848_d - 2, this.field_145849_e, this.getTact(), type);
            this.fillFluid(this.field_145851_c - 1, this.field_145848_d - 2, this.field_145849_e, this.getTact(), type);
            this.fillFluid(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e + 1, this.getTact(), type);
            this.fillFluid(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e - 1, this.getTact(), type);
            this.fillFluid(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.getTact(), type);
            this.fillFluid(this.field_145851_c, this.field_145848_d - 3, this.field_145849_e, this.getTact(), type);
        }
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidTypeHandler.FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    @Deprecated
    public boolean getTact() {
        return this.field_145850_b.func_82737_E() % 20L < 10L;
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index == 0) {
            this.gas.setFill(fill);
        }
    }

    @Override
    public void setFluidFill(int fill, FluidTypeHandler.FluidType type) {
        if (type == this.gas.getTankType()) {
            this.gas.setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index == 0) {
            this.gas.setTankType(type);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        return new ArrayList(){
            {
                this.add(TileEntityRBMKOutgasser.this.gas);
            }
        };
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type == this.gas.getTankType()) {
            return this.gas.getFill();
        }
        return 0;
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidTypeHandler.FluidType type) {
        return this.list;
    }

    @Override
    public void clearFluidList(FluidTypeHandler.FluidType type) {
        this.list.clear();
    }

    @Override
    public void onMelt(int reduce) {
        int count = 4 + this.field_145850_b.field_73012_v.nextInt(2);
        for (int i = 0; i < count; ++i) {
            this.spawnDebris(EntityRBMKDebris.DebrisType.BLANK);
        }
        super.onMelt(reduce);
    }

    @Override
    public TileEntityRBMKConsole.ColumnType getConsoleType() {
        return TileEntityRBMKConsole.ColumnType.OUTGASSER;
    }

    @Override
    public NBTTagCompound getNBTForConsole() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("gas", this.gas.getFill());
        data.func_74768_a("maxGas", this.gas.getMaxFill());
        data.func_74777_a("type", (short)this.gas.getTankType().ordinal());
        data.func_74780_a("progress", this.progress);
        return data;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.progress = nbt.func_74769_h("progress");
        this.gas.readFromNBT(nbt, "gas");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74780_a("progress", this.progress);
        this.gas.writeToNBT(nbt, "gas");
    }

    static {
        recipes.put("blockLithium", ItemFluidIcon.addQuantity(new ItemStack(ModItems.fluid_icon, 1, FluidTypeHandler.FluidType.TRITIUM.ordinal()), 10000));
        recipes.put("ingotLithium", ItemFluidIcon.addQuantity(new ItemStack(ModItems.fluid_icon, 1, FluidTypeHandler.FluidType.TRITIUM.ordinal()), 1000));
        recipes.put("dustLithium", ItemFluidIcon.addQuantity(new ItemStack(ModItems.fluid_icon, 1, FluidTypeHandler.FluidType.TRITIUM.ordinal()), 1000));
        recipes.put(new RecipesCommon.ComparableStack(ModItems.powder_lithium_tiny), ItemFluidIcon.addQuantity(new ItemStack(ModItems.fluid_icon, 1, FluidTypeHandler.FluidType.TRITIUM.ordinal()), 100));
        recipes.put("ingotGold", new ItemStack(ModItems.ingot_au198));
        recipes.put("nuggetGold", new ItemStack(ModItems.nugget_au198));
        recipes.put("dustGold", new ItemStack(ModItems.powder_au198));
    }
}

