/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKBase;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKControlManual;
import com.hbm.util.I18nUtil;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.EnumChatFormatting;
import net.minecraft.util.MathHelper;
import net.minecraft.util.Vec3;

public class TileEntityRBMKConsole
extends TileEntityMachineBase
implements IControlReceiver {
    private int targetX;
    private int targetY;
    private int targetZ;
    public RBMKColumn[] columns = new RBMKColumn[225];

    public TileEntityRBMKConsole() {
        super(0);
    }

    @Override
    public String getName() {
        return null;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K && this.field_145850_b.func_82737_E() % 10L == 0L) {
            this.rescan();
            this.prepareNetworkPack();
        }
    }

    private void rescan() {
        for (int i = -7; i <= 7; ++i) {
            for (int j = -7; j <= 7; ++j) {
                TileEntity te = this.field_145850_b.func_147438_o(this.targetX + i, this.targetY, this.targetZ + j);
                int index = i + 7 + (j + 7) * 15;
                if (te instanceof TileEntityRBMKBase) {
                    TileEntityRBMKBase rbmk = (TileEntityRBMKBase)te;
                    this.columns[index] = new RBMKColumn(rbmk.getConsoleType(), rbmk.getNBTForConsole());
                    this.columns[index].data.func_74780_a("heat", rbmk.heat);
                    this.columns[index].data.func_74780_a("maxHeat", rbmk.maxHeat());
                    continue;
                }
                this.columns[index] = null;
            }
        }
    }

    private void prepareNetworkPack() {
        NBTTagCompound data = new NBTTagCompound();
        for (int i = 0; i < this.columns.length; ++i) {
            if (this.columns[i] == null) continue;
            data.func_74782_a("column_" + i, (NBTBase)this.columns[i].data);
            data.func_74777_a("type_" + i, (short)this.columns[i].type.ordinal());
        }
        this.networkPack(data, 50);
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.columns = new RBMKColumn[225];
        for (int i = 0; i < this.columns.length; ++i) {
            if (!data.func_74764_b("type_" + i)) continue;
            this.columns[i] = new RBMKColumn(ColumnType.values()[data.func_74765_d("type_" + i)], (NBTTagCompound)data.func_74781_a("column_" + i));
        }
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 20.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("level")) {
            Set keys = data.func_150296_c();
            for (String key : keys) {
                int z;
                int x;
                TileEntity te;
                if (!key.startsWith("sel_") || !((te = this.field_145850_b.func_147438_o(this.targetX + (x = data.func_74762_e(key) % 15 - 7), this.targetY, this.targetZ + (z = data.func_74762_e(key) / 15 - 7))) instanceof TileEntityRBMKControlManual)) continue;
                TileEntityRBMKControlManual rod = (TileEntityRBMKControlManual)te;
                rod.startingLevel = rod.level;
                rod.setTarget(MathHelper.func_151237_a((double)data.func_74769_h("level"), (double)0.0, (double)1.0));
                te.func_70296_d();
            }
        }
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 2), (double)this.field_145848_d, (double)(this.field_145849_e - 2), (double)(this.field_145851_c + 3), (double)(this.field_145848_d + 4), (double)(this.field_145849_e + 3));
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public void setTarget(int x, int y, int z) {
        this.targetX = x;
        this.targetY = y;
        this.targetZ = z;
        this.func_70296_d();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.targetX = nbt.func_74762_e("tX");
        this.targetY = nbt.func_74762_e("tY");
        this.targetZ = nbt.func_74762_e("tZ");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("tX", this.targetX);
        nbt.func_74768_a("tY", this.targetY);
        nbt.func_74768_a("tZ", this.targetZ);
    }

    public static enum ColumnType {
        BLANK(0),
        FUEL(10),
        CONTROL(20),
        CONTROL_AUTO(30),
        BOILER(40),
        MODERATOR(50),
        ABSORBER(60),
        REFLECTOR(70),
        OUTGASSER(80),
        BREEDER(90);

        public int offset;

        private ColumnType(int offset) {
            this.offset = offset;
        }
    }

    public static class RBMKColumn {
        public ColumnType type;
        public NBTTagCompound data;

        public RBMKColumn(ColumnType type) {
            this.type = type;
        }

        public RBMKColumn(ColumnType type, NBTTagCompound data) {
            this.type = type;
            this.data = data != null ? data : new NBTTagCompound();
        }

        @SideOnly(value=Side.CLIENT)
        public List<String> getFancyStats() {
            if (this.data == null) {
                return null;
            }
            ArrayList<String> stats = new ArrayList<String>();
            stats.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("rbmk.heat", (double)((int)(this.data.func_74769_h("heat") * 10.0)) / 10.0 + "\u00b0C"));
            switch (this.type) {
                case FUEL: {
                    stats.add(EnumChatFormatting.GREEN + I18nUtil.resolveKey("rbmk.rod.depletion", (double)((int)((1.0 - this.data.func_74769_h("enrichment")) * 100000.0)) / 1000.0 + "%"));
                    stats.add(EnumChatFormatting.DARK_PURPLE + I18nUtil.resolveKey("rbmk.rod.xenon", (double)((int)(this.data.func_74769_h("xenon") * 1000.0)) / 1000.0 + "%"));
                    stats.add(EnumChatFormatting.DARK_RED + I18nUtil.resolveKey("rbmk.rod.coreTemp", (double)((int)(this.data.func_74769_h("c_coreHeat") * 10.0)) / 10.0 + "\u00b0C"));
                    stats.add(EnumChatFormatting.RED + I18nUtil.resolveKey("rbmk.rod.skinTemp", (double)((int)(this.data.func_74769_h("c_heat") * 10.0)) / 10.0 + "\u00b0C", (double)((int)(this.data.func_74769_h("c_maxHeat") * 10.0)) / 10.0 + "\u00b0C"));
                    break;
                }
                case BOILER: {
                    stats.add(EnumChatFormatting.BLUE + I18nUtil.resolveKey("rbmk.boiler.water", this.data.func_74762_e("water"), this.data.func_74762_e("maxWater")));
                    stats.add(EnumChatFormatting.WHITE + I18nUtil.resolveKey("rbmk.boiler.steam", this.data.func_74762_e("steam"), this.data.func_74762_e("maxSteam")));
                    stats.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("rbmk.boiler.type", I18nUtil.resolveKey(FluidTypeHandler.FluidType.values()[this.data.func_74765_d("type")].getUnlocalizedName(), new Object[0])));
                    break;
                }
                case CONTROL: {
                    short col;
                    if (this.data.func_74764_b("color") && (col = this.data.func_74765_d("color")) >= 0 && col < TileEntityRBMKControlManual.RBMKColor.values().length) {
                        stats.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("rbmk.control." + TileEntityRBMKControlManual.RBMKColor.values()[col].name().toLowerCase(), new Object[0]));
                    }
                }
                case CONTROL_AUTO: {
                    stats.add(EnumChatFormatting.YELLOW + I18nUtil.resolveKey("rbmk.control.level", (int)(this.data.func_74769_h("level") * 100.0) + "%"));
                }
            }
            return stats;
        }
    }
}

