/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.blocks.ModBlocks;
import com.hbm.entity.projectile.EntityRBMKDebris;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IControlReceiver;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.FluidTank;
import com.hbm.lib.Library;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKSlottedBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.Vec3;

public class TileEntityRBMKBoiler
extends TileEntityRBMKSlottedBase
implements IFluidAcceptor,
IFluidSource,
IControlReceiver {
    public FluidTank feed;
    public FluidTank steam;
    public List<IFluidAcceptor> list = new ArrayList<IFluidAcceptor>();

    public TileEntityRBMKBoiler() {
        super(0);
        this.feed = new FluidTank(FluidTypeHandler.FluidType.WATER, 10000, 0);
        this.steam = new FluidTank(FluidTypeHandler.FluidType.STEAM, 1000000, 1);
    }

    @Override
    public String getName() {
        return "container.rbmkBoiler";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.feed.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            this.steam.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            double heatCap = this.getHeatFromSteam(this.steam.getTankType());
            double heatProvided = this.heat - heatCap;
            if (heatProvided > 0.0) {
                int waterUsed = (int)Math.floor(heatProvided / RBMKDials.getBoilerHeatConsumption(this.field_145850_b));
                waterUsed = Math.min(waterUsed, this.feed.getFill());
                this.feed.setFill(this.feed.getFill() - waterUsed);
                int steamProduced = (int)Math.floor((double)(waterUsed * 100) / this.getFactorFromSteam(this.steam.getTankType()));
                this.steam.setFill(this.steam.getFill() + steamProduced);
                if (this.steam.getFill() > this.steam.getMaxFill()) {
                    this.steam.setFill(this.steam.getMaxFill());
                }
                this.heat -= (double)waterUsed * RBMKDials.getBoilerHeatConsumption(this.field_145850_b);
            }
            this.fillFluidInit(this.steam.getTankType());
        }
        super.func_145845_h();
    }

    public double getHeatFromSteam(FluidTypeHandler.FluidType type) {
        switch (type) {
            case STEAM: {
                return 100.0;
            }
            case HOTSTEAM: {
                return 300.0;
            }
            case SUPERHOTSTEAM: {
                return 450.0;
            }
            case ULTRAHOTSTEAM: {
                return 600.0;
            }
        }
        return 0.0;
    }

    public double getFactorFromSteam(FluidTypeHandler.FluidType type) {
        switch (type) {
            case STEAM: {
                return 1.0;
            }
            case HOTSTEAM: {
                return 10.0;
            }
            case SUPERHOTSTEAM: {
                return 100.0;
            }
            case ULTRAHOTSTEAM: {
                return 1000.0;
            }
        }
        return 0.0;
    }

    @Override
    public void fillFluidInit(FluidTypeHandler.FluidType type) {
        this.fillFluid(this.field_145851_c, this.field_145848_d + RBMKDials.getColumnHeight(this.field_145850_b) + 1, this.field_145849_e, this.getTact(), type);
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) == ModBlocks.rbmk_loader) {
            this.fillFluid(this.field_145851_c + 1, this.field_145848_d - 1, this.field_145849_e, this.getTact(), type);
            this.fillFluid(this.field_145851_c - 1, this.field_145848_d - 1, this.field_145849_e, this.getTact(), type);
            this.fillFluid(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e + 1, this.getTact(), type);
            this.fillFluid(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e - 1, this.getTact(), type);
            this.fillFluid(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e, this.getTact(), type);
        }
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e) == ModBlocks.rbmk_loader) {
            this.fillFluid(this.field_145851_c + 1, this.field_145848_d - 2, this.field_145849_e, this.getTact(), type);
            this.fillFluid(this.field_145851_c - 1, this.field_145848_d - 2, this.field_145849_e, this.getTact(), type);
            this.fillFluid(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e + 1, this.getTact(), type);
            this.fillFluid(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e - 1, this.getTact(), type);
            this.fillFluid(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.getTact(), type);
            this.fillFluid(this.field_145851_c, this.field_145848_d - 3, this.field_145849_e, this.getTact(), type);
        }
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidTypeHandler.FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    @Deprecated
    public boolean getTact() {
        return this.field_145850_b.func_82737_E() % 2L == 0L;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type == this.feed.getTankType()) {
            this.feed.setFill(i);
        } else if (type == this.steam.getTankType()) {
            this.steam.setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type == this.feed.getTankType()) {
            return this.feed.getFill();
        }
        if (type == this.steam.getTankType()) {
            return this.steam.getFill();
        }
        return 0;
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type == this.feed.getTankType()) {
            return this.feed.getMaxFill();
        }
        if (type == this.steam.getTankType()) {
            return this.steam.getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index == 0) {
            this.feed.setFill(fill);
        } else if (index == 1) {
            this.steam.setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index == 0) {
            this.feed.setTankType(type);
        } else if (index == 1) {
            this.steam.setTankType(type);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.feed);
        list.add(this.steam);
        return list;
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidTypeHandler.FluidType type) {
        return this.list;
    }

    @Override
    public void clearFluidList(FluidTypeHandler.FluidType type) {
        this.list.clear();
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.feed.readFromNBT(nbt, "feed");
        this.steam.readFromNBT(nbt, "steam");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.feed.writeToNBT(nbt, "feed");
        this.steam.writeToNBT(nbt, "steam");
    }

    @Override
    public boolean hasPermission(EntityPlayer player) {
        return Vec3.func_72443_a((double)((double)this.field_145851_c - player.field_70165_t), (double)((double)this.field_145848_d - player.field_70163_u), (double)((double)this.field_145849_e - player.field_70161_v)).func_72433_c() < 20.0;
    }

    @Override
    public void receiveControl(NBTTagCompound data) {
        if (data.func_74764_b("compression")) {
            switch (this.steam.getTankType()) {
                case STEAM: {
                    this.steam.setTankType(FluidTypeHandler.FluidType.HOTSTEAM);
                    this.steam.setFill(this.steam.getFill() / 10);
                    break;
                }
                case HOTSTEAM: {
                    this.steam.setTankType(FluidTypeHandler.FluidType.SUPERHOTSTEAM);
                    this.steam.setFill(this.steam.getFill() / 10);
                    break;
                }
                case SUPERHOTSTEAM: {
                    this.steam.setTankType(FluidTypeHandler.FluidType.ULTRAHOTSTEAM);
                    this.steam.setFill(this.steam.getFill() / 10);
                    break;
                }
                case ULTRAHOTSTEAM: {
                    this.steam.setTankType(FluidTypeHandler.FluidType.STEAM);
                    this.steam.setFill(Math.min(this.steam.getFill() * 1000, this.steam.getMaxFill()));
                }
            }
            this.func_70296_d();
        }
    }

    @Override
    public void onMelt(int reduce) {
        int count = 1 + this.field_145850_b.field_73012_v.nextInt(2);
        for (int i = 0; i < count; ++i) {
            this.spawnDebris(EntityRBMKDebris.DebrisType.BLANK);
        }
        super.onMelt(reduce);
    }

    @Override
    public TileEntityRBMKConsole.ColumnType getConsoleType() {
        return TileEntityRBMKConsole.ColumnType.BOILER;
    }

    @Override
    public NBTTagCompound getNBTForConsole() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74768_a("water", this.feed.getFill());
        data.func_74768_a("maxWater", this.feed.getMaxFill());
        data.func_74768_a("steam", this.steam.getFill());
        data.func_74768_a("maxSteam", this.steam.getMaxFill());
        data.func_74777_a("type", (short)this.steam.getTankType().ordinal());
        return data;
    }
}

