/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine.rbmk;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.rbmk.RBMKBase;
import com.hbm.entity.effect.EntitySpear;
import com.hbm.entity.projectile.EntityRBMKDebris;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.NBTPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.INBTPacketReceiver;
import com.hbm.tileentity.machine.rbmk.RBMKDials;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKConsole;
import com.hbm.tileentity.machine.rbmk.TileEntityRBMKRod;
import com.hbm.util.I18nUtil;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.init.Blocks;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.MathHelper;
import net.minecraft.util.MovingObjectPosition;
import net.minecraft.world.World;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.common.util.ForgeDirection;
import org.lwjgl.opengl.GL11;

public abstract class TileEntityRBMKBase
extends TileEntity
implements INBTPacketReceiver {
    public double heat;
    public static final ForgeDirection[] heatDirs = new ForgeDirection[]{ForgeDirection.NORTH, ForgeDirection.EAST, ForgeDirection.SOUTH, ForgeDirection.WEST};
    protected static boolean diag = false;
    public static HashSet<TileEntityRBMKBase> columns = new HashSet();

    public boolean hasLid() {
        if (!this.isLidRemovable()) {
            return true;
        }
        return this.func_145832_p() != RBMKBase.DIR_NO_LID.ordinal() + 10;
    }

    public boolean isLidRemovable() {
        return true;
    }

    public double maxHeat() {
        return 1500.0;
    }

    public double passiveCooling() {
        return RBMKDials.getPassiveCooling(this.field_145850_b);
    }

    public boolean shouldUpdate() {
        return true;
    }

    public int trackingRange() {
        return 25;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.moveHeat();
            this.coolPassively();
            NBTTagCompound data = new NBTTagCompound();
            this.func_145841_b(data);
            this.networkPack(data, this.trackingRange());
        }
    }

    private void moveHeat() {
        ArrayList<TileEntityRBMKBase> rec = new ArrayList<TileEntityRBMKBase>();
        rec.add(this);
        double heatTot = this.heat;
        for (ForgeDirection dir : heatDirs) {
            TileEntity te = this.field_145850_b.func_147438_o(this.field_145851_c + dir.offsetX, this.field_145848_d, this.field_145849_e + dir.offsetZ);
            if (!(te instanceof TileEntityRBMKBase)) continue;
            TileEntityRBMKBase base = (TileEntityRBMKBase)te;
            rec.add(base);
            heatTot += base.heat;
        }
        int members = rec.size();
        double stepSize = RBMKDials.getColumnHeatFlow(this.field_145850_b);
        if (members > 1) {
            double targetHeat = heatTot / (double)members;
            for (TileEntityRBMKBase rbmk : rec) {
                double delta = targetHeat - rbmk.heat;
                rbmk.heat += delta * stepSize;
            }
            this.func_70296_d();
        }
    }

    protected void coolPassively() {
        this.heat -= this.passiveCooling();
        if (this.heat < 20.0) {
            this.heat = 20.0;
        }
    }

    public void func_145839_a(NBTTagCompound nbt) {
        if (!diag) {
            super.func_145839_a(nbt);
        }
        this.heat = nbt.func_74769_h("heat");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        if (!diag) {
            super.func_145841_b(nbt);
        }
        nbt.func_74780_a("heat", this.heat);
    }

    public void networkPack(NBTTagCompound nbt, int range) {
        diag = true;
        if (!this.field_145850_b.field_72995_K) {
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new NBTPacket(nbt, this.field_145851_c, this.field_145848_d, this.field_145849_e), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)range));
        }
        diag = false;
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        diag = true;
        this.func_145839_a(nbt);
        diag = false;
    }

    public void getDiagData(NBTTagCompound nbt) {
        diag = true;
        this.func_145841_b(nbt);
        diag = false;
    }

    @SideOnly(value=Side.CLIENT)
    public static void diagnosticPrintHook(RenderGameOverlayEvent.Pre event) {
        Minecraft mc = Minecraft.func_71410_x();
        WorldClient world = mc.field_71441_e;
        MovingObjectPosition mop = mc.field_71476_x;
        ScaledResolution resolution = event.resolution;
        if (mop != null) {
            MovingObjectPosition.MovingObjectType cfr_ignored_0 = mop.field_72313_a;
            if (mop.field_72313_a == MovingObjectPosition.MovingObjectType.BLOCK && world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d) instanceof RBMKBase) {
                RBMKBase rbmk = (RBMKBase)world.func_147439_a(mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                int[] pos = rbmk.findCore((World)world, mop.field_72311_b, mop.field_72312_c, mop.field_72309_d);
                if (pos == null) {
                    return;
                }
                TileEntityRBMKBase te = (TileEntityRBMKBase)world.func_147438_o(pos[0], pos[1], pos[2]);
                NBTTagCompound flush = new NBTTagCompound();
                te.getDiagData(flush);
                Set keys = flush.func_150296_c();
                GL11.glPushMatrix();
                int pX = resolution.func_78326_a() / 2 + 8;
                int pZ = resolution.func_78328_b() / 2;
                ArrayList<String> exceptions = new ArrayList<String>();
                exceptions.add("x");
                exceptions.add("y");
                exceptions.add("z");
                exceptions.add("items");
                exceptions.add("id");
                String title = "Dump of Ordered Data Diagnostic (DODD)";
                mc.field_71466_p.func_78276_b(title, pX + 1, pZ - 19, 24576);
                mc.field_71466_p.func_78276_b(title, pX, pZ - 20, 65280);
                mc.field_71466_p.func_78276_b(I18nUtil.resolveKey(rbmk.func_149739_a() + ".name", new Object[0]), pX + 1, pZ - 9, 0x606000);
                mc.field_71466_p.func_78276_b(I18nUtil.resolveKey(rbmk.func_149739_a() + ".name", new Object[0]), pX, pZ - 10, 0xFFFF00);
                Object[] ents = new String[keys.size()];
                keys.toArray(ents);
                Arrays.sort(ents);
                for (Object key : ents) {
                    if (exceptions.contains(key)) continue;
                    mc.field_71466_p.func_78276_b((String)key + ": " + flush.func_74781_a((String)key), pX, pZ, 0xFFFFFF);
                    pZ += 10;
                }
                GL11.glDisable((int)3042);
                GL11.glPopMatrix();
                Minecraft.func_71410_x().field_71446_o.func_110577_a(Gui.field_110324_m);
            }
        }
    }

    public void onOverheat() {
        for (int i = 0; i < 4; ++i) {
            this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + i, this.field_145849_e, Blocks.field_150353_l);
        }
    }

    public void onMelt(int reduce) {
        this.standardMelt(reduce);
        if (this.func_145832_p() == RBMKBase.DIR_NORMAL_LID.ordinal() + 10) {
            this.spawnDebris(EntityRBMKDebris.DebrisType.LID);
        }
    }

    protected void standardMelt(int reduce) {
        int h = RBMKDials.getColumnHeight(this.field_145850_b);
        reduce = MathHelper.func_76125_a((int)reduce, (int)1, (int)h);
        if (this.field_145850_b.field_73012_v.nextInt(3) == 0) {
            ++reduce;
        }
        for (int i = h; i >= 0; --i) {
            if (i <= h + 1 - reduce) {
                if (reduce > 1 && i == h + 1 - reduce) {
                    this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + i, this.field_145849_e, ModBlocks.pribris_burning);
                } else {
                    this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + i, this.field_145849_e, ModBlocks.pribris);
                }
            } else {
                this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d + i, this.field_145849_e, Blocks.field_150350_a);
            }
            this.field_145850_b.func_147471_g(this.field_145851_c, this.field_145848_d + i, this.field_145849_e);
        }
    }

    protected void spawnDebris(EntityRBMKDebris.DebrisType type) {
        EntityRBMKDebris debris = new EntityRBMKDebris(this.field_145850_b, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 4.0, (double)this.field_145849_e + 0.5, type);
        debris.field_70159_w = this.field_145850_b.field_73012_v.nextGaussian() * 0.25;
        debris.field_70179_y = this.field_145850_b.field_73012_v.nextGaussian() * 0.25;
        debris.field_70181_x = 0.25 + this.field_145850_b.field_73012_v.nextDouble() * 1.25;
        if (type == EntityRBMKDebris.DebrisType.LID) {
            debris.field_70159_w *= 0.5;
            debris.field_70181_x += 0.5;
            debris.field_70179_y *= 0.5;
        }
        this.field_145850_b.func_72838_d((Entity)debris);
    }

    public void meltdown() {
        RBMKBase.dropLids = false;
        columns.clear();
        this.getFF(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        int minX = this.field_145851_c;
        int maxX = this.field_145851_c;
        int minZ = this.field_145849_e;
        int maxZ = this.field_145849_e;
        for (TileEntityRBMKBase rbmk : columns) {
            if (rbmk.field_145851_c < minX) {
                minX = rbmk.field_145851_c;
            }
            if (rbmk.field_145851_c > maxX) {
                maxX = rbmk.field_145851_c;
            }
            if (rbmk.field_145849_e < minZ) {
                minZ = rbmk.field_145849_e;
            }
            if (rbmk.field_145849_e <= maxZ) continue;
            maxZ = rbmk.field_145849_e;
        }
        for (TileEntityRBMKBase rbmk : columns) {
            int distFromMinX = rbmk.field_145851_c - minX;
            int distFromMaxX = maxX - rbmk.field_145851_c;
            int distFromMinZ = rbmk.field_145849_e - minZ;
            int distFromMaxZ = maxZ - rbmk.field_145849_e;
            int minDist = Math.min(distFromMinX, Math.min(distFromMaxX, Math.min(distFromMinZ, distFromMaxZ)));
            rbmk.onMelt(minDist + 1);
        }
        for (TileEntityRBMKBase rbmk : columns) {
            if (!(rbmk instanceof TileEntityRBMKRod) || this.field_145850_b.func_147439_a(rbmk.field_145851_c, rbmk.field_145848_d, rbmk.field_145849_e) != ModBlocks.corium_block) continue;
            for (int x = rbmk.field_145851_c - 1; x <= rbmk.field_145851_c + 1; ++x) {
                for (int y = rbmk.field_145848_d - 1; y <= rbmk.field_145848_d + 1; ++y) {
                    for (int z = rbmk.field_145849_e - 1; z <= rbmk.field_145849_e + 1; ++z) {
                        Block b = this.field_145850_b.func_147439_a(x, y, z);
                        if (this.field_145850_b.field_73012_v.nextInt(3) != 0 || b != ModBlocks.pribris && b != ModBlocks.pribris_burning) continue;
                        if (RBMKBase.digamma) {
                            this.field_145850_b.func_147449_b(x, y, z, ModBlocks.pribris_digamma);
                            continue;
                        }
                        this.field_145850_b.func_147449_b(x, y, z, ModBlocks.pribris_radiating);
                    }
                }
            }
        }
        int smallDim = Math.min(maxX - minX, maxZ - minZ);
        int avgX = minX + (maxX - minX) / 2;
        int avgZ = minZ + (maxZ - minZ) / 2;
        NBTTagCompound data = new NBTTagCompound();
        data.func_74778_a("type", "rbmkmush");
        data.func_74776_a("scale", (float)smallDim);
        PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, (double)avgX + 0.5, this.field_145848_d + 1, (double)avgZ + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)avgX + 0.5, (double)(this.field_145848_d + 1), (double)avgZ + 0.5, 250.0));
        MainRegistry.proxy.effectNT(data);
        this.field_145850_b.func_72908_a((double)avgX + 0.5, (double)(this.field_145848_d + 1), (double)avgZ + 0.5, "hbm:block.rbmk_explosion", 50.0f, 1.0f);
        if (RBMKBase.digamma) {
            EntitySpear spear = new EntitySpear(this.field_145850_b);
            spear.field_70165_t = (double)avgX + 0.5;
            spear.field_70161_v = (double)avgZ + 0.5;
            spear.field_70163_u = this.field_145848_d + 100;
            this.field_145850_b.func_72838_d((Entity)spear);
        }
        RBMKBase.dropLids = true;
        RBMKBase.digamma = false;
    }

    private void getFF(int x, int y, int z) {
        TileEntityRBMKBase rbmk;
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (te instanceof TileEntityRBMKBase && !columns.contains(rbmk = (TileEntityRBMKBase)te)) {
            columns.add(rbmk);
            this.getFF(x + 1, y, z);
            this.getFF(x - 1, y, z);
            this.getFF(x, y, z + 1);
            this.getFF(x, y, z - 1);
        }
    }

    public abstract TileEntityRBMKConsole.ColumnType getConsoleType();

    public NBTTagCompound getNBTForConsole() {
        return null;
    }

    public static List<String> getFancyStats(NBTTagCompound nbt) {
        return null;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 17), (double)(this.field_145849_e + 1));
    }
}

