/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.config.BombConfig;
import com.hbm.entity.logic.EntityNukeExplosionMK3;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.IFluidSource;
import com.hbm.interfaces.IReactor;
import com.hbm.interfaces.ISource;
import com.hbm.inventory.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemCapacitor;
import com.hbm.items.special.WatzFuel;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityWatzCore
extends TileEntity
implements ISidedInventory,
IReactor,
ISource,
IFluidContainer,
IFluidSource {
    public long power;
    public static final long maxPower = 100000000L;
    public int heat;
    public int heatMultiplier;
    public int powerMultiplier;
    public int decayMultiplier;
    public int heatList;
    public int wasteList;
    public int powerList;
    Random rand = new Random();
    private ItemStack[] slots;
    public int age = 0;
    public List<IConsumer> list = new ArrayList<IConsumer>();
    public List<IFluidAcceptor> list1 = new ArrayList<IFluidAcceptor>();
    public FluidTank tank;
    private String customName;

    public TileEntityWatzCore() {
        this.slots = new ItemStack[40];
        this.tank = new FluidTank(FluidTypeHandler.FluidType.WATZ, 64000, 0);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.watzPowerplant";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return null;
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("power");
        this.tank.readFromNBT(nbt, "watz");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tank.writeToNBT(nbt, "watz");
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    @Override
    public boolean isStructureValid(World world) {
        int j;
        int i;
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 3, this.field_145848_d + i, this.field_145849_e - 1) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 3, this.field_145848_d + i, this.field_145849_e + 1) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 2, this.field_145848_d + i, this.field_145849_e - 2) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 2, this.field_145848_d + i, this.field_145849_e - 1) == ModBlocks.watz_element) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 2, this.field_145848_d + i, this.field_145849_e) == ModBlocks.watz_control) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 2, this.field_145848_d + i, this.field_145849_e + 1) == ModBlocks.watz_element) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 2, this.field_145848_d + i, this.field_145849_e + 2) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 1, this.field_145848_d + i, this.field_145849_e - 3) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 1, this.field_145848_d + i, this.field_145849_e - 2) == ModBlocks.watz_element) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 1, this.field_145848_d + i, this.field_145849_e - 1) == ModBlocks.watz_control) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 1, this.field_145848_d + i, this.field_145849_e) == ModBlocks.watz_cooler) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 1, this.field_145848_d + i, this.field_145849_e + 1) == ModBlocks.watz_control) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 1, this.field_145848_d + i, this.field_145849_e + 2) == ModBlocks.watz_element) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 1, this.field_145848_d + i, this.field_145849_e + 3) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 0, this.field_145848_d + i, this.field_145849_e - 2) == ModBlocks.watz_control) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 0, this.field_145848_d + i, this.field_145849_e - 1) == ModBlocks.watz_cooler) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 0, this.field_145848_d + i, this.field_145849_e + 1) == ModBlocks.watz_cooler) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 0, this.field_145848_d + i, this.field_145849_e + 2) == ModBlocks.watz_control) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c - 1, this.field_145848_d + i, this.field_145849_e - 3) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c - 1, this.field_145848_d + i, this.field_145849_e - 2) == ModBlocks.watz_element) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c - 1, this.field_145848_d + i, this.field_145849_e - 1) == ModBlocks.watz_control) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c - 1, this.field_145848_d + i, this.field_145849_e) == ModBlocks.watz_cooler) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c - 1, this.field_145848_d + i, this.field_145849_e + 1) == ModBlocks.watz_control) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c - 1, this.field_145848_d + i, this.field_145849_e + 2) == ModBlocks.watz_element) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c - 1, this.field_145848_d + i, this.field_145849_e + 3) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c - 2, this.field_145848_d + i, this.field_145849_e - 2) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c - 2, this.field_145848_d + i, this.field_145849_e - 1) == ModBlocks.watz_element) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c - 2, this.field_145848_d + i, this.field_145849_e) == ModBlocks.watz_control) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c - 2, this.field_145848_d + i, this.field_145849_e + 1) == ModBlocks.watz_element) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c - 2, this.field_145848_d + i, this.field_145849_e + 2) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c - 3, this.field_145848_d + i, this.field_145849_e - 1) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = -5; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c - 3, this.field_145848_d + i, this.field_145849_e + 1) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = -5; i <= -1; ++i) {
            if (world.func_147439_a(this.field_145851_c, this.field_145848_d + i, this.field_145849_e) == ModBlocks.watz_conductor) continue;
            return false;
        }
        for (i = 1; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c, this.field_145848_d + i, this.field_145849_e) == ModBlocks.watz_conductor) continue;
            return false;
        }
        for (i = -5; i <= -1; ++i) {
            if (world.func_147439_a(this.field_145851_c + 3, this.field_145848_d + i, this.field_145849_e) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = 1; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c + 3, this.field_145848_d + i, this.field_145849_e) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = -5; i <= -1; ++i) {
            if (world.func_147439_a(this.field_145851_c - 3, this.field_145848_d + i, this.field_145849_e) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = 1; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c - 3, this.field_145848_d + i, this.field_145849_e) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = -5; i <= -1; ++i) {
            if (world.func_147439_a(this.field_145851_c, this.field_145848_d + i, this.field_145849_e + 3) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = 1; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c, this.field_145848_d + i, this.field_145849_e + 3) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = -5; i <= -1; ++i) {
            if (world.func_147439_a(this.field_145851_c, this.field_145848_d + i, this.field_145849_e - 3) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        for (i = 1; i <= 5; ++i) {
            if (world.func_147439_a(this.field_145851_c, this.field_145848_d + i, this.field_145849_e - 3) == ModBlocks.reinforced_brick) continue;
            return false;
        }
        if (world.func_147439_a(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e) != ModBlocks.watz_hatch) {
            return false;
        }
        if (world.func_147439_a(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e) != ModBlocks.watz_hatch) {
            return false;
        }
        if (world.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 3) != ModBlocks.watz_hatch) {
            return false;
        }
        if (world.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 3) != ModBlocks.watz_hatch) {
            return false;
        }
        for (i = -3; i <= 3; ++i) {
            for (j = -3; j <= 3; ++j) {
                if (world.func_147439_a(this.field_145851_c + i, this.field_145848_d + 6, this.field_145849_e + j) == ModBlocks.watz_end || world.func_147439_a(this.field_145851_c + i, this.field_145848_d + 6, this.field_145849_e + j) == ModBlocks.watz_conductor) continue;
                return false;
            }
        }
        for (i = -3; i <= 3; ++i) {
            for (j = -3; j <= 3; ++j) {
                if (world.func_147439_a(this.field_145851_c + i, this.field_145848_d - 6, this.field_145849_e + j) == ModBlocks.watz_end || world.func_147439_a(this.field_145851_c + i, this.field_145848_d - 6, this.field_145849_e + j) == ModBlocks.watz_conductor) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean isCoatingValid(World world) {
        return true;
    }

    @Override
    public boolean hasFuse() {
        return this.slots[38] != null && this.slots[38].func_77973_b() == ModItems.titanium_filter && ItemCapacitor.getDura(this.slots[38]) > 0;
    }

    @Override
    public int getWaterScaled(int i) {
        return 0;
    }

    @Override
    public long getPowerScaled(long i) {
        return this.power / 100L * i / 1000000L;
    }

    @Override
    public int getCoolantScaled(int i) {
        return 0;
    }

    @Override
    public int getHeatScaled(int i) {
        return 0;
    }

    public void func_145845_h() {
        if (this.isStructureValid(this.field_145850_b) && !this.field_145850_b.field_72995_K) {
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.ffgeuaInit();
                this.fillFluidInit(this.tank.getTankType());
            }
            this.powerMultiplier = 100;
            this.heatMultiplier = 100;
            this.decayMultiplier = 100;
            this.powerList = 0;
            this.heatList = 0;
            this.heat = 0;
            if (this.hasFuse()) {
                int i;
                for (i = 0; i < 36; ++i) {
                    this.surveyPellet(this.slots[i]);
                }
                for (i = 0; i < 36; ++i) {
                    this.surveyPelletAgain(this.slots[i]);
                }
                for (i = 0; i < 36; ++i) {
                    this.decayPellet(i);
                }
            }
            if (this.heatList > 0) {
                ItemCapacitor.setDura(this.slots[38], ItemCapacitor.getDura(this.slots[38]) - 1);
            }
            this.heatList *= this.heatMultiplier;
            this.heatList /= 100;
            this.heat = this.heatList;
            this.powerList *= this.powerMultiplier;
            this.powerList /= 100;
            this.power += (long)this.powerList;
            this.tank.setFill(this.tank.getFill() + this.decayMultiplier * this.heat / 100 / 100);
            if (this.power > 100000000L) {
                this.power = 100000000L;
            }
            if (this.tank.getFill() > this.tank.getMaxFill()) {
                this.emptyWaste();
            }
            this.power = Library.chargeItemsFromTE(this.slots, 37, this.power, 100000000L);
            this.tank.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            this.tank.unloadTank(36, 39, this.slots);
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
        }
    }

    public void surveyPellet(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof WatzFuel) {
            WatzFuel fuel = (WatzFuel)stack.func_77973_b();
            this.powerList += fuel.power;
            this.heatList += fuel.heat;
        }
    }

    public void surveyPelletAgain(ItemStack stack) {
        if (stack != null && stack.func_77973_b() instanceof WatzFuel) {
            WatzFuel fuel = (WatzFuel)stack.func_77973_b();
            this.powerMultiplier = (int)((float)this.powerMultiplier * fuel.powerMultiplier);
            this.heatMultiplier = (int)((float)this.heatMultiplier * fuel.heatMultiplier);
            this.decayMultiplier = (int)((float)this.decayMultiplier * fuel.decayMultiplier);
        }
    }

    public void decayPellet(int i) {
        if (this.slots[i] != null && this.slots[i].func_77973_b() instanceof WatzFuel) {
            WatzFuel fuel = (WatzFuel)this.slots[i].func_77973_b();
            WatzFuel.setLifeTime(this.slots[i], WatzFuel.getLifeTime(this.slots[i]) + this.decayMultiplier);
            WatzFuel.updateDamage(this.slots[i]);
            if (WatzFuel.getLifeTime(this.slots[i]) >= fuel.lifeTime) {
                this.slots[i] = this.slots[i].func_77973_b() == ModItems.pellet_lead ? new ItemStack(ModItems.powder_lead) : new ItemStack(ModItems.pellet_lead);
            }
        }
    }

    public void emptyWaste() {
        this.tank.setFill(this.tank.getFill() / 4);
        this.tank.setFill(this.tank.getFill() * 3);
        if (!this.field_145850_b.field_72995_K) {
            if (this.field_145850_b.func_147439_a(this.field_145851_c + 4, this.field_145848_d, this.field_145849_e) == Blocks.field_150350_a) {
                this.field_145850_b.func_147449_b(this.field_145851_c + 4, this.field_145848_d, this.field_145849_e, ModBlocks.mud_block);
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "game.neutral.swim.splash", 3.0f, 0.5f);
            } else if (this.field_145850_b.func_147439_a(this.field_145851_c - 4, this.field_145848_d, this.field_145849_e) == Blocks.field_150350_a) {
                this.field_145850_b.func_147449_b(this.field_145851_c - 4, this.field_145848_d, this.field_145849_e, ModBlocks.mud_block);
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "game.neutral.swim.splash", 3.0f, 0.5f);
            } else if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e + 4) == Blocks.field_150350_a) {
                this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e + 4, ModBlocks.mud_block);
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "game.neutral.swim.splash", 3.0f, 0.5f);
            } else if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e - 4) == Blocks.field_150350_a) {
                this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e - 4, ModBlocks.mud_block);
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "game.neutral.swim.splash", 3.0f, 0.5f);
            } else if (this.rand.nextInt(10) != 0) {
                for (int i = -3; i <= 3; ++i) {
                    for (int j = -5; j <= 5; ++j) {
                        for (int k = -3; k <= 3; ++k) {
                            if (this.rand.nextInt(2) != 0) continue;
                            this.field_145850_b.func_147449_b(this.field_145851_c + i, this.field_145848_d + j, this.field_145849_e + k, ModBlocks.mud_block);
                        }
                    }
                }
                this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.mud_block);
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "game.neutral.swim.splash", 3.0f, 0.5f);
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "random.explode", 3.0f, 0.75f);
            } else {
                EntityNukeExplosionMK3 entity = new EntityNukeExplosionMK3(this.field_145850_b);
                entity.field_70165_t = this.field_145851_c;
                entity.field_70163_u = this.field_145848_d;
                entity.field_70161_v = this.field_145849_e;
                entity.destructionRange = BombConfig.fleijaRadius;
                entity.speed = 25;
                entity.coefficient = 1.0f;
                entity.waste = false;
                this.field_145850_b.func_72838_d((Entity)entity);
            }
        }
    }

    @Override
    public void ffgeua(int x, int y, int z, boolean newTact) {
        Library.ffgeua(x, y, z, newTact, this, this.field_145850_b);
    }

    @Override
    public void ffgeuaInit() {
        this.ffgeua(this.field_145851_c, this.field_145848_d + 7, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d - 7, this.field_145849_e, this.getTact());
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public long getSPower() {
        return this.power;
    }

    @Override
    public void setSPower(long i) {
        this.power = i;
    }

    @Override
    public List<IConsumer> getList() {
        return this.list;
    }

    @Override
    public void clearList() {
        this.list.clear();
    }

    @Override
    public void setFillstate(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        this.tank.setTankType(type);
    }

    @Override
    public void fillFluidInit(FluidTypeHandler.FluidType type) {
        this.fillFluid(this.field_145851_c + 4, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 4, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e + 4, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e - 4, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidTypeHandler.FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        return this.tank.getFill();
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        this.tank.setFill(i);
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidTypeHandler.FluidType type) {
        return this.list1;
    }

    @Override
    public void clearFluidList(FluidTypeHandler.FluidType type) {
        this.list1.clear();
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tank);
        return list;
    }
}

