/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.entity.missile.EntitySoyuz;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.handler.MissileStruct;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.inventory.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;

public class TileEntitySoyuzLauncher
extends TileEntityMachineBase
implements ISidedInventory,
IConsumer,
IFluidContainer,
IFluidAcceptor {
    public long power;
    public static final long maxPower = 1000000L;
    public FluidTank[] tanks;
    public byte mode;
    public boolean starting;
    public int countdown;
    public static final int maxCount = 600;
    public byte rocketType = (byte)-1;
    private AudioWrapper audio;
    public MissileStruct load;

    public TileEntitySoyuzLauncher() {
        super(27);
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.KEROSENE, 128000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.OXYGEN, 128000, 1);
    }

    @Override
    public String getName() {
        return "container.soyuzLauncher";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.tanks[0].loadTank(4, 5, this.slots);
            this.tanks[1].loadTank(6, 7, this.slots);
            for (int i = 0; i < 2; ++i) {
                this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            }
            this.power = Library.chargeTEFromItems(this.slots, 8, this.power, 1000000L);
            if (!this.starting || !this.canLaunch()) {
                this.countdown = 600;
                this.starting = false;
            } else if (this.countdown > 0) {
                --this.countdown;
                if (this.countdown % 100 == 0 && this.countdown > 0) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:alarm.hatch", 100.0f, 1.1f);
                }
            } else {
                this.liftOff();
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74774_a("mode", this.mode);
            data.func_74757_a("starting", this.starting);
            data.func_74774_a("type", this.getType());
            this.networkPack(data, 250);
        }
        if (this.field_145850_b.field_72995_K) {
            if (!this.starting || !this.canLaunch()) {
                if (this.audio != null) {
                    this.audio.stopSound();
                    this.audio = null;
                }
                this.countdown = 600;
            } else if (this.countdown > 0) {
                if (this.audio == null) {
                    this.audio = MainRegistry.proxy.getLoopedSound("hbm:block.soyuzReady", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 1.0f);
                    this.audio.updateVolume(100.0f);
                    this.audio.startSound();
                }
                --this.countdown;
            }
            List entities = this.field_145850_b.func_72872_a(EntitySoyuz.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c - 0.5), (double)this.field_145848_d, (double)((double)this.field_145849_e - 0.5), (double)((double)this.field_145851_c + 1.5), (double)(this.field_145848_d + 10), (double)((double)this.field_145849_e + 1.5)));
            if (!entities.isEmpty()) {
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "smoke");
                data.func_74778_a("mode", "shockRand");
                data.func_74768_a("count", 50);
                data.func_74780_a("strength", this.field_145850_b.field_73012_v.nextGaussian() * 3.0 + 6.0);
                data.func_74780_a("posX", (double)this.field_145851_c + 0.5);
                data.func_74780_a("posY", (double)(this.field_145848_d - 3));
                data.func_74780_a("posZ", (double)this.field_145849_e + 0.5);
                MainRegistry.proxy.effectNT(data);
            }
        }
    }

    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.mode = data.func_74771_c("mode");
        this.starting = data.func_74767_n("starting");
        this.rocketType = data.func_74771_c("type");
    }

    public void startCountdown() {
        if (this.canLaunch()) {
            this.starting = true;
        }
    }

    public void liftOff() {
        this.starting = false;
        int req = this.getFuelRequired();
        int pow = this.getPowerRequired();
        EntitySoyuz soyuz = new EntitySoyuz(this.field_145850_b);
        soyuz.setSkin(this.getType());
        soyuz.mode = this.mode;
        soyuz.func_70012_b((double)this.field_145851_c + 0.5, this.field_145848_d + 1, (double)this.field_145849_e + 0.5, 0.0f, 0.0f);
        this.field_145850_b.func_72838_d((Entity)soyuz);
        this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:entity.soyuzTakeoff", 100.0f, 1.1f);
        this.tanks[0].setFill(this.tanks[0].getFill() - req);
        this.tanks[1].setFill(this.tanks[1].getFill() - req);
        this.power -= (long)pow;
        if (this.mode == 0) {
            soyuz.setSat(this.slots[2]);
            if (this.orbital() == 2) {
                this.slots[3] = null;
            }
            this.slots[2] = null;
        }
        if (this.mode == 1) {
            ArrayList<ItemStack> payload = new ArrayList<ItemStack>();
            for (int i = 9; i < 27; ++i) {
                payload.add(this.slots[i]);
                this.slots[i] = null;
            }
            soyuz.targetX = this.slots[1].field_77990_d.func_74762_e("xCoord");
            soyuz.targetZ = this.slots[1].field_77990_d.func_74762_e("zCoord");
            soyuz.setPayload(payload);
        }
        this.slots[0] = null;
    }

    public boolean canLaunch() {
        return this.hasRocket() && this.hasFuel() && this.hasRocket() && this.hasPower() && this.designator() != 1 && this.orbital() != 1 && this.satellite() != 1;
    }

    public boolean hasFuel() {
        return this.tanks[0].getFill() >= this.getFuelRequired();
    }

    public boolean hasOxy() {
        return this.tanks[1].getFill() >= this.getFuelRequired();
    }

    public int getFuelRequired() {
        if (this.mode == 1) {
            return 20000 + this.getDist();
        }
        return 128000;
    }

    public int getDist() {
        if (this.designator() == 2) {
            int x = this.slots[1].field_77990_d.func_74762_e("xCoord");
            int z = this.slots[1].field_77990_d.func_74762_e("zCoord");
            return (int)Vec3.func_72443_a((double)(this.field_145851_c - x), (double)0.0, (double)(this.field_145849_e - z)).func_72433_c();
        }
        return 0;
    }

    public boolean hasPower() {
        return this.power >= (long)this.getPowerRequired();
    }

    public int getPowerRequired() {
        return 750000;
    }

    private byte getType() {
        if (!this.hasRocket()) {
            return -1;
        }
        return (byte)this.slots[0].func_77960_j();
    }

    public long getPowerScaled(long i) {
        return this.power * i / 1000000L;
    }

    public boolean hasRocket() {
        return this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.missile_soyuz;
    }

    public int designator() {
        if (this.mode == 0) {
            return 0;
        }
        if (this.slots[1] != null && (this.slots[1].func_77973_b() == ModItems.designator || this.slots[1].func_77973_b() == ModItems.designator_range || this.slots[1].func_77973_b() == ModItems.designator_manual) && this.slots[1].func_77942_o()) {
            return 2;
        }
        return 1;
    }

    public int satellite() {
        if (this.mode == 1) {
            return 0;
        }
        if (this.slots[2] != null) {
            return 2;
        }
        return 1;
    }

    public int orbital() {
        if (this.mode == 1) {
            return 0;
        }
        if (this.slots[2] != null && this.slots[2].func_77973_b() == ModItems.sat_gerald) {
            if (this.slots[3] != null && this.slots[3].func_77973_b() == ModItems.missile_soyuz_lander) {
                return 2;
            }
            return 1;
        }
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.tanks[0].readFromNBT(nbt, "fuel");
        this.tanks[1].readFromNBT(nbt, "oxidizer");
        this.power = nbt.func_74763_f("power");
        this.mode = nbt.func_74771_c("mode");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        NBTTagList list = new NBTTagList();
        this.tanks[0].writeToNBT(nbt, "fuel");
        this.tanks[1].writeToNBT(nbt, "oxidizer");
        nbt.func_74772_a("power", this.power);
        nbt.func_74774_a("mode", this.mode);
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getMaxFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setFluidFill(int fill, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(fill);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tanks[0]);
        list.add(this.tanks[1]);
        return list;
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        return 0;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }
}

