/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.FluidTank;
import com.hbm.lib.Library;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.ChunkCoordinates;

public class TileEntitySolarBoiler
extends TileEntity
implements IFluidAcceptor,
IFluidSource {
    private FluidTank water;
    private FluidTank steam;
    public List<IFluidAcceptor> list = new ArrayList<IFluidAcceptor>();
    public int heat;
    public HashSet<ChunkCoordinates> primary = new HashSet();
    public HashSet<ChunkCoordinates> secondary = new HashSet();
    AxisAlignedBB bb = null;

    public TileEntitySolarBoiler() {
        this.water = new FluidTank(FluidTypeHandler.FluidType.WATER, 16000, 0);
        this.steam = new FluidTank(FluidTypeHandler.FluidType.STEAM, 1600000, 1);
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.fillFluidInit(FluidTypeHandler.FluidType.STEAM);
            int process = this.heat / 10;
            process = Math.min(process, this.water.getFill());
            process = Math.min(process, (this.steam.getMaxFill() - this.steam.getFill()) / 100);
            if (process < 0) {
                process = 0;
            }
            this.water.setFill(this.water.getFill() - process);
            this.steam.setFill(this.steam.getFill() + process * 100);
            this.heat = 0;
        } else {
            this.secondary.clear();
            this.secondary.addAll(this.primary);
            this.primary.clear();
        }
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index == 0) {
            this.water.setFill(fill);
        }
        if (index == 1) {
            this.steam.setFill(fill);
        }
    }

    @Override
    public void setFluidFill(int fill, FluidTypeHandler.FluidType type) {
        if (type == FluidTypeHandler.FluidType.WATER) {
            this.water.setFill(fill);
        }
        if (type == FluidTypeHandler.FluidType.STEAM) {
            this.steam.setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index == 0) {
            this.water.setTankType(type);
        }
        if (index == 1) {
            this.steam.setTankType(type);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        return Arrays.asList(this.water, this.steam);
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type == FluidTypeHandler.FluidType.WATER) {
            return this.water.getFill();
        }
        if (type == FluidTypeHandler.FluidType.STEAM) {
            return this.steam.getFill();
        }
        return 0;
    }

    @Override
    public void fillFluidInit(FluidTypeHandler.FluidType type) {
        this.fillFluid(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidTypeHandler.FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.field_145850_b.func_82737_E() % 2L == 0L;
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type == FluidTypeHandler.FluidType.WATER) {
            return this.water.getMaxFill();
        }
        if (type == FluidTypeHandler.FluidType.STEAM) {
            return this.steam.getMaxFill();
        }
        return 0;
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidTypeHandler.FluidType type) {
        return this.list;
    }

    @Override
    public void clearFluidList(FluidTypeHandler.FluidType type) {
        this.list.clear();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)(this.field_145851_c - 1), (double)this.field_145848_d, (double)(this.field_145849_e - 1), (double)(this.field_145851_c + 2), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 2));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

