/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.interfaces.IConsumer;
import com.hbm.lib.Library;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityMicrowave
extends TileEntityMachineBase
implements IConsumer {
    public long power;
    public static final long maxPower = 50000L;
    public static final int consumption = 50;
    public static final int maxTime = 300;
    public int time;
    public int speed;
    public static final int maxSpeed = 5;

    public TileEntityMicrowave() {
        super(3);
    }

    @Override
    public String getName() {
        return "container.microwave";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 2, this.power, 50000L);
            if (this.canProcess()) {
                if (this.speed >= 5) {
                    this.field_145850_b.func_147480_a(this.field_145851_c, this.field_145848_d, this.field_145849_e, false);
                    this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 7.5f, true, true);
                    return;
                }
                if (this.time >= 300) {
                    this.process();
                    this.time = 0;
                }
                if (this.canProcess()) {
                    this.power -= 50L;
                    this.time += this.speed * 2;
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("time", this.time);
            data.func_74768_a("speed", this.speed);
            this.networkPack(data, 50);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.time = data.func_74762_e("time");
        this.speed = data.func_74762_e("speed");
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (value == 0) {
            ++this.speed;
        }
        if (value == 1) {
            --this.speed;
        }
        if (this.speed < 0) {
            this.speed = 0;
        }
        if (this.speed > 5) {
            this.speed = 5;
        }
    }

    private void process() {
        ItemStack stack = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[0]).func_77946_l();
        if (this.slots[1] == null) {
            this.slots[1] = stack;
        } else {
            this.slots[1].field_77994_a += stack.field_77994_a;
        }
        this.func_70298_a(0, 1);
        this.func_70296_d();
    }

    private boolean canProcess() {
        if (this.speed == 0) {
            return false;
        }
        if (this.power < 50L) {
            return false;
        }
        if (this.slots[0] != null && FurnaceRecipes.func_77602_a().func_151395_a(this.slots[0]) != null) {
            ItemStack stack = FurnaceRecipes.func_77602_a().func_151395_a(this.slots[0]);
            if (this.slots[1] == null) {
                return true;
            }
            if (!stack.func_77969_a(this.slots[1])) {
                return false;
            }
            return stack.field_77994_a + this.slots[1].field_77994_a <= stack.func_77976_d();
        }
        return false;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i == 0 && FurnaceRecipes.func_77602_a().func_151395_a(itemStack) != null;
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 1;
    }

    @Override
    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 1;
        } else {
            int[] nArray3 = new int[1];
            nArray = nArray3;
            nArray3[0] = 0;
        }
        return nArray;
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / 50000L;
    }

    public int getProgressScaled(int i) {
        return this.time * i / 300;
    }

    public int getSpeedScaled(int i) {
        return this.speed * i / 5;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 50000L;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.speed = nbt.func_74762_e("speed");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("speed", this.speed);
    }
}

