/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.ISource;
import com.hbm.inventory.FluidContainerRegistry;
import com.hbm.inventory.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityMachineSeleniumEngine
extends TileEntity
implements ISidedInventory,
ISource,
IFluidContainer,
IFluidAcceptor {
    private ItemStack[] slots;
    public long power;
    public int soundCycle = 0;
    public static final long maxPower = 250000L;
    public long powerCap = 250000L;
    public int age = 0;
    public List<IConsumer> list = new ArrayList<IConsumer>();
    public FluidTank tank;
    public int pistonCount = 0;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{1, 2};
    private static final int[] slots_side = new int[]{2};
    private String customName;

    public TileEntityMachineSeleniumEngine() {
        this.slots = new ItemStack[14];
        this.tank = new FluidTank(FluidTypeHandler.FluidType.DIESEL, 16000, 0);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.machineSelenium";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 9 && FluidContainerRegistry.getFluidContent(stack, this.tank.getTankType()) > 0) {
            return true;
        }
        return i == 13 && stack.func_77973_b() instanceof IBatteryItem;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("powerTime");
        this.powerCap = nbt.func_74763_f("powerCap");
        this.tank.readFromNBT(nbt, "fuel");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        nbt.func_74772_a("powerCap", this.powerCap);
        this.tank.writeToNBT(nbt, "fuel");
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        if (i == 1 && (itemStack.func_77973_b() == ModItems.canister_empty || itemStack.func_77973_b() == ModItems.tank_steel)) {
            return true;
        }
        return i == 2 && itemStack.func_77973_b() instanceof IBatteryItem && ((IBatteryItem)itemStack.func_77973_b()).getCharge(itemStack) == ((IBatteryItem)itemStack.func_77973_b()).getMaxCharge();
    }

    public long getPowerScaled(long i) {
        return this.power * i / this.powerCap;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.ffgeuaInit();
            }
            this.pistonCount = this.countPistons();
            this.tank.setType(11, 12, this.slots);
            this.tank.loadTank(9, 10, this.slots);
            this.tank.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            FluidTypeHandler.FluidType type = this.tank.getTankType();
            this.powerCap = type.name().equals(FluidTypeHandler.FluidType.NITAN.name()) ? 2500000L : 250000L;
            this.power = Library.chargeItemsFromTE(this.slots, 13, this.power, this.powerCap);
            if (this.pistonCount > 2) {
                this.generate();
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.pistonCount, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 150.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, (int)this.powerCap, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
        }
    }

    public int countPistons() {
        int count = 0;
        for (int i = 0; i < 9; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.piston_selenium) continue;
            ++count;
        }
        return count;
    }

    public boolean hasAcceptableFuel() {
        return this.getHEFromFuel() > 0;
    }

    public int getHEFromFuel() {
        FluidTypeHandler.FluidType type = this.tank.getTankType();
        if (type.name().equals(FluidTypeHandler.FluidType.SMEAR.name())) {
            return 50;
        }
        if (type.name().equals(FluidTypeHandler.FluidType.HEATINGOIL.name())) {
            return 75;
        }
        if (type.name().equals(FluidTypeHandler.FluidType.HYDROGEN.name())) {
            return 5;
        }
        if (type.name().equals(FluidTypeHandler.FluidType.DIESEL.name())) {
            return 225;
        }
        if (type.name().equals(FluidTypeHandler.FluidType.KEROSENE.name())) {
            return 300;
        }
        if (type.name().equals(FluidTypeHandler.FluidType.RECLAIMED.name())) {
            return 100;
        }
        if (type.name().equals(FluidTypeHandler.FluidType.PETROIL.name())) {
            return 125;
        }
        if (type.name().equals(FluidTypeHandler.FluidType.BIOFUEL.name())) {
            return 200;
        }
        if (type.name().equals(FluidTypeHandler.FluidType.NITAN.name())) {
            return 2500;
        }
        return 0;
    }

    public void generate() {
        if (this.hasAcceptableFuel() && this.tank.getFill() > 0) {
            if (this.soundCycle == 0) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "fireworks.blast", 1.0f, 0.5f);
            }
            ++this.soundCycle;
            if (this.soundCycle >= 3) {
                this.soundCycle = 0;
            }
            this.tank.setFill(this.tank.getFill() - this.pistonCount * 5);
            if (this.tank.getFill() < 0) {
                this.tank.setFill(0);
            }
            this.power = (long)((double)this.power + (double)this.getHEFromFuel() * Math.pow(this.pistonCount, 1.15));
            if (this.power > this.powerCap) {
                this.power = this.powerCap;
            }
        }
    }

    @Override
    public void ffgeua(int x, int y, int z, boolean newTact) {
        Library.ffgeua(x, y, z, newTact, this, this.field_145850_b);
    }

    @Override
    public void ffgeuaInit() {
        this.ffgeua(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.getTact());
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public long getSPower() {
        return this.power;
    }

    @Override
    public void setSPower(long i) {
        this.power = i;
    }

    @Override
    public List<IConsumer> getList() {
        return this.list;
    }

    @Override
    public void clearList() {
        this.list.clear();
    }

    @Override
    public void setFillstate(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        this.tank.setTankType(type);
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        return type.name().equals(this.tank.getTankType().name()) ? this.tank.getMaxFill() : 0;
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        return type.name().equals(this.tank.getTankType().name()) ? this.tank.getFill() : 0;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tank.getTankType().name())) {
            this.tank.setFill(i);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tank);
        return list;
    }
}

