/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import com.hbm.config.VersatileConfig;
import com.hbm.interfaces.IConsumer;
import com.hbm.inventory.MachineRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemCapacitor;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.TileEntityMachineBase;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityMachineSchrabidiumTransmutator
extends TileEntityMachineBase
implements IConsumer {
    public long power = 0L;
    public int process = 0;
    public static final long maxPower = 5000000L;
    public static final int processSpeed = 600;
    private AudioWrapper audio;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{1, 2};
    private static final int[] slots_side = new int[]{3, 2};

    public TileEntityMachineSchrabidiumTransmutator() {
        super(4);
    }

    @Override
    public String getName() {
        return "container.machine_schrabidium_transmutator";
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        switch (i) {
            case 0: {
                if (!MachineRecipes.mODE(stack, "ingotUranium")) break;
                return true;
            }
            case 2: {
                if (stack.func_77973_b() != ModItems.redcoil_capacitor) break;
                return true;
            }
            case 3: {
                if (!(stack.func_77973_b() instanceof IBatteryItem)) break;
                return true;
            }
        }
        return false;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.process = nbt.func_74762_e("process");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("process", this.process);
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack stack, int j) {
        if (i == 2 && stack.func_77973_b() != null && stack.func_77973_b() == ModItems.redcoil_capacitor && ItemCapacitor.getDura(stack) <= 0) {
            return true;
        }
        if (i == 1) {
            return true;
        }
        return i == 3 && stack.func_77973_b() instanceof IBatteryItem && ((IBatteryItem)stack.func_77973_b()).getCharge(stack) == 0L;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 5000000L;
    }

    public int getProgressScaled(int i) {
        return this.process * i / 600;
    }

    public boolean canProcess() {
        return this.power >= 4990000L && this.slots[0] != null && MachineRecipes.mODE(this.slots[0], "ingotUranium") && this.slots[2] != null && this.slots[2].func_77973_b() == ModItems.redcoil_capacitor && ItemCapacitor.getDura(this.slots[2]) > 0 && (this.slots[1] == null || this.slots[1] != null && this.slots[1].func_77973_b() == VersatileConfig.getTransmutatorItem() && this.slots[1].field_77994_a < this.slots[1].func_77976_d());
    }

    public boolean isProcessing() {
        return this.process > 0;
    }

    public void process() {
        ++this.process;
        if (this.process >= 600) {
            this.power = 0L;
            this.process = 0;
            --this.slots[0].field_77994_a;
            if (this.slots[0].field_77994_a <= 0) {
                this.slots[0] = null;
            }
            if (this.slots[1] == null) {
                this.slots[1] = new ItemStack(VersatileConfig.getTransmutatorItem());
            } else {
                ++this.slots[1].field_77994_a;
            }
            if (this.slots[2] != null) {
                ItemCapacitor.setDura(this.slots[2], ItemCapacitor.getDura(this.slots[2]) - 1);
            }
            this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "ambient.weather.thunder", 10000.0f, 0.8f + this.field_145850_b.field_73012_v.nextFloat() * 0.2f);
        }
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 3, this.power, 5000000L);
            if (this.canProcess()) {
                this.process();
            } else {
                this.process = 0;
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("progress", this.process);
            this.networkPack(data, 50);
        } else if (this.process > 0) {
            if (this.audio == null) {
                this.audio = MainRegistry.proxy.getLoopedSound("hbm:weapon.tauChargeLoop", this.field_145851_c, this.field_145848_d, this.field_145849_e, 1.0f, 1.0f);
                this.audio.startSound();
            }
        } else if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.process = data.func_74762_e("progress");
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 5000000L;
    }
}

