/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.FluidContainerRegistry;
import com.hbm.inventory.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityMachineRefinery
extends TileEntity
implements ISidedInventory,
IConsumer,
IFluidContainer,
IFluidAcceptor,
IFluidSource {
    private ItemStack[] slots;
    public long power = 0L;
    public int sulfur = 0;
    public static final int maxSulfur = 100;
    public static final long maxPower = 1000L;
    public int age = 0;
    public FluidTank[] tanks;
    public List<IFluidAcceptor> list1 = new ArrayList<IFluidAcceptor>();
    public List<IFluidAcceptor> list2 = new ArrayList<IFluidAcceptor>();
    public List<IFluidAcceptor> list3 = new ArrayList<IFluidAcceptor>();
    public List<IFluidAcceptor> list4 = new ArrayList<IFluidAcceptor>();
    private static final int[] slots_top = new int[]{1};
    private static final int[] slots_bottom = new int[]{0, 2, 4, 6, 8, 10, 11};
    private static final int[] slots_side = new int[]{0, 3, 5, 7, 9};
    private String customName;

    public TileEntityMachineRefinery() {
        this.slots = new ItemStack[12];
        this.tanks = new FluidTank[5];
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.HOTOIL, 64000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.HEAVYOIL, 16000, 1);
        this.tanks[2] = new FluidTank(FluidTypeHandler.FluidType.NAPHTHA, 16000, 2);
        this.tanks[3] = new FluidTank(FluidTypeHandler.FluidType.LIGHTOIL, 16000, 3);
        this.tanks[4] = new FluidTank(FluidTypeHandler.FluidType.PETROLEUM, 16000, 4);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.machineRefinery";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 128.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 0 && stack.func_77973_b() instanceof IBatteryItem) {
            return true;
        }
        if (i == 1 && FluidContainerRegistry.getFluidContent(stack, FluidTypeHandler.FluidType.HOTOIL) > 0) {
            return true;
        }
        if (stack.func_77973_b() == ModItems.canister_empty) {
            if (i == 3) {
                return true;
            }
            if (i == 5) {
                return true;
            }
            if (i == 7) {
                return true;
            }
            if (i == 9) {
                return true;
            }
        }
        return false;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("power");
        this.tanks[0].readFromNBT(nbt, "input");
        this.tanks[1].readFromNBT(nbt, "heavy");
        this.tanks[2].readFromNBT(nbt, "naphtha");
        this.tanks[3].readFromNBT(nbt, "light");
        this.tanks[4].readFromNBT(nbt, "petroleum");
        this.sulfur = nbt.func_74762_e("sulfur");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tanks[0].writeToNBT(nbt, "input");
        this.tanks[1].writeToNBT(nbt, "heavy");
        this.tanks[2].writeToNBT(nbt, "naphtha");
        this.tanks[3].writeToNBT(nbt, "light");
        this.tanks[4].writeToNBT(nbt, "petroleum");
        nbt.func_74768_a("sulfur", this.sulfur);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        if (i == 0 && itemStack.func_77973_b() instanceof IBatteryItem && ((IBatteryItem)itemStack.func_77973_b()).getCharge(itemStack) == 0L) {
            return true;
        }
        if (i == 2) {
            return true;
        }
        if (i == 4) {
            return true;
        }
        if (i == 6) {
            return true;
        }
        if (i == 8) {
            return true;
        }
        if (i == 10) {
            return true;
        }
        return i == 11;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 1000L);
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.fillFluidInit(this.tanks[1].getTankType());
                this.fillFluidInit(this.tanks[2].getTankType());
                this.fillFluidInit(this.tanks[3].getTankType());
                this.fillFluidInit(this.tanks[4].getTankType());
            }
            this.tanks[0].loadTank(1, 2, this.slots);
            int ho = 50;
            int nt = 25;
            int lo = 15;
            int pe = 10;
            if (this.power >= 5L && this.tanks[0].getFill() >= 100 && this.tanks[1].getFill() + ho <= this.tanks[1].getMaxFill() && this.tanks[2].getFill() + nt <= this.tanks[2].getMaxFill() && this.tanks[3].getFill() + lo <= this.tanks[3].getMaxFill() && this.tanks[4].getFill() + pe <= this.tanks[4].getMaxFill()) {
                this.tanks[0].setFill(this.tanks[0].getFill() - 100);
                this.tanks[1].setFill(this.tanks[1].getFill() + ho);
                this.tanks[2].setFill(this.tanks[2].getFill() + nt);
                this.tanks[3].setFill(this.tanks[3].getFill() + lo);
                this.tanks[4].setFill(this.tanks[4].getFill() + pe);
                ++this.sulfur;
                this.power -= 5L;
            }
            this.tanks[1].unloadTank(3, 4, this.slots);
            this.tanks[2].unloadTank(5, 6, this.slots);
            this.tanks[3].unloadTank(7, 8, this.slots);
            this.tanks[4].unloadTank(9, 10, this.slots);
            for (int i = 0; i < 5; ++i) {
                this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            }
            if (this.sulfur >= 100) {
                if (this.slots[11] == null) {
                    this.slots[11] = new ItemStack(ModItems.sulfur);
                    this.sulfur -= 100;
                } else if (this.slots[11] != null && this.slots[11].func_77973_b() == ModItems.sulfur && this.slots[11].field_77994_a < this.slots[11].func_77976_d()) {
                    ++this.slots[11].field_77994_a;
                    this.sulfur -= 100;
                }
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
        }
    }

    public long getPowerScaled(long i) {
        return this.power * i / 1000L;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000L;
    }

    @Override
    public void fillFluidInit(FluidTypeHandler.FluidType type) {
        this.fillFluid(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e - 2, this.getTact(), type);
        this.fillFluid(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 2, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 2, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e + 2, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e + 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e + 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e - 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e - 1, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidTypeHandler.FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        if (type.name().equals(this.tanks[2].getTankType().name())) {
            return this.tanks[2].getFill();
        }
        if (type.name().equals(this.tanks[3].getTankType().name())) {
            return this.tanks[3].getFill();
        }
        if (type.name().equals(this.tanks[4].getTankType().name())) {
            return this.tanks[4].getFill();
        }
        return 0;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(i);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(i);
        } else if (type.name().equals(this.tanks[2].getTankType().name())) {
            this.tanks[2].setFill(i);
        } else if (type.name().equals(this.tanks[3].getTankType().name())) {
            this.tanks[3].setFill(i);
        } else if (type.name().equals(this.tanks[4].getTankType().name())) {
            this.tanks[4].setFill(i);
        }
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.list1;
        }
        if (type.name().equals(this.tanks[2].getTankType().name())) {
            return this.list2;
        }
        if (type.name().equals(this.tanks[3].getTankType().name())) {
            return this.list3;
        }
        if (type.name().equals(this.tanks[4].getTankType().name())) {
            return this.list4;
        }
        return new ArrayList<IFluidAcceptor>();
    }

    @Override
    public void clearFluidList(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.list1.clear();
        }
        if (type.name().equals(this.tanks[2].getTankType().name())) {
            this.list2.clear();
        }
        if (type.name().equals(this.tanks[3].getTankType().name())) {
            this.list3.clear();
        }
        if (type.name().equals(this.tanks[4].getTankType().name())) {
            this.list4.clear();
        }
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index < 5 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index < 5 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tanks[0]);
        list.add(this.tanks[1]);
        list.add(this.tanks[2]);
        list.add(this.tanks[3]);
        list.add(this.tanks[4]);
        return list;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

