/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.MachineReactor;
import com.hbm.config.MobConfig;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFuelRod;
import com.hbm.lib.Library;
import com.hbm.packet.AuxGaugePacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.saveddata.RadiationSavedData;
import com.hbm.tileentity.machine.TileEntityMachineReactor;
import com.hbm.tileentity.machine.TileEntityNukeFurnace;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityMachineReactorSmall
extends TileEntity
implements ISidedInventory,
IFluidContainer,
IFluidAcceptor,
IFluidSource {
    private ItemStack[] slots;
    public int hullHeat;
    public final int maxHullHeat = 100000;
    public int coreHeat;
    public final int maxCoreHeat = 50000;
    public int rods;
    public final int rodsMax = 100;
    public boolean retracting = true;
    public int age = 0;
    public List<IFluidAcceptor> list = new ArrayList<IFluidAcceptor>();
    public FluidTank[] tanks;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 13, 15};
    private static final int[] slots_side = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 14};
    private String customName;
    private double decayMod = 1.0;
    private double coreHeatMod = 1.0;
    private double hullHeatMod = 1.0;
    private double conversionMod = 1.0;

    public TileEntityMachineReactorSmall() {
        this.slots = new ItemStack[16];
        this.tanks = new FluidTank[3];
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.WATER, 32000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.COOLANT, 16000, 1);
        this.tanks[2] = new FluidTank(FluidTypeHandler.FluidType.STEAM, 8000, 2);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.reactorSmall";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        if ((i == 0 || i == 1 || i == 2 || i == 3 || i == 4 || i == 5 || i == 6 || i == 7 || i == 8 || i == 9 || i == 10 || i == 11) && itemStack.func_77973_b() instanceof ItemFuelRod) {
            return true;
        }
        if (i == 12 && (itemStack.func_77973_b() == ModItems.rod_water || itemStack.func_77973_b() == ModItems.rod_dual_water || itemStack.func_77973_b() == ModItems.rod_quad_water || itemStack.func_77973_b() == Items.field_151131_as)) {
            return true;
        }
        return i == 14 && (itemStack.func_77973_b() == ModItems.rod_coolant || itemStack.func_77973_b() == ModItems.rod_dual_coolant || itemStack.func_77973_b() == ModItems.rod_quad_coolant);
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.coreHeat = nbt.func_74762_e("heat");
        this.hullHeat = nbt.func_74762_e("hullHeat");
        this.rods = nbt.func_74762_e("rods");
        this.retracting = nbt.func_74767_n("ret");
        this.slots = new ItemStack[this.func_70302_i_()];
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "coolant");
        this.tanks[2].readFromNBT(nbt, "steam");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74768_a("heat", this.coreHeat);
        nbt.func_74768_a("hullHeat", this.hullHeat);
        nbt.func_74768_a("rods", this.rods);
        nbt.func_74757_a("ret", this.retracting);
        NBTTagList list = new NBTTagList();
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "coolant");
        this.tanks[2].writeToNBT(nbt, "steam");
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        if (!(i != 0 && i != 1 && i != 2 && i != 3 && i != 4 && i != 5 && i != 6 && i != 7 && i != 8 && i != 9 && i != 10 && i != 11 || itemStack.func_77973_b() != ModItems.rod_uranium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_dual_uranium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_quad_uranium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_thorium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_dual_thorium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_quad_thorium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_plutonium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_dual_plutonium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_quad_plutonium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_mox_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_dual_mox_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_quad_mox_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_schrabidium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_dual_schrabidium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_quad_schrabidium_fuel_depleted)) {
            return true;
        }
        return !(i != 13 && i != 15 || itemStack.func_77973_b() != Items.field_151133_ar && itemStack.func_77973_b() != ModItems.rod_empty && itemStack.func_77973_b() != ModItems.rod_dual_empty && itemStack.func_77973_b() != ModItems.rod_quad_empty && itemStack.func_77973_b() != ModItems.fluid_tank_empty && itemStack.func_77973_b() != ModItems.fluid_barrel_empty);
    }

    public int getCoreHeatScaled(int i) {
        return this.coreHeat * i / 50000;
    }

    public int getHullHeatScaled(int i) {
        return this.hullHeat * i / 100000;
    }

    public int getSteamScaled(int i) {
        return this.tanks[2].getFill() * i / this.tanks[2].getMaxFill();
    }

    public boolean hasCoreHeat() {
        return this.coreHeat > 0;
    }

    public boolean hasHullHeat() {
        return this.hullHeat > 0;
    }

    private int[] getNeighbouringSlots(int id) {
        switch (id) {
            case 0: {
                return new int[]{1, 5};
            }
            case 1: {
                return new int[]{0, 6};
            }
            case 2: {
                return new int[]{3, 7};
            }
            case 3: {
                return new int[]{2, 4, 8};
            }
            case 4: {
                return new int[]{3, 9};
            }
            case 5: {
                return new int[]{0, 6, 10};
            }
            case 6: {
                return new int[]{1, 5, 11};
            }
            case 7: {
                return new int[]{2, 8};
            }
            case 8: {
                return new int[]{3, 7, 9};
            }
            case 9: {
                return new int[]{4, 8};
            }
            case 10: {
                return new int[]{5, 11};
            }
            case 11: {
                return new int[]{6, 10};
            }
        }
        return null;
    }

    public int getFuelPercent() {
        if (this.getRodCount() == 0) {
            return 0;
        }
        int rodMax = 0;
        int rod = 0;
        for (int i = 0; i < 12; ++i) {
            if (this.slots[i] == null || !(this.slots[i].func_77973_b() instanceof ItemFuelRod)) continue;
            rodMax += ((ItemFuelRod)this.slots[i].func_77973_b()).lifeTime;
            rod += ((ItemFuelRod)this.slots[i].func_77973_b()).lifeTime - ItemFuelRod.getLifeTime(this.slots[i]);
        }
        if (rodMax == 0) {
            return 0;
        }
        return rod * 100 / rodMax;
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.fillFluidInit(this.tanks[2].getTankType());
            }
            this.tanks[0].loadTank(12, 13, this.slots);
            this.tanks[1].loadTank(14, 15, this.slots);
            if (this.retracting && this.rods > 0) {
                if (this.rods == 100) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.reactorStart", 1.0f, 0.75f);
                }
                --this.rods;
                if (this.rods == 0) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.reactorStop", 1.0f, 1.0f);
                }
            }
            if (!this.retracting && this.rods < 100) {
                if (this.rods == 0) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.reactorStart", 1.0f, 0.75f);
                }
                ++this.rods;
                if (this.rods == 100) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.reactorStop", 1.0f, 1.0f);
                }
            }
            if (this.rods >= 100) {
                for (i = 0; i < 12; ++i) {
                    if (this.slots[i] == null) continue;
                    if (this.slots[i].func_77973_b() instanceof ItemFuelRod) {
                        this.decay(i);
                        continue;
                    }
                    if (this.slots[i].func_77973_b() != ModItems.meteorite_sword_bred) continue;
                    this.slots[i] = new ItemStack(ModItems.meteorite_sword_irradiated);
                }
            }
            this.coreHeatMod = 1.0;
            this.hullHeatMod = 1.0;
            this.conversionMod = 1.0;
            this.decayMod = 1.0;
            this.getInteractions();
            if (this.coreHeat > 0 && this.tanks[1].getFill() > 0 && this.hullHeat < this.maxHullHeat) {
                this.hullHeat = (int)((double)this.hullHeat + (double)this.coreHeat * 0.175 * this.hullHeatMod);
                this.coreHeat = (int)((double)this.coreHeat - (double)this.coreHeat * 0.1);
                this.tanks[1].setFill(this.tanks[1].getFill() - 10);
                if (this.tanks[1].getFill() < 0) {
                    this.tanks[1].setFill(0);
                }
            }
            if (this.hullHeat > 100000) {
                this.hullHeat = 100000;
            }
            if (this.hullHeat > 0 && this.tanks[0].getFill() > 0) {
                this.generateSteam();
                this.hullHeat = (int)((double)this.hullHeat - (double)this.hullHeat * 0.085);
            }
            if (this.coreHeat > 50000) {
                this.explode();
            }
            if (!(this.rods <= 0 || this.coreHeat <= 0 || this.blocksRad(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e) && this.blocksRad(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e) && this.blocksRad(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1) && this.blocksRad(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1))) {
                float rad = (float)this.coreHeat / 50000.0f * 50.0f;
                RadiationSavedData data = RadiationSavedData.getData(this.field_145850_b);
                RadiationSavedData.incrementRad(this.field_145850_b, this.field_145851_c, this.field_145849_e, rad, rad * 4.0f);
            }
            for (i = 0; i < 3; ++i) {
                this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.rods, 0), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 150.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.retracting ? 1 : 0, 1), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.coreHeat, 2), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxGaugePacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.hullHeat, 3), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
        }
    }

    private void generateSteam() {
        double steam;
        double water = steam = (double)this.hullHeat / 100000.0 * ((double)this.tanks[2].getMaxFill() / 50.0) * this.conversionMod;
        switch (this.tanks[2].getTankType()) {
            case STEAM: {
                water /= 100.0;
                break;
            }
            case HOTSTEAM: {
                water /= 10.0;
                break;
            }
        }
        this.tanks[0].setFill(this.tanks[0].getFill() - (int)Math.ceil(water));
        this.tanks[2].setFill(this.tanks[2].getFill() + (int)Math.floor(steam));
        if (this.tanks[0].getFill() < 0) {
            this.tanks[0].setFill(0);
        }
        if (this.tanks[2].getFill() > this.tanks[2].getMaxFill()) {
            this.tanks[2].setFill(this.tanks[2].getMaxFill());
        }
    }

    private void getInteractions() {
        this.getInteractionForBlock(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e);
        this.getInteractionForBlock(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e);
        this.getInteractionForBlock(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1);
        this.getInteractionForBlock(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1);
        TileEntity te1 = this.field_145850_b.func_147438_o(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e);
        TileEntity te2 = this.field_145850_b.func_147438_o(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e);
        TileEntity te3 = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2);
        TileEntity te4 = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2);
        boolean b1 = this.blocksRad(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e);
        boolean b2 = this.blocksRad(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e);
        boolean b3 = this.blocksRad(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1);
        boolean b4 = this.blocksRad(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1);
        TileEntityMachineReactorSmall[] reactors = new TileEntityMachineReactorSmall[]{te1 instanceof TileEntityMachineReactorSmall && !b1 ? (TileEntityMachineReactorSmall)te1 : null, te2 instanceof TileEntityMachineReactorSmall && !b2 ? (TileEntityMachineReactorSmall)te2 : null, te3 instanceof TileEntityMachineReactorSmall && !b3 ? (TileEntityMachineReactorSmall)te3 : null, te4 instanceof TileEntityMachineReactorSmall && !b4 ? (TileEntityMachineReactorSmall)te4 : null};
        for (int i = 0; i < 4; ++i) {
            if (reactors[i] == null || reactors[i].rods < 100 || reactors[i].getRodCount() <= 0) continue;
            this.decayMod += (double)reactors[i].getRodCount() / 2.0;
        }
    }

    private void getInteractionForBlock(int x, int y, int z) {
        Block b = this.field_145850_b.func_147439_a(x, y, z);
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (b == Blocks.field_150353_l || b == Blocks.field_150356_k) {
            this.hullHeatMod *= 3.0;
            this.conversionMod *= 0.5;
        } else if (b == Blocks.field_150451_bX) {
            this.conversionMod *= 1.15;
        } else if (b == ModBlocks.block_lead) {
            this.decayMod += 1.0;
        } else if (b == Blocks.field_150355_j || b == Blocks.field_150358_i) {
            this.tanks[0].setFill(this.tanks[0].getFill() + 25);
            if (this.tanks[0].getFill() > this.tanks[0].getMaxFill()) {
                this.tanks[0].setFill(this.tanks[0].getMaxFill());
            }
        } else if (b == ModBlocks.block_niter) {
            if (this.tanks[0].getFill() >= 50 && this.tanks[1].getFill() + 5 <= this.tanks[1].getMaxFill()) {
                this.tanks[0].setFill(this.tanks[0].getFill() - 50);
                this.tanks[1].setFill(this.tanks[1].getFill() + 5);
            }
        } else if (b == ModBlocks.machine_reactor) {
            TileEntity tile;
            int[] pos = ((MachineReactor)ModBlocks.machine_reactor).findCore(this.field_145850_b, x, y, z);
            if (pos != null && (tile = this.field_145850_b.func_147438_o(pos[0], pos[1], pos[2])) instanceof TileEntityMachineReactor) {
                TileEntityMachineReactor reactor = (TileEntityMachineReactor)tile;
                if (reactor.charge <= 1 && this.hullHeat > 0) {
                    reactor.charge = 1;
                    reactor.heat = (int)Math.floor(this.hullHeat * 4 / 100000) + 1;
                }
            }
        } else if (te instanceof TileEntityNukeFurnace) {
            TileEntityNukeFurnace reactor = (TileEntityNukeFurnace)te;
            if (reactor.dualPower < 1 && this.coreHeat > 0) {
                reactor.dualPower = 1;
            }
        } else if (b == ModBlocks.block_uranium) {
            this.coreHeatMod *= 1.05;
        } else if (b == Blocks.field_150402_ci) {
            this.hullHeatMod *= 1.1;
        } else if (b == ModBlocks.block_beryllium) {
            this.hullHeatMod *= 0.95;
            this.conversionMod *= 1.05;
        } else if (b == ModBlocks.block_schrabidium) {
            this.decayMod += 1.0;
            this.conversionMod *= 1.25;
            this.hullHeatMod *= 1.1;
        } else if (b == ModBlocks.block_waste) {
            this.decayMod += 3.0;
        }
    }

    private boolean blocksRad(int x, int y, int z) {
        Block b = this.field_145850_b.func_147439_a(x, y, z);
        if (b == ModBlocks.block_lead || b == ModBlocks.block_desh || b == ModBlocks.brick_concrete) {
            return true;
        }
        return b.func_149638_a(null) >= 100.0f;
    }

    public int getRodCount() {
        int count = 0;
        for (int i = 0; i < 12; ++i) {
            if (this.slots[i] == null || !(this.slots[i].func_77973_b() instanceof ItemFuelRod)) continue;
            ++count;
        }
        return count;
    }

    private boolean hasFuelRod(int id) {
        if (id > 11) {
            return false;
        }
        if (this.slots[id] != null) {
            return this.slots[id].func_77973_b() instanceof ItemFuelRod;
        }
        return false;
    }

    private int getNeightbourCount(int id) {
        int[] neighbours = this.getNeighbouringSlots(id);
        if (neighbours == null) {
            return 0;
        }
        int count = 0;
        for (int i = 0; i < neighbours.length; ++i) {
            if (!this.hasFuelRod(neighbours[i])) continue;
            ++count;
        }
        return count;
    }

    private void decay(int id) {
        if (id > 11) {
            return;
        }
        int decay = this.getNeightbourCount(id) + 1;
        decay = (int)((double)decay * this.decayMod);
        for (int i = 0; i < decay; ++i) {
            ItemFuelRod rod = (ItemFuelRod)this.slots[id].func_77973_b();
            this.coreHeat = (int)((double)this.coreHeat + (double)rod.heat * this.coreHeatMod);
            ItemFuelRod.setLifeTime(this.slots[id], ItemFuelRod.getLifeTime(this.slots[id]) + 1);
            if (ItemFuelRod.getLifeTime(this.slots[id]) <= ((ItemFuelRod)this.slots[id].func_77973_b()).lifeTime) continue;
            this.onRunOut(id);
            return;
        }
    }

    private void onRunOut(int id) {
        Item item = this.slots[id].func_77973_b();
        if (item == ModItems.rod_uranium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_uranium_fuel_depleted);
        } else if (item == ModItems.rod_thorium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_thorium_fuel_depleted);
        } else if (item == ModItems.rod_plutonium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_plutonium_fuel_depleted);
        } else if (item == ModItems.rod_mox_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_mox_fuel_depleted);
        } else if (item == ModItems.rod_schrabidium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_schrabidium_fuel_depleted);
        } else if (item == ModItems.rod_dual_uranium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_dual_uranium_fuel_depleted);
        } else if (item == ModItems.rod_dual_thorium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_dual_thorium_fuel_depleted);
        } else if (item == ModItems.rod_dual_plutonium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_dual_plutonium_fuel_depleted);
        } else if (item == ModItems.rod_dual_mox_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_dual_mox_fuel_depleted);
        } else if (item == ModItems.rod_dual_schrabidium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_dual_schrabidium_fuel_depleted);
        } else if (item == ModItems.rod_quad_uranium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_quad_uranium_fuel_depleted);
        } else if (item == ModItems.rod_quad_thorium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_quad_thorium_fuel_depleted);
        } else if (item == ModItems.rod_quad_plutonium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_quad_plutonium_fuel_depleted);
        } else if (item == ModItems.rod_quad_mox_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_quad_mox_fuel_depleted);
        } else if (item == ModItems.rod_quad_schrabidium_fuel) {
            this.slots[id] = new ItemStack(ModItems.rod_quad_schrabidium_fuel_depleted);
        }
    }

    private void explode() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
        this.field_145850_b.func_147468_f(this.field_145851_c, this.field_145848_d, this.field_145849_e);
        this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 18.0f, true);
        ExplosionNukeGeneric.waste(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 35);
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, ModBlocks.toxic_block);
        RadiationSavedData data = RadiationSavedData.getData(this.field_145850_b);
        RadiationSavedData.incrementRad(this.field_145850_b, this.field_145851_c, this.field_145849_e, 1000.0f, 2000.0f);
        if (MobConfig.enableElementals) {
            List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5)).func_72314_b(100.0, 100.0, 100.0));
            for (EntityPlayer player : players) {
                player.getEntityData().func_74775_l("PlayerPersisted").func_74757_a("radMark", true);
            }
        }
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidTypeHandler.FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public void fillFluidInit(FluidTypeHandler.FluidType type) {
        this.fillFluid(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c - 1, this.field_145848_d + 2, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c + 1, this.field_145848_d + 2, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e - 1, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d + 2, this.field_145849_e + 1, this.getTact(), type);
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getMaxFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(i);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(i);
        } else if (type.name().equals(this.tanks[2].getTankType().name())) {
            this.tanks[2].setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        if (type.name().equals(this.tanks[2].getTankType().name())) {
            return this.tanks[2].getFill();
        }
        return 0;
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index < 3 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index < 3 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tanks[0]);
        list.add(this.tanks[1]);
        list.add(this.tanks[2]);
        return list;
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidTypeHandler.FluidType type) {
        return this.list;
    }

    @Override
    public void clearFluidList(FluidTypeHandler.FluidType type) {
        this.list.clear();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public boolean isSubmerged() {
        return this.field_145850_b.func_147439_a(this.field_145851_c + 1, this.field_145848_d + 1, this.field_145849_e).func_149688_o() == Material.field_151586_h && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e + 1).func_149688_o() == Material.field_151586_h && this.field_145850_b.func_147439_a(this.field_145851_c - 1, this.field_145848_d + 1, this.field_145849_e).func_149688_o() == Material.field_151586_h && this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e - 1).func_149688_o() == Material.field_151586_h;
    }
}

