/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.inventory.BreederRecipes;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityMachineReactor
extends TileEntityMachineBase {
    public int progress;
    public int charge;
    public int heat;
    public static final int maxPower = 1000;
    public static final int processingSpeed = 1000;
    private static final int[] slots_top = new int[]{1};
    private static final int[] slots_bottom = new int[]{2, 0};
    private static final int[] slots_side = new int[]{0};
    AxisAlignedBB bb = null;

    public TileEntityMachineReactor() {
        super(3);
    }

    @Override
    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    @Override
    public String getName() {
        return "container.reactor";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            boolean markDirty = false;
            if (this.charge == 0) {
                this.heat = 0;
            }
            if (this.hasItemPower(this.slots[0]) && this.charge == 0) {
                this.charge += TileEntityMachineReactor.getItemPower(this.slots[0]);
                this.heat = TileEntityMachineReactor.getItemHeat(this.slots[0]);
                if (this.slots[0] != null) {
                    --this.slots[0].field_77994_a;
                    if (this.slots[0].field_77994_a == 0) {
                        this.slots[0] = this.slots[0].func_77973_b().getContainerItem(this.slots[0]);
                    }
                    markDirty = true;
                }
            }
            if (this.hasPower() && this.canProcess()) {
                ++this.progress;
                if (this.progress == 1000) {
                    this.progress = 0;
                    --this.charge;
                    this.processItem();
                    markDirty = true;
                }
            } else {
                this.progress = 0;
            }
            boolean trigger = true;
            if (this.hasPower() && this.canProcess() && this.progress == 0) {
                trigger = false;
            }
            if (trigger) {
                markDirty = true;
            }
            if (markDirty) {
                this.func_70296_d();
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74777_a("charge", (short)this.charge);
            data.func_74777_a("progress", (short)this.progress);
            data.func_74774_a("heat", (byte)this.heat);
            this.networkPack(data, 20);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.charge = data.func_74765_d("charge");
        this.progress = data.func_74765_d("progress");
        this.heat = data.func_74771_c("heat");
    }

    public boolean canProcess() {
        if (this.slots[1] == null) {
            return false;
        }
        BreederRecipes.BreederRecipe recipe = BreederRecipes.getOutput(this.slots[1]);
        if (recipe == null) {
            return false;
        }
        if (this.heat < recipe.heat) {
            return false;
        }
        if (this.slots[2] == null) {
            return true;
        }
        if (!this.slots[2].func_77969_a(recipe.output)) {
            return false;
        }
        if (this.slots[2].field_77994_a < this.func_70297_j_() && this.slots[2].field_77994_a < this.slots[2].func_77976_d()) {
            return true;
        }
        return this.slots[2].field_77994_a < recipe.output.func_77976_d();
    }

    private void processItem() {
        if (this.canProcess()) {
            BreederRecipes.BreederRecipe rec = BreederRecipes.getOutput(this.slots[1]);
            if (rec == null) {
                return;
            }
            ItemStack itemStack = rec.output;
            if (this.slots[2] == null) {
                this.slots[2] = itemStack.func_77946_l();
            } else if (this.slots[2].func_77969_a(itemStack)) {
                this.slots[2].field_77994_a += itemStack.field_77994_a;
            }
            for (int i = 1; i < 2; ++i) {
                if (this.slots[i].field_77994_a <= 0) {
                    this.slots[i] = new ItemStack(this.slots[i].func_77973_b().func_77664_n());
                } else {
                    --this.slots[i].field_77994_a;
                }
                if (this.slots[i].field_77994_a > 0) continue;
                this.slots[i] = null;
            }
        }
    }

    public boolean hasItemPower(ItemStack stack) {
        return BreederRecipes.getFuelValue(stack) != null;
    }

    private static int getItemPower(ItemStack stack) {
        int[] power = BreederRecipes.getFuelValue(stack);
        if (power == null) {
            return 0;
        }
        return power[1];
    }

    private static int getItemHeat(ItemStack stack) {
        int[] power = BreederRecipes.getFuelValue(stack);
        if (power == null) {
            return 0;
        }
        return power[0];
    }

    @Override
    public int[] func_94128_d(int side) {
        return side == 0 ? slots_bottom : (side == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i == 2 ? false : (i == 0 ? this.hasItemPower(itemStack) : true);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        if (i == 0) {
            return !this.hasItemPower(this.slots[0]);
        }
        return true;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 1000;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 4;
    }

    public boolean hasPower() {
        return this.charge > 0;
    }

    public boolean isProcessing() {
        return this.progress > 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.charge = nbt.func_74765_d("charge");
        this.heat = nbt.func_74765_d("heat");
        this.progress = nbt.func_74765_d("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74777_a("charge", (short)this.charge);
        nbt.func_74777_a("heat", (short)this.heat);
        nbt.func_74777_a("progress", (short)this.progress);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 3), (double)(this.field_145849_e + 1));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

