/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.entity.IRadarDetectable;
import com.hbm.blocks.ModBlocks;
import com.hbm.config.WeaponConfig;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.Untested;
import com.hbm.tileentity.TileEntityTickingBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

@Untested
public class TileEntityMachineRadar
extends TileEntityTickingBase
implements IConsumer {
    public List<Entity> entList = new ArrayList<Entity>();
    public List<int[]> nearbyMissiles = new ArrayList<int[]>();
    int pingTimer = 0;
    int lastPower;
    static final int maxTimer = 80;
    public boolean scanMissiles = true;
    public boolean scanPlayers = true;
    public boolean smartMode = true;
    public boolean redMode = true;
    public float prevRotation;
    public float rotation;
    public long power = 0L;
    public static final int maxPower = 100000;

    @Override
    public String getInventoryName() {
        return "";
    }

    @Override
    public void func_145845_h() {
        if (this.field_145848_d < WeaponConfig.radarAltitude) {
            return;
        }
        if (!this.field_145850_b.field_72995_K) {
            this.nearbyMissiles.clear();
            if (this.power > 0L) {
                this.allocateMissiles();
                this.power -= 500L;
                if (this.power < 0L) {
                    this.power = 0L;
                }
            }
            if (this.lastPower != this.getRedPower()) {
                this.field_145850_b.func_147459_d(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.func_145838_q());
            }
            this.sendMissileData();
            this.lastPower = this.getRedPower();
            if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e) != ModBlocks.muffler) {
                ++this.pingTimer;
                if (this.power > 0L && this.pingTimer >= 80) {
                    this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "hbm:block.sonarPing", 5.0f, 1.0f);
                    this.pingTimer = 0;
                }
            }
        } else {
            this.prevRotation = this.rotation;
            if (this.power > 0L) {
                this.rotation += 5.0f;
            }
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
                this.prevRotation -= 360.0f;
            }
        }
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        switch (meta) {
            case 0: {
                this.scanMissiles = !this.scanMissiles;
                break;
            }
            case 1: {
                this.scanPlayers = !this.scanPlayers;
                break;
            }
            case 2: {
                this.smartMode = !this.smartMode;
                break;
            }
            case 3: {
                this.redMode = !this.redMode;
            }
        }
    }

    private void allocateMissiles() {
        this.nearbyMissiles.clear();
        this.entList.clear();
        List list = this.field_145850_b.func_72839_b(null, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5 - (double)WeaponConfig.radarRange), (double)0.0, (double)((double)this.field_145849_e + 0.5 - (double)WeaponConfig.radarRange), (double)((double)this.field_145851_c + 0.5 + (double)WeaponConfig.radarRange), (double)5000.0, (double)((double)this.field_145849_e + 0.5 + (double)WeaponConfig.radarRange)));
        for (Entity e : list) {
            if (e.field_70163_u < (double)(this.field_145848_d + WeaponConfig.radarBuffer)) continue;
            if (e instanceof EntityPlayer && this.scanPlayers) {
                this.nearbyMissiles.add(new int[]{(int)e.field_70165_t, (int)e.field_70161_v, IRadarDetectable.RadarTargetType.PLAYER.ordinal(), (int)e.field_70163_u});
                this.entList.add(e);
            }
            if (!(e instanceof IRadarDetectable) || !this.scanMissiles) continue;
            this.nearbyMissiles.add(new int[]{(int)e.field_70165_t, (int)e.field_70161_v, ((IRadarDetectable)e).getTargetType().ordinal(), (int)e.field_70163_u});
            if (this.smartMode && !(e.field_70181_x <= 0.0)) continue;
            this.entList.add(e);
        }
    }

    public int getRedPower() {
        if (!this.entList.isEmpty()) {
            if (this.redMode) {
                double maxRange = (double)WeaponConfig.radarRange * Math.sqrt(2.0);
                int power = 0;
                for (int i = 0; i < this.entList.size(); ++i) {
                    Entity e = this.entList.get(i);
                    double dist = Math.sqrt(Math.pow(e.field_70165_t - (double)this.field_145851_c, 2.0) + Math.pow(e.field_70161_v - (double)this.field_145849_e, 2.0));
                    int p = 15 - (int)Math.floor(dist / maxRange * 15.0);
                    if (p <= power) continue;
                    power = p;
                }
                return power;
            }
            int power = 0;
            for (int i = 0; i < this.nearbyMissiles.size(); ++i) {
                if (this.nearbyMissiles.get(i)[3] + 1 <= power) continue;
                power = this.nearbyMissiles.get(i)[3] + 1;
            }
            return power;
        }
        return 0;
    }

    private void sendMissileData() {
        NBTTagCompound data = new NBTTagCompound();
        data.func_74772_a("power", this.power);
        data.func_74757_a("scanMissiles", this.scanMissiles);
        data.func_74757_a("scanPlayers", this.scanPlayers);
        data.func_74757_a("smartMode", this.smartMode);
        data.func_74757_a("redMode", this.redMode);
        data.func_74768_a("count", this.nearbyMissiles.size());
        for (int i = 0; i < this.nearbyMissiles.size(); ++i) {
            data.func_74768_a("x" + i, this.nearbyMissiles.get(i)[0]);
            data.func_74768_a("z" + i, this.nearbyMissiles.get(i)[1]);
            data.func_74768_a("type" + i, this.nearbyMissiles.get(i)[2]);
            data.func_74768_a("y" + i, this.nearbyMissiles.get(i)[3]);
        }
        this.networkPack(data, 15);
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.nearbyMissiles.clear();
        this.power = data.func_74763_f("power");
        this.scanMissiles = data.func_74767_n("scanMissiles");
        this.scanPlayers = data.func_74767_n("scanPlayers");
        this.smartMode = data.func_74767_n("smartMode");
        this.redMode = data.func_74767_n("redMode");
        int count = data.func_74762_e("count");
        for (int i = 0; i < count; ++i) {
            int x = data.func_74762_e("x" + i);
            int z = data.func_74762_e("z" + i);
            int type = data.func_74762_e("type" + i);
            int y = data.func_74762_e("y" + i);
            this.nearbyMissiles.add(new int[]{x, z, type, y});
        }
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.scanMissiles = nbt.func_74767_n("scanMissiles");
        this.scanPlayers = nbt.func_74767_n("scanPlayers");
        this.smartMode = nbt.func_74767_n("smartMode");
        this.redMode = nbt.func_74767_n("redMode");
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74757_a("scanMissiles", this.scanMissiles);
        nbt.func_74757_a("scanPlayers", this.scanPlayers);
        nbt.func_74757_a("smartMode", this.smartMode);
        nbt.func_74757_a("redMode", this.redMode);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

