/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.MachineITER;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.inventory.FluidTank;
import com.hbm.lib.Library;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityITER;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachinePlasmaHeater
extends TileEntityMachineBase
implements IFluidAcceptor,
IConsumer {
    public long power;
    public static final long maxPower = 100000000L;
    public FluidTank[] tanks = new FluidTank[2];
    public FluidTank plasma;

    public TileEntityMachinePlasmaHeater() {
        super(5);
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.DEUTERIUM, 16000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.TRITIUM, 16000, 1);
        this.plasma = new FluidTank(FluidTypeHandler.FluidType.PLASMA_DT, 64000, 2);
    }

    @Override
    public String getName() {
        return "container.plasmaHeater";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            TileEntity te;
            int[] pos;
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 100000000L);
            this.tanks[0].setType(1, 2, this.slots);
            this.tanks[1].setType(3, 4, this.slots);
            this.updateType();
            int maxConv = 50;
            int powerReq = 10000;
            int convert = Math.min(this.tanks[0].getFill(), this.tanks[1].getFill());
            convert = Math.min(convert, this.plasma.getMaxFill() - this.plasma.getFill());
            convert = Math.min(convert, maxConv);
            convert = (int)Math.min((long)convert, this.power / (long)powerReq);
            convert = Math.max(0, convert);
            if (convert > 0 && this.plasma.getTankType() != FluidTypeHandler.FluidType.NONE) {
                this.tanks[0].setFill(this.tanks[0].getFill() - convert);
                this.tanks[1].setFill(this.tanks[1].getFill() - convert);
                this.plasma.setFill(this.plasma.getFill() + convert * 2);
                this.power -= (long)(convert * powerReq);
                this.func_70296_d();
            }
            ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10)).getOpposite();
            int dist = 11;
            if (this.field_145850_b.func_147439_a(this.field_145851_c + dir.offsetX * dist, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * dist) == ModBlocks.iter && (pos = ((MachineITER)ModBlocks.iter).findCore(this.field_145850_b, this.field_145851_c + dir.offsetX * dist, this.field_145848_d + 2, this.field_145849_e + dir.offsetZ * dist)) != null && (te = this.field_145850_b.func_147438_o(pos[0], pos[1], pos[2])) instanceof TileEntityITER) {
                TileEntityITER iter = (TileEntityITER)te;
                if (iter.plasma.getFill() == 0 && this.plasma.getTankType() != FluidTypeHandler.FluidType.NONE) {
                    iter.plasma.setTankType(this.plasma.getTankType());
                }
                if (iter.isOn && iter.plasma.getTankType() == this.plasma.getTankType()) {
                    int toLoad = Math.min(iter.plasma.getMaxFill() - iter.plasma.getFill(), this.plasma.getFill());
                    toLoad = Math.min(toLoad, 40);
                    this.plasma.setFill(this.plasma.getFill() - toLoad);
                    iter.plasma.setFill(iter.plasma.getFill() + toLoad);
                    this.func_70296_d();
                    iter.func_70296_d();
                }
            }
            for (int i = 0; i < this.tanks.length; ++i) {
                this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            }
            this.plasma.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            this.networkPack(data, 50);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
    }

    private void updateType() {
        ArrayList types = new ArrayList(){
            {
                this.add(TileEntityMachinePlasmaHeater.this.tanks[0].getTankType());
                this.add(TileEntityMachinePlasmaHeater.this.tanks[1].getTankType());
            }
        };
        if (types.contains((Object)FluidTypeHandler.FluidType.DEUTERIUM) && types.contains((Object)FluidTypeHandler.FluidType.TRITIUM)) {
            this.plasma.setTankType(FluidTypeHandler.FluidType.PLASMA_DT);
            return;
        }
        if (types.contains((Object)FluidTypeHandler.FluidType.DEUTERIUM) && types.contains((Object)FluidTypeHandler.FluidType.HYDROGEN)) {
            this.plasma.setTankType(FluidTypeHandler.FluidType.PLASMA_HD);
            return;
        }
        if (types.contains((Object)FluidTypeHandler.FluidType.HYDROGEN) && types.contains((Object)FluidTypeHandler.FluidType.TRITIUM)) {
            this.plasma.setTankType(FluidTypeHandler.FluidType.PLASMA_HT);
            return;
        }
        if (types.contains((Object)FluidTypeHandler.FluidType.XENON) && types.contains((Object)FluidTypeHandler.FluidType.MERCURY)) {
            this.plasma.setTankType(FluidTypeHandler.FluidType.PLASMA_XM);
            return;
        }
        if (types.contains((Object)FluidTypeHandler.FluidType.BALEFIRE) && types.contains((Object)FluidTypeHandler.FluidType.AMAT)) {
            this.plasma.setTankType(FluidTypeHandler.FluidType.PLASMA_BF);
            return;
        }
        this.plasma.setTankType(FluidTypeHandler.FluidType.NONE);
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / 100000000L;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.tanks[0].readFromNBT(nbt, "fuel_1");
        this.tanks[1].readFromNBT(nbt, "fuel_2");
        this.plasma.readFromNBT(nbt, "plasma");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tanks[0].writeToNBT(nbt, "fuel_1");
        this.tanks[1].writeToNBT(nbt, "fuel_2");
        this.plasma.writeToNBT(nbt, "plasma");
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getMaxFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getMaxFill();
        }
        if (type.name().equals(this.plasma.getTankType().name())) {
            return this.plasma.getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(i);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(i);
        } else if (type.name().equals(this.plasma.getTankType().name())) {
            this.plasma.setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        if (type.name().equals(this.plasma.getTankType().name())) {
            return this.plasma.getFill();
        }
        return 0;
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
        if (index == 2) {
            this.plasma.setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
        if (index == 2) {
            this.plasma.setTankType(type);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tanks[0]);
        list.add(this.tanks[1]);
        list.add(this.plasma);
        return list;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

