/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import com.hbm.blocks.ModBlocks;
import com.hbm.entity.particle.EntityGasFX;
import com.hbm.explosion.ExplosionLarge;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;

public class TileEntityMachineOilWell
extends TileEntity
implements ISidedInventory,
IConsumer,
IFluidContainer,
IFluidSource {
    private ItemStack[] slots;
    public long power;
    public int warning;
    public int warning2;
    public static final long maxPower = 100000L;
    public int age = 0;
    public int age2 = 0;
    public List<IFluidAcceptor> list1 = new ArrayList<IFluidAcceptor>();
    public List<IFluidAcceptor> list2 = new ArrayList<IFluidAcceptor>();
    public FluidTank[] tanks;
    private static final int[] slots_top = new int[]{1};
    private static final int[] slots_bottom = new int[]{2, 0};
    private static final int[] slots_side = new int[]{0};
    Random rand = new Random();
    private String customName;
    List<int[]> list = new ArrayList<int[]>();

    public TileEntityMachineOilWell() {
        this.slots = new ItemStack[6];
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.OIL, 64000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.GAS, 64000, 1);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.oilWell";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 128.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i == 0 && itemStack.func_77973_b() instanceof IBatteryItem) {
            return true;
        }
        return i == 1;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("powerTime");
        this.age = nbt.func_74762_e("age");
        this.tanks[0].readFromNBT(nbt, "oil");
        this.tanks[1].readFromNBT(nbt, "gas");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        nbt.func_74768_a("age", this.age);
        this.tanks[0].writeToNBT(nbt, "oil");
        this.tanks[1].writeToNBT(nbt, "gas");
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return false;
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    public void func_145845_h() {
        int timer = 50;
        ++this.age;
        ++this.age2;
        if (this.age >= timer) {
            this.age -= timer;
        }
        if (this.age2 >= 20) {
            this.age2 -= 20;
        }
        if (this.age2 == 9 || this.age2 == 19) {
            this.fillFluidInit(this.tanks[0].getTankType());
            this.fillFluidInit(this.tanks[1].getTankType());
        }
        if (!this.field_145850_b.field_72995_K) {
            int i;
            this.tanks[0].unloadTank(1, 2, this.slots);
            this.tanks[1].unloadTank(3, 4, this.slots);
            for (i = 0; i < 2; ++i) {
                this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            }
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 100000L);
            if (this.power >= 100L) {
                if (this.age == timer - 1) {
                    this.warning = 0;
                    for (i = this.field_145848_d - 1; i > this.field_145848_d - 1 - 100; --i) {
                        if (i <= 5) {
                            this.warning = 2;
                            break;
                        }
                        Block b = this.field_145850_b.func_147439_a(this.field_145851_c, i, this.field_145849_e);
                        if (b == ModBlocks.oil_pipe) continue;
                        if ((b.isReplaceable((IBlockAccess)this.field_145850_b, this.field_145851_c, i, this.field_145849_e) || b.func_149638_a(null) < 100.0f) && b != ModBlocks.ore_oil && b != ModBlocks.ore_oil_empty) {
                            if (this.field_145850_b.func_147439_a(this.field_145851_c, i, this.field_145849_e) == ModBlocks.ore_uranium) {
                                for (int u = -1; u <= 1; ++u) {
                                    for (int v = -1; v <= 1; ++v) {
                                        if (this.field_145850_b.func_147439_a(this.field_145851_c + u, this.field_145848_d + 6, this.field_145849_e + v) != Blocks.field_150350_a) continue;
                                        this.field_145850_b.func_147449_b(this.field_145851_c + u, this.field_145848_d + 6, this.field_145849_e + v, ModBlocks.gas_radon_dense);
                                    }
                                }
                            }
                            this.field_145850_b.func_147449_b(this.field_145851_c, i, this.field_145849_e, ModBlocks.oil_pipe);
                            if (i != this.field_145848_d - 100) break;
                            this.warning = 2;
                            break;
                        }
                        if (this.tanks[0].getFill() < this.tanks[0].getMaxFill() && this.tanks[1].getFill() < this.tanks[1].getMaxFill()) {
                            if (this.succ(this.field_145851_c, i, this.field_145849_e)) {
                                this.tanks[0].setFill(this.tanks[0].getFill() + 500);
                                if (this.tanks[0].getFill() > this.tanks[0].getMaxFill()) {
                                    this.tanks[0].setFill(this.tanks[0].getMaxFill());
                                }
                                this.tanks[1].setFill(this.tanks[1].getFill() + (100 + this.rand.nextInt(401)));
                                if (this.tanks[1].getFill() > this.tanks[1].getMaxFill()) {
                                    this.tanks[1].setFill(this.tanks[1].getMaxFill());
                                }
                                ExplosionLarge.spawnOilSpills(this.field_145850_b, (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 5.5f, (float)this.field_145849_e + 0.5f, 3);
                                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "game.neutral.swim.splash", 2.0f, 0.5f);
                                break;
                            }
                            this.field_145850_b.func_147449_b(this.field_145851_c, i, this.field_145849_e, ModBlocks.oil_pipe);
                            break;
                        }
                        this.warning = 1;
                        break;
                    }
                }
                this.power -= 100L;
            } else {
                this.warning = 1;
            }
            this.warning2 = 0;
            if (this.tanks[1].getFill() > 0) {
                if (this.slots[5] != null && (this.slots[5].func_77973_b() == ModItems.fuse || this.slots[5].func_77973_b() == ModItems.screwdriver)) {
                    this.warning2 = 2;
                    this.tanks[1].setFill(this.tanks[1].getFill() - 50);
                    if (this.tanks[1].getFill() <= 0) {
                        this.tanks[1].setFill(0);
                    }
                    this.field_145850_b.func_72838_d((Entity)new EntityGasFX(this.field_145850_b, (float)this.field_145851_c + 0.5f, (float)this.field_145848_d + 6.5f, (float)this.field_145849_e + 0.5f, 0.0, 0.0, 0.0));
                    for (int u = -1; u <= 1; ++u) {
                        for (int v = -1; v <= 1; ++v) {
                            if (this.field_145850_b.field_73012_v.nextInt(10) != 0 || this.field_145850_b.func_147439_a(this.field_145851_c + u, this.field_145848_d + 6, this.field_145849_e + v) != Blocks.field_150350_a) continue;
                            this.field_145850_b.func_147449_b(this.field_145851_c + u, this.field_145848_d + 6, this.field_145849_e + v, ModBlocks.gas_flammable);
                        }
                    }
                } else {
                    this.warning2 = 1;
                }
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
        }
    }

    public boolean succ(int x, int y, int z) {
        int c;
        int b;
        int i;
        int a;
        this.list.clear();
        this.succ1(x, y, z);
        this.succ2(x, y, z);
        if (!this.list.isEmpty() && this.field_145850_b.func_147439_a(a = this.list.get(i = this.rand.nextInt(this.list.size()))[0], b = this.list.get(i)[1], c = this.list.get(i)[2]) == ModBlocks.ore_oil) {
            this.field_145850_b.func_147449_b(a, b, c, ModBlocks.ore_oil_empty);
            return true;
        }
        return false;
    }

    public void succInit1(int x, int y, int z) {
        this.succ1(x + 1, y, z);
        this.succ1(x - 1, y, z);
        this.succ1(x, y + 1, z);
        this.succ1(x, y - 1, z);
        this.succ1(x, y, z + 1);
        this.succ1(x, y, z - 1);
    }

    public void succInit2(int x, int y, int z) {
        this.succ2(x + 1, y, z);
        this.succ2(x - 1, y, z);
        this.succ2(x, y + 1, z);
        this.succ2(x, y - 1, z);
        this.succ2(x, y, z + 1);
        this.succ2(x, y, z - 1);
    }

    public void succ1(int x, int y, int z) {
        if (this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.ore_oil_empty && this.field_145850_b.func_72805_g(x, y, z) == 0) {
            this.field_145850_b.func_72921_c(x, y, z, 1, 2);
            this.succInit1(x, y, z);
        }
    }

    public void succ2(int x, int y, int z) {
        if (this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.ore_oil_empty && this.field_145850_b.func_72805_g(x, y, z) == 1) {
            this.field_145850_b.func_72921_c(x, y, z, 0, 2);
            this.succInit2(x, y, z);
        } else if (this.field_145850_b.func_147439_a(x, y, z) == ModBlocks.ore_oil) {
            this.list.add(new int[]{x, y, z});
        }
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public boolean getTact() {
        return this.age2 >= 0 && this.age2 < 10;
    }

    @Override
    public void fillFluidInit(FluidTypeHandler.FluidType type) {
        this.fillFluid(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidTypeHandler.FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        return 0;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(i);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(i);
        }
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.list1;
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.list2;
        }
        return new ArrayList<IFluidAcceptor>();
    }

    @Override
    public void clearFluidList(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.list1.clear();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.list2.clear();
        }
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tanks[0]);
        list.add(this.tanks[1]);
        return list;
    }
}

