/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.IFluidSource;
import com.hbm.interfaces.ISource;
import com.hbm.inventory.FluidTank;
import com.hbm.inventory.MachineRecipes;
import com.hbm.lib.Library;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityMachineLargeTurbine
extends TileEntityMachineBase
implements IFluidContainer,
IFluidAcceptor,
IFluidSource,
ISource {
    public long power;
    public static final long maxPower = 100000000L;
    public int age = 0;
    public List<IConsumer> list1 = new ArrayList<IConsumer>();
    public List<IFluidAcceptor> list2 = new ArrayList<IFluidAcceptor>();
    public FluidTank[] tanks = new FluidTank[2];
    private boolean shouldTurn;
    public float rotor;
    public float lastRotor;

    public TileEntityMachineLargeTurbine() {
        super(7);
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.STEAM, 512000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.WATER, 10240000, 1);
    }

    @Override
    public String getName() {
        return "container.machineLargeTurbine";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.age;
            if (this.age >= 2) {
                this.age = 0;
            }
            this.fillFluidInit(this.tanks[1].getTankType());
            this.ffgeuaInit();
            this.tanks[0].setType(0, 1, this.slots);
            this.tanks[0].loadTank(2, 3, this.slots);
            this.power = Library.chargeItemsFromTE(this.slots, 4, this.power, 100000000L);
            boolean operational = false;
            Object[] outs = MachineRecipes.getTurbineOutput(this.tanks[0].getTankType());
            if (outs == null) {
                this.tanks[1].setTankType(FluidTypeHandler.FluidType.NONE);
            } else {
                this.tanks[1].setTankType((FluidTypeHandler.FluidType)((Object)outs[0]));
                int processMax = (int)Math.ceil(Math.ceil((float)this.tanks[0].getFill() / 10.0f) / (double)((Integer)outs[2]).intValue());
                int processSteam = this.tanks[0].getFill() / (Integer)outs[2];
                int processWater = (this.tanks[1].getMaxFill() - this.tanks[1].getFill()) / (Integer)outs[1];
                int cycles = Math.min(processMax, Math.min(processSteam, processWater));
                this.tanks[0].setFill(this.tanks[0].getFill() - (Integer)outs[2] * cycles);
                this.tanks[1].setFill(this.tanks[1].getFill() + (Integer)outs[1] * cycles);
                this.power += (long)((Integer)outs[3] * cycles);
                if (this.power > 100000000L) {
                    this.power = 100000000L;
                }
                if (cycles > 0) {
                    operational = true;
                }
            }
            this.tanks[1].unloadTank(5, 6, this.slots);
            for (int i = 0; i < 2; ++i) {
                this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74757_a("operational", operational);
            this.networkPack(data, 50);
        } else {
            this.lastRotor = this.rotor;
            if (this.shouldTurn) {
                this.rotor += 15.0f;
                if (this.rotor >= 360.0f) {
                    this.rotor -= 360.0f;
                    this.lastRotor -= 360.0f;
                }
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.shouldTurn = data.func_74767_n("operational");
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / 100000000L;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "steam");
        this.power = nbt.func_74763_f("power");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "steam");
        nbt.func_74772_a("power", this.power);
    }

    @Override
    public void ffgeua(int x, int y, int z, boolean newTact) {
        Library.ffgeua(x, y, z, newTact, this, this.field_145850_b);
    }

    @Override
    public void ffgeuaInit() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        this.ffgeua(this.field_145851_c + dir.offsetX * -4, this.field_145848_d, this.field_145849_e + dir.offsetZ * -4, this.getTact());
    }

    @Override
    public void fillFluidInit(FluidTypeHandler.FluidType type) {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        dir = dir.getRotation(ForgeDirection.UP);
        this.fillFluid(this.field_145851_c + dir.offsetX * 2, this.field_145848_d, this.field_145849_e + dir.offsetZ * 2, this.getTact(), type);
        this.fillFluid(this.field_145851_c + dir.offsetX * -2, this.field_145848_d, this.field_145849_e + dir.offsetZ * -2, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidTypeHandler.FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.age == 0;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(i);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        return 0;
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tanks[0]);
        list.add(this.tanks[1]);
        return list;
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidTypeHandler.FluidType type) {
        return this.list2;
    }

    @Override
    public void clearFluidList(FluidTypeHandler.FluidType type) {
        this.list2.clear();
    }

    @Override
    public long getSPower() {
        return this.power;
    }

    @Override
    public void setSPower(long i) {
        this.power = i;
    }

    @Override
    public List<IConsumer> getList() {
        return this.list1;
    }

    @Override
    public void clearList() {
        this.list1.clear();
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }
}

