/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.google.common.collect.HashBiMap;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.handler.MultiblockHandlerXR;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.ISource;
import com.hbm.inventory.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityFurnace;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;
import scala.actors.threadpool.Arrays;

public class TileEntityMachineIGenerator
extends TileEntityMachineBase
implements ISource,
IFluidAcceptor {
    public long power;
    public static final long maxPower = 1000000L;
    public int lastBurnTime;
    public int burnTime;
    public int temperature;
    public static final int maxTemperature = 1000;
    public int torque;
    public static final int maxTorque = 10000;
    public float limiter = 0.0f;
    public static final int animSpeed = 50;
    @SideOnly(value=Side.CLIENT)
    public float rotation;
    @SideOnly(value=Side.CLIENT)
    public float prevRotation;
    public IGenRTG[] pellets = new IGenRTG[12];
    public FluidTank[] tanks;
    public int age = 0;
    public List<IConsumer> list = new ArrayList<IConsumer>();
    int ignoreNext = 0;
    private static HashBiMap<Item, IGenRTG> rtgPellets = HashBiMap.create();

    public TileEntityMachineIGenerator() {
        super(15);
        this.tanks = new FluidTank[3];
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.WATER, 8000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.HEATINGOIL, 16000, 1);
        this.tanks[2] = new FluidTank(FluidTypeHandler.FluidType.LUBRICANT, 2000, 2);
    }

    @Override
    public String getName() {
        return "container.iGenerator";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            int i;
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.ffgeuaInit();
            }
            this.tanks[0].loadTank(7, 8, this.slots);
            this.tanks[1].loadTank(9, 10, this.slots);
            this.tanks[1].setType(11, 12, this.slots);
            this.tanks[2].loadTank(13, 14, this.slots);
            this.loadFuel();
            this.pelletAction();
            if (this.burnTime > 0) {
                --this.burnTime;
                this.temperature += 100;
            }
            this.fuelAction();
            if (this.temperature > 1000) {
                this.temperature = 1000;
            }
            int displayHeat = this.temperature;
            this.rtgAction();
            this.rotorAction();
            this.generatorAction();
            this.power = Library.chargeItemsFromTE(this.slots, 6, this.power, 1000000L);
            NBTTagCompound data = new NBTTagCompound();
            int[] rtgs = new int[this.pellets.length];
            for (i = 0; i < this.pellets.length; ++i) {
                rtgs[i] = this.pellets[i] != null ? this.pellets[i].ordinal() : -1;
            }
            data.func_74783_a("rtgs", rtgs);
            data.func_74768_a("temp", displayHeat);
            data.func_74768_a("torque", this.torque);
            data.func_74768_a("power", (int)this.power);
            data.func_74777_a("burn", (short)this.burnTime);
            data.func_74777_a("lastBurn", (short)this.lastBurnTime);
            data.func_74776_a("dial", this.limiter);
            this.networkPack(data, 250);
            for (i = 0; i < 3; ++i) {
                this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            }
        } else {
            this.prevRotation = this.rotation;
            this.rotation += (float)(this.torque * 50 / 10000);
            if (this.rotation >= 360.0f) {
                this.rotation -= 360.0f;
                this.prevRotation -= 360.0f;
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        int[] rtgs = nbt.func_74759_k("rtgs");
        if (rtgs != null) {
            for (int i = 0; i < this.pellets.length; ++i) {
                int pellet = rtgs[i];
                this.pellets[i] = pellet >= 0 && pellet < IGenRTG.values().length ? IGenRTG.values()[pellet] : null;
            }
        }
        this.temperature = nbt.func_74762_e("temp");
        this.torque = nbt.func_74762_e("torque");
        this.power = nbt.func_74762_e("power");
        this.burnTime = nbt.func_74765_d("burn");
        this.lastBurnTime = nbt.func_74765_d("lastBurn");
        if (this.ignoreNext <= 0) {
            this.limiter = nbt.func_74760_g("dial");
        } else {
            --this.ignoreNext;
        }
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (meta == 0) {
            this.pushPellet();
        }
        if (meta == 1) {
            this.popPellet();
        }
        if (meta == 2) {
            this.setDialByAngle(value);
        }
    }

    private void loadFuel() {
        int time;
        if (this.burnTime <= 0 && this.slots[0] != null && (time = TileEntityFurnace.func_145952_a((ItemStack)this.slots[0]) / 2) > 0) {
            if (this.slots[0].func_77973_b().hasContainerItem(this.slots[0]) && this.slots[0].field_77994_a == 1) {
                this.slots[0] = this.slots[0].func_77973_b().getContainerItem(this.slots[0]);
            } else {
                this.func_70298_a(0, 1);
            }
            this.burnTime = time;
            this.lastBurnTime = time;
            this.func_70296_d();
        }
    }

    private void pelletAction() {
        for (int i = 0; i < this.pellets.length; ++i) {
            if (this.pellets[i] == null) continue;
            this.temperature += this.pellets[i].heat;
        }
    }

    private void fuelAction() {
        int heat = this.getHeatFromFuel(this.tanks[1].getTankType());
        int maxBurn = 2;
        if (this.tanks[1].getFill() > 0) {
            int burn = Math.min(maxBurn, this.tanks[1].getFill());
            this.tanks[1].setFill(this.tanks[1].getFill() - burn);
            this.temperature += heat * burn;
        }
    }

    public int getHeatFromFuel(FluidTypeHandler.FluidType type) {
        switch (type) {
            case SMEAR: {
                return 75;
            }
            case HEATINGOIL: {
                return 150;
            }
            case DIESEL: {
                return 225;
            }
            case KEROSENE: {
                return 300;
            }
            case RECLAIMED: {
                return 100;
            }
            case PETROIL: {
                return 125;
            }
            case BIOFUEL: {
                return 200;
            }
            case NITAN: {
                return 2500;
            }
        }
        return 0;
    }

    private void rtgAction() {
        int rtg = 0;
        for (int i = 3; i <= 5; ++i) {
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.thermo_element) continue;
            rtg += 15;
        }
        int pow = Math.min(this.temperature, rtg);
        this.temperature -= pow;
        this.power += (long)pow;
        if (this.power > 1000000L) {
            this.power = 1000000L;
        }
    }

    private void rotorAction() {
        int conversion = this.getConversion();
        if (this.temperature > 10 && this.tanks[0].getFill() > 0) {
            this.tanks[0].setFill(this.tanks[0].getFill() - 1);
        }
        if (this.torque > 10 && this.tanks[2].getFill() > 0 && this.field_145850_b.field_73012_v.nextInt(2) == 0) {
            this.tanks[2].setFill(this.tanks[2].getFill() - 1);
        }
        this.torque = (int)((double)this.torque + (double)conversion * (this.tanks[0].getFill() > 0 ? 1.5 : 1.0));
        this.temperature -= conversion;
        if (this.torque > 10000) {
            this.field_145850_b.func_72876_a(null, (double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, 5.0f, true);
        }
    }

    private void generatorAction() {
        double balanceFactor = 0.025;
        this.power = (long)((double)this.power + (double)this.torque * balanceFactor);
        this.torque -= this.getBrake();
        if (this.power > 1000000L) {
            this.power = 1000000L;
        }
    }

    public int getBrake() {
        return (int)Math.ceil((double)this.torque * 0.1 * (this.tanks[2].getFill() > 0 ? 0.5 : 1.0));
    }

    public int getConversion() {
        return (int)((float)this.temperature * this.limiter);
    }

    private void pushPellet() {
        IGenRTG pellet;
        if (this.pellets[11] != null) {
            return;
        }
        if (this.slots[1] != null && (pellet = IGenRTG.getPellet(this.slots[1].func_77973_b())) != null) {
            for (int i = 0; i < this.pellets.length; ++i) {
                if (this.pellets[i] != null) continue;
                this.pellets[i] = pellet;
                this.func_70298_a(1, 1);
                this.func_70296_d();
                return;
            }
        }
    }

    private void popPellet() {
        if (this.slots[2] != null) {
            return;
        }
        if (this.pellets[0] == null) {
            return;
        }
        this.slots[2] = new ItemStack((Item)rtgPellets.inverse().get((Object)this.pellets[0]));
        for (int i = 0; i < this.pellets.length - 1; ++i) {
            this.pellets[i] = this.pellets[i + 1];
        }
        this.pellets[this.pellets.length - 1] = null;
        this.func_70296_d();
    }

    public double getSolidGauge() {
        return (double)this.burnTime / (double)this.lastBurnTime;
    }

    public double getPowerGauge() {
        return (double)this.power / 1000000.0;
    }

    public double getTempGauge() {
        return (double)this.temperature / 1000.0;
    }

    public double getTorqueGauge() {
        return (double)this.torque / 10000.0;
    }

    public float getAngleFromDial() {
        return (45.0f + this.limiter * 270.0f) % 360.0f;
    }

    public void setDialByAngle(float angle) {
        this.limiter = (angle - 45.0f) / 270.0f;
        this.ignoreNext = 5;
    }

    @Override
    public void ffgeuaInit() {
        ForgeDirection dir = ForgeDirection.getOrientation((int)(this.func_145832_p() - 10));
        int[] rot = MultiblockHandlerXR.rotate(new int[]{1, 0, 2, 2, 8, 8}, dir);
        boolean tact = this.getTact();
        for (int iy = 0; iy <= 1; ++iy) {
            for (int ix = -rot[4]; ix <= rot[5]; ++ix) {
                for (int iz = -rot[2]; iz <= rot[3]; ++iz) {
                    if (ix != -rot[4] && ix != rot[5] && iz != -rot[2] && iz != rot[3]) continue;
                    this.ffgeua(this.field_145851_c + dir.offsetX * 2 + ix, this.field_145848_d + iy, this.field_145849_e + dir.offsetZ * 2 + iz, tact);
                }
            }
        }
    }

    @Override
    public void ffgeua(int x, int y, int z, boolean newTact) {
        Library.ffgeua(x, y, z, newTact, this, this.field_145850_b);
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public long getSPower() {
        return this.power;
    }

    @Override
    public void setSPower(long i) {
        this.power = i;
    }

    @Override
    public List<IConsumer> getList() {
        return this.list;
    }

    @Override
    public void clearList() {
        this.list.clear();
    }

    @Override
    public void setFillstate(int fill, int index) {
        this.tanks[index].setFill(fill);
    }

    @Override
    public void setFluidFill(int fill, FluidTypeHandler.FluidType type) {
        if (type == FluidTypeHandler.FluidType.WATER) {
            this.tanks[0].setFill(fill);
        } else if (type == FluidTypeHandler.FluidType.LUBRICANT) {
            this.tanks[2].setFill(fill);
        } else if (this.tanks[1].getTankType() == type) {
            this.tanks[1].setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        this.tanks[index].setTankType(type);
    }

    @Override
    public List<FluidTank> getTanks() {
        return Arrays.asList((Object[])this.tanks);
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        for (int i = 0; i < 3; ++i) {
            if (this.tanks[i].getTankType() != type) continue;
            return this.tanks[i].getFill();
        }
        return 0;
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        for (int i = 0; i < 3; ++i) {
            if (this.tanks[i].getTankType() != type) continue;
            return this.tanks[i].getMaxFill();
        }
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        for (int i = 0; i < this.pellets.length; ++i) {
            short s = nbt.func_74765_d("pellet" + i);
            this.pellets[i] = s >= 0 && s < IGenRTG.values().length ? IGenRTG.values()[s] : null;
        }
        this.burnTime = nbt.func_74762_e("burn");
        this.lastBurnTime = nbt.func_74762_e("lastBurn");
        this.limiter = nbt.func_74760_g("limiter");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        for (int i = 0; i < this.pellets.length; ++i) {
            if (this.pellets[i] != null) {
                nbt.func_74777_a("pellet" + i, (short)this.pellets[i].ordinal());
                continue;
            }
            nbt.func_74777_a("pellet" + i, (short)-1);
        }
        nbt.func_74768_a("burn", this.burnTime);
        nbt.func_74768_a("lastBurn", this.lastBurnTime);
        nbt.func_74776_a("limiter", this.limiter);
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public static enum IGenRTG {
        PLUTONIUM(ModItems.pellet_rtg, 0, 5),
        URANIUM(ModItems.pellet_rtg_weak, 9, 3),
        POLONIUM(ModItems.pellet_rtg_polonium, 18, 25);

        public int offset;
        public int heat;

        private IGenRTG(Item item, int offset, int heat) {
            rtgPellets.put((Object)item, (Object)this);
            this.offset = offset;
            this.heat = heat;
        }

        public static IGenRTG getPellet(Item item) {
            return (IGenRTG)((Object)rtgPellets.get((Object)item));
        }
    }
}

