/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import com.hbm.blocks.machine.MachineGenerator;
import com.hbm.explosion.ExplosionNukeGeneric;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.ISource;
import com.hbm.inventory.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemFuelRod;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.PacketDispatcher;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityMachineGenerator
extends TileEntity
implements ISidedInventory,
ISource,
IFluidContainer,
IFluidAcceptor {
    private ItemStack[] slots;
    public int heat;
    public final int heatMax = 100000;
    public long power;
    public final long powerMax = 100000L;
    public boolean isLoaded = false;
    public int age = 0;
    public List<IConsumer> list = new ArrayList<IConsumer>();
    public FluidTank[] tanks;
    private static final int[] slots_top = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8};
    private static final int[] slots_bottom = new int[]{0, 1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13};
    private static final int[] slots_side = new int[]{9, 10, 11};
    private String customName;

    public TileEntityMachineGenerator() {
        this.slots = new ItemStack[14];
        this.tanks = new FluidTank[2];
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.WATER, 32000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.COOLANT, 16000, 1);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.generator";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        if ((i == 0 || i == 1 || i == 2 || i == 3 || i == 4 || i == 5 || i == 6 || i == 7 || i == 8) && itemStack.func_77973_b() instanceof ItemFuelRod) {
            return true;
        }
        if (i == 9 && (itemStack.func_77973_b() == ModItems.rod_water || itemStack.func_77973_b() == ModItems.rod_dual_water || itemStack.func_77973_b() == ModItems.rod_quad_water || itemStack.func_77973_b() == Items.field_151131_as)) {
            return true;
        }
        if (i == 10 && (itemStack.func_77973_b() == ModItems.rod_coolant || itemStack.func_77973_b() == ModItems.rod_dual_coolant || itemStack.func_77973_b() == ModItems.rod_quad_coolant)) {
            return true;
        }
        return i == 11 && itemStack.func_77973_b() instanceof IBatteryItem;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("power");
        this.heat = nbt.func_74762_e("heat");
        this.slots = new ItemStack[this.func_70302_i_()];
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "coolant");
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("heat", this.heat);
        NBTTagList list = new NBTTagList();
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "coolant");
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        if (!(i != 0 && i != 1 && i != 2 && i != 3 && i != 4 && i != 5 && i != 6 && i != 7 && i != 8 || itemStack.func_77973_b() != ModItems.rod_uranium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_dual_uranium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_quad_uranium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_plutonium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_dual_plutonium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_quad_plutonium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_mox_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_dual_mox_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_quad_mox_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_schrabidium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_dual_schrabidium_fuel_depleted && itemStack.func_77973_b() != ModItems.rod_quad_schrabidium_fuel_depleted)) {
            return true;
        }
        if (!(i != 9 && i != 10 || itemStack.func_77973_b() != Items.field_151133_ar && itemStack.func_77973_b() != ModItems.rod_empty && itemStack.func_77973_b() != ModItems.rod_dual_empty && itemStack.func_77973_b() != ModItems.rod_quad_empty)) {
            return true;
        }
        return i == 11 && itemStack.func_77973_b() instanceof IBatteryItem && ((IBatteryItem)itemStack.func_77973_b()).getCharge(itemStack) == ((IBatteryItem)itemStack.func_77973_b()).getMaxCharge();
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    public int getHeatScaled(int i) {
        return this.heat * i / 100000;
    }

    public boolean hasPower() {
        return this.power > 0L;
    }

    public boolean hasHeat() {
        return this.heat > 0;
    }

    public void func_145845_h() {
        ++this.age;
        if (this.age >= 20) {
            this.age = 0;
        }
        if (this.age == 9 || this.age == 19) {
            this.ffgeuaInit();
        }
        if (!this.field_145850_b.field_72995_K) {
            int i;
            this.tanks[0].loadTank(9, 12, this.slots);
            this.tanks[1].loadTank(10, 13, this.slots);
            for (i = 0; i < 2; ++i) {
                this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            }
            this.power = Library.chargeItemsFromTE(this.slots, 11, this.power, 100000L);
            for (i = 0; i < 9; ++i) {
                int j;
                if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.rod_uranium_fuel) {
                    j = ItemFuelRod.getLifeTime(this.slots[i]);
                    ItemFuelRod.setLifeTime(this.slots[i], j + 1);
                    this.attemptHeat(1);
                    this.attemptPower(100);
                    if (ItemFuelRod.getLifeTime(this.slots[i]) == ((ItemFuelRod)this.slots[i].func_77973_b()).lifeTime) {
                        this.slots[i] = new ItemStack(ModItems.rod_uranium_fuel_depleted);
                    }
                }
                if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.rod_dual_uranium_fuel) {
                    j = ItemFuelRod.getLifeTime(this.slots[i]);
                    ItemFuelRod.setLifeTime(this.slots[i], j + 1);
                    this.attemptHeat(1);
                    this.attemptPower(100);
                    if (ItemFuelRod.getLifeTime(this.slots[i]) == ((ItemFuelRod)this.slots[i].func_77973_b()).lifeTime) {
                        this.slots[i] = new ItemStack(ModItems.rod_dual_uranium_fuel_depleted);
                    }
                }
                if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.rod_quad_uranium_fuel) {
                    j = ItemFuelRod.getLifeTime(this.slots[i]);
                    ItemFuelRod.setLifeTime(this.slots[i], j + 1);
                    this.attemptHeat(1);
                    this.attemptPower(100);
                    if (ItemFuelRod.getLifeTime(this.slots[i]) == ((ItemFuelRod)this.slots[i].func_77973_b()).lifeTime) {
                        this.slots[i] = new ItemStack(ModItems.rod_quad_uranium_fuel_depleted);
                    }
                }
                if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.rod_plutonium_fuel) {
                    j = ItemFuelRod.getLifeTime(this.slots[i]);
                    ItemFuelRod.setLifeTime(this.slots[i], j + 1);
                    this.attemptHeat(2);
                    this.attemptPower(150);
                    if (ItemFuelRod.getLifeTime(this.slots[i]) == ((ItemFuelRod)this.slots[i].func_77973_b()).lifeTime) {
                        this.slots[i] = new ItemStack(ModItems.rod_plutonium_fuel_depleted);
                    }
                }
                if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.rod_dual_plutonium_fuel) {
                    j = ItemFuelRod.getLifeTime(this.slots[i]);
                    ItemFuelRod.setLifeTime(this.slots[i], j + 1);
                    this.attemptHeat(2);
                    this.attemptPower(150);
                    if (ItemFuelRod.getLifeTime(this.slots[i]) == ((ItemFuelRod)this.slots[i].func_77973_b()).lifeTime) {
                        this.slots[i] = new ItemStack(ModItems.rod_dual_plutonium_fuel_depleted);
                    }
                }
                if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.rod_quad_plutonium_fuel) {
                    j = ItemFuelRod.getLifeTime(this.slots[i]);
                    ItemFuelRod.setLifeTime(this.slots[i], j + 1);
                    this.attemptHeat(2);
                    this.attemptPower(150);
                    if (ItemFuelRod.getLifeTime(this.slots[i]) == ((ItemFuelRod)this.slots[i].func_77973_b()).lifeTime) {
                        this.slots[i] = new ItemStack(ModItems.rod_quad_plutonium_fuel_depleted);
                    }
                }
                if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.rod_mox_fuel) {
                    j = ItemFuelRod.getLifeTime(this.slots[i]);
                    ItemFuelRod.setLifeTime(this.slots[i], j + 1);
                    this.attemptHeat(1);
                    this.attemptPower(50);
                    if (ItemFuelRod.getLifeTime(this.slots[i]) == ((ItemFuelRod)this.slots[i].func_77973_b()).lifeTime) {
                        this.slots[i] = new ItemStack(ModItems.rod_mox_fuel_depleted);
                    }
                }
                if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.rod_dual_mox_fuel) {
                    j = ItemFuelRod.getLifeTime(this.slots[i]);
                    ItemFuelRod.setLifeTime(this.slots[i], j + 1);
                    this.attemptHeat(1);
                    this.attemptPower(50);
                    if (ItemFuelRod.getLifeTime(this.slots[i]) == ((ItemFuelRod)this.slots[i].func_77973_b()).lifeTime) {
                        this.slots[i] = new ItemStack(ModItems.rod_dual_mox_fuel_depleted);
                    }
                }
                if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.rod_quad_mox_fuel) {
                    j = ItemFuelRod.getLifeTime(this.slots[i]);
                    ItemFuelRod.setLifeTime(this.slots[i], j + 1);
                    this.attemptHeat(1);
                    this.attemptPower(50);
                    if (ItemFuelRod.getLifeTime(this.slots[i]) == ((ItemFuelRod)this.slots[i].func_77973_b()).lifeTime) {
                        this.slots[i] = new ItemStack(ModItems.rod_quad_mox_fuel_depleted);
                    }
                }
                if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.rod_schrabidium_fuel) {
                    j = ItemFuelRod.getLifeTime(this.slots[i]);
                    ItemFuelRod.setLifeTime(this.slots[i], j + 1);
                    this.attemptHeat(10);
                    this.attemptPower(25000);
                    if (ItemFuelRod.getLifeTime(this.slots[i]) == ((ItemFuelRod)this.slots[i].func_77973_b()).lifeTime) {
                        this.slots[i] = new ItemStack(ModItems.rod_schrabidium_fuel_depleted);
                    }
                }
                if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.rod_dual_schrabidium_fuel) {
                    j = ItemFuelRod.getLifeTime(this.slots[i]);
                    ItemFuelRod.setLifeTime(this.slots[i], j + 1);
                    this.attemptHeat(10);
                    this.attemptPower(25000);
                    if (ItemFuelRod.getLifeTime(this.slots[i]) == ((ItemFuelRod)this.slots[i].func_77973_b()).lifeTime) {
                        this.slots[i] = new ItemStack(ModItems.rod_dual_schrabidium_fuel_depleted);
                    }
                }
                if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.rod_quad_schrabidium_fuel) continue;
                j = ItemFuelRod.getLifeTime(this.slots[i]);
                ItemFuelRod.setLifeTime(this.slots[i], j + 1);
                this.attemptHeat(10);
                this.attemptPower(25000);
                if (ItemFuelRod.getLifeTime(this.slots[i]) != ((ItemFuelRod)this.slots[i].func_77973_b()).lifeTime) continue;
                this.slots[i] = new ItemStack(ModItems.rod_quad_schrabidium_fuel_depleted);
            }
            if (this.power > 100000L) {
                this.power = 100000L;
            }
            if (this.heat > 100000) {
                this.explode();
            }
            if (!((this.slots[0] == null || !(this.slots[0].func_77973_b() instanceof ItemFuelRod)) && this.slots[0] != null || (this.slots[1] == null || this.slots[1].func_77973_b() instanceof ItemFuelRod) && this.slots[1] != null || (this.slots[2] == null || this.slots[2].func_77973_b() instanceof ItemFuelRod) && this.slots[2] != null || (this.slots[3] == null || this.slots[3].func_77973_b() instanceof ItemFuelRod) && this.slots[3] != null || (this.slots[4] == null || this.slots[4].func_77973_b() instanceof ItemFuelRod) && this.slots[4] != null || (this.slots[5] == null || this.slots[5].func_77973_b() instanceof ItemFuelRod) && this.slots[5] != null || (this.slots[6] == null || this.slots[6].func_77973_b() instanceof ItemFuelRod) && this.slots[6] != null || (this.slots[7] == null || this.slots[7].func_77973_b() instanceof ItemFuelRod) && this.slots[7] != null || (this.slots[8] == null || this.slots[8].func_77973_b() instanceof ItemFuelRod) && this.slots[8] != null)) {
                if (this.heat - 10 >= 0 && this.tanks[1].getFill() - 2 >= 0) {
                    this.heat -= 10;
                    this.tanks[1].setFill(this.tanks[1].getFill() - 2);
                }
                if (this.heat < 10 && this.heat != 0 && this.tanks[1].getFill() != 0) {
                    --this.heat;
                    this.tanks[1].setFill(this.tanks[1].getFill() - 1);
                }
                if (this.heat != 0 && this.tanks[1].getFill() == 0) {
                    --this.heat;
                }
                if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof MachineGenerator) {
                    this.isLoaded = false;
                }
            } else if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof MachineGenerator) {
                this.isLoaded = true;
            }
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
        }
    }

    public void attemptPower(int i) {
        int j = (int)Math.ceil(i / 100);
        if (this.tanks[0].getFill() - j >= 0) {
            this.power += (long)i;
            if (j > this.tanks[0].getMaxFill() / 25) {
                j = this.tanks[0].getMaxFill() / 25;
            }
            this.tanks[0].setFill(this.tanks[0].getFill() - j);
        }
    }

    public void attemptHeat(int i) {
        Random rand = new Random();
        int j = rand.nextInt(i + 1);
        if (this.tanks[1].getFill() - j >= 0) {
            this.tanks[1].setFill(this.tanks[1].getFill() - j);
        } else {
            this.heat += i;
        }
    }

    public void explode() {
        for (int i = 0; i < this.slots.length; ++i) {
            this.slots[i] = null;
        }
        this.field_145850_b.func_72876_a(null, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 18.0f, true);
        ExplosionNukeGeneric.waste(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e, 35);
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d, this.field_145849_e, (Block)Blocks.field_150356_k);
    }

    @Override
    public void ffgeua(int x, int y, int z, boolean newTact) {
        Library.ffgeua(x, y, z, newTact, this, this.field_145850_b);
    }

    @Override
    public void ffgeuaInit() {
        this.ffgeua(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, this.getTact());
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public long getSPower() {
        return this.power;
    }

    @Override
    public void setSPower(long i) {
        this.power = i;
    }

    @Override
    public List<IConsumer> getList() {
        return this.list;
    }

    @Override
    public void clearList() {
        this.list.clear();
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getMaxFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getMaxFill();
        }
        return 0;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(i);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        return 0;
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tanks[0]);
        list.add(this.tanks[1]);
        return list;
    }
}

