/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.ISource;
import com.hbm.inventory.FluidContainerRegistry;
import com.hbm.inventory.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.tileentity.TileEntityMachineBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;

public class TileEntityMachineDiesel
extends TileEntityMachineBase
implements ISource,
IFluidContainer,
IFluidAcceptor {
    public long power;
    public int soundCycle = 0;
    public static final long maxPower = 50000L;
    public long powerCap = 50000L;
    public int age = 0;
    public List<IConsumer> list = new ArrayList<IConsumer>();
    public FluidTank tank = new FluidTank(FluidTypeHandler.FluidType.DIESEL, 16000, 0);
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{1, 2};
    private static final int[] slots_side = new int[]{2};

    public TileEntityMachineDiesel() {
        super(5);
    }

    @Override
    public String getName() {
        return "container.machineDiesel";
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        if (i == 0 && FluidContainerRegistry.getFluidContent(stack, this.tank.getTankType()) > 0) {
            return true;
        }
        return i == 2 && stack.func_77973_b() instanceof IBatteryItem;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("powerTime");
        this.powerCap = nbt.func_74763_f("powerCap");
        this.tank.readFromNBT(nbt, "fuel");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        nbt.func_74772_a("powerCap", this.powerCap);
        this.tank.writeToNBT(nbt, "fuel");
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        if (i == 1 && (itemStack.func_77973_b() == ModItems.canister_empty || itemStack.func_77973_b() == ModItems.tank_steel)) {
            return true;
        }
        return i == 2 && itemStack.func_77973_b() instanceof IBatteryItem && ((IBatteryItem)itemStack.func_77973_b()).getCharge(itemStack) == ((IBatteryItem)itemStack.func_77973_b()).getMaxCharge();
    }

    public long getPowerScaled(long i) {
        return this.power * i / this.powerCap;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.ffgeuaInit();
            }
            this.tank.setType(3, 4, this.slots);
            this.tank.loadTank(0, 1, this.slots);
            this.tank.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            FluidTypeHandler.FluidType type = this.tank.getTankType();
            this.powerCap = type.name().equals(FluidTypeHandler.FluidType.NITAN.name()) ? 500000L : 50000L;
            this.power = Library.chargeItemsFromTE(this.slots, 2, this.power, this.powerCap);
            this.generate();
            NBTTagCompound data = new NBTTagCompound();
            data.func_74768_a("power", (int)this.power);
            data.func_74768_a("powerCap", (int)this.powerCap);
            this.networkPack(data, 50);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74762_e("power");
        this.powerCap = data.func_74762_e("powerCap");
    }

    public boolean hasAcceptableFuel() {
        return this.getHEFromFuel() > 0;
    }

    public int getHEFromFuel() {
        FluidTypeHandler.FluidType type = this.tank.getTankType();
        if (type.name().equals(FluidTypeHandler.FluidType.HYDROGEN.name())) {
            return 10;
        }
        if (type.name().equals(FluidTypeHandler.FluidType.DIESEL.name())) {
            return 500;
        }
        if (type.name().equals(FluidTypeHandler.FluidType.PETROIL.name())) {
            return 300;
        }
        if (type.name().equals(FluidTypeHandler.FluidType.BIOFUEL.name())) {
            return 400;
        }
        if (type.name().equals(FluidTypeHandler.FluidType.NITAN.name())) {
            return 5000;
        }
        return 0;
    }

    public void generate() {
        if (this.hasAcceptableFuel() && this.tank.getFill() > 0) {
            if (this.soundCycle == 0) {
                this.field_145850_b.func_72908_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, "fireworks.blast", 1.5f * this.getVolume(3), 0.5f);
            }
            ++this.soundCycle;
            if (this.soundCycle >= 3) {
                this.soundCycle = 0;
            }
            this.tank.setFill(this.tank.getFill() - 10);
            if (this.tank.getFill() < 0) {
                this.tank.setFill(0);
            }
            this.power = this.power + (long)this.getHEFromFuel() <= this.powerCap ? (this.power += (long)this.getHEFromFuel()) : this.powerCap;
        }
    }

    @Override
    public void ffgeua(int x, int y, int z, boolean newTact) {
        Library.ffgeua(x, y, z, newTact, this, this.field_145850_b);
    }

    @Override
    public void ffgeuaInit() {
        this.ffgeua(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, this.getTact());
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public long getSPower() {
        return this.power;
    }

    @Override
    public void setSPower(long i) {
        this.power = i;
    }

    @Override
    public List<IConsumer> getList() {
        return this.list;
    }

    @Override
    public void clearList() {
        this.list.clear();
    }

    @Override
    public void setFillstate(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        this.tank.setTankType(type);
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        return type.name().equals(this.tank.getTankType().name()) ? this.tank.getMaxFill() : 0;
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        return type.name().equals(this.tank.getTankType().name()) ? this.tank.getFill() : 0;
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tank.getTankType().name())) {
            this.tank.setFill(i);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tank);
        return list;
    }
}

