/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.interfaces.IConsumer;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Items;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;

public class TileEntityMachineDeuterium
extends TileEntity
implements ISidedInventory,
IConsumer {
    private ItemStack[] slots = new ItemStack[5];
    public long power = 0L;
    public int water = 0;
    public int sulfur = 0;
    public int process = 0;
    public static final int maxFill = 1000;
    public static final long maxPower = 100000L;
    public static final int processSpeed = 200;
    private static final int[] slots_top = new int[]{3};
    private static final int[] slots_bottom = new int[]{4, 0, 1};
    private static final int[] slots_side = new int[]{0, 1, 2};
    private String customName;

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.machine_deuterium";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) != this) {
            return false;
        }
        return player.func_70092_e((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5) <= 64.0;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack stack) {
        switch (i) {
            case 1: {
                if (stack.func_77973_b() != ModItems.rod_water && stack.func_77973_b() != ModItems.rod_dual_water && stack.func_77973_b() != ModItems.rod_quad_water && stack.func_77973_b() != Items.field_151131_as) break;
                return true;
            }
            case 2: {
                if (stack.func_77973_b() != ModItems.sulfur) break;
                return true;
            }
            case 3: {
                if (stack.func_77973_b() != ModItems.cell_empty) break;
                return true;
            }
        }
        return false;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("power");
        this.water = nbt.func_74762_e("water");
        this.sulfur = nbt.func_74762_e("sulfur");
        this.process = nbt.func_74762_e("process");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74768_a("water", this.water);
        nbt.func_74768_a("sulfur", this.sulfur);
        nbt.func_74768_a("process", this.process);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        if (i == 4) {
            return true;
        }
        return i == 1 && (itemStack.func_77973_b() == Items.field_151133_ar || itemStack.func_77973_b() == ModItems.rod_empty || itemStack.func_77973_b() == ModItems.rod_dual_empty || itemStack.func_77973_b() == ModItems.rod_quad_empty);
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    public int getWaterScaled(int i) {
        return this.water * i / 1000;
    }

    public int getSulfurScaled(int i) {
        return this.sulfur * i / 1000;
    }

    public int getProgressScaled(int i) {
        return this.process * i / 200;
    }

    public boolean canProcess() {
        return this.water != 0 && this.power != 0L && this.sulfur != 0 && this.slots[3] != null && this.slots[3].func_77973_b() == ModItems.cell_empty && (this.slots[4] == null || this.slots[4] != null && this.slots[4].field_77994_a < 64);
    }

    public boolean isProcessing() {
        return this.process > 0;
    }

    public void process() {
        this.water -= 2;
        --this.sulfur;
        this.power -= 25L;
        ++this.process;
        if (this.process >= 200) {
            --this.slots[3].field_77994_a;
            if (this.slots[3].field_77994_a == 0) {
                this.slots[3] = null;
            }
            if (this.slots[4] == null) {
                this.slots[4] = new ItemStack(ModItems.cell_deuterium);
            } else {
                ++this.slots[4].field_77994_a;
            }
            this.process = 0;
        }
    }

    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            if (this.slots[2] != null && this.slots[2].func_77973_b() == ModItems.sulfur && this.sulfur + 125 <= 1000) {
                this.sulfur += 125;
                --this.slots[2].field_77994_a;
                if (this.slots[2].field_77994_a == 0) {
                    this.slots[2] = null;
                }
            }
            if (this.slots[1] != null && this.slots[1].func_77973_b() == Items.field_151131_as && this.water + 250 <= 1000) {
                this.water += 250;
                --this.slots[1].field_77994_a;
                if (this.slots[1].field_77994_a == 0) {
                    this.slots[1] = this.slots[1].func_77973_b().getContainerItem(this.slots[1]);
                }
            }
            if (this.slots[1] != null && this.slots[1].func_77973_b() == ModItems.rod_water && this.water + 250 <= 1000) {
                this.water += 250;
                --this.slots[1].field_77994_a;
                if (this.slots[1].field_77994_a == 0) {
                    this.slots[1] = this.slots[1].func_77973_b().getContainerItem(this.slots[1]);
                }
            }
            if (this.slots[1] != null && this.slots[1].func_77973_b() == ModItems.rod_dual_water && this.water + 500 <= 1000) {
                this.water += 500;
                --this.slots[1].field_77994_a;
                if (this.slots[1].field_77994_a == 0) {
                    this.slots[1] = this.slots[1].func_77973_b().getContainerItem(this.slots[1]);
                }
            }
            if (this.slots[1] != null && this.slots[1].func_77973_b() == ModItems.rod_quad_water && this.water + 1000 <= 1000) {
                this.water += 1000;
                --this.slots[1].field_77994_a;
                if (this.slots[1].field_77994_a == 0) {
                    this.slots[1] = this.slots[1].func_77973_b().getContainerItem(this.slots[1]);
                }
            }
            if (this.slots[1] != null && this.slots[1].func_77973_b() == ModItems.inf_water) {
                this.water = 1000;
            }
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 100000L);
            if (this.canProcess()) {
                this.process();
            } else {
                this.process = 0;
            }
        }
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }
}

