/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.inventory.CrystallizerRecipes;
import com.hbm.inventory.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemMachineUpgrade;
import com.hbm.lib.Library;
import com.hbm.tileentity.TileEntityMachineBase;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityMachineCrystallizer
extends TileEntityMachineBase
implements IConsumer,
IFluidAcceptor {
    public long power;
    public static final long maxPower = 1000000L;
    public static final int demand = 1000;
    public static final int acidRequired = 500;
    public short progress;
    public static final short duration = 600;
    public float angle;
    public float prevAngle;
    public FluidTank tank = new FluidTank(FluidTypeHandler.FluidType.ACID, 8000, 0);

    public TileEntityMachineCrystallizer() {
        super(7);
    }

    @Override
    public String getName() {
        return "container.crystallizer";
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 1, this.power, 1000000L);
            this.tank.loadTank(3, 4, this.slots);
            int i = 0;
            while ((float)i < this.getCycleCount()) {
                if (this.canProcess()) {
                    this.progress = (short)(this.progress + 1);
                    this.power -= (long)this.getPowerRequired();
                    if (this.progress > this.getDuration()) {
                        this.progress = 0;
                        this.tank.setFill(this.tank.getFill() - this.getRequiredAcid());
                        this.processItem();
                        this.func_70296_d();
                    }
                } else {
                    this.progress = 0;
                }
                ++i;
            }
            this.tank.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            NBTTagCompound data = new NBTTagCompound();
            data.func_74777_a("progress", this.progress);
            data.func_74772_a("power", this.power);
            this.networkPack(data, 25);
        } else {
            this.prevAngle = this.angle;
            if (this.progress > 0) {
                this.angle += 5.0f * this.getCycleCount();
                if (this.angle >= 360.0f) {
                    this.angle -= 360.0f;
                    this.prevAngle -= 360.0f;
                }
            }
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.power = data.func_74763_f("power");
        this.progress = data.func_74765_d("progress");
    }

    private void processItem() {
        ItemStack result = CrystallizerRecipes.getOutput(this.slots[0]);
        if (result == null) {
            return;
        }
        if (this.slots[2] == null) {
            this.slots[2] = result;
        } else if (this.slots[2].field_77994_a + result.field_77994_a <= this.slots[2].func_77976_d()) {
            this.slots[2].field_77994_a += result.field_77994_a;
        }
        float freeChance = this.getFreeChance();
        if (freeChance == 0.0f || freeChance < this.field_145850_b.field_73012_v.nextFloat()) {
            this.func_70298_a(0, 1);
        }
    }

    private boolean canProcess() {
        if (this.slots[0] == null) {
            return false;
        }
        if (this.power < (long)this.getPowerRequired()) {
            return false;
        }
        if (this.tank.getFill() < this.getRequiredAcid()) {
            return false;
        }
        ItemStack result = CrystallizerRecipes.getOutput(this.slots[0]);
        if (result == null) {
            return false;
        }
        if (this.slots[2] != null && (this.slots[2].func_77973_b() != result.func_77973_b() || this.slots[2].func_77960_j() != result.func_77960_j())) {
            return false;
        }
        return this.slots[2] == null || this.slots[2].field_77994_a < this.slots[2].func_77976_d();
    }

    public int getRequiredAcid() {
        int extra = 0;
        for (int i = 5; i <= 6; ++i) {
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_effect_1) {
                extra += 1000;
            }
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_effect_2) {
                extra += 2000;
            }
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.upgrade_effect_3) continue;
            extra += 3000;
        }
        return 500 + Math.min(extra, 3000);
    }

    public float getFreeChance() {
        float chance = 0.0f;
        for (int i = 5; i <= 6; ++i) {
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_effect_1) {
                chance += 0.05f;
            }
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_effect_2) {
                chance += 0.1f;
            }
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.upgrade_effect_3) continue;
            chance += 0.15f;
        }
        return Math.min(chance, 0.15f);
    }

    public int getDuration() {
        float durationMod = 1.0f;
        for (int i = 5; i <= 6; ++i) {
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_speed_1) {
                durationMod -= 0.1f;
            }
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_speed_2) {
                durationMod -= 0.2f;
            }
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.upgrade_speed_3) continue;
            durationMod -= 0.3f;
        }
        return (int)(600.0f * Math.max(durationMod, 0.7f));
    }

    public int getPowerRequired() {
        int consumption = 0;
        for (int i = 5; i <= 6; ++i) {
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_speed_1) {
                consumption += 1000;
            }
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_speed_2) {
                consumption += 2000;
            }
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.upgrade_speed_3) continue;
            consumption += 3000;
        }
        return 1000 + Math.min(consumption, 3000);
    }

    public float getCycleCount() {
        int cycles = 1;
        for (int i = 5; i <= 6; ++i) {
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_overdrive_1) {
                ++cycles;
            }
            if (this.slots[i] != null && this.slots[i].func_77973_b() == ModItems.upgrade_overdrive_2) {
                cycles += 2;
            }
            if (this.slots[i] == null || this.slots[i].func_77973_b() != ModItems.upgrade_overdrive_3) continue;
            cycles += 3;
        }
        return Math.min(cycles, 4);
    }

    public long getPowerScaled(int i) {
        return this.power * (long)i / 1000000L;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / 600;
    }

    @Override
    public void setFillstate(int fill, int index) {
        this.tank.setFill(fill);
    }

    @Override
    public void setFluidFill(int fill, FluidTypeHandler.FluidType type) {
        this.tank.setFill(fill);
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        this.tank.setTankType(type);
    }

    @Override
    public List<FluidTank> getTanks() {
        return new ArrayList(){
            {
                this.add(TileEntityMachineCrystallizer.this.tank);
            }
        };
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        return this.tank.getFill();
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        return this.tank.getMaxFill();
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 1000000L;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.tank.readFromNBT(nbt, "tank");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tank.writeToNBT(nbt, "tank");
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i == 0 && CrystallizerRecipes.getOutput(itemStack) != null) {
            return true;
        }
        return i == 1 && itemStack.func_77973_b() instanceof IBatteryItem;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 2;
    }

    @Override
    public int[] func_94128_d(int side) {
        int[] nArray;
        if (side == 0) {
            int[] nArray2 = new int[1];
            nArray = nArray2;
            nArray2[0] = 2;
        } else {
            int[] nArray3 = new int[2];
            nArray3[0] = 0;
            nArray = nArray3;
            nArray3[1] = 2;
        }
        return nArray;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return TileEntity.INFINITE_EXTENT_AABB;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public void func_70299_a(int i, ItemStack stack) {
        super.func_70299_a(i, stack);
        if (stack != null && i >= 5 && i <= 6 && stack.func_77973_b() instanceof ItemMachineUpgrade) {
            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:item.upgradePlug", 1.0f, 1.0f);
        }
    }
}

