/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import com.hbm.blocks.machine.MachineBattery;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.ISource;
import com.hbm.lib.Library;
import com.hbm.tileentity.TileEntityMachineBase;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;

public class TileEntityMachineBattery
extends TileEntityMachineBase
implements IConsumer,
ISource {
    public long power = 0L;
    public long maxPower = 1000000L;
    public short redLow = 0;
    public short redHigh = (short)2;
    public boolean conducts = false;
    private static final int[] slots_top = new int[]{0};
    private static final int[] slots_bottom = new int[]{0, 1};
    private static final int[] slots_side = new int[]{1};
    public int age = 0;
    public List<IConsumer> list = new ArrayList<IConsumer>();
    private String customName;

    public TileEntityMachineBattery() {
        super(2);
        this.slots = new ItemStack[2];
    }

    public TileEntityMachineBattery(long maxPower) {
        super(2);
        this.slots = new ItemStack[2];
        this.maxPower = maxPower;
    }

    @Override
    public String getName() {
        return "container.battery";
    }

    @Override
    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : this.getName();
    }

    @Override
    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    @Override
    public void setCustomName(String name) {
        this.customName = name;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack stack) {
        switch (i) {
            case 0: {
                if (!(stack.func_77973_b() instanceof IBatteryItem)) break;
                return true;
            }
            case 1: {
                if (!(stack.func_77973_b() instanceof IBatteryItem)) break;
                return true;
            }
        }
        return true;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("power");
        this.redLow = nbt.func_74765_d("redLow");
        this.redHigh = nbt.func_74765_d("redHigh");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74777_a("redLow", this.redLow);
        nbt.func_74777_a("redHigh", this.redHigh);
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return p_94128_1_ == 0 ? slots_bottom : (p_94128_1_ == 1 ? slots_top : slots_side);
    }

    @Override
    public boolean func_102007_a(int i, ItemStack itemStack, int j) {
        return this.func_94041_b(i, itemStack);
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        if (itemStack.func_77973_b() instanceof IBatteryItem) {
            if (i == 0 && ((IBatteryItem)itemStack.func_77973_b()).getCharge(itemStack) == 0L) {
                return true;
            }
            if (i == 1 && ((IBatteryItem)itemStack.func_77973_b()).getCharge(itemStack) == ((IBatteryItem)itemStack.func_77973_b()).getMaxCharge()) {
                return true;
            }
        }
        return false;
    }

    public long getPowerRemainingScaled(long i) {
        return this.power * i / this.maxPower;
    }

    @Override
    public void func_145845_h() {
        if (this.field_145850_b.func_147439_a(this.field_145851_c, this.field_145848_d, this.field_145849_e) instanceof MachineBattery && !this.field_145850_b.field_72995_K) {
            this.maxPower = ((MachineBattery)this.field_145850_b.func_147439_a((int)this.field_145851_c, (int)this.field_145848_d, (int)this.field_145849_e)).maxPower;
            short mode = this.getRelevantMode();
            if (mode == 1 || mode == 2) {
                ++this.age;
                if (this.age >= 20) {
                    this.age = 0;
                }
                if (this.age == 9 || this.age == 19) {
                    this.ffgeuaInit();
                }
            }
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, this.maxPower);
            this.power = Library.chargeItemsFromTE(this.slots, 1, this.power, this.maxPower);
            NBTTagCompound nbt = new NBTTagCompound();
            nbt.func_74772_a("power", this.power);
            nbt.func_74772_a("maxPower", this.maxPower);
            nbt.func_74777_a("redLow", this.redLow);
            nbt.func_74777_a("redHigh", this.redHigh);
            this.networkPack(nbt, 20);
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.maxPower = nbt.func_74763_f("maxPower");
        this.redLow = nbt.func_74765_d("redLow");
        this.redHigh = nbt.func_74765_d("redHigh");
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public void ffgeua(int x, int y, int z, boolean newTact) {
        Library.ffgeua(x, y, z, newTact, this, this.field_145850_b);
    }

    @Override
    public void ffgeuaInit() {
        this.ffgeua(this.field_145851_c, this.field_145848_d + 1, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d - 1, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e - 1, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d, this.field_145849_e + 1, this.getTact());
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    public short getRelevantMode() {
        if (this.field_145850_b.func_72864_z(this.field_145851_c, this.field_145848_d, this.field_145849_e)) {
            return this.redHigh;
        }
        return this.redLow;
    }

    @Override
    public long getMaxPower() {
        if (!this.field_145850_b.field_72995_K && this.getRelevantMode() >= 2) {
            return 0L;
        }
        return this.maxPower;
    }

    @Override
    public long getSPower() {
        return this.power;
    }

    @Override
    public void setSPower(long i) {
        this.power = i;
    }

    @Override
    public List<IConsumer> getList() {
        return this.list;
    }

    @Override
    public void clearList() {
        this.list.clear();
    }
}

