/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import api.hbm.energy.IBatteryItem;
import com.hbm.blocks.ModBlocks;
import com.hbm.interfaces.IConsumer;
import com.hbm.inventory.AssemblerRecipes;
import com.hbm.inventory.RecipesCommon;
import com.hbm.items.ModItems;
import com.hbm.items.machine.ItemAssemblyTemplate;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.sound.AudioWrapper;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityCrateIron;
import com.hbm.tileentity.machine.TileEntityCrateSteel;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityChest;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraft.util.AxisAlignedBB;

public class TileEntityMachineAssembler
extends TileEntityMachineBase
implements IConsumer {
    public long power;
    public static final long maxPower = 100000L;
    public int progress;
    public int maxProgress = 100;
    public boolean isProgressing;
    int age = 0;
    int consumption = 100;
    int speed = 100;
    @SideOnly(value=Side.CLIENT)
    public int recipe;
    private AudioWrapper audio;
    Random rand = new Random();

    public TileEntityMachineAssembler() {
        super(18);
    }

    @Override
    public String getName() {
        return "container.assembler";
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        if (i == 0 && itemStack.func_77973_b() instanceof IBatteryItem) {
            return true;
        }
        return i == 1;
    }

    @Override
    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("powerTime");
        this.progress = nbt.func_74762_e("progress");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("powerTime", this.power);
        nbt.func_74768_a("progress", this.progress);
    }

    public long getPowerScaled(long i) {
        return this.power * i / 100000L;
    }

    public int getProgressScaled(int i) {
        return this.progress * i / this.maxProgress;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            IInventory chest;
            this.consumption = 100;
            this.speed = 100;
            for (int i = 1; i < 4; ++i) {
                ItemStack stack = this.slots[i];
                if (stack == null) continue;
                if (stack.func_77973_b() == ModItems.upgrade_speed_1) {
                    this.speed -= 25;
                    this.consumption += 300;
                }
                if (stack.func_77973_b() == ModItems.upgrade_speed_2) {
                    this.speed -= 50;
                    this.consumption += 600;
                }
                if (stack.func_77973_b() == ModItems.upgrade_speed_3) {
                    this.speed -= 75;
                    this.consumption += 900;
                }
                if (stack.func_77973_b() == ModItems.upgrade_power_1) {
                    this.consumption -= 30;
                    this.speed += 5;
                }
                if (stack.func_77973_b() == ModItems.upgrade_power_2) {
                    this.consumption -= 60;
                    this.speed += 10;
                }
                if (stack.func_77973_b() != ModItems.upgrade_power_3) continue;
                this.consumption -= 90;
                this.speed += 15;
            }
            if (this.speed < 25) {
                this.speed = 25;
            }
            if (this.consumption < 10) {
                this.consumption = 10;
            }
            this.isProgressing = false;
            this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 100000L);
            if (AssemblerRecipes.getOutputFromTempate(this.slots[4]) != null && AssemblerRecipes.getRecipeFromTempate(this.slots[4]) != null) {
                this.maxProgress = ItemAssemblyTemplate.getProcessTime(this.slots[4]) * this.speed / 100;
                if (this.power >= (long)this.consumption && this.removeItems(AssemblerRecipes.getRecipeFromTempate(this.slots[4]), this.cloneItemStackProper(this.slots))) {
                    if (this.slots[5] == null || this.slots[5] != null && this.slots[5].func_77973_b() == AssemblerRecipes.getOutputFromTempate(this.slots[4]).func_77946_l().func_77973_b() && this.slots[5].field_77994_a + AssemblerRecipes.getOutputFromTempate((ItemStack)this.slots[4]).func_77946_l().field_77994_a <= this.slots[5].func_77976_d()) {
                        ++this.progress;
                        this.isProgressing = true;
                        if (this.progress >= this.maxProgress) {
                            this.progress = 0;
                            if (this.slots[5] == null) {
                                this.slots[5] = AssemblerRecipes.getOutputFromTempate(this.slots[4]).func_77946_l();
                            } else {
                                this.slots[5].field_77994_a += AssemblerRecipes.getOutputFromTempate((ItemStack)this.slots[4]).func_77946_l().field_77994_a;
                            }
                            this.removeItems(AssemblerRecipes.getRecipeFromTempate(this.slots[4]), this.slots);
                            if (this.slots[0] != null && this.slots[0].func_77973_b() == ModItems.meteorite_sword_alloyed) {
                                this.slots[0] = new ItemStack(ModItems.meteorite_sword_machined);
                            }
                        }
                        this.power -= (long)this.consumption;
                    }
                } else {
                    this.progress = 0;
                }
            } else {
                this.progress = 0;
            }
            int meta = this.field_145850_b.func_72805_g(this.field_145851_c, this.field_145848_d, this.field_145849_e);
            TileEntity te1 = null;
            TileEntity te2 = null;
            if (meta == 2) {
                te1 = this.field_145850_b.func_147438_o(this.field_145851_c - 2, this.field_145848_d, this.field_145849_e);
                te2 = this.field_145850_b.func_147438_o(this.field_145851_c + 3, this.field_145848_d, this.field_145849_e - 1);
            }
            if (meta == 3) {
                te1 = this.field_145850_b.func_147438_o(this.field_145851_c + 2, this.field_145848_d, this.field_145849_e);
                te2 = this.field_145850_b.func_147438_o(this.field_145851_c - 3, this.field_145848_d, this.field_145849_e + 1);
            }
            if (meta == 4) {
                te1 = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e + 2);
                te2 = this.field_145850_b.func_147438_o(this.field_145851_c - 1, this.field_145848_d, this.field_145849_e - 3);
            }
            if (meta == 5) {
                te1 = this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e - 2);
                te2 = this.field_145850_b.func_147438_o(this.field_145851_c + 1, this.field_145848_d, this.field_145849_e + 3);
            }
            this.tryExchangeTemplates(te1, te2);
            if (te1 instanceof IInventory) {
                chest = (IInventory)te1;
                this.tryFillContainer(chest, 5);
            }
            if (te2 instanceof IInventory) {
                chest = (IInventory)te2;
                for (int i = 0; i < chest.func_70302_i_() && !this.tryFillAssembler(chest, i); ++i) {
                }
            }
            NBTTagCompound data = new NBTTagCompound();
            data.func_74772_a("power", this.power);
            data.func_74768_a("progress", this.progress);
            data.func_74768_a("maxProgress", this.maxProgress);
            data.func_74757_a("isProgressing", this.isProgressing);
            data.func_74768_a("recipe", this.slots[4] != null ? this.slots[4].func_77960_j() : -1);
            this.networkPack(data, 150);
        } else {
            float volume = this.getVolume(2);
            if (this.isProgressing && volume > 0.0f) {
                if (this.audio == null) {
                    this.audio = MainRegistry.proxy.getLoopedSound("hbm:block.assemblerOperate", this.field_145851_c, this.field_145848_d, this.field_145849_e, volume, 1.0f);
                    this.audio.startSound();
                }
            } else if (this.audio != null) {
                this.audio.stopSound();
                this.audio = null;
            }
        }
    }

    public void onChunkUnload() {
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    public void func_145843_s() {
        super.func_145843_s();
        if (this.audio != null) {
            this.audio.stopSound();
            this.audio = null;
        }
    }

    @Override
    public void networkUnpack(NBTTagCompound nbt) {
        this.power = nbt.func_74763_f("power");
        this.progress = nbt.func_74762_e("progress");
        this.maxProgress = nbt.func_74762_e("maxProgress");
        this.isProgressing = nbt.func_74767_n("isProgressing");
        this.recipe = nbt.func_74762_e("recipe");
    }

    private boolean removeItems(List<RecipesCommon.AStack> stack, ItemStack[] array) {
        if (stack == null) {
            return false;
        }
        for (int i = 0; i < stack.size(); ++i) {
            for (int j = 0; j < stack.get((int)i).stacksize; ++j) {
                RecipesCommon.AStack sta = stack.get(i).copy();
                sta.stacksize = 1;
                if (this.canRemoveItemFromArray(sta, array)) continue;
                return false;
            }
        }
        return true;
    }

    public boolean canRemoveItemFromArray(RecipesCommon.AStack stack, ItemStack[] array) {
        RecipesCommon.AStack st = stack.copy();
        if (st == null) {
            return true;
        }
        for (int i = 6; i < 18; ++i) {
            if (array[i] == null) continue;
            ItemStack sta = array[i].func_77946_l();
            sta.field_77994_a = 1;
            if (sta == null || !st.isApplicable(sta) || array[i].field_77994_a <= 0) continue;
            --array[i].field_77994_a;
            if (array[i].field_77994_a <= 0) {
                array[i] = null;
            }
            return true;
        }
        return false;
    }

    public boolean tryExchangeTemplates(TileEntity te1, TileEntity te2) {
        boolean te1Valid = this.validateTe(te1);
        boolean te2Valid = this.validateTe(te2);
        if (te1Valid && te2Valid) {
            int i;
            IInventory iTe1 = (IInventory)te1;
            IInventory iTe2 = (IInventory)te2;
            boolean openSlot = false;
            boolean existingTemplate = false;
            boolean filledContainer = false;
            for (i = 0; i < iTe1.func_70302_i_(); ++i) {
                if (iTe1.func_70301_a(i) != null) continue;
                openSlot = true;
            }
            if (this.slots[4] != null) {
                existingTemplate = true;
            }
            for (i = 0; i < iTe2.func_70302_i_(); ++i) {
                if (iTe2.func_70301_a(i) == null || !(iTe2.func_70301_a(i).func_77973_b() instanceof ItemAssemblyTemplate)) continue;
                if (openSlot && existingTemplate) {
                    filledContainer = this.tryFillContainer(iTe1, 4);
                }
                if (!filledContainer) continue;
                ItemStack copy = iTe2.func_70301_a(i).func_77946_l();
                iTe2.func_70299_a(i, null);
                this.slots[4] = copy;
            }
        }
        return false;
    }

    private boolean validateTe(TileEntity te) {
        if (te instanceof TileEntityChest) {
            return true;
        }
        if (te instanceof TileEntityHopper) {
            return true;
        }
        if (te instanceof TileEntityCrateIron) {
            return true;
        }
        return te instanceof TileEntityCrateSteel;
    }

    public ItemStack[] cloneItemStackProper(ItemStack[] array) {
        ItemStack[] stack = new ItemStack[array.length];
        for (int i = 0; i < array.length; ++i) {
            stack[i] = array[i] != null ? array[i].func_77946_l() : null;
        }
        return stack;
    }

    public boolean tryFillContainer(IInventory inventory, int slot) {
        int i;
        int size = inventory.func_70302_i_();
        for (i = 0; i < size; ++i) {
            if (inventory.func_70301_a(i) == null) continue;
            if (this.slots[slot] == null) {
                return false;
            }
            ItemStack sta1 = inventory.func_70301_a(i).func_77946_l();
            ItemStack sta2 = this.slots[slot].func_77946_l();
            if (sta1 == null || sta2 == null) continue;
            sta1.field_77994_a = 1;
            sta2.field_77994_a = 1;
            if (!ItemStack.func_77989_b((ItemStack)sta1, (ItemStack)sta2) || !ItemStack.func_77970_a((ItemStack)sta1, (ItemStack)sta2) || inventory.func_70301_a((int)i).field_77994_a >= inventory.func_70301_a(i).func_77976_d()) continue;
            --this.slots[slot].field_77994_a;
            if (this.slots[slot].field_77994_a <= 0) {
                this.slots[slot] = null;
            }
            ItemStack sta3 = inventory.func_70301_a(i).func_77946_l();
            ++sta3.field_77994_a;
            inventory.func_70299_a(i, sta3);
            return true;
        }
        for (i = 0; i < size; ++i) {
            if (this.slots[slot] == null) {
                return false;
            }
            ItemStack sta2 = this.slots[slot].func_77946_l();
            if (inventory.func_70301_a(i) != null || sta2 == null) continue;
            sta2.field_77994_a = 1;
            --this.slots[slot].field_77994_a;
            if (this.slots[slot].field_77994_a <= 0) {
                this.slots[slot] = null;
            }
            inventory.func_70299_a(i, sta2);
            return true;
        }
        return false;
    }

    public boolean tryFillAssembler(IInventory inventory, int slot) {
        int i;
        if (AssemblerRecipes.getOutputFromTempate(this.slots[4]) == null || AssemblerRecipes.getRecipeFromTempate(this.slots[4]) == null) {
            return false;
        }
        List<RecipesCommon.AStack> list = TileEntityMachineAssembler.copyItemStackList(AssemblerRecipes.getRecipeFromTempate(this.slots[4]));
        for (int i2 = 0; i2 < list.size(); ++i2) {
            list.get((int)i2).stacksize = 1;
        }
        if (inventory.func_70301_a(slot) == null) {
            return false;
        }
        ItemStack stack = inventory.func_70301_a(slot).func_77946_l();
        stack.field_77994_a = 1;
        boolean flag = false;
        for (int i3 = 0; i3 < list.size(); ++i3) {
            if (!list.get(i3).isApplicable(stack)) continue;
            flag = true;
        }
        if (!flag) {
            return false;
        }
        for (i = 6; i < 18; ++i) {
            if (this.slots[i] == null) continue;
            ItemStack sta1 = inventory.func_70301_a(slot).func_77946_l();
            ItemStack sta2 = this.slots[i].func_77946_l();
            if (sta1 == null || sta2 == null) continue;
            sta1.field_77994_a = 1;
            sta2.field_77994_a = 1;
            if (!sta1.func_77969_a(sta2) || this.slots[i].field_77994_a >= this.slots[i].func_77976_d()) continue;
            ItemStack sta3 = inventory.func_70301_a(slot).func_77946_l();
            --sta3.field_77994_a;
            if (sta3.field_77994_a <= 0) {
                sta3 = null;
            }
            inventory.func_70299_a(slot, sta3);
            ++this.slots[i].field_77994_a;
            return true;
        }
        for (i = 6; i < 18; ++i) {
            ItemStack sta2 = inventory.func_70301_a(slot).func_77946_l();
            if (this.slots[i] != null || sta2 == null) continue;
            sta2.field_77994_a = 1;
            this.slots[i] = sta2.func_77946_l();
            ItemStack sta3 = inventory.func_70301_a(slot).func_77946_l();
            --sta3.field_77994_a;
            if (sta3.field_77994_a <= 0) {
                sta3 = null;
            }
            inventory.func_70299_a(slot, sta3);
            return true;
        }
        return false;
    }

    public static List<RecipesCommon.AStack> copyItemStackList(List<RecipesCommon.AStack> list) {
        ArrayList<RecipesCommon.AStack> newList = new ArrayList<RecipesCommon.AStack>();
        if (list == null || list.isEmpty()) {
            return newList;
        }
        for (RecipesCommon.AStack stack : list) {
            newList.add(stack.copy());
        }
        return newList;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 100000L;
    }

    public AxisAlignedBB getRenderBoundingBox() {
        return AxisAlignedBB.func_72330_a((double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, (double)(this.field_145851_c + 1), (double)(this.field_145848_d + 1), (double)(this.field_145849_e + 1)).func_72314_b(2.0, 1.0, 2.0);
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    @Override
    public int countMufflers() {
        int count = 0;
        for (int x = this.field_145851_c - 1; x <= this.field_145851_c + 1; ++x) {
            for (int z = this.field_145849_e - 1; z <= this.field_145849_e + 1; ++z) {
                if (this.field_145850_b.func_147439_a(x, this.field_145848_d - 1, z) != ModBlocks.muffler) continue;
                ++count;
            }
        }
        return count;
    }
}

