/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.MachineITER;
import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidSource;
import com.hbm.inventory.BreederRecipes;
import com.hbm.inventory.FluidTank;
import com.hbm.inventory.FusionRecipes;
import com.hbm.items.ModItems;
import com.hbm.items.special.ItemFusionShield;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityITERStruct;
import cpw.mods.fml.relauncher.Side;
import cpw.mods.fml.relauncher.SideOnly;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.util.AxisAlignedBB;
import net.minecraft.util.Vec3;

public class TileEntityITER
extends TileEntityMachineBase
implements IConsumer,
IFluidAcceptor,
IFluidSource {
    public long power;
    public static final long maxPower = 10000000L;
    public static final int powerReq = 100000;
    public int age = 0;
    public List<IFluidAcceptor> list = new ArrayList<IFluidAcceptor>();
    public FluidTank[] tanks = new FluidTank[2];
    public FluidTank plasma;
    public int progress;
    public static final int duration = 100;
    @SideOnly(value=Side.CLIENT)
    public int blanket;
    public float rotor;
    public float lastRotor;
    public boolean isOn;
    AxisAlignedBB bb = null;

    public TileEntityITER() {
        super(5);
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.WATER, 1280000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.ULTRAHOTSTEAM, 128000, 1);
        this.plasma = new FluidTank(FluidTypeHandler.FluidType.PLASMA_DT, 16000, 2);
    }

    @Override
    public String getName() {
        return "container.machineITER";
    }

    @Override
    public void func_145845_h() {
        block29: {
            block26: {
                block27: {
                    block28: {
                        if (this.field_145850_b.field_72995_K) break block26;
                        ++this.age;
                        if (this.age >= 20) {
                            this.age = 0;
                        }
                        if (this.age == 9 || this.age == 19) {
                            this.fillFluidInit(this.tanks[1].getTankType());
                        }
                        this.power = Library.chargeTEFromItems(this.slots, 0, this.power, 10000000L);
                        if (!this.isOn) {
                            this.plasma.setFill(0);
                        }
                        if (this.plasma.getFill() <= 0) break block27;
                        if (this.plasma.getTankType().temperature >= this.getShield()) break block28;
                        if (!this.isOn) break block27;
                        if (this.power >= 100000L) break block27;
                    }
                    this.disassemble();
                    Vec3 vec = Vec3.func_72443_a((double)5.5, (double)0.0, (double)0.0);
                    vec.func_72442_b(this.field_145850_b.field_73012_v.nextFloat() * (float)Math.PI * 2.0f);
                    this.field_145850_b.func_72885_a(null, (double)this.field_145851_c + 0.5 + vec.field_72450_a, (double)this.field_145848_d + 0.5 + this.field_145850_b.field_73012_v.nextGaussian() * 1.5, (double)this.field_145849_e + 0.5 + vec.field_72449_c, 2.5f, true, true);
                }
                if (this.isOn && this.power >= 100000L) {
                    int chance;
                    this.power -= 100000L;
                    if (this.plasma.getFill() > 0 && (chance = FusionRecipes.getByproductChance(this.plasma.getTankType())) > 0 && this.field_145850_b.field_73012_v.nextInt(chance) == 0) {
                        this.produceByproduct();
                    }
                    if (this.plasma.getFill() > 0 && this.getShield() != 0) {
                        ItemFusionShield.setShieldDamage(this.slots[3], ItemFusionShield.getShieldDamage(this.slots[3]) + 1L);
                        if (ItemFusionShield.getShieldDamage(this.slots[3]) > ((ItemFusionShield)this.slots[3].func_77973_b()).field_77699_b) {
                            this.slots[3] = null;
                            this.field_145850_b.func_72908_a((double)this.field_145851_c + 0.5, (double)this.field_145848_d + 0.5, (double)this.field_145849_e + 0.5, "hbm:block.shutdown", 5.0f, 1.0f);
                            this.isOn = false;
                            this.func_70296_d();
                        }
                    }
                    int prod = FusionRecipes.getSteamProduction(this.plasma.getTankType());
                    for (int i = 0; i < 20; ++i) {
                        if (this.plasma.getFill() <= 0) continue;
                        if (this.tanks[0].getFill() >= prod * 10) {
                            this.tanks[0].setFill(this.tanks[0].getFill() - prod * 10);
                            this.tanks[1].setFill(this.tanks[1].getFill() + prod);
                            if (this.tanks[1].getFill() > this.tanks[1].getMaxFill()) {
                                this.tanks[1].setFill(this.tanks[1].getMaxFill());
                            }
                        }
                        this.plasma.setFill(this.plasma.getFill() - 1);
                    }
                }
                this.doBreederStuff();
                for (int i = 0; i < this.tanks.length; ++i) {
                    this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
                }
                this.plasma.updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
                NBTTagCompound data = new NBTTagCompound();
                data.func_74757_a("isOn", this.isOn);
                data.func_74772_a("power", this.power);
                data.func_74768_a("progress", this.progress);
                if (this.slots[3] == null) {
                    data.func_74768_a("blanket", 0);
                } else if (this.slots[3].func_77973_b() == ModItems.fusion_shield_tungsten) {
                    data.func_74768_a("blanket", 1);
                } else if (this.slots[3].func_77973_b() == ModItems.fusion_shield_desh) {
                    data.func_74768_a("blanket", 2);
                } else if (this.slots[3].func_77973_b() == ModItems.fusion_shield_chlorophyte) {
                    data.func_74768_a("blanket", 3);
                } else if (this.slots[3].func_77973_b() == ModItems.fusion_shield_vaporwave) {
                    data.func_74768_a("blanket", 4);
                }
                this.networkPack(data, 250);
                break block29;
            }
            this.lastRotor = this.rotor;
            if (this.isOn) {
                if (this.power >= 100000L) {
                    this.rotor += 15.0f;
                    if (this.rotor >= 360.0f) {
                        this.rotor -= 360.0f;
                        this.lastRotor -= 360.0f;
                    }
                }
            }
        }
    }

    private void doBreederStuff() {
        if (this.plasma.getFill() == 0) {
            this.progress = 0;
            return;
        }
        BreederRecipes.BreederRecipe out = BreederRecipes.getOutput(this.slots[1]);
        if (this.slots[1] != null && this.slots[1].func_77973_b() == ModItems.meteorite_sword_irradiated) {
            out = new BreederRecipes.BreederRecipe(ModItems.meteorite_sword_fused, 1);
        }
        if (this.slots[1] != null && this.slots[1].func_77973_b() == ModItems.meteorite_sword_fused) {
            out = new BreederRecipes.BreederRecipe(ModItems.meteorite_sword_baleful, 4);
        }
        if (out == null) {
            this.progress = 0;
            return;
        }
        if (this.slots[2] != null && this.slots[2].field_77994_a >= this.slots[2].func_77976_d()) {
            this.progress = 0;
            return;
        }
        int level = FusionRecipes.getBreedingLevel(this.plasma.getTankType());
        if (out.heat > level) {
            this.progress = 0;
            return;
        }
        ++this.progress;
        if (this.progress > 100) {
            if (this.slots[2] != null) {
                ++this.slots[2].field_77994_a;
            } else {
                this.slots[2] = out.output.func_77946_l();
            }
            --this.slots[1].field_77994_a;
            if (this.slots[1].field_77994_a <= 0) {
                this.slots[1] = null;
            }
            this.func_70296_d();
        }
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return true;
    }

    @Override
    public int[] func_94128_d(int p_94128_1_) {
        return new int[]{2, 4};
    }

    private void produceByproduct() {
        ItemStack by = FusionRecipes.getByproduct(this.plasma.getTankType());
        if (by == null) {
            return;
        }
        if (this.slots[4] == null) {
            this.slots[4] = by;
            return;
        }
        if (this.slots[4].func_77973_b() == by.func_77973_b() && this.slots[4].func_77960_j() == by.func_77960_j() && this.slots[4].field_77994_a < this.slots[4].func_77976_d()) {
            ++this.slots[4].field_77994_a;
        }
    }

    public int getShield() {
        if (this.slots[3] == null || !(this.slots[3].func_77973_b() instanceof ItemFusionShield)) {
            return 0;
        }
        return ((ItemFusionShield)this.slots[3].func_77973_b()).maxTemp;
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.isOn = data.func_74767_n("isOn");
        this.power = data.func_74763_f("power");
        this.blanket = data.func_74762_e("blanket");
        this.progress = data.func_74762_e("progress");
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (meta == 0) {
            this.isOn = !this.isOn;
        }
    }

    public long getPowerScaled(long i) {
        return this.power * i / 10000000L;
    }

    public long getProgressScaled(long i) {
        return (long)this.progress * i / 100L;
    }

    @Override
    public void setPower(long i) {
        this.power = i;
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 10000000L;
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
        if (index == 2) {
            this.plasma.setFill(fill);
        }
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            this.tanks[0].setFill(i);
        } else if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(i);
        } else if (type.name().equals(this.plasma.getTankType().name())) {
            this.plasma.setFill(i);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index < 2 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
        if (index == 2) {
            this.plasma.setTankType(type);
        }
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tanks[0]);
        list.add(this.tanks[1]);
        list.add(this.plasma);
        return list;
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        if (type.name().equals(this.plasma.getTankType().name())) {
            return this.plasma.getFill();
        }
        return 0;
    }

    @Override
    public void fillFluidInit(FluidTypeHandler.FluidType type) {
        this.fillFluid(this.field_145851_c, this.field_145848_d - 3, this.field_145849_e, this.getTact(), type);
        this.fillFluid(this.field_145851_c, this.field_145848_d + 3, this.field_145849_e, this.getTact(), type);
    }

    @Override
    public void fillFluid(int x, int y, int z, boolean newTact, FluidTypeHandler.FluidType type) {
        Library.transmitFluid(x, y, z, newTact, this, this.field_145850_b, type);
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public List<IFluidAcceptor> getFluidList(FluidTypeHandler.FluidType type) {
        return this.list;
    }

    @Override
    public void clearFluidList(FluidTypeHandler.FluidType type) {
        this.list.clear();
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[0].getTankType().name())) {
            return this.tanks[0].getMaxFill();
        }
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getMaxFill();
        }
        if (type.name().equals(this.plasma.getTankType().name())) {
            return this.plasma.getMaxFill();
        }
        return 0;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.power = nbt.func_74763_f("power");
        this.isOn = nbt.func_74767_n("isOn");
        this.tanks[0].readFromNBT(nbt, "water");
        this.tanks[1].readFromNBT(nbt, "steam");
        this.plasma.readFromNBT(nbt, "plasma");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        nbt.func_74757_a("isOn", this.isOn);
        this.tanks[0].writeToNBT(nbt, "water");
        this.tanks[1].writeToNBT(nbt, "steam");
        this.plasma.writeToNBT(nbt, "plasma");
    }

    public AxisAlignedBB getRenderBoundingBox() {
        if (this.bb == null) {
            this.bb = AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5 - 8.0), (double)((double)this.field_145848_d + 0.5 - 3.0), (double)((double)this.field_145849_e + 0.5 - 8.0), (double)((double)this.field_145851_c + 0.5 + 8.0), (double)((double)this.field_145848_d + 0.5 + 3.0), (double)((double)this.field_145849_e + 0.5 + 8.0));
        }
        return this.bb;
    }

    @SideOnly(value=Side.CLIENT)
    public double func_145833_n() {
        return 65536.0;
    }

    public void disassemble() {
        MachineITER.drop = false;
        int[][][] layout = TileEntityITERStruct.layout;
        for (int y = 0; y < 5; ++y) {
            for (int x = 0; x < layout[0].length; ++x) {
                block8: for (int z = 0; z < layout[0][0].length; ++z) {
                    int ly = y > 2 ? 4 - y : y;
                    int width = 7;
                    if (x == width && y == 0 && z == width) continue;
                    int b = layout[ly][x][z];
                    switch (b) {
                        case 1: {
                            this.field_145850_b.func_147449_b(this.field_145851_c - width + x, this.field_145848_d + y - 2, this.field_145849_e - width + z, ModBlocks.fusion_conductor);
                            continue block8;
                        }
                        case 2: {
                            this.field_145850_b.func_147449_b(this.field_145851_c - width + x, this.field_145848_d + y - 2, this.field_145849_e - width + z, ModBlocks.fusion_center);
                            continue block8;
                        }
                        case 3: {
                            this.field_145850_b.func_147449_b(this.field_145851_c - width + x, this.field_145848_d + y - 2, this.field_145849_e - width + z, ModBlocks.fusion_motor);
                            continue block8;
                        }
                        case 4: {
                            this.field_145850_b.func_147449_b(this.field_145851_c - width + x, this.field_145848_d + y - 2, this.field_145849_e - width + z, ModBlocks.reinforced_glass);
                        }
                    }
                }
            }
        }
        this.field_145850_b.func_147449_b(this.field_145851_c, this.field_145848_d - 2, this.field_145849_e, ModBlocks.struct_iter_core);
        MachineITER.drop = true;
        List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5)).func_72314_b(50.0, 10.0, 50.0));
        for (EntityPlayer player : players) {
            player.func_71029_a((StatBase)MainRegistry.achMeltdown);
        }
    }
}

