/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.blocks.ModBlocks;
import com.hbm.blocks.machine.BlockHadronCoil;
import com.hbm.blocks.machine.BlockHadronPlating;
import com.hbm.interfaces.IConsumer;
import com.hbm.inventory.HadronRecipes;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.main.MainRegistry;
import com.hbm.packet.AuxParticlePacketNT;
import com.hbm.packet.PacketDispatcher;
import com.hbm.tileentity.TileEntityMachineBase;
import com.hbm.tileentity.machine.TileEntityHadronDiode;
import com.hbm.tileentity.machine.TileEntityHadronPower;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.stats.StatBase;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.AxisAlignedBB;
import net.minecraftforge.common.util.ForgeDirection;

public class TileEntityHadron
extends TileEntityMachineBase
implements IConsumer {
    public long power;
    public static final long maxPower = 10000000L;
    public boolean isOn = false;
    public boolean analysisOnly = false;
    public boolean hopperMode = false;
    private int delay;
    public EnumHadronState state = EnumHadronState.IDLE;
    private static final int delaySuccess = 20;
    private static final int delayNoResult = 60;
    private static final int delayError = 60;
    private static final int[] access = new int[]{0, 1, 2, 3};
    static final int maxParticles = 1;
    List<Particle> particles = new ArrayList<Particle>();
    List<Particle> particlesToRemove = new ArrayList<Particle>();

    public TileEntityHadron() {
        super(5);
    }

    @Override
    public String getName() {
        return "container.hadron";
    }

    @Override
    public int[] func_94128_d(int side) {
        return access;
    }

    @Override
    public boolean func_102008_b(int i, ItemStack itemStack, int j) {
        return i == 2 || i == 3;
    }

    @Override
    public boolean func_94041_b(int i, ItemStack itemStack) {
        return i == 0 || i == 1;
    }

    @Override
    public void func_145845_h() {
        if (!this.field_145850_b.field_72995_K) {
            this.power = Library.chargeTEFromItems(this.slots, 4, this.power, 10000000L);
            this.drawPower();
            if (this.delay <= 0 && this.isOn && this.particles.size() < 1 && this.slots[0] != null && this.slots[1] != null && (double)this.power >= 7500000.0 && (!this.hopperMode || this.slots[0].field_77994_a > 1 && this.slots[1].field_77994_a > 1)) {
                ForgeDirection dir = ForgeDirection.getOrientation((int)this.func_145832_p());
                this.particles.add(new Particle(this.slots[0], this.slots[1], dir, this.field_145851_c, this.field_145848_d, this.field_145849_e));
                this.func_70298_a(0, 1);
                this.func_70298_a(1, 1);
                this.power = (long)((double)this.power - 7500000.0);
                this.state = EnumHadronState.PROGRESS;
            }
            if (this.delay > 0) {
                --this.delay;
            } else if (this.particles.isEmpty()) {
                this.state = EnumHadronState.IDLE;
            }
            if (!this.particles.isEmpty()) {
                this.updateParticles();
            }
            for (Particle p : this.particlesToRemove) {
                this.particles.remove(p);
            }
            this.particlesToRemove.clear();
            NBTTagCompound data = new NBTTagCompound();
            data.func_74757_a("isOn", this.isOn);
            data.func_74772_a("power", this.power);
            data.func_74757_a("analysis", this.analysisOnly);
            data.func_74757_a("hopperMode", this.hopperMode);
            data.func_74774_a("state", (byte)this.state.ordinal());
            this.networkPack(data, 50);
        }
    }

    private void process(Particle p) {
        ItemStack[] result = HadronRecipes.getOutput(p.item1, p.item2, p.momentum, this.analysisOnly);
        if (result == null) {
            this.state = EnumHadronState.NORESULT;
            this.delay = 60;
            this.field_145850_b.func_72908_a((double)p.posX, (double)p.posY, (double)p.posZ, "random.orb", 2.0f, 0.5f);
            return;
        }
        if ((this.slots[2] == null || this.slots[2].func_77973_b() == result[0].func_77973_b() && this.slots[2].field_77994_a < this.slots[2].func_77976_d()) && (this.slots[3] == null || this.slots[3].func_77973_b() == result[1].func_77973_b() && this.slots[3].field_77994_a < this.slots[3].func_77976_d())) {
            for (int i = 2; i <= 3; ++i) {
                if (this.slots[i] == null) {
                    this.slots[i] = result[i - 2].func_77946_l();
                    continue;
                }
                ++this.slots[i].field_77994_a;
            }
            if (result[0].func_77973_b() == ModItems.particle_digamma) {
                List players = this.field_145850_b.func_72872_a(EntityPlayer.class, AxisAlignedBB.func_72330_a((double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5), (double)((double)this.field_145851_c + 0.5), (double)((double)this.field_145848_d + 0.5), (double)((double)this.field_145849_e + 0.5)).func_72314_b(128.0, 50.0, 128.0));
                for (EntityPlayer player : players) {
                    player.func_71029_a((StatBase)MainRegistry.achOmega12);
                }
            }
        }
        this.field_145850_b.func_72908_a((double)p.posX, (double)p.posY, (double)p.posZ, "random.orb", 2.0f, 1.0f);
        this.delay = 20;
        this.state = EnumHadronState.SUCCESS;
    }

    @Override
    public void networkUnpack(NBTTagCompound data) {
        this.isOn = data.func_74767_n("isOn");
        this.power = data.func_74763_f("power");
        this.analysisOnly = data.func_74767_n("analysis");
        this.hopperMode = data.func_74767_n("hopperMode");
        this.state = EnumHadronState.values()[data.func_74771_c("state")];
    }

    @Override
    public void handleButtonPacket(int value, int meta) {
        if (meta == 0) {
            boolean bl = this.isOn = !this.isOn;
        }
        if (meta == 1) {
            boolean bl = this.analysisOnly = !this.analysisOnly;
        }
        if (meta == 2) {
            this.hopperMode = !this.hopperMode;
        }
    }

    private void drawPower() {
        for (ForgeDirection dir : this.getRandomDirs()) {
            if (this.power == 10000000L) {
                return;
            }
            int x = this.field_145851_c + dir.offsetX * 2;
            int y = this.field_145848_d + dir.offsetY * 2;
            int z = this.field_145849_e + dir.offsetZ * 2;
            TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
            if (!(te instanceof TileEntityHadronPower)) continue;
            TileEntityHadronPower plug = (TileEntityHadronPower)te;
            long toDraw = Math.min(10000000L - this.power, plug.getPower());
            this.setPower(this.power + toDraw);
            plug.setPower(plug.getPower() - toDraw);
        }
    }

    private void finishParticle(Particle p) {
        this.particlesToRemove.add(p);
        if (!p.isExpired()) {
            this.process(p);
        }
        p.expired = true;
    }

    private void updateParticles() {
        for (Particle particle : this.particles) {
            particle.update();
        }
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.isOn = nbt.func_74767_n("isOn");
        this.power = nbt.func_74763_f("power");
        this.analysisOnly = nbt.func_74767_n("analysis");
        this.hopperMode = nbt.func_74767_n("hopperMode");
    }

    @Override
    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74757_a("isOn", this.isOn);
        nbt.func_74772_a("power", this.power);
        nbt.func_74757_a("analysis", this.analysisOnly);
        nbt.func_74757_a("hopperMode", this.hopperMode);
    }

    public int getPowerScaled(int i) {
        return (int)(this.power * (long)i / 10000000L);
    }

    @Override
    public void setPower(long i) {
        this.power = i;
        this.func_70296_d();
    }

    @Override
    public long getPower() {
        return this.power;
    }

    @Override
    public long getMaxPower() {
        return 10000000L;
    }

    public void makeSteppy(Particle p) {
        ForgeDirection dir = p.dir;
        p.posX += dir.offsetX;
        p.posY += dir.offsetY;
        p.posZ += dir.offsetZ;
        int x = p.posX;
        int y = p.posY;
        int z = p.posZ;
        Block block = this.field_145850_b.func_147439_a(x, y, z);
        TileEntity te = this.field_145850_b.func_147438_o(x, y, z);
        if (te instanceof TileEntityHadron) {
            if (p.analysis != 3) {
                p.expire();
            } else {
                this.finishParticle(p);
            }
            return;
        }
        if (block.func_149688_o() != Material.field_151579_a && block != ModBlocks.hadron_diode) {
            p.expire();
        }
        if (block == ModBlocks.hadron_diode) {
            p.isCheckExempt = true;
        }
        if (this.coilValue(this.field_145850_b.func_147439_a(x + dir.offsetX, y + dir.offsetY, z + dir.offsetZ)) > 0) {
            p.isCheckExempt = true;
        }
    }

    public void checkSegment(Particle p) {
        ForgeDirection dir = p.dir;
        int x = p.posX;
        int y = p.posY;
        int z = p.posZ;
        int dX = 1 - Math.abs(dir.offsetX);
        int dY = 1 - Math.abs(dir.offsetY);
        int dZ = 1 - Math.abs(dir.offsetZ);
        boolean analysis = true;
        for (int a = x - dX * 2; a <= x + dX * 2; ++a) {
            for (int b = y - dY * 2; b <= y + dY * 2; ++b) {
                for (int c = z - dZ * 2; c <= z + dZ * 2; ++c) {
                    Block block = this.field_145850_b.func_147439_a(a, b, c);
                    if (a == x && b == y && c == z) {
                        if (block.func_149688_o() == Material.field_151579_a) continue;
                        analysis = false;
                        continue;
                    }
                    int ix = Math.abs(x - a);
                    int iy = Math.abs(y - b);
                    int iz = Math.abs(z - c);
                    if (ix <= 1 && iy <= 1 && iz <= 1) {
                        if (p.isCheckExempt && ix + iy + iz == 1 || block.func_149688_o() == Material.field_151579_a && analysis) continue;
                        analysis = false;
                        int coilVal = this.coilValue(block);
                        if (coilVal == 0) {
                            p.expire();
                            continue;
                        }
                        p.momentum += coilVal;
                        p.charge -= coilVal;
                        continue;
                    }
                    if (ix + iy + iz > 3 || this.isAnalysis(block)) continue;
                    analysis = false;
                    if (this.isPlating(block)) continue;
                    TileEntity te = this.field_145850_b.func_147438_o(a, b, c);
                    if (te instanceof TileEntityHadronPower) {
                        TileEntityHadronPower plug = (TileEntityHadronPower)te;
                        long bit = 10000L;
                        int times = (int)(plug.getPower() / bit);
                        p.charge += times;
                        plug.setPower(plug.getPower() - (long)times * bit);
                        continue;
                    }
                    if (p.isCheckExempt && ix + iy + iz == 2) continue;
                    p.expire();
                }
            }
        }
        if (analysis) {
            ++p.analysis;
            if (p.analysis > 3) {
                p.expire();
            }
            if (p.analysis == 2) {
                this.field_145850_b.func_72908_a((double)p.posX + 0.5, (double)p.posY + 0.5, (double)p.posZ + 0.5, "fireworks.blast", 2.0f, 2.0f);
                this.state = EnumHadronState.ANALYSIS;
                NBTTagCompound data = new NBTTagCompound();
                data.func_74778_a("type", "hadron");
                PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxParticlePacketNT(data, (double)p.posX + 0.5, (double)p.posY + 0.5, (double)p.posZ + 0.5), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)p.posX + 0.5, (double)p.posY + 0.5, (double)p.posZ + 0.5, 25.0));
            }
            if (this.analysisOnly && p.analysis == 2) {
                this.finishParticle(p);
            }
        } else if (p.analysis > 0 && p.analysis < 3) {
            p.expire();
        }
    }

    public void changeDirection(Particle p) {
        List<ForgeDirection> dirs;
        ForgeDirection dir = p.dir;
        int x = p.posX;
        int y = p.posY;
        int z = p.posZ;
        int nx = x + dir.offsetX;
        int ny = y + dir.offsetY;
        int nz = z + dir.offsetZ;
        Block next = this.field_145850_b.func_147439_a(nx, ny, nz);
        TileEntity te = this.field_145850_b.func_147438_o(nx, ny, nz);
        if (te instanceof TileEntityHadronDiode) {
            TileEntityHadronDiode diode = (TileEntityHadronDiode)te;
            if (diode.getConfig(p.dir.getOpposite().ordinal()) != TileEntityHadronDiode.DiodeConfig.IN) {
                p.expire();
            }
            p.isCheckExempt = true;
            return;
        }
        te = this.field_145850_b.func_147438_o(x, y, z);
        if (te instanceof TileEntityHadronDiode) {
            p.isCheckExempt = true;
            TileEntityHadronDiode diode = (TileEntityHadronDiode)te;
            if (diode.getConfig(dir.ordinal()) == TileEntityHadronDiode.DiodeConfig.OUT) {
                return;
            }
            dirs = this.getRandomDirs();
            for (ForgeDirection d : dirs) {
                if (d == dir || d == dir.getOpposite() || diode.getConfig(d.ordinal()) != TileEntityHadronDiode.DiodeConfig.OUT) continue;
                p.dir = d;
                return;
            }
        }
        if (next.func_149688_o() == Material.field_151579_a || next == ModBlocks.hadron_core) {
            return;
        }
        if (this.coilValue(next) > 0) {
            ForgeDirection validDir = ForgeDirection.UNKNOWN;
            dirs = this.getRandomDirs();
            for (ForgeDirection d : dirs) {
                if (d == dir || d == dir.getOpposite() || this.field_145850_b.func_147439_a(x + d.offsetX, y + d.offsetY, z + d.offsetZ).func_149688_o() != Material.field_151579_a) continue;
                if (validDir == ForgeDirection.UNKNOWN) {
                    validDir = d;
                    continue;
                }
                p.expire();
                return;
            }
            p.dir = validDir;
            p.isCheckExempt = true;
            return;
        }
        p.expire();
    }

    private List<ForgeDirection> getRandomDirs() {
        List<Integer> rands = Arrays.asList(0, 1, 2, 3, 4, 5);
        Collections.shuffle(rands);
        ArrayList<ForgeDirection> dirs = new ArrayList<ForgeDirection>();
        for (Integer i : rands) {
            dirs.add(ForgeDirection.getOrientation((int)i));
        }
        return dirs;
    }

    public int coilValue(Block b) {
        if (b instanceof BlockHadronCoil) {
            return ((BlockHadronCoil)b).factor;
        }
        return 0;
    }

    public boolean isPlating(Block b) {
        return b instanceof BlockHadronPlating || b instanceof BlockHadronCoil || b == ModBlocks.hadron_plating_glass || b == ModBlocks.hadron_analysis_glass || b == ModBlocks.hadron_access;
    }

    public boolean isAnalysis(Block b) {
        return b == ModBlocks.hadron_analysis || b == ModBlocks.hadron_analysis_glass;
    }

    public static enum EnumHadronState {
        IDLE(0x8080FF),
        PROGRESS(0xFFFF00),
        ANALYSIS(0xFFFF00),
        NORESULT(0xFF8000),
        SUCCESS(65280),
        ERROR(0xFF0000);

        public int color;

        private EnumHadronState(int color) {
            this.color = color;
        }
    }

    public class Particle {
        ItemStack item1;
        ItemStack item2;
        ForgeDirection dir;
        int posX;
        int posY;
        int posZ;
        int momentum;
        int charge;
        int analysis;
        boolean isCheckExempt = false;
        boolean expired = false;

        public Particle(ItemStack item1, ItemStack item2, ForgeDirection dir, int posX, int posY, int posZ) {
            this.item1 = item1.func_77946_l();
            this.item2 = item2.func_77946_l();
            this.item1.field_77994_a = 1;
            this.item2.field_77994_a = 1;
            this.dir = dir;
            this.posX = posX;
            this.posY = posY;
            this.posZ = posZ;
            this.charge = 0;
            this.momentum = 0;
        }

        public void expire() {
            if (this.expired) {
                return;
            }
            this.expired = true;
            TileEntityHadron.this.particlesToRemove.add(this);
            TileEntityHadron.this.field_145850_b.func_72885_a(null, (double)this.posX + 0.5, (double)this.posY + 0.5, (double)this.posZ + 0.5, 10.0f, false, false);
            TileEntityHadron.this.state = EnumHadronState.ERROR;
            TileEntityHadron.this.delay = 60;
        }

        public boolean isExpired() {
            return this.expired;
        }

        public void update() {
            if (this.expired) {
                return;
            }
            TileEntityHadron.this.changeDirection(this);
            TileEntityHadron.this.makeSteppy(this);
            if (!this.isExpired()) {
                TileEntityHadron.this.checkSegment(this);
            }
            this.isCheckExempt = false;
            if (this.charge < 0) {
                this.expire();
            }
        }
    }
}

