/*
 * Decompiled with CFR 0.152.
 */
package com.hbm.tileentity.machine;

import com.hbm.handler.FluidTypeHandler;
import com.hbm.interfaces.IConsumer;
import com.hbm.interfaces.IFluidAcceptor;
import com.hbm.interfaces.IFluidContainer;
import com.hbm.interfaces.IReactor;
import com.hbm.interfaces.ISource;
import com.hbm.inventory.FluidTank;
import com.hbm.items.ModItems;
import com.hbm.lib.Library;
import com.hbm.packet.AuxElectricityPacket;
import com.hbm.packet.PacketDispatcher;
import com.hbm.world.machine.FWatz;
import cpw.mods.fml.common.network.NetworkRegistry;
import cpw.mods.fml.common.network.simpleimpl.IMessage;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.world.World;

public class TileEntityFWatzCore
extends TileEntity
implements ISidedInventory,
IReactor,
ISource,
IFluidContainer,
IFluidAcceptor {
    public long power;
    public static final long maxPower = 10000000000L;
    public boolean cooldown = false;
    public FluidTank[] tanks;
    Random rand = new Random();
    private ItemStack[] slots;
    public int age = 0;
    public List<IConsumer> list = new ArrayList<IConsumer>();
    private String customName;

    public TileEntityFWatzCore() {
        this.slots = new ItemStack[7];
        this.tanks = new FluidTank[3];
        this.tanks[0] = new FluidTank(FluidTypeHandler.FluidType.COOLANT, 128000, 0);
        this.tanks[1] = new FluidTank(FluidTypeHandler.FluidType.AMAT, 64000, 1);
        this.tanks[2] = new FluidTank(FluidTypeHandler.FluidType.ASCHRAB, 64000, 2);
    }

    public int func_70302_i_() {
        return this.slots.length;
    }

    public ItemStack func_70301_a(int i) {
        return this.slots[i];
    }

    public ItemStack func_70304_b(int i) {
        if (this.slots[i] != null) {
            ItemStack itemStack = this.slots[i];
            this.slots[i] = null;
            return itemStack;
        }
        return null;
    }

    public void func_70299_a(int i, ItemStack itemStack) {
        this.slots[i] = itemStack;
        if (itemStack != null && itemStack.field_77994_a > this.func_70297_j_()) {
            itemStack.field_77994_a = this.func_70297_j_();
        }
    }

    public String func_145825_b() {
        return this.func_145818_k_() ? this.customName : "container.fusionaryWatzPlant";
    }

    public boolean func_145818_k_() {
        return this.customName != null && this.customName.length() > 0;
    }

    public void setCustomName(String name) {
        this.customName = name;
    }

    public int func_70297_j_() {
        return 64;
    }

    public boolean func_70300_a(EntityPlayer player) {
        return this.field_145850_b.func_147438_o(this.field_145851_c, this.field_145848_d, this.field_145849_e) == this;
    }

    public void func_70295_k_() {
    }

    public void func_70305_f() {
    }

    public boolean func_94041_b(int i, ItemStack itemStack) {
        return true;
    }

    public ItemStack func_70298_a(int i, int j) {
        if (this.slots[i] != null) {
            if (this.slots[i].field_77994_a <= j) {
                ItemStack itemStack = this.slots[i];
                this.slots[i] = null;
                return itemStack;
            }
            ItemStack itemStack1 = this.slots[i].func_77979_a(j);
            if (this.slots[i].field_77994_a == 0) {
                this.slots[i] = null;
            }
            return itemStack1;
        }
        return null;
    }

    public int[] func_94128_d(int p_94128_1_) {
        return null;
    }

    public boolean func_102007_a(int p_102007_1_, ItemStack p_102007_2_, int p_102007_3_) {
        return false;
    }

    public boolean func_102008_b(int p_102008_1_, ItemStack p_102008_2_, int p_102008_3_) {
        return false;
    }

    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        NBTTagList list = nbt.func_150295_c("items", 10);
        this.power = nbt.func_74763_f("power");
        this.tanks[0].readFromNBT(nbt, "cool");
        this.tanks[1].readFromNBT(nbt, "amat");
        this.tanks[2].readFromNBT(nbt, "aschrab");
        this.slots = new ItemStack[this.func_70302_i_()];
        for (int i = 0; i < list.func_74745_c(); ++i) {
            NBTTagCompound nbt1 = list.func_150305_b(i);
            byte b0 = nbt1.func_74771_c("slot");
            if (b0 < 0 || b0 >= this.slots.length) continue;
            this.slots[b0] = ItemStack.func_77949_a((NBTTagCompound)nbt1);
        }
    }

    public void func_145841_b(NBTTagCompound nbt) {
        super.func_145841_b(nbt);
        nbt.func_74772_a("power", this.power);
        this.tanks[0].writeToNBT(nbt, "cool");
        this.tanks[1].writeToNBT(nbt, "amat");
        this.tanks[2].writeToNBT(nbt, "aschrab");
        NBTTagList list = new NBTTagList();
        for (int i = 0; i < this.slots.length; ++i) {
            if (this.slots[i] == null) continue;
            NBTTagCompound nbt1 = new NBTTagCompound();
            nbt1.func_74774_a("slot", (byte)i);
            this.slots[i].func_77955_b(nbt1);
            list.func_74742_a((NBTBase)nbt1);
        }
        nbt.func_74782_a("items", (NBTBase)list);
    }

    @Override
    public boolean isStructureValid(World world) {
        return FWatz.checkHull(world, this.field_145851_c, this.field_145848_d, this.field_145849_e);
    }

    @Override
    public boolean isCoatingValid(World world) {
        return true;
    }

    @Override
    public boolean hasFuse() {
        return this.slots[1] != null && (this.slots[1].func_77973_b() == ModItems.fuse || this.slots[1].func_77973_b() == ModItems.screwdriver);
    }

    @Override
    public int getCoolantScaled(int i) {
        return 0;
    }

    @Override
    public long getPowerScaled(long i) {
        return this.power / 100L * i / 100000000L;
    }

    @Override
    public int getWaterScaled(int i) {
        return 0;
    }

    @Override
    public int getHeatScaled(int i) {
        return 0;
    }

    public int getSingularityType() {
        if (this.slots[2] != null) {
            Item item = this.slots[2].func_77973_b();
            if (item == ModItems.singularity) {
                return 1;
            }
            if (item == ModItems.singularity_counter_resonant) {
                return 2;
            }
            if (item == ModItems.singularity_super_heated) {
                return 3;
            }
            if (item == ModItems.black_hole) {
                return 4;
            }
            if (item == ModItems.overfuse) {
                return 5;
            }
        }
        return 0;
    }

    public void func_145845_h() {
        if (this.isStructureValid(this.field_145850_b) && !this.field_145850_b.field_72995_K) {
            int i;
            ++this.age;
            if (this.age >= 20) {
                this.age = 0;
            }
            if (this.age == 9 || this.age == 19) {
                this.ffgeuaInit();
            }
            if (this.hasFuse() && this.getSingularityType() > 0) {
                if (this.cooldown) {
                    i = this.getSingularityType();
                    if (i == 1) {
                        this.tanks[0].setFill(this.tanks[0].getFill() + 1500);
                    }
                    if (i == 2) {
                        this.tanks[0].setFill(this.tanks[0].getFill() + 3000);
                    }
                    if (i == 3) {
                        this.tanks[0].setFill(this.tanks[0].getFill() + 750);
                    }
                    if (i == 4) {
                        this.tanks[0].setFill(this.tanks[0].getFill() + 7500);
                    }
                    if (i == 5) {
                        this.tanks[0].setFill(this.tanks[0].getFill() + 15000);
                    }
                    if (this.tanks[0].getFill() >= this.tanks[0].getMaxFill()) {
                        this.cooldown = false;
                        this.tanks[0].setFill(this.tanks[0].getMaxFill());
                    }
                } else {
                    i = this.getSingularityType();
                    if (i == 1 && this.tanks[1].getFill() - 75 >= 0 && this.tanks[2].getFill() - 75 >= 0) {
                        this.tanks[0].setFill(this.tanks[0].getFill() - 150);
                        this.tanks[1].setFill(this.tanks[1].getFill() - 75);
                        this.tanks[2].setFill(this.tanks[2].getFill() - 75);
                        this.power += 5000000L;
                    }
                    if (i == 2 && this.tanks[1].getFill() - 75 >= 0 && this.tanks[2].getFill() - 35 >= 0) {
                        this.tanks[0].setFill(this.tanks[0].getFill() - 75);
                        this.tanks[1].setFill(this.tanks[1].getFill() - 35);
                        this.tanks[2].setFill(this.tanks[2].getFill() - 30);
                        this.power += 2500000L;
                    }
                    if (i == 3 && this.tanks[1].getFill() - 75 >= 0 && this.tanks[2].getFill() - 140 >= 0) {
                        this.tanks[0].setFill(this.tanks[0].getFill() - 300);
                        this.tanks[1].setFill(this.tanks[1].getFill() - 75);
                        this.tanks[2].setFill(this.tanks[2].getFill() - 140);
                        this.power += 10000000L;
                    }
                    if (i == 4 && this.tanks[1].getFill() - 100 >= 0 && this.tanks[2].getFill() - 100 >= 0) {
                        this.tanks[0].setFill(this.tanks[0].getFill() - 100);
                        this.tanks[1].setFill(this.tanks[1].getFill() - 100);
                        this.tanks[2].setFill(this.tanks[2].getFill() - 100);
                        this.power += 10000000L;
                    }
                    if (i == 5 && this.tanks[1].getFill() - 15 >= 0 && this.tanks[2].getFill() - 15 >= 0) {
                        this.tanks[0].setFill(this.tanks[0].getFill() - 150);
                        this.tanks[1].setFill(this.tanks[1].getFill() - 15);
                        this.tanks[2].setFill(this.tanks[2].getFill() - 15);
                        this.power += 100000000L;
                    }
                    if (this.power > 10000000000L) {
                        this.power = 10000000000L;
                    }
                    if (this.tanks[0].getFill() <= 0) {
                        this.cooldown = true;
                        this.tanks[0].setFill(0);
                    }
                }
            }
            if (this.power > 10000000000L) {
                this.power = 10000000000L;
            }
            this.power = Library.chargeItemsFromTE(this.slots, 0, this.power, 10000000000L);
            this.tanks[1].loadTank(3, 5, this.slots);
            this.tanks[2].loadTank(4, 6, this.slots);
            for (i = 0; i < 3; ++i) {
                this.tanks[i].updateTank(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.field_145850_b.field_73011_w.field_76574_g);
            }
        }
        if (this.isRunning() && (this.tanks[1].getFill() <= 0 || this.tanks[2].getFill() <= 0 || !this.hasFuse() || this.getSingularityType() == 0) || this.cooldown || !this.isStructureValid(this.field_145850_b)) {
            this.emptyPlasma();
        }
        if (!this.isRunning() && this.tanks[1].getFill() >= 100 && this.tanks[2].getFill() >= 100 && this.hasFuse() && this.getSingularityType() > 0 && !this.cooldown && this.isStructureValid(this.field_145850_b)) {
            this.fillPlasma();
        }
        if (!this.field_145850_b.field_72995_K) {
            PacketDispatcher.wrapper.sendToAllAround((IMessage)new AuxElectricityPacket(this.field_145851_c, this.field_145848_d, this.field_145849_e, this.power), new NetworkRegistry.TargetPoint(this.field_145850_b.field_73011_w.field_76574_g, (double)this.field_145851_c, (double)this.field_145848_d, (double)this.field_145849_e, 50.0));
        }
    }

    public void fillPlasma() {
        if (!this.field_145850_b.field_72995_K) {
            FWatz.fillPlasma(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public void emptyPlasma() {
        if (!this.field_145850_b.field_72995_K) {
            FWatz.emptyPlasma(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e);
        }
    }

    public boolean isRunning() {
        return FWatz.getPlasma(this.field_145850_b, this.field_145851_c, this.field_145848_d, this.field_145849_e) && this.isStructureValid(this.field_145850_b);
    }

    @Override
    public void ffgeua(int x, int y, int z, boolean newTact) {
        Library.ffgeua(x, y, z, newTact, this, this.field_145850_b);
    }

    @Override
    public void ffgeuaInit() {
        this.ffgeua(this.field_145851_c + 10, this.field_145848_d - 11, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c - 10, this.field_145848_d - 11, this.field_145849_e, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d - 11, this.field_145849_e + 10, this.getTact());
        this.ffgeua(this.field_145851_c, this.field_145848_d - 11, this.field_145849_e - 10, this.getTact());
    }

    @Override
    public boolean getTact() {
        return this.age >= 0 && this.age < 10;
    }

    @Override
    public long getSPower() {
        return this.power;
    }

    @Override
    public void setSPower(long i) {
        this.power = i;
    }

    @Override
    public List<IConsumer> getList() {
        return this.list;
    }

    @Override
    public void clearList() {
        this.list.clear();
    }

    @Override
    public void setFillstate(int fill, int index) {
        if (index < 3 && this.tanks[index] != null) {
            this.tanks[index].setFill(fill);
        }
    }

    @Override
    public void setType(FluidTypeHandler.FluidType type, int index) {
        if (index < 3 && this.tanks[index] != null) {
            this.tanks[index].setTankType(type);
        }
    }

    @Override
    public void setFluidFill(int i, FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            this.tanks[1].setFill(i);
        } else if (type.name().equals(this.tanks[2].getTankType().name())) {
            this.tanks[2].setFill(i);
        }
    }

    @Override
    public int getFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getFill();
        }
        if (type.name().equals(this.tanks[2].getTankType().name())) {
            return this.tanks[2].getFill();
        }
        return 0;
    }

    @Override
    public int getMaxFluidFill(FluidTypeHandler.FluidType type) {
        if (type.name().equals(this.tanks[1].getTankType().name())) {
            return this.tanks[1].getMaxFill();
        }
        if (type.name().equals(this.tanks[2].getTankType().name())) {
            return this.tanks[2].getMaxFill();
        }
        return 0;
    }

    @Override
    public List<FluidTank> getTanks() {
        ArrayList<FluidTank> list = new ArrayList<FluidTank>();
        list.add(this.tanks[0]);
        list.add(this.tanks[1]);
        list.add(this.tanks[2]);
        return list;
    }
}

